/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.clinicaldata.vhim400;

import gov.va.med.cds.clinicaldata.vhim400.ClinicalDataResponseInterface;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

public class ConfigurableClinicalDataResponse
implements ClinicalDataResponseInterface {
    private static final String DEFAULT_TEMPLATE_ID_ELEMENT_NAME = "templateId";
    private static final String DEFAULT_REQUEST_ID_ELEMENT_NAME = "requestId";
    private static final String DEFAULT_REQUESTED_NATIONAL_ID_ELEMENT_NAME = "requestedNationalId";
    private static final String DEFAULT_REQUESTED_EDIPI_ELEMENT_NAME = "requestedEdiPi";
    private static final String DEFAULT_RESULTANT_IDENTIFIERS_ELEMENT_NAME = "resultantIdentifiers";
    private static final String DEFAULT_REQUESTED_RESOLVED_IDENTIFIERS_ELEMENT_NAME = "requestedResolvedIdentifiers";
    private static final String DEFAULT_REQUESTED_EXCLUDED_IDENTIFIERS_ELEMENT_NAME = "requestedExcludedIdentifiers";
    private static final String DEFAULT_CREATED_IDENTIFIERS_ELEMENT_NAME = "recordIdentifiers";
    protected String templateIdElementName = "templateId";
    protected String requestIdElementName = "requestId";
    private String requestedNationalIdElementName = "requestedNationalId";
    private String resultantIdentifiersElementName = "resultantIdentifiers";
    private String requestedResolvedIdentifiersElementName = "requestedResolvedIdentifiers";
    private String requestedEdipiElementName = "requestedEdiPi";
    private String requestedExcludedIdentifiersElementName = "requestedExcludedIdentifiers";
    private String createdIdentifiersElementName = "recordIdentifiers";
    protected static final String CLIENT_NAME_ELEMENT_NAME = "clientName";
    protected static final String CLIENT_REQUEST_INITIATION_TIME_ELEMENT_NAME = "clientRequestInitiationTime";
    protected String patientElementPath;
    private String clinicalRootPath;
    private String errorResponseTemplateId;

    public ConfigurableClinicalDataResponse(String patientElementPath, String clinicalRootPath, String errorResponseTemplateId) {
        this.patientElementPath = patientElementPath;
        this.clinicalRootPath = clinicalRootPath;
        this.errorResponseTemplateId = errorResponseTemplateId;
    }

    public ConfigurableClinicalDataResponse(String clinicalRootPath, String errorResponseTemplateId) {
        this.clinicalRootPath = clinicalRootPath;
        this.errorResponseTemplateId = errorResponseTemplateId;
    }

    @Override
    public Document buildEmptyClinicalDocument(String templateId, String requestId, String clientName) {
        Document document = this.buildClinicalDocument(templateId, requestId, clientName, true);
        this.getChildElement(document, this.clinicalRootPath, true);
        return document;
    }

    @Override
    public Document buildEmptyClinicalDocument(String templateId, String requestId) {
        Document document = this.buildClinicalDocument(templateId, requestId, true);
        this.getChildElement(document, this.clinicalRootPath, true);
        return document;
    }

    @Override
    public Document buildEmptyClinicalDocument(String templateId, String requestId, boolean addPatient) {
        Document document = this.buildClinicalDocument(templateId, requestId, addPatient);
        this.getChildElement(document, this.clinicalRootPath, addPatient);
        return document;
    }

    @Override
    public Element getChildElement(Document document, String name, boolean create) {
        Element rootElement = null;
        if (document == null || (rootElement = document.getRootElement()) == null) {
            throw new IllegalArgumentException("The document not be null and must have a root element attached.");
        }
        return this.getChildElement(rootElement, name, create);
    }

    @Override
    public Element buildRecordIdentifierElement(String recordIdentifier, Element clinicalData) {
        Element identifierElement = DocumentHelper.createElement((String)"recordIdentifier");
        identifierElement.add(DocumentHelper.createElement((String)"identity"));
        identifierElement.element("identity").setText(recordIdentifier);
        return identifierElement;
    }

    protected Element getChildElement(Element start, String name, boolean create) {
        String[] pathTokens = name.split("\\/");
        Element parent = start;
        Element child = null;
        for (String elementName : pathTokens) {
            if (parent == null) {
                return null;
            }
            child = parent.element(elementName);
            if (child == null && create) {
                child = DocumentHelper.createElement((String)elementName);
                parent.add(child);
            }
            parent = child;
        }
        return child;
    }

    @Override
    public Element getChildElement(Document document, String name) {
        return this.getChildElement(document, name, false);
    }

    @Override
    public Element getClinicalRoot(Document document) {
        return this.getChildElement(document, this.clinicalRootPath, true);
    }

    protected Document buildClinicalDocument(String templateId, String requestId, String clientName, boolean addPatient) {
        Namespace clinicalDataNamespace = DocumentHelper.createNamespace((String)"clinicaldata", (String)"Clinicaldata");
        Element clinicalDataElement = DocumentHelper.createElement((QName)DocumentHelper.createQName((String)"ClinicalData", (Namespace)clinicalDataNamespace));
        if (clientName != null) {
            this.getChildElement(clinicalDataElement, CLIENT_NAME_ELEMENT_NAME, true).addText(clientName);
            this.getChildElement(clinicalDataElement, CLIENT_REQUEST_INITIATION_TIME_ELEMENT_NAME, true).addText("2012-12-17T09:30:47Z");
        }
        if (templateId != null) {
            this.getChildElement(clinicalDataElement, this.templateIdElementName, true).addText(templateId);
        }
        if (requestId != null) {
            this.getChildElement(clinicalDataElement, this.requestIdElementName, true).addText(requestId);
        }
        if (addPatient) {
            this.getChildElement(clinicalDataElement, this.patientElementPath, true);
        }
        return DocumentHelper.createDocument((Element)clinicalDataElement);
    }

    protected Document buildClinicalDocument(String templateId, String requestId, boolean addPatient) {
        Namespace clinicalDataNamespace = DocumentHelper.createNamespace((String)"clinicaldata", (String)"Clinicaldata");
        Element clinicalDataElement = DocumentHelper.createElement((QName)DocumentHelper.createQName((String)"ClinicalData", (Namespace)clinicalDataNamespace));
        if (templateId != null) {
            this.getChildElement(clinicalDataElement, this.templateIdElementName, true).addText(templateId);
        }
        if (requestId != null) {
            this.getChildElement(clinicalDataElement, this.requestIdElementName, true).addText(requestId);
        }
        if (addPatient) {
            this.getChildElement(clinicalDataElement, this.patientElementPath, true);
        }
        return DocumentHelper.createDocument((Element)clinicalDataElement);
    }

    @Override
    public Element getPatientElement(Document document) {
        return this.getChildElement(document, this.patientElementPath, true);
    }

    @Override
    public Element getRequestId(Document document) {
        return this.getChildElement(document, DEFAULT_REQUEST_ID_ELEMENT_NAME);
    }

    @Override
    public Element getTemplateId(Document document) {
        return this.getChildElement(document, DEFAULT_TEMPLATE_ID_ELEMENT_NAME);
    }

    @Override
    public Element setTemplateIdText(Document document, String templateIdText) {
        Element templateId = this.getChildElement(document, DEFAULT_TEMPLATE_ID_ELEMENT_NAME, true);
        templateId.setText(templateIdText);
        return templateId;
    }

    @Override
    public Document buildEmptyClinicalDocumentWithPatient(String templateId, String requestId) {
        return this.buildClinicalDocument(templateId, requestId, true);
    }

    @Override
    public Document buildEmptyClinicalDocumentWithoutPatient(String templateId, String requestId) {
        return this.buildClinicalDocument(templateId, requestId, false);
    }

    @Override
    public Element getErrorSectionRoot(Document document) {
        return this.getChildElement(document, "errorSection");
    }

    @Override
    public String getErrorResponseTemplateId() {
        return this.errorResponseTemplateId;
    }

    @Override
    public Element getRequestedNationalId(Document document) {
        String requestIdPath = String.format("%s/%s", this.patientElementPath, this.requestedNationalIdElementName);
        return this.getChildElement(document, requestIdPath);
    }

    @Override
    public Document addRequestedNationalId(Document document, String nationalId) {
        String requestIdPath = String.format("%s/%s", this.patientElementPath, this.requestedNationalIdElementName);
        Element requestedNationalId = this.getChildElement(document, requestIdPath, true);
        requestedNationalId.setText(nationalId);
        return document;
    }

    @Override
    public Document buildEmptyClinicalDocument() {
        return this.buildEmptyClinicalDocument(null, null);
    }

    @Override
    public Document buildEmptyClinicalDocumentWithPatient() {
        return this.buildClinicalDocument(null, null, true);
    }

    @Override
    public Document buildClinicalDocumentWithCreatedIdentifiers(String templateId, String requestId, List<Element> createdIdentifiers, boolean addPatient) {
        return this.buildResponseClinicalDocumentWithCreatedIdentifiers(templateId, requestId, createdIdentifiers, addPatient);
    }

    @Override
    public Document buildClinicalDocumentWithCreatedIdentifiers(String templateId, String requestId, List<Element> createdIdentifiers) {
        return this.buildResponseClinicalDocumentWithCreatedIdentifiers(templateId, requestId, createdIdentifiers, true);
    }

    private Document buildResponseClinicalDocumentWithCreatedIdentifiers(String templateId, String requestId, List<Element> createdIdentifiers, boolean addPatient) {
        Document clinicalDocument = this.buildEmptyClinicalDocument(templateId, requestId, addPatient);
        Element clinicalDataElement = clinicalDocument.getRootElement();
        Element createdRecordIdentifiers = DocumentHelper.createElement((String)this.createdIdentifiersElementName);
        for (Element identifier : createdIdentifiers) {
            if (identifier == null) continue;
            createdRecordIdentifiers.add(identifier);
        }
        clinicalDataElement.add(createdRecordIdentifiers);
        return clinicalDocument;
    }

    @Override
    public Element getRequestedExcludedIdentifiers(Document document) {
        String requestIdPath = String.format("%s/%s", this.patientElementPath, this.requestedExcludedIdentifiersElementName);
        return this.getChildElement(document, requestIdPath);
    }

    @Override
    public Element getRequestedResolvedIdentifiers(Document document) {
        String requestIdPath = String.format("%s/%s", this.patientElementPath, this.requestedResolvedIdentifiersElementName);
        return this.getChildElement(document, requestIdPath);
    }

    @Override
    public Element getRequestedEdipi(Document document) {
        String requestIdPath = String.format("%s/%s", this.patientElementPath, this.requestedEdipiElementName);
        return this.getChildElement(document, requestIdPath);
    }

    @Override
    public Element getResultantIdentifiers(Document document) {
        String requestIdPath = String.format("%s/%s", this.patientElementPath, this.resultantIdentifiersElementName);
        return this.getChildElement(document, requestIdPath);
    }

    public void setCreatedIdentifiersElementName(String createdIdentifiersElementName) {
        this.createdIdentifiersElementName = createdIdentifiersElementName;
    }

    @Override
    public Document buildErrorResponse(String templateId, String requestId, Document writeResultDocument, Document clinicalDataDocument) {
        return writeResultDocument;
    }
}

