/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.clinicaldata.vhim400;

import gov.va.med.cds.clinicaldata.DomainEntryPoint;
import gov.va.med.cds.clinicaldata.vhim400.ConfigurableClinicalDataResponse;
import gov.va.med.cds.exception.ErrorCodeEnum;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.springframework.beans.factory.annotation.Required;

public class CdsResponse1ClinicalDataResponse
extends ConfigurableClinicalDataResponse {
    private Map<String, Set<DomainEntryPoint>> templateIdToDomainEntryPointListMap = null;
    private String statusElementName = null;

    public CdsResponse1ClinicalDataResponse(String patientElementPath, String clinicalRootPath, String errorResponseTemplateId) {
        super(patientElementPath, clinicalRootPath, errorResponseTemplateId);
    }

    @Override
    public Element buildRecordIdentifierElement(String recordIdentifier, Element clinicalData) {
        Element documentIdentifier;
        Element identifierElement = DocumentHelper.createElement((String)"identifier");
        if (recordIdentifier != null) {
            identifierElement.add(DocumentHelper.createElement((String)"recordIdentifier"));
            identifierElement.element("recordIdentifier").add(DocumentHelper.createElement((String)"identity"));
            identifierElement.element("recordIdentifier").element("identity").setText(recordIdentifier);
        }
        if ((documentIdentifier = clinicalData.element("documentIdentifier")) == null) {
            throw new IllegalArgumentException("Required document identifier element not present in create document.");
        }
        identifierElement.add((Node)documentIdentifier.clone());
        Element statusElement = clinicalData.element(this.statusElementName);
        if (statusElement != null) {
            String status = statusElement.getText();
            statusElement = DocumentHelper.createElement((String)"status");
            statusElement.setText(status);
            identifierElement.add(statusElement);
        }
        return identifierElement;
    }

    @Override
    public Document buildErrorResponse(String templateId, String requestId, Document writeResultDocument, Document clinicalDataDocument) {
        Node displayMessageNode;
        List<String> identifiers = null;
        if (clinicalDataDocument != null) {
            identifiers = this.getDocumentIdentifiers(templateId, clinicalDataDocument);
        }
        if (identifiers != null && identifiers.size() > 0 && (displayMessageNode = writeResultDocument.selectSingleNode("//displayMessage")) != null) {
            String displayMessageText = displayMessageNode.getText();
            displayMessageText = String.format("%s Could not process document(s): %s", displayMessageText, identifiers.toString());
            displayMessageNode.setText(displayMessageText);
        }
        return writeResultDocument;
    }

    private List<String> getDocumentIdentifiers(String templateId, Document clinicalDataDocument) {
        ArrayList<String> recordIdentifiers = new ArrayList<String>();
        if (this.templateIdToDomainEntryPointListMap != null) {
            Set<DomainEntryPoint> domainEntryPoints = this.templateIdToDomainEntryPointListMap.get(templateId);
            if (domainEntryPoints == null) {
                throw new RuntimeException(ErrorCodeEnum.WRITE_REQUEST_SIMPLE_INVALID_TEMPLATE_ID.getClientMessage());
            }
            Element documentRoot = clinicalDataDocument.getRootElement();
            Element patientElement = documentRoot.element("patient");
            for (DomainEntryPoint domainEntryPoint : domainEntryPoints) {
                List<Element> clinicalRecords = domainEntryPoint.getClinicalRecords(patientElement);
                if (clinicalRecords == null || clinicalRecords.size() <= 0) continue;
                for (Element clinicalRecord : clinicalRecords) {
                    String documentId;
                    Node documentIdentifier = clinicalRecord.selectSingleNode("//documentIdentifier/identity");
                    if (documentIdentifier == null || (documentId = documentIdentifier.getText()) == null || documentId.length() <= 0) continue;
                    recordIdentifiers.add(documentId);
                }
            }
        }
        return recordIdentifiers;
    }

    @Required
    public void setTemplateIdToDomainEntryPointListMap(Map<String, Set<DomainEntryPoint>> templateIdToDomainEntryPointListMap) {
        this.templateIdToDomainEntryPointListMap = templateIdToDomainEntryPointListMap;
    }

    @Resource
    public void setStatusElementName(String statusElementName) {
        this.statusElementName = statusElementName;
    }
}

