/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.logger;

import gov.va.med.cds.audit.AbstractAuditLog;
import gov.va.med.cds.audit.persistence.AuditLogPersistenceManagerInterface;
import gov.va.med.cds.ejb.interceptor.CdsLoggerAuditAutowiredInterceptor;
import gov.va.med.cds.util.LogMessageUtil;
import javax.interceptor.Interceptors;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.jndi.JndiTemplate;

@Interceptors(value={CdsLoggerAuditAutowiredInterceptor.class})
public class ReadAuditMessageDrivenBean
implements MessageListener {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private JndiTemplate jndiTemplate = new JndiTemplate();
    private static final String DEFAULT_AUDIT_LOG_PM_BEAN_ID = "cdsHibernateAuditLogPersistenceManager";
    private AuditLogPersistenceManagerInterface auditLogPersistenceManager;
    @Autowired
    protected ApplicationContext appContext;

    public void ejbCreate() {
        String auditPmBeanId = (String)this.safeGetEnvironmentEntry("java:comp/env/ejb/AuditLogPersistenceManagerBeanId", String.class, DEFAULT_AUDIT_LOG_PM_BEAN_ID);
        this.auditLogPersistenceManager = (AuditLogPersistenceManagerInterface)this.appContext.getBean(auditPmBeanId);
    }

    public void onMessage(Message readRequestAuditInformation) {
        try {
            ObjectMessage objectMessage = (ObjectMessage)readRequestAuditInformation;
            this.auditLogPersistenceManager.storeAuditLog((AbstractAuditLog)objectMessage.getObject());
        }
        catch (Exception e) {
            this.logger.error((Object)LogMessageUtil.buildMessage(null, null, (String)this.auditLogPersistenceManager.getAppName(), (String)"Error auditing read request message. "), (Throwable)e);
        }
    }

    protected Object safeGetEnvironmentEntry(String name, Class type, Object defaultValue) {
        Object environmentEntry = defaultValue;
        try {
            environmentEntry = this.jndiTemplate.lookup(name, type);
        }
        catch (NamingException ne) {
            this.logger.warn((Object)String.format("Error initializing CDS VIM MDB. Error Reason: %s", ne.getMessage()), (Throwable)ne);
        }
        return environmentEntry;
    }
}

