/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.rpc.ejb;

import gov.va.med.cds.audit.VhimRequestAuditLoggerInterface;
import gov.va.med.cds.client.ClinicalDataServiceInterface;
import gov.va.med.cds.ejb.interceptor.CdsAutowiredInterceptor;
import gov.va.med.cds.util.LogMessageUtil;
import gov.va.med.repositories.Pathways;
import javax.ejb.Stateless;
import javax.interceptor.Interceptors;
import javax.jws.WebService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@WebService(endpointInterface="gov.va.med.repositories.Pathways", targetNamespace="http://repositories.med.DNS   /pathways", portName="PathwaysHttpPort", serviceName="Pathways")
@Stateless(name="ClinicalDataServiceRpcSynchronous", mappedName="ejb/remote/gov/va/med/cds/ClinicalDataServiceRpcSynchronousSession")
@Interceptors(value={CdsAutowiredInterceptor.class})
public class ClinicalDataServiceRpcSynchronousSession
implements Pathways {
    protected final Log logger = LogFactory.getLog(this.getClass());
    @Autowired
    private ClinicalDataServiceInterface clinicalDataServiceSynchronous;
    @Autowired
    private String pathwaysAppName;
    @Autowired
    @Qualifier(value="vhimRequestPathwaysAuditLogger")
    private VhimRequestAuditLoggerInterface vhimRequestPathwaysAuditLogger;
    @Autowired
    @Qualifier(value="vhimRequestAuditLogger")
    private VhimRequestAuditLoggerInterface vhimRequestAuditLogger;

    public boolean isAlive() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)LogMessageUtil.buildMessage(null, null, (String)this.pathwaysAppName, (String)"About to call the POMO isAlive() method from inside the SLSB"));
        }
        boolean result = this.clinicalDataServiceSynchronous.isAlive();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)LogMessageUtil.buildMessage(null, null, (String)this.pathwaysAppName, (String)"Finished calling the POMO isAlive() method from inside the SLSB"));
        }
        return result;
    }

    public String readData(String templateId, String filterRequest, String filterId, String requestId) {
        long startTime = System.currentTimeMillis();
        if (filterRequest != null) {
            filterRequest = filterRequest.trim();
        }
        String response = this.clinicalDataServiceSynchronous.readClinicalData(templateId, filterRequest, filterId, requestId);
        this.vhimRequestPathwaysAuditLogger.auditReadRequest(templateId, filterRequest, filterId, requestId, startTime, response);
        return response;
    }

    public String createData(String createXml, String templateId, String requestId) {
        long startTime = System.currentTimeMillis();
        if (createXml != null) {
            createXml = createXml.trim();
        }
        this.vhimRequestAuditLogger.auditWriteRequest(templateId, createXml, requestId);
        String response = this.clinicalDataServiceSynchronous.createClinicalData(createXml, templateId, requestId, false);
        return response;
    }
}

