/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.ejb;

import gov.va.med.cds.audit.VhimRequestAuditLoggerInterface;
import gov.va.med.cds.client.ClinicalDataServiceInterface;
import gov.va.med.cds.client.webservice.ClinicalDataServiceSynchronousInterface;
import gov.va.med.cds.ejb.interceptor.CdsAutowiredInterceptor;
import gov.va.med.cds.util.LogMessageUtil;
import javax.ejb.Stateless;
import javax.interceptor.Interceptors;
import javax.jws.WebService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@WebService(serviceName="ClinicalDataServiceSynchronousInterface", portName="ClinicalDataServiceSynchronousInterfaceHttpPort", endpointInterface="gov.va.med.cds.client.webservice.ClinicalDataServiceSynchronousInterface", targetNamespace="http://client.cds.med.DNS   ")
@Stateless(name="ClinicalDataServiceSynchronous", mappedName="ejb/remote/gov/va/med/cds/ClinicalDataServiceSynchronousSession")
@Interceptors(value={CdsAutowiredInterceptor.class})
public class ClinicalDataServiceSynchronousSession
implements ClinicalDataServiceSynchronousInterface {
    protected final Log logger = LogFactory.getLog(this.getClass());
    @Autowired
    private ClinicalDataServiceInterface clinicalDataSourceSynchronous;
    @Autowired
    @Qualifier(value="vhimRequestAuditLogger")
    private VhimRequestAuditLoggerInterface vhimRequestAuditLogger;
    @Autowired
    private String cdsAppName;

    public String appendClinicalData(String appendRequest, String templateId, String requestId) {
        if (appendRequest != null) {
            appendRequest = appendRequest.trim();
        }
        this.vhimRequestAuditLogger.auditWriteRequest(templateId, appendRequest, requestId);
        return this.clinicalDataSourceSynchronous.appendClinicalData(appendRequest, templateId, requestId);
    }

    public String createClinicalData(String createRequest, String templateId, String requestId) {
        if (createRequest != null) {
            createRequest = createRequest.trim();
        }
        this.vhimRequestAuditLogger.auditWriteRequest(templateId, createRequest, requestId);
        return this.clinicalDataSourceSynchronous.createClinicalData(createRequest, templateId, requestId);
    }

    public String createClinicalData(String createRequest, String templateId, String requestId, boolean auditVhimRequest) {
        if (createRequest != null) {
            createRequest = createRequest.trim();
        }
        if (auditVhimRequest) {
            this.vhimRequestAuditLogger.auditWriteRequest(templateId, createRequest, requestId);
        }
        return this.clinicalDataSourceSynchronous.createClinicalData(createRequest, templateId, requestId);
    }

    public String deleteClinicalData(String deleteRequest, String templateId, String requestId) {
        if (deleteRequest != null) {
            deleteRequest = deleteRequest.trim();
        }
        this.vhimRequestAuditLogger.auditWriteRequest(templateId, deleteRequest, requestId);
        return this.clinicalDataSourceSynchronous.deleteClinicalData(deleteRequest, templateId, requestId);
    }

    public String readClinicalData(String templateId, String filterId, String requestId) {
        throw new UnsupportedOperationException();
    }

    public String readClinicalData(String templateId, String filterRequest, String filterId, String requestId) {
        if (filterRequest != null) {
            filterRequest = filterRequest.trim();
        }
        return this.readClinicalData(templateId, filterRequest, filterId, requestId, true);
    }

    public String readClinicalData(String templateId, String filterRequest, String filterId, String requestId, boolean audit) {
        long startTime = System.currentTimeMillis();
        if (filterRequest != null) {
            filterRequest = filterRequest.trim();
        }
        String response = this.clinicalDataSourceSynchronous.readClinicalData(templateId, filterRequest, filterId, requestId);
        if (audit) {
            this.vhimRequestAuditLogger.auditReadRequest(templateId, filterRequest, filterId, requestId, startTime, response);
        }
        return response;
    }

    public String updateClinicalData(String updateRequest, String templateId, String requestId) {
        if (updateRequest != null) {
            updateRequest = updateRequest.trim();
        }
        this.vhimRequestAuditLogger.auditWriteRequest(templateId, updateRequest, requestId);
        return this.clinicalDataSourceSynchronous.updateClinicalData(updateRequest, templateId, requestId);
    }

    public boolean isAlive() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)LogMessageUtil.buildMessage(null, null, (String)this.cdsAppName, (String)"About to call the POMO isAlive() method from inside the SLSB"));
        }
        boolean result = this.clinicalDataSourceSynchronous.isAlive();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)LogMessageUtil.buildMessage(null, null, (String)this.cdsAppName, (String)"Finished calling the POMO isAlive() method from inside the SLSB"));
        }
        return result;
    }

    public void setClinicalDataServiceSynchronous(ClinicalDataServiceInterface clinicalDataSourceSynchronous) {
        this.clinicalDataSourceSynchronous = clinicalDataSourceSynchronous;
    }

    public void setVhimRequestAuditLogger(VhimRequestAuditLoggerInterface vhimRequestAuditLogger) {
        this.vhimRequestAuditLogger = vhimRequestAuditLogger;
    }
}

