/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.ejb;

import gov.va.med.cds.audit.VhimRequestAuditLoggerInterface;
import gov.va.med.cds.client.ClinicalDataServiceInterface;
import gov.va.med.cds.clinicaldata.vhim400.ClinicalDataResponseInterface;
import gov.va.med.cds.exception.ErrorCodeEnum;
import gov.va.med.cds.exception.RuntimeMDBOnMessageException;
import gov.va.med.cds.response.util.ResponseErrorSectionExtractor;
import gov.va.med.cds.util.LogMessageUtil;
import java.nio.ByteBuffer;
import javax.annotation.PostConstruct;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.core.MessageCreator;
import org.springframework.jndi.JndiTemplate;

public abstract class AbstractCdsVhimClinicalMdb
implements MessageListener {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private static String TEMPLATE_ID = "TEMPLATE_ID";
    private static String REQUEST_ID = "REQUEST_ID";
    private static String NO_REQUEST_ID_PROVIDED = "NO_REQUEST_ID";
    private JndiTemplate jndiTemplate = new JndiTemplate();
    private Boolean persistOriginalMessage;
    protected ClinicalDataServiceInterface cdsService;
    private ResponseErrorSectionExtractor responseErrorSectionExtractor;
    private VhimRequestAuditLoggerInterface vhimRequestAuditLogger;
    private JmsTemplate responseJmsTemplate;
    private String cdsAppName;
    private ClinicalDataResponseInterface clinicalDataResponse;
    private BeanFactory beanFactory;

    @PostConstruct
    protected void onEjbCreate() {
        try {
            this.beanFactory = new ClassPathXmlApplicationContext("classpath:gov/va/med/cds/ejb/config/weblogicApplicationContext.xml");
            this.persistOriginalMessage = (Boolean)this.safeGetEnvironmentEntry("java:comp/env/ejb/vhim400/defaultPersistOriginalMessage", Boolean.class, Boolean.TRUE);
            this.vhimRequestAuditLogger = (VhimRequestAuditLoggerInterface)this.beanFactory.getBean("vhimRequestAuditLogger");
            this.cdsService = (ClinicalDataServiceInterface)this.beanFactory.getBean("clinicalDataServiceSynchronous");
            this.responseErrorSectionExtractor = (ResponseErrorSectionExtractor)this.beanFactory.getBean("responseErrorSectionExtractor");
            this.responseJmsTemplate = (JmsTemplate)this.beanFactory.getBean("responseTopicJmsTemplate");
            this.clinicalDataResponse = (ClinicalDataResponseInterface)this.beanFactory.getBean("clinicalDataResponse");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected Object safeGetEnvironmentEntry(String name, Class type, Object defaultValue) {
        Object environmentEntry = defaultValue;
        try {
            environmentEntry = this.jndiTemplate.lookup(name, type);
        }
        catch (NamingException ne) {
            this.logger.warn((Object)String.format("Error initializing CDS VIM MDB. Error Reason: %s", ne.getMessage()), (Throwable)ne);
        }
        return environmentEntry;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onMessage(Message message) {
        String templateId = null;
        String requestId = null;
        String response = null;
        try {
            byte[] messageBytes = null;
            templateId = message.getStringProperty(TEMPLATE_ID);
            requestId = message.getStringProperty(REQUEST_ID);
            if (message instanceof BytesMessage) {
                BytesMessage bytesMsg = (BytesMessage)message;
                int msgLength = (int)bytesMsg.getBodyLength();
                messageBytes = new byte[msgLength];
                bytesMsg.readBytes(messageBytes);
            } else if (message instanceof TextMessage) {
                TextMessage textMsg = (TextMessage)message;
                messageBytes = textMsg.getText().getBytes();
            }
            ByteBuffer messageBuffer = ByteBuffer.wrap(messageBytes);
            String vhimPayload = new String(messageBuffer.array());
            if (this.persistOriginalMessage.booleanValue()) {
                this.vhimRequestAuditLogger.auditWriteRequest(templateId, vhimPayload, requestId);
            }
            response = this.doClinicalOperation(vhimPayload, templateId, requestId);
            this.responseErrorSectionExtractor.checkForErrorsInResponse(response);
        }
        catch (Exception e) {
            try {
                String msg = "Exception occured while processing CDS write request message.";
                this.logger.error((Object)LogMessageUtil.buildMessage(null, (String)requestId, (String)this.cdsAppName, (String)msg), (Throwable)e);
                if (response == null) {
                    templateId = templateId != null ? templateId : "CdsResponse400";
                    requestId = requestId != null ? requestId : NO_REQUEST_ID_PROVIDED;
                    response = this.clinicalDataResponse.buildEmptyClinicalDocument(templateId, requestId).asXML();
                }
                throw new RuntimeMDBOnMessageException(ErrorCodeEnum.MDB_ON_MESSAGE_JMS_EXCEPTION, (Throwable)e, new String[]{msg});
            }
            catch (Throwable throwable) {
                try {
                    String responseMessage = response;
                    String responseTemplateId = templateId;
                    String responseRequestId = requestId;
                    Destination destination = message.getJMSReplyTo();
                    if (destination == null) {
                        destination = this.responseJmsTemplate.getDefaultDestination();
                    }
                    if (responseMessage == null) throw throwable;
                    this.responseJmsTemplate.send(destination, new MessageCreator(responseMessage, responseTemplateId, responseRequestId){
                        final /* synthetic */ String val$responseMessage;
                        final /* synthetic */ String val$responseTemplateId;
                        final /* synthetic */ String val$responseRequestId;
                        {
                            this.val$responseMessage = string;
                            this.val$responseTemplateId = string2;
                            this.val$responseRequestId = string3;
                        }

                        public Message createMessage(Session session) throws JMSException {
                            TextMessage message = session.createTextMessage(this.val$responseMessage);
                            message.setStringProperty(TEMPLATE_ID, this.val$responseTemplateId);
                            message.setStringProperty(REQUEST_ID, this.val$responseRequestId);
                            return message;
                        }
                    });
                    throw throwable;
                }
                catch (Exception ex2) {
                    String errMsg = "Failed to publish response message to JMS destination.";
                    this.logger.error((Object)LogMessageUtil.buildMessage(null, (String)requestId, (String)this.cdsAppName, (String)errMsg), (Throwable)ex2);
                    throw new RuntimeMDBOnMessageException(ErrorCodeEnum.MDB_ON_MESSAGE_JMS_EXCEPTION, (Throwable)ex2, new String[]{errMsg});
                }
            }
        }
        try {
            String responseMessage = response;
            String responseTemplateId = templateId;
            String responseRequestId = requestId;
            Destination destination = message.getJMSReplyTo();
            if (destination == null) {
                destination = this.responseJmsTemplate.getDefaultDestination();
            }
            if (responseMessage == null) return;
            this.responseJmsTemplate.send(destination, new /* invalid duplicate definition of identical inner class */);
            return;
        }
        catch (Exception ex2) {
            String errMsg = "Failed to publish response message to JMS destination.";
            this.logger.error((Object)LogMessageUtil.buildMessage(null, (String)requestId, (String)this.cdsAppName, (String)errMsg), (Throwable)ex2);
            throw new RuntimeMDBOnMessageException(ErrorCodeEnum.MDB_ON_MESSAGE_JMS_EXCEPTION, (Throwable)ex2, new String[]{errMsg});
        }
    }

    protected abstract String doClinicalOperation(String var1, String var2, String var3);

    public void setPersistOriginalMessage(Boolean persistOriginalMessage) {
        this.persistOriginalMessage = persistOriginalMessage;
    }

    public void setCdsService(ClinicalDataServiceInterface cdsService) {
        this.cdsService = cdsService;
    }

    public void setResponseErrorSectionExtractor(ResponseErrorSectionExtractor responseErrorSectionExtractor) {
        this.responseErrorSectionExtractor = responseErrorSectionExtractor;
    }

    public void setVhimRequestAuditLogger(VhimRequestAuditLoggerInterface vhimRequestAuditLogger) {
        this.vhimRequestAuditLogger = vhimRequestAuditLogger;
    }

    public void setClinicalDataResponse(ClinicalDataResponseInterface clinicalDataResponse) {
        this.clinicalDataResponse = clinicalDataResponse;
    }

    public void setResponseJmsTemplate(JmsTemplate responseJmsTemplate) {
        this.responseJmsTemplate = responseJmsTemplate;
    }
}

