/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.xml.schema;

import gov.va.med.cds.exception.ErrorCodeEnum;
import gov.va.med.cds.template.DefaultTemplateMetaData;
import gov.va.med.cds.template.TemplateMetaDataInterface;
import gov.va.med.cds.vdm.VhimVersion;
import gov.va.med.cds.xml.EntityResolver;
import gov.va.med.cds.xml.PathReplacementEntityResolver;
import gov.va.med.cds.xml.schema.SchemaException;
import gov.va.med.cds.xml.schema.SchemaHelperInterface;
import gov.va.med.cds.xml.schema.SchemaValidationException;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.xsd.XSDAttributeUse;
import org.eclipse.xsd.XSDComplexTypeContent;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDParticleContent;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.util.XSDResourceFactoryImpl;
import org.eclipse.xsd.util.XSDResourceImpl;
import org.springframework.core.io.DefaultResourceLoader;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseSchemaHelper
implements SchemaHelperInterface {
    private TemplateMetaDataInterface metaData = null;
    private Map<String, Set<String>> classMap;
    private EntityResolver schemaEntityResolver;
    private String schemaUrl;
    private Log logger = LogFactory.getLog(EclipseSchemaHelper.class);
    private Schema schema;

    public EclipseSchemaHelper(org.springframework.core.io.Resource schemaResource, EntityResolver aSchemaEntityResolver) throws SchemaException {
        this.schemaEntityResolver = aSchemaEntityResolver;
        try {
            this.setupSymbolMapAndMetaData(schemaResource);
            this.createCompiledSchema(schemaResource);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Loaded schema " + schemaResource.getURL() + " with template ID " + this.metaData.getTemplateId()));
            }
        }
        catch (SAXException e) {
            throw new SchemaException(ErrorCodeEnum.CANNOT_PARSE_SCHEMA, (Throwable)e, schemaResource.toString());
        }
        catch (IOException e) {
            throw new SchemaException(ErrorCodeEnum.CANNOT_PARSE_SCHEMA, (Throwable)e, schemaResource.toString());
        }
    }

    private void setupSymbolMapAndMetaData(org.springframework.core.io.Resource schemaResource) throws IOException, SchemaException {
        this.metaData = new DefaultTemplateMetaData();
        this.classMap = new HashMap<String, Set<String>>();
        this.schemaUrl = schemaResource.getURL().getFile();
        XSDSchema xsdSchema = this.findSchema(this.schemaUrl);
        this.mapTemplateSchema(xsdSchema);
    }

    private void createCompiledSchema(org.springframework.core.io.Resource schemaResource) throws SchemaValidationException, IOException, SAXException {
        String language = "http://www.w3.org/2001/XMLSchema";
        SchemaFactory factory = SchemaFactory.newInstance(language);
        LocalErrorHandler localErrorHandler = new LocalErrorHandler();
        factory.setErrorHandler(localErrorHandler);
        factory.setResourceResolver(this.schemaEntityResolver);
        StreamSource ss = new StreamSource(schemaResource.getInputStream());
        this.schema = factory.newSchema(ss);
        if (localErrorHandler.parseException != null) {
            throw localErrorHandler.parseException;
        }
    }

    @Override
    public TemplateMetaDataInterface getMetaData() {
        return this.metaData;
    }

    @Override
    public Map<String, Set<String>> getSymbolMap() {
        return this.classMap;
    }

    @Override
    public String getTemplateId() {
        String templateId = "";
        if (this.metaData != null) {
            templateId = this.metaData.getTemplateId();
        }
        return templateId;
    }

    @Override
    public void validate(String xmlInstance) throws SchemaValidationException {
        try {
            Validator validator = this.schema.newValidator();
            validator.validate(new StreamSource(new StringReader(xmlInstance)));
        }
        catch (SAXException e) {
            throw new SchemaValidationException(ErrorCodeEnum.SCHEMA_VALIDATION_FAILED, (Throwable)e, xmlInstance);
        }
        catch (IOException e) {
            throw new SchemaValidationException(ErrorCodeEnum.SCHEMA_VALIDATION_FAILED, (Throwable)e, xmlInstance);
        }
    }

    private XSDSchema findSchema(String url) throws SchemaException {
        XSDSchema schema = null;
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getLoadOptions().put(XSDResourceImpl.XSD_TRACK_LOCATION, Boolean.TRUE);
        Resource emfResource = null;
        URI uri = URI.createFileURI((String)url);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("In " + EclipseSchemaHelper.class.getName() + " about to load an emf resource from URI = " + url));
        }
        try {
            emfResource = resourceSet.getResource(uri, true);
        }
        catch (RuntimeException e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Exception thrown when trying load resource with URI " + uri), (Throwable)e);
            }
            throw new SchemaException(ErrorCodeEnum.CANNOT_FIND_SCHEMA, (Throwable)e, url);
        }
        if (emfResource instanceof XSDResourceImpl) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("In " + EclipseSchemaHelper.class.getName() + " the resource created for URI " + url + " is a " + emfResource.getClass()));
            }
            XSDResourceImpl xsdResource = (XSDResourceImpl)emfResource;
            schema = xsdResource.getSchema();
            this.metaData.setTargetNamespace(schema.getTargetNamespace());
        }
        if (schema == null) {
            throw new SchemaException(ErrorCodeEnum.CANNOT_FIND_SCHEMA, url);
        }
        return schema;
    }

    protected void mapTemplateSchema(XSDSchema schema) {
        EList types = schema.getTypeDefinitions();
        for (Object type : types) {
            XSDTypeDefinition typedef = (XSDTypeDefinition)type;
            if (!(typedef instanceof XSDComplexTypeDefinition)) continue;
            String classKey = typedef.getTargetNamespace() + "." + typedef.getName();
            HashSet memberSet = new HashSet();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("adding " + classKey.toUpperCase() + " to the symbol map."));
            }
            this.classMap.put(classKey.toUpperCase(), memberSet);
            XSDComplexTypeDefinition cType = (XSDComplexTypeDefinition)typedef;
            XSDTypeDefinition baseTypeObj = cType.getBaseType();
            if (!cType.getDerivationMethod().getName().equals("restriction")) {
                this.processParent(baseTypeObj, memberSet);
            }
            this.listAttributes(cType, memberSet);
            this.listContents(cType, memberSet);
        }
    }

    private void listContents(XSDComplexTypeDefinition cType, Set memberSet) {
        XSDParticle content;
        XSDParticleContent modContent;
        XSDComplexTypeContent contentObj = cType.getContent();
        if (contentObj != null && contentObj instanceof XSDParticle && (modContent = (content = (XSDParticle)contentObj).getContent()) instanceof XSDModelGroup) {
            XSDModelGroup modelContent = (XSDModelGroup)modContent;
            EList modelContents = modelContent.getParticles();
            for (Object partObj : modelContents) {
                XSDParticle particle;
                XSDParticleContent decObj;
                if (!(partObj instanceof XSDParticle) || !((decObj = (particle = (XSDParticle)partObj).getContent()) instanceof XSDElementDeclaration)) continue;
                XSDElementDeclaration declaration = (XSDElementDeclaration)decObj;
                String declarationName = declaration.getName();
                if ((declarationName = StringUtils.remove((String)declarationName, (String)"_")) != null) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("adding " + declarationName + " to the symbol set."));
                    }
                    memberSet.add(declarationName.toUpperCase());
                    continue;
                }
                declarationName = declaration.getResolvedElementDeclaration().getName();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("adding resolved name " + declarationName + " to the symbol set."));
                }
                memberSet.add(declarationName.toUpperCase());
            }
        }
    }

    private void listAttributes(XSDComplexTypeDefinition cType, Set memberSet) {
        boolean newAddedAttribute = true;
        String attributeName = null;
        EList attributes = cType.getAttributeUses();
        for (Object attrib : attributes) {
            XSDAttributeUse attribute = (XSDAttributeUse)attrib;
            attributeName = attribute.getAttributeDeclaration().getName().toUpperCase();
            attributeName = StringUtils.remove((String)attributeName, (String)"_");
            memberSet.add(attributeName);
            newAddedAttribute = memberSet.add(attributeName);
            if (newAddedAttribute) continue;
            newAddedAttribute = true;
            if ("TEMPLATEID".equals(attributeName)) {
                this.metaData.setTemplateId((String)attribute.getValue());
                continue;
            }
            if (!"VHIMVERSION".equals(attributeName)) continue;
            this.metaData.setVhimVersion(VhimVersion.valueOf((String)attribute.getValue()));
        }
    }

    private void processParent(Object baseTypeObj, Set memberSet) {
        if (baseTypeObj == null || !(baseTypeObj instanceof XSDComplexTypeDefinition)) {
            return;
        }
        XSDComplexTypeDefinition type = (XSDComplexTypeDefinition)baseTypeObj;
        if ("anyType".equals(type.getName())) {
            return;
        }
        this.listAttributes(type, memberSet);
        this.listContents(type, memberSet);
        XSDTypeDefinition parent = type.getBaseType();
        this.processParent(parent, memberSet);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Schema URL: " + this.schemaUrl + "\n");
        if (this.classMap != null) {
            ArrayList<String> sortedKeys = new ArrayList<String>(this.classMap.keySet());
            Collections.sort(sortedKeys);
            for (String key : sortedKeys) {
                ArrayList sortedAttributes = new ArrayList(this.classMap.get(key));
                Collections.sort(sortedAttributes);
                buf.append("  " + key + ": ");
                boolean first = true;
                for (String attribute : sortedAttributes) {
                    if (first) {
                        first = false;
                    } else {
                        buf.append(", ");
                    }
                    buf.append(" " + attribute);
                }
                buf.append("\n");
            }
        }
        return buf.toString();
    }

    public static void main(String[] args) throws SchemaException {
        String defaultSchemaUrl;
        String schemaUrl = defaultSchemaUrl = "gov/va/med/cds/vhim/vhim3400/allergies/strictfullread00001/template/StrictFullRead00001.xsd";
        if (args.length == 1) {
            schemaUrl = args[0];
        }
        DefaultResourceLoader loader = new DefaultResourceLoader();
        org.springframework.core.io.Resource schemaResource = loader.getResource(schemaUrl);
        PathReplacementEntityResolver schemaEntityResolver = new PathReplacementEntityResolver("/vhim/", "gov/va/med/cds/vhim/");
        EclipseSchemaHelper eclipseSchemaHelper = new EclipseSchemaHelper(schemaResource, schemaEntityResolver);
        System.out.print(eclipseSchemaHelper.toString());
    }

    static {
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("xsd", new XSDResourceFactoryImpl());
    }

    private class LocalErrorHandler
    extends DefaultHandler
    implements ErrorHandler {
        public SchemaValidationException parseException = null;

        private LocalErrorHandler() {
        }

        public void error(SAXParseException e) throws SAXException {
            this.parseException = new SchemaValidationException(e);
            EclipseSchemaHelper.this.logger.error((Object)"The following error occured when validating an xml instance against a schema", (Throwable)e);
        }

        public void fatalError(SAXParseException e) throws SAXException {
            this.parseException = new SchemaValidationException(e);
            EclipseSchemaHelper.this.logger.fatal((Object)"The following error occured when validating an xml instance against a schema", (Throwable)e);
        }

        public void warning(SAXParseException e) throws SAXException {
            if (EclipseSchemaHelper.this.logger.isWarnEnabled()) {
                EclipseSchemaHelper.this.logger.warn((Object)"A problem occurred when validating an xml instance against a schema", (Throwable)e);
            }
        }
    }
}

