/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.template;

import gov.va.med.cds.exception.ErrorCodeEnum;
import gov.va.med.cds.exception.InitializationException;
import gov.va.med.cds.request.ReadRequestInterface;
import gov.va.med.cds.request.ValidationException;
import gov.va.med.cds.request.WriteRequestInterface;
import gov.va.med.cds.template.TemplateMetaDataInterface;
import gov.va.med.cds.template.TemplateMetaDataProviderInterface;
import gov.va.med.cds.template.TemplateValidatorInterface;
import gov.va.med.cds.vdm.VhimVersion;
import gov.va.med.cds.xml.schema.SchemaException;
import gov.va.med.cds.xml.schema.SchemaHelperFactoryInterface;
import gov.va.med.cds.xml.schema.SchemaHelperInterface;
import gov.va.med.cds.xml.schema.SchemaSymbolMapProviderInterface;
import gov.va.med.cds.xml.schema.SchemaValidationException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateCache
implements TemplateValidatorInterface,
SchemaSymbolMapProviderInterface,
TemplateMetaDataProviderInterface {
    private static final Log logger = LogFactory.getLog(TemplateCache.class);
    private Resource[] schemas = null;
    private SchemaHelperFactoryInterface schemaHelperFactory = null;
    private Map<String, SchemaHelperInterface> schemaHelperMap = new HashMap<String, SchemaHelperInterface>();

    public TemplateCache(SchemaHelperFactoryInterface schemaHelperFactory, Resource[] schemas) {
        this.schemaHelperFactory = schemaHelperFactory;
        this.schemas = schemas;
        if (logger.isDebugEnabled()) {
            logger.debug("Constructor of " + TemplateCache.class.getName() + ". About to initialize " + schemas == null ? Integer.valueOf(0) : schemas.length + " templates");
        }
        this.init();
    }

    @Override
    public TemplateMetaDataInterface validate(WriteRequestInterface writeRequest) {
        String requestXml = writeRequest.getRequestData();
        String templateId = this.getTemplateId(requestXml);
        VhimVersion vhimVersion = this.getVhimVersion(requestXml);
        SchemaHelperInterface schemaHelper = this.schemaHelperMap.get(templateId);
        if (schemaHelper == null) {
            throw new ValidationException(ErrorCodeEnum.WRITE_REQUEST_TEMPLATE_ID_INVALID, templateId);
        }
        if (vhimVersion == null) {
            throw new ValidationException(ErrorCodeEnum.WRITE_REQUEST_VHIM_VERSION_NULL, schemaHelper.getMetaData().getVhimVersion().getVersion());
        }
        if (vhimVersion != schemaHelper.getMetaData().getVhimVersion()) {
            throw new ValidationException(ErrorCodeEnum.WRITE_REQUEST_VHIM_VERSION_INVALID, vhimVersion.getVersion(), schemaHelper.getMetaData().getVhimVersion().getVersion());
        }
        this.validateAgainstSchemaValidator(writeRequest, schemaHelper.getMetaData());
        return schemaHelper.getMetaData();
    }

    @Override
    public TemplateMetaDataInterface validate(ReadRequestInterface readRequest) {
        if (readRequest == null) {
            throw new ValidationException(ErrorCodeEnum.READ_REQUEST_OBJECT_NULL);
        }
        if (readRequest.getTemplateId() == null) {
            throw new ValidationException(ErrorCodeEnum.READ_REQUEST_TEMPLATE_ID_NULL);
        }
        String templateId = readRequest.getTemplateId();
        SchemaHelperInterface schemaHelper = this.schemaHelperMap.get(templateId);
        if (schemaHelper == null) {
            throw new ValidationException(ErrorCodeEnum.READ_REQUEST_TEMPLATE_ID_INVALID, templateId);
        }
        return schemaHelper.getMetaData();
    }

    private void validateAgainstSchemaValidator(WriteRequestInterface writeRequest, TemplateMetaDataInterface metaData) {
        SchemaHelperInterface schemaHelper = this.schemaHelperMap.get(metaData.getTemplateId());
        try {
            schemaHelper.validate(writeRequest.getRequestData());
        }
        catch (SchemaValidationException e) {
            throw new ValidationException(ErrorCodeEnum.READ_REQUEST_TEMPLATE_ID_VALIDATION_FAILED, (Throwable)e, metaData.getTemplateId(), ExceptionUtils.getRootCauseMessage((Throwable)e));
        }
    }

    private String getTemplateId(String aXmlString) {
        String templateId = null;
        String searchString = "templateId=\"";
        int templateIdIndex = aXmlString.indexOf(searchString);
        if (templateIdIndex != -1) {
            templateId = aXmlString.substring(templateIdIndex + searchString.length());
            templateId = templateId.substring(0, templateId.indexOf("\""));
        }
        return templateId;
    }

    private VhimVersion getVhimVersion(String aXmlString) {
        String vhimVersion = null;
        String searchString = "vhimVersion=\"";
        VhimVersion vhimVersionEnum = null;
        int templateIdIndex = aXmlString.indexOf(searchString);
        if (templateIdIndex != -1) {
            vhimVersion = aXmlString.substring(templateIdIndex + searchString.length());
            vhimVersion = vhimVersion.substring(0, vhimVersion.indexOf("\""));
        }
        if (vhimVersion == null || vhimVersion == "") {
            throw new ValidationException(ErrorCodeEnum.VHIM_VERSION_IS_REQUIRED);
        }
        try {
            vhimVersionEnum = VhimVersion.valueOf(vhimVersion);
        }
        catch (IllegalArgumentException e) {
            throw new ValidationException(ErrorCodeEnum.ENCOUNTERED_WRONG_VHIM_VERSION, vhimVersion);
        }
        return vhimVersionEnum;
    }

    private void init() {
        if (this.schemas == null) {
            throw new InitializationException(ErrorCodeEnum.MISSING_SCHEMA_RESOURCE_LIST);
        }
        if (this.schemaHelperFactory == null) {
            throw new InitializationException(ErrorCodeEnum.MISSING_SCHEMA_HELPER_FACTORY);
        }
        for (Resource resource : this.schemas) {
            this.loadSchemaIntoCache(resource);
        }
    }

    private void loadSchemaIntoCache(Resource schemaResource) {
        SchemaHelperInterface schemaHelper;
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("About to create a schema helper for the schema " + schemaResource.getFilename()));
            }
            schemaHelper = this.schemaHelperFactory.create(schemaResource);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Finished creating a schema helper for the schema " + schemaResource.getFilename()));
            }
        }
        catch (SchemaException e) {
            throw new InitializationException(ErrorCodeEnum.UNABLE_TO_LOAD_SCHEMAS_INTO_CACHE, (Throwable)e);
        }
        if (!this.schemaHelperMap.containsKey(schemaHelper.getTemplateId())) {
            this.schemaHelperMap.put(schemaHelper.getTemplateId(), schemaHelper);
        } else if (logger.isWarnEnabled()) {
            logger.warn((Object)("The template ID='" + schemaHelper.getTemplateId() + "' already exists. The template registry will not add another one."));
        }
    }

    @Override
    public Map<String, Set<String>> getSymbolMap(String templateId) {
        SchemaHelperInterface schemaHelper = this.schemaHelperMap.get(templateId);
        if (schemaHelper == null) {
            throw new ValidationException(ErrorCodeEnum.INVALID_TEMPLATE, templateId);
        }
        return schemaHelper.getSymbolMap();
    }

    @Override
    public TemplateMetaDataInterface getTemplateMetaDataByTemplateId(String templateId) {
        return this.schemaHelperMap.get(templateId).getMetaData();
    }

    @Override
    public TemplateMetaDataInterface getDefaultResponseTemplateMetaData() {
        return this.schemaHelperMap.get("99999").getMetaData();
    }
}

