/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.persistence.hibernate;

import gov.va.med.cds.cdm.clinicaldata.RequestType;
import gov.va.med.cds.cdm.datatype.IdentityInterface;
import gov.va.med.cds.exception.ErrorCodeEnum;
import gov.va.med.cds.filter.CdsPersistenceFilterInterface;
import gov.va.med.cds.persistence.PersistenceException;
import gov.va.med.cds.persistence.PersistenceManagerInterface;
import gov.va.med.cds.persistence.ReadException;
import gov.va.med.cds.persistence.hibernate.AppenderFactory;
import gov.va.med.cds.persistence.hibernate.AppenderInterface;
import gov.va.med.cds.persistence.hibernate.HibernateConstraintViolationException;
import gov.va.med.cds.persistence.hibernate.IdentityException;
import gov.va.med.cds.persistence.hibernate.UpdaterFactory;
import gov.va.med.cds.persistence.hibernate.UpdaterInterface;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Example;
import org.hibernate.exception.ConstraintViolationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernatePersistenceManager
implements PersistenceManagerInterface {
    private static final Log logger = LogFactory.getLog(HibernatePersistenceManager.class);
    private SessionFactory sessionFactory;
    private Transaction transaction = null;
    private Session session = null;

    private Query buildQuery(Session aSession, CdsPersistenceFilterInterface aCdsFilter) throws ReadException {
        String queryName = aCdsFilter.getEntryPoint();
        List<String> vpids = aCdsFilter.getVpids();
        boolean useVpid = false;
        boolean useDates = false;
        if (vpids != null && vpids.size() > 0) {
            useVpid = true;
            queryName = queryName + ".patient";
            if (aCdsFilter.getFormattedStringStartDate() != null) {
                useDates = true;
                queryName = queryName + ".date";
            }
        }
        if (!useVpid) {
            throw new ReadException(ErrorCodeEnum.NO_VPID_REQUESTED);
        }
        Query query = aSession.getNamedQuery(queryName);
        query.setParameterList("patient", vpids);
        if (useDates) {
            query.setParameter("startDate", (Object)aCdsFilter.getFormattedStringStartDate());
            query.setParameter("endDate", (Object)aCdsFilter.getFormattedStringEndDate());
        }
        return query;
    }

    private Object readObject(IdentityInterface aIdentityInterface, Session aSession) throws IdentityException {
        IdentityInterface identityInterface = null;
        List results = null;
        try {
            identityInterface = (IdentityInterface)aIdentityInterface.getClass().newInstance();
            identityInterface.setIdentity(aIdentityInterface.getIdentity());
            Criteria criteria = aSession.createCriteria(aIdentityInterface.getClass());
            criteria.add((Criterion)Example.create((Object)identityInterface));
            results = criteria.list();
            if (results.size() != 1) {
                String message = aIdentityInterface.getClass().getName() + " with ID: " + aIdentityInterface.getIdentity();
                throw new IdentityException(ErrorCodeEnum.NON_UNIQUE_IDENTITY, message);
            }
        }
        catch (InstantiationException e) {
            String message = aIdentityInterface.getClass().getName() + " with ID: " + aIdentityInterface.getIdentity();
            throw new IdentityException(ErrorCodeEnum.CANT_CREATE_IDENTITY, (Throwable)e, message);
        }
        catch (IllegalAccessException e) {
            String message = aIdentityInterface.getClass().getName() + " with ID: " + aIdentityInterface.getIdentity();
            throw new IdentityException(ErrorCodeEnum.CANT_CREATE_IDENTITY, (Throwable)e, message);
        }
        return results.get(0);
    }

    @Override
    public List<Serializable> readData(CdsPersistenceFilterInterface aFilter) throws PersistenceException {
        List hibernateQueryResultList = (List)this.performCRUADOnClinicalData(RequestType.READ, aFilter);
        return hibernateQueryResultList;
    }

    @Override
    public List readByExampleData(Object aObject) throws ReadException {
        List results = null;
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(" --------- Reading data by example: " + aObject));
            }
            Criteria criteria = this.session.createCriteria(aObject.getClass());
            criteria.add((Criterion)Example.create((Object)aObject));
            results = criteria.list();
        }
        catch (HibernateException e) {
            throw new PersistenceException(ErrorCodeEnum.READ_BY_EXAMPLE_FAILURE, (Throwable)e, aObject.toString());
        }
        return results;
    }

    @Override
    public Object performCRUADOnClinicalData(RequestType aRequestType, Object aObject) throws PersistenceException {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(aRequestType.getOperationStartMessage() + aObject));
            }
            switch (aRequestType) {
                case CREATE: {
                    this.session.save(aObject);
                    break;
                }
                case READ: {
                    Query query = this.buildQuery(this.session, (CdsPersistenceFilterInterface)aObject);
                    List queryResults = query.list();
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)aRequestType.getOperationGoodMessage());
                    }
                    return queryResults;
                }
                case DELETE: {
                    this.session.delete(this.readObject((IdentityInterface)aObject, this.session));
                    break;
                }
                case APPEND: {
                    AppenderFactory appenderFactory = AppenderFactory.getInstance();
                    AppenderInterface appender = appenderFactory.createAppender(aObject.getClass());
                    Object appendToObject = this.readObject((IdentityInterface)aObject, this.session);
                    appender.append(appendToObject, aObject);
                    this.session.update(appendToObject);
                    break;
                }
                case UPDATE: {
                    UpdaterFactory updateFactory = UpdaterFactory.getInstance();
                    UpdaterInterface updater = updateFactory.createUpdater(aObject.getClass());
                    Object updateToObject = this.readObject((IdentityInterface)aObject, this.session);
                    updater.update(updateToObject, aObject);
                    this.session.update(updateToObject);
                    break;
                }
            }
            this.session.flush();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)aRequestType.getOperationGoodMessage());
            }
            return null;
        }
        catch (ConstraintViolationException e) {
            throw new HibernateConstraintViolationException(e, aObject);
        }
        catch (PersistenceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PersistenceException(ErrorCodeEnum.HDRII_OPERATION_FAILED, (Throwable)e, aRequestType.getType(), e.getMessage(), aObject.toString());
        }
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    @Override
    public void startTransaction() {
        this.session = this.sessionFactory.openSession();
        this.transaction = this.session.beginTransaction();
    }

    @Override
    public void commitTransaction() {
        this.transaction.commit();
        this.session.close();
    }

    @Override
    public void rollbackTransaction() {
        this.transaction.rollback();
        this.session.close();
    }
}

