/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.persistence.hibernate;

import gov.va.med.cds.exception.ErrorCodeEnum;
import gov.va.med.cds.persistence.PersistenceException;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.hibernate.exception.ConstraintViolationException;

public class HibernateConstraintViolationException
extends PersistenceException {
    public HibernateConstraintViolationException(String message) {
        super(message);
    }

    public HibernateConstraintViolationException(Throwable cause) {
        super(cause);
    }

    public HibernateConstraintViolationException(String message, Throwable cause) {
        super(message, cause);
    }

    public HibernateConstraintViolationException(ErrorCodeEnum errorCodeName) {
        super(errorCodeName);
    }

    public HibernateConstraintViolationException(ErrorCodeEnum errorCodeName, String ... messages) {
        super(errorCodeName, messages);
    }

    public HibernateConstraintViolationException(ErrorCodeEnum errorCode, Throwable cause, String ... customMsg) {
        super(errorCode, cause, customMsg);
    }

    public HibernateConstraintViolationException(ConstraintViolationException cause, Object cdmObject) {
        super(ExceptionUtils.getRootCauseMessage((Throwable)cause), (Throwable)cause);
        this.parseRootExceptionCauseMessage(cause);
    }

    private void parseRootExceptionCauseMessage(ConstraintViolationException exception) {
        String violation = exception.getConstraintName();
        if (violation != null) {
            this.setCustomMsgValues(new String[]{violation});
            if (violation.contains("_VPID_")) {
                this.setErrorCode(ErrorCodeEnum.WRITE_REQUEST_VPID_INVALID);
            } else if (violation.contains("_VLID_")) {
                this.setErrorCode(ErrorCodeEnum.WRITE_REQUEST_VLID_INVALID);
            } else {
                this.setErrorCode(ErrorCodeEnum.HDRII_CONSTRAINT_VIOLATED);
            }
        } else {
            violation = ExceptionUtils.getRootCauseMessage((Throwable)exception);
            this.setCustomMsgValues(new String[]{violation});
            this.setErrorCode(ErrorCodeEnum.HDRII_CONSTRAINT_VIOLATED);
        }
    }
}

