/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.persistence.hibernate;

import gov.va.med.cds.cdm.allergies.IntoleranceCondition;
import gov.va.med.cds.cdm.allergies.ReactionObservationEvent;
import gov.va.med.cds.cdm.vitals.VitalSignObservationEvent;
import gov.va.med.cds.persistence.hibernate.AppenderInterface;
import gov.va.med.cds.persistence.hibernate.IntoleranceConditionAppender;
import gov.va.med.cds.persistence.hibernate.ReactionObservationEventAppender;
import gov.va.med.cds.persistence.hibernate.VitalSignObservationEventAppender;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppenderFactory {
    private static final Log logger = LogFactory.getLog(AppenderFactory.class);
    private Map<Class, Class> appenders = null;
    private static AppenderFactory instance = new AppenderFactory();

    private AppenderFactory() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Initializing Appenders");
        }
        this.appenders = new HashMap<Class, Class>();
        this.appenders.put(IntoleranceCondition.class, IntoleranceConditionAppender.class);
        this.appenders.put(ReactionObservationEvent.class, ReactionObservationEventAppender.class);
        this.appenders.put(VitalSignObservationEvent.class, VitalSignObservationEventAppender.class);
    }

    public static AppenderFactory getInstance() {
        if (instance == null) {
            instance = new AppenderFactory();
        }
        return instance;
    }

    public AppenderInterface createAppender(Class aClass) throws InstantiationException, IllegalAccessException {
        return (AppenderInterface)this.appenders.get(aClass).newInstance();
    }

    public void setAppenders(Map<Class, Class> appenders) {
        this.appenders = appenders;
    }
}

