/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.mapping;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.dozer.util.mapping.MapperIF;
import net.sf.dozer.util.mapping.MappingException;
import net.sf.dozer.util.mapping.cache.Cache;
import net.sf.dozer.util.mapping.cache.CacheEntry;
import net.sf.dozer.util.mapping.cache.CacheKeyFactory;
import net.sf.dozer.util.mapping.cache.CacheManagerIF;
import net.sf.dozer.util.mapping.converters.CustomConverter;
import net.sf.dozer.util.mapping.converters.CustomConverterContainer;
import net.sf.dozer.util.mapping.converters.PrimitiveOrWrapperConverter;
import net.sf.dozer.util.mapping.event.DozerEvent;
import net.sf.dozer.util.mapping.event.DozerEventManager;
import net.sf.dozer.util.mapping.event.EventManagerIF;
import net.sf.dozer.util.mapping.fieldmap.ClassMap;
import net.sf.dozer.util.mapping.fieldmap.Configuration;
import net.sf.dozer.util.mapping.fieldmap.ExcludeFieldMap;
import net.sf.dozer.util.mapping.fieldmap.FieldMap;
import net.sf.dozer.util.mapping.fieldmap.GenericFieldMap;
import net.sf.dozer.util.mapping.fieldmap.MapFieldMap;
import net.sf.dozer.util.mapping.stats.StatisticsManagerIF;
import net.sf.dozer.util.mapping.util.ClassMapBuilder;
import net.sf.dozer.util.mapping.util.ClassMapFinder;
import net.sf.dozer.util.mapping.util.ClassMapKeyFactory;
import net.sf.dozer.util.mapping.util.CollectionUtils;
import net.sf.dozer.util.mapping.util.DateFormatContainer;
import net.sf.dozer.util.mapping.util.DestBeanCreator;
import net.sf.dozer.util.mapping.util.LogMsgFactory;
import net.sf.dozer.util.mapping.util.MappingUtils;
import net.sf.dozer.util.mapping.util.MappingValidator;
import net.sf.dozer.util.mapping.util.ReflectionUtils;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.collections.set.ListOrderedSet;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class MappingProcessor
implements MapperIF {
    private static final Logger log = Logger.getLogger(MappingProcessor.class);
    private List superListOfFieldNames = null;
    private final transient Map customMappings;
    private final Configuration globalConfiguration;
    private final List customConverterObjects;
    private final CacheManagerIF cacheMgr;
    private final StatisticsManagerIF statsMgr;
    private final EventManagerIF eventMgr;
    private final ClassMapFinder classMapFinder = new ClassMapFinder();
    private final MappingUtils mappingUtils = new MappingUtils();
    private final ReflectionUtils reflectionUtils = new ReflectionUtils();
    private final CollectionUtils collectionUtils = new CollectionUtils();
    private final MappingValidator mappingValidator = new MappingValidator();
    private final ClassMapBuilder classMapBuilder = new ClassMapBuilder();
    private final LogMsgFactory logMsgFactory = new LogMsgFactory();
    private final DestBeanCreator destBeanCreator = new DestBeanCreator(MappingUtils.storedFactories);
    private final PrimitiveOrWrapperConverter primitiveOrWrapperConverter = new PrimitiveOrWrapperConverter();

    public MappingProcessor(Map mappings, Configuration globalConfiguration, CacheManagerIF cacheMgr, StatisticsManagerIF statsMgr, List customConverterObjects, List eventListeners) {
        this.customMappings = mappings;
        this.globalConfiguration = globalConfiguration;
        this.cacheMgr = cacheMgr;
        this.statsMgr = statsMgr;
        this.customConverterObjects = customConverterObjects;
        this.eventMgr = new DozerEventManager(eventListeners);
    }

    public Object map(Object sourceObj, Class destClass) {
        return this.map(sourceObj, destClass, (String)null);
    }

    public Object map(Object sourceObj, Class destClass, String mapId) {
        Object destObj = null;
        ClassMap classMap = null;
        try {
            this.mappingValidator.validateMappingRequest(sourceObj, destClass);
            classMap = this.getClassMap(sourceObj, destClass, mapId, false);
            CustomConverterContainer customConverterContainer = classMap.getConfiguration().getCustomConverters();
            Class converterClass = this.mappingUtils.getCustomConverterFromContainer(this.cacheMgr, customConverterContainer, sourceObj.getClass(), destClass);
            if (converterClass != null) {
                this.eventMgr.fireEvent(new DozerEvent("MAPPING_STARTED", classMap, null, sourceObj, destObj, null));
                return this.mapUsingCustomConverter(converterClass, sourceObj.getClass(), sourceObj, destClass, destObj, null, true);
            }
            destObj = this.destBeanCreator.create(sourceObj, classMap, destClass);
            this.eventMgr.fireEvent(new DozerEvent("MAPPING_STARTED", classMap, null, sourceObj, destObj, null));
            this.map(classMap, sourceObj, destObj, null, null);
        }
        catch (Throwable e) {
            this.mappingUtils.throwMappingException(e);
        }
        this.eventMgr.fireEvent(new DozerEvent("MAPPING_FINISHED", classMap, null, sourceObj, destObj, null));
        return destObj;
    }

    public void map(Object sourceObj, Object destObj) {
        this.map(sourceObj, destObj, null);
    }

    private void directMap(ClassMap classMap, Object sourceObj, Object destObj, ClassMap parentClassMap, FieldMap parentFieldMap) throws NoSuchMethodException, ClassNotFoundException, NoSuchFieldException, IllegalAccessException, InvocationTargetException, InstantiationException {
        this.mappingValidator.validateMappingRequest(sourceObj, destObj);
        Class<?> sourceClass = sourceObj.getClass();
        Class<?> destClass = destObj.getClass();
        String mapId = null;
        if (parentFieldMap != null) {
            mapId = parentFieldMap.getMapId();
        }
        if (classMap == null) {
            classMap = this.getClassMap(sourceObj, destObj.getClass(), mapId, true);
        }
        if (parentClassMap != null && this.superListOfFieldNames == null) {
            this.superListOfFieldNames = new ArrayList();
        }
        List parentFieldNames = null;
        if (parentClassMap == null) {
            List superClasses = this.checkForSuperTypeMapping(sourceClass, destClass);
            superClasses.addAll(this.classMapFinder.findInterfaceMappings(this.customMappings, sourceClass, destClass));
            if (superClasses != null && superClasses.size() > 0) {
                parentFieldNames = this.processSuperTypeMapping(superClasses, sourceObj, destObj, sourceClass, parentFieldMap);
            }
        }
        List fieldMaps = classMap.getFieldMaps();
        for (int i = 0; i < fieldMaps.size(); ++i) {
            FieldMap fieldMapping = (FieldMap)fieldMaps.get(i);
            this.mapField(fieldMapping, classMap, sourceObj, destObj, parentClassMap, parentFieldMap, parentFieldNames);
        }
    }

    public void map(Object sourceObj, Object destObj, String mapId) {
        ClassMap classMap = null;
        try {
            CustomConverterContainer customConverterContainer;
            Class converterClass;
            this.mappingValidator.validateMappingRequest(sourceObj, destObj);
            classMap = this.getClassMap(sourceObj, destObj.getClass(), mapId, true);
            this.eventMgr.fireEvent(new DozerEvent("MAPPING_STARTED", classMap, null, sourceObj, destObj, null));
            Class sourceClass = classMap.getSourceClass().getClassToMap();
            Class destClass = classMap.getDestClass().getClassToMap();
            if (sourceClass == sourceObj.getClass() && destClass == destObj.getClass() && mapId == null && (converterClass = this.mappingUtils.getCustomConverterFromContainer(this.cacheMgr, customConverterContainer = classMap.getConfiguration().getCustomConverters(), sourceObj.getClass(), destObj.getClass())) != null) {
                this.mapUsingCustomConverter(converterClass, sourceObj.getClass(), sourceObj, destObj.getClass(), destObj, null, true);
                return;
            }
            this.directMap(classMap, sourceObj, destObj, null, null);
        }
        catch (Throwable e) {
            this.mappingUtils.throwMappingException(e);
        }
        this.eventMgr.fireEvent(new DozerEvent("MAPPING_FINISHED", classMap, null, sourceObj, destObj, null));
    }

    private void map(ClassMap classMap, Object sourceObj, Object destObj, ClassMap parentClassMap, FieldMap parentFieldMap) throws NoSuchMethodException, ClassNotFoundException, NoSuchFieldException, IllegalAccessException, InvocationTargetException, InstantiationException {
        CustomConverterContainer customConverterContainer;
        Class converterClass;
        this.mappingValidator.validateMappingRequest(sourceObj, destObj);
        Class<?> sourceClass = sourceObj.getClass();
        Class<?> destClass = destObj.getClass();
        String mapId = null;
        if (parentFieldMap != null) {
            mapId = parentFieldMap.getMapId();
        }
        if (classMap == null) {
            classMap = this.getClassMap(sourceObj, destObj.getClass(), mapId, true);
        }
        if (parentClassMap != null && this.superListOfFieldNames == null) {
            this.superListOfFieldNames = new ArrayList();
        }
        if ((converterClass = this.mappingUtils.getCustomConverterFromContainer(this.cacheMgr, customConverterContainer = classMap.getConfiguration().getCustomConverters(), sourceObj.getClass(), destClass)) != null) {
            Object rvalue = this.mapUsingCustomConverter(converterClass, sourceObj.getClass(), sourceObj, destClass, destObj, null, true);
            if (rvalue != null) {
                destObj = rvalue;
            }
            return;
        }
        List parentFieldNames = null;
        if (parentClassMap == null) {
            List superClasses = this.checkForSuperTypeMapping(sourceClass, destClass);
            superClasses.addAll(this.classMapFinder.findInterfaceMappings(this.customMappings, sourceClass, destClass));
            if (superClasses != null && superClasses.size() > 0) {
                parentFieldNames = this.processSuperTypeMapping(superClasses, sourceObj, destObj, sourceClass, parentFieldMap);
            }
        }
        List fieldMaps = classMap.getFieldMaps();
        for (int i = 0; i < fieldMaps.size(); ++i) {
            FieldMap fieldMapping = (FieldMap)fieldMaps.get(i);
            this.mapField(fieldMapping, classMap, sourceObj, destObj, parentClassMap, parentFieldMap, parentFieldNames);
        }
    }

    private void mapField(FieldMap fieldMapping, ClassMap classMap, Object sourceObj, Object destObj, ClassMap parentClassMap, FieldMap parentFieldMap, List parentFieldNames) {
        if (fieldMapping instanceof ExcludeFieldMap) {
            return;
        }
        Class<?> sourceClass = sourceObj.getClass();
        Class<?> destClass = destObj.getClass();
        Object sourceFieldValue = null;
        try {
            sourceFieldValue = fieldMapping.getSrcFieldValue(sourceClass, sourceObj);
            String methodName = fieldMapping.getDestFieldReadMethodName(destClass);
            String sourceMethodName = fieldMapping.getSourceFieldReadMethodName(sourceClass);
            String parentSourceField = null;
            if (parentFieldMap != null) {
                parentSourceField = parentFieldMap.getSourceField().getName();
            }
            String key = this.mappingUtils.getParentFieldNameKey(parentSourceField, sourceObj, sourceClass.getName(), sourceMethodName, methodName, fieldMapping.getSourceField().getName(), fieldMapping.getDestField().getName());
            if (parentClassMap != null) {
                if (this.superListOfFieldNames.contains(key)) {
                    return;
                }
                this.superListOfFieldNames.add(key);
            }
            if (parentFieldNames != null && parentFieldNames.size() > 0) {
                if (parentFieldNames.contains(key)) {
                    return;
                }
                parentFieldNames.add(key);
            }
            if (fieldMapping instanceof GenericFieldMap && ((GenericFieldMap)fieldMapping).isMethodMap() && fieldMapping.getDestField().getType().equals("iterate")) {
                this.mapFromIterateMethodFieldMap(sourceObj, destObj, sourceFieldValue, classMap, fieldMapping);
            } else {
                this.mapFromFieldMap(sourceObj, destObj, sourceFieldValue, classMap, fieldMapping);
            }
            this.statsMgr.increment("Field Mapping Success Count");
        }
        catch (Throwable e) {
            log.error((Object)this.logMsgFactory.createFieldMappingErrorMsg(sourceObj, fieldMapping, sourceFieldValue, destObj, e), e);
            this.statsMgr.increment("Field Mapping Failure Count");
            if (classMap.getStopOnErrors()) {
                this.mappingUtils.throwMappingException(e);
            }
            this.statsMgr.increment("Field Mapping Failure Ignored Count");
        }
    }

    private void mapFromFieldMap(Object sourceObj, Object destObj, Object sourceFieldValue, ClassMap classMap, FieldMap fieldMapping) throws IllegalAccessException, InvocationTargetException, InstantiationException, NoSuchMethodException, ClassNotFoundException, NoSuchFieldException {
        Class<?> destFieldType = null;
        destFieldType = fieldMapping instanceof GenericFieldMap && ((GenericFieldMap)fieldMapping).isMethodMap() ? fieldMapping.getDestFieldWriteMethod(classMap.getDestClass().getClassToMap()).getParameterTypes()[0] : fieldMapping.getDestFieldType(classMap.getDestClass().getClassToMap());
        String destFieldName = fieldMapping.getDestField().getName();
        Object destFieldValue = this.mapOrRecurseObject(sourceFieldValue, destFieldType, classMap, fieldMapping, destObj);
        CustomConverterContainer customConverters = classMap.getConfiguration().getCustomConverters();
        Class converterClass = null;
        if (customConverters != null && fieldMapping.getDestinationTypeHint() != null && destFieldValue != null && fieldMapping.getDestinationTypeHint().getHints().size() == 1) {
            converterClass = customConverters.getConverterByDestinationType(Thread.currentThread().getContextClassLoader().loadClass(fieldMapping.getDestinationTypeHint().getHintName()), destFieldValue.getClass(), this.cacheMgr);
        }
        if (converterClass != null) {
            Object o = converterClass.newInstance();
            if (!(o instanceof CustomConverter)) {
                throw new InstantiationException("Class is not an instance of the CustomConverter interface");
            }
            CustomConverter theConverter = (CustomConverter)o;
            destFieldValue = theConverter.convert(null, destFieldValue, destFieldValue.getClass(), destFieldType.getClass());
        }
        this.writeDestinationValue(destObj, destFieldValue, classMap, fieldMapping);
        if (log.isDebugEnabled()) {
            log.debug((Object)this.logMsgFactory.createFieldMappingSuccessMsg(sourceObj.getClass(), destObj.getClass(), fieldMapping.getSourceField().getName(), destFieldName, sourceFieldValue, destFieldValue));
        }
    }

    private void mapFromIterateMethodFieldMap(Object sourceObj, Object destObj, Object sourceFieldValue, ClassMap classMap, FieldMap fieldMapping) throws IllegalAccessException, InvocationTargetException, InstantiationException, ClassNotFoundException, NoSuchMethodException, NoSuchFieldException {
        String destFieldName = fieldMapping.getDestField().getName();
        if (sourceFieldValue instanceof Iterator) {
            sourceFieldValue = IteratorUtils.toList((Iterator)((Iterator)sourceFieldValue));
        }
        if (sourceFieldValue != null) {
            for (int i = 0; i < this.collectionUtils.getLengthOfCollection(sourceFieldValue); ++i) {
                Object value = this.collectionUtils.getValueFromCollection(sourceFieldValue, i);
                if (fieldMapping.getDestinationTypeHint() == null) {
                    throw new MappingException("<field type=\"iterate\"> must have a source or destination type hint");
                }
                CustomConverterContainer customConverters = classMap.getConfiguration().getCustomConverters();
                Class converterClass = null;
                if (customConverters != null) {
                    converterClass = customConverters.getConverterByDestinationType(Thread.currentThread().getContextClassLoader().loadClass(fieldMapping.getDestinationTypeHint().getHintName()), value.getClass(), this.cacheMgr);
                }
                if ((value = customConverters != null && converterClass != null ? this.mapUsingCustomConverter(converterClass, value.getClass(), value, fieldMapping.getDestinationTypeHint().getHint(), null, fieldMapping, false) : this.map(value, fieldMapping.getDestinationTypeHint().getHint())) == null) continue;
                this.writeDestinationValue(destObj, value, classMap, fieldMapping);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)this.logMsgFactory.createFieldMappingSuccessMsg(sourceObj.getClass(), destObj.getClass(), fieldMapping.getSourceField().getName(), destFieldName, sourceFieldValue, null));
        }
    }

    private Object mapOrRecurseObject(Object sourceFieldValue, Class destFieldType, ClassMap classMap, FieldMap fieldMap, Object destObj) throws InvocationTargetException, InstantiationException, IllegalAccessException, NoSuchMethodException, ClassNotFoundException, NoSuchFieldException {
        return this.mapOrRecurseObject(sourceFieldValue, destFieldType, classMap, fieldMap, destObj, false);
    }

    private Object mapOrRecurseObject(Object sourceFieldValue, Class destFieldType, ClassMap classMap, FieldMap fieldMap, Object destObj, boolean ignoreClassMap) throws InvocationTargetException, InstantiationException, IllegalAccessException, NoSuchMethodException, ClassNotFoundException, NoSuchFieldException {
        boolean isDestFieldTypeSupportedMap = this.mappingUtils.isSupportedMap(destFieldType);
        if (sourceFieldValue == null && !isDestFieldTypeSupportedMap) {
            return null;
        }
        if (sourceFieldValue == null && isDestFieldTypeSupportedMap) {
            return this.mapMapToProperty(sourceFieldValue, null, fieldMap, destObj, destFieldType, classMap);
        }
        Object rvalue = null;
        Class<?> sourceFieldClass = sourceFieldValue.getClass();
        boolean isSourceFieldClassSupportedMap = this.mappingUtils.isSupportedMap(sourceFieldClass);
        CustomConverterContainer customConverters = classMap.getConfiguration().getCustomConverters();
        Class converterClass = null;
        if (customConverters != null) {
            converterClass = customConverters.getConverterByDestinationType(destFieldType, sourceFieldClass, this.cacheMgr);
        }
        if (customConverters == null || converterClass == null) {
            if (fieldMap.getCopyByReference()) {
                return sourceFieldValue;
            }
            if (fieldMap.getMapId() != null && this.mappingUtils.validateMap(sourceFieldClass, destFieldType, fieldMap)) {
                return this.mapCustomObject(fieldMap, destObj, destFieldType, sourceFieldValue);
            }
            if (fieldMap instanceof MapFieldMap && !ignoreClassMap) {
                return this.mapClassLevelMap(fieldMap, sourceFieldValue, sourceFieldClass, classMap, destFieldType, destObj);
            }
            if (this.mappingUtils.isSupportedCollection(sourceFieldClass) && this.mappingUtils.isSupportedCollection(destFieldType)) {
                return this.mapCollection(sourceFieldValue, classMap, fieldMap, destObj);
            }
            if (isSourceFieldClassSupportedMap && isDestFieldTypeSupportedMap) {
                return this.mapMap(sourceFieldValue, classMap, fieldMap, destObj, destFieldType);
            }
            if (isSourceFieldClassSupportedMap || isDestFieldTypeSupportedMap) {
                return this.mapMapToProperty(sourceFieldValue, sourceFieldClass, fieldMap, destObj, destFieldType, classMap);
            }
            if (this.mappingUtils.isCustomMapMethod(fieldMap)) {
                return this.mapCustomMapToProperty(sourceFieldValue, sourceFieldClass, fieldMap, destObj, destFieldType);
            }
            if (this.mappingUtils.isPrimitiveOrWrapper(sourceFieldClass) || this.mappingUtils.isPrimitiveOrWrapper(destFieldType)) {
                if (fieldMap.getDestinationTypeHint() != null) {
                    destFieldType = fieldMap.getDestinationTypeHint().getHint();
                }
                if (fieldMap.getSourceField().getIndex() < 0) {
                    return this.primitiveOrWrapperConverter.convert(sourceFieldValue, destFieldType, new DateFormatContainer(classMap, fieldMap));
                }
                return this.primitiveOrWrapperConverter.convertUsingIndex(sourceFieldValue, fieldMap.getSourceField().getIndex(), destFieldType, new DateFormatContainer(classMap, fieldMap));
            }
            return this.mapCustomObject(fieldMap, destObj, destFieldType, sourceFieldValue);
        }
        rvalue = this.mapUsingCustomConverter(converterClass, sourceFieldClass, sourceFieldValue, destFieldType, destObj, fieldMap, false);
        return rvalue;
    }

    private Object mapClassLevelMap(FieldMap fieldMap, Object sourceFieldValue, Class sourceFieldClass, ClassMap classMap, Class destType, Object destObj) throws InvocationTargetException, IllegalAccessException, NoSuchFieldException, InstantiationException, ClassNotFoundException, NoSuchMethodException {
        if (!this.mappingUtils.isSupportedMap(sourceFieldClass) && !classMap.getSourceClass().isCustomMap()) {
            return sourceFieldValue;
        }
        String key = null;
        key = StringUtils.isEmpty((String)fieldMap.getDestField().getKey()) ? fieldMap.getDestField().getName() : fieldMap.getDestField().getKey();
        Method resultMethod = this.reflectionUtils.getMethod(sourceFieldValue, fieldMap.getSourceField().getMapGetMethod());
        Object result = resultMethod.invoke(sourceFieldValue, key);
        return this.mapOrRecurseObject(result, destType, classMap, fieldMap, destObj, true);
    }

    private Object mapCustomObject(FieldMap fieldMap, Object destObj, Class destFieldType, Object sourceFieldValue) throws InvocationTargetException, IllegalAccessException, InstantiationException, NoSuchMethodException, ClassNotFoundException, NoSuchFieldException {
        Object field = this.mappingValidator.validateField(fieldMap, destObj, destFieldType);
        ClassMap classMap = null;
        if (field == null) {
            Class destType;
            if (fieldMap.getDestinationTypeHint() != null && (destType = fieldMap.getDestinationTypeHint().getHint()) != null) {
                destFieldType = destType;
            }
            String mapId = null;
            if (fieldMap != null) {
                mapId = fieldMap.getMapId();
            }
            classMap = this.getClassMap(sourceFieldValue, destFieldType, mapId, false);
            field = this.destBeanCreator.create(sourceFieldValue, classMap, fieldMap, null);
        }
        this.map(classMap, sourceFieldValue, field, null, fieldMap);
        return field;
    }

    private Object mapCollection(Object sourceCollectionValue, ClassMap classMap, FieldMap fieldMap, Object destObj) throws IllegalAccessException, InstantiationException, InvocationTargetException, NoSuchMethodException, ClassNotFoundException, NoSuchFieldException {
        if (sourceCollectionValue instanceof Iterator) {
            sourceCollectionValue = IteratorUtils.toList((Iterator)((Iterator)sourceCollectionValue));
        }
        Class<List> destCollectionType = fieldMap.getDestFieldType(classMap.getDestClass().getClassToMap());
        Class<?> sourceFieldType = sourceCollectionValue.getClass();
        Object result = null;
        if (destCollectionType.getName().equals(Collection.class.getName())) {
            destCollectionType = List.class;
        }
        if (this.collectionUtils.isArray(sourceFieldType) && this.collectionUtils.isArray(destCollectionType)) {
            result = this.mapArrayToArray(sourceCollectionValue, classMap, fieldMap, destObj);
        } else if (this.collectionUtils.isArray(sourceFieldType) && this.collectionUtils.isList(destCollectionType)) {
            result = this.mapArrayToList(sourceCollectionValue, classMap, fieldMap, destObj);
        } else if (this.collectionUtils.isList(sourceFieldType) && this.collectionUtils.isArray(destCollectionType)) {
            result = this.mapListToArray((List)sourceCollectionValue, classMap, fieldMap, destObj);
        } else if (this.collectionUtils.isList(sourceFieldType) && this.collectionUtils.isList(destCollectionType)) {
            result = this.mapListToList((List)sourceCollectionValue, classMap, fieldMap, destObj);
        } else if (this.collectionUtils.isSet(sourceFieldType) && this.collectionUtils.isSet(destCollectionType)) {
            result = this.mapSetToSet((Set)sourceCollectionValue, classMap, fieldMap, destObj, destCollectionType);
        } else if (this.collectionUtils.isSet(sourceFieldType) && this.collectionUtils.isArray(destCollectionType)) {
            result = this.mapSetToArray((Set)sourceCollectionValue, classMap, fieldMap, destObj);
        } else if (this.collectionUtils.isArray(sourceFieldType) && this.collectionUtils.isSet(destCollectionType)) {
            result = this.addToSet(fieldMap, Arrays.asList((Object[])sourceCollectionValue), classMap, destObj);
        } else if (this.collectionUtils.isSet(sourceFieldType) && this.collectionUtils.isList(destCollectionType)) {
            result = this.mapListToList((Set)sourceCollectionValue, classMap, fieldMap, destObj);
        } else if (this.collectionUtils.isList(sourceFieldType) && this.collectionUtils.isSet(destCollectionType)) {
            result = this.addToSet(fieldMap, (List)sourceCollectionValue, classMap, destObj);
        }
        return result;
    }

    private Object mapMap(Object sourceMapValue, ClassMap classMap, FieldMap fieldMap, Object destObj, Class destFieldType) throws IllegalAccessException, InstantiationException, InvocationTargetException, NoSuchMethodException, ClassNotFoundException, NoSuchFieldException {
        Map result = null;
        Object field = fieldMap.doesFieldExist(destObj, destFieldType);
        result = field == null ? (Map)sourceMapValue.getClass().newInstance() : (Map)field;
        Map sourceMap = (Map)sourceMapValue;
        Set sourceEntrySet = sourceMap.entrySet();
        for (Map.Entry sourceEntry : sourceEntrySet) {
            Object sourceEntryValue = sourceEntry.getValue();
            Object destEntryValue = this.mapOrRecurseObject(sourceEntryValue, sourceEntryValue.getClass(), classMap, fieldMap, destObj);
            result.put(sourceEntry.getKey(), destEntryValue);
        }
        return result;
    }

    private Object mapMapToProperty(Object sourceValue, Class sourceFieldClass, FieldMap fieldMap, Object destObj, Class destType, ClassMap classMap) throws IllegalAccessException, InstantiationException, InvocationTargetException, NoSuchMethodException, ClassNotFoundException, NoSuchFieldException {
        Object result = null;
        String key = null;
        if (this.mappingUtils.isSupportedMap((Class)destType)) {
            Object field = fieldMap.doesFieldExist(destObj, (Class)destType);
            if (sourceFieldClass == null) {
                return field;
            }
            if (field == null) {
                if (fieldMap.getDestinationTypeHint() != null) {
                    destType = fieldMap.getDestinationTypeHint().getHint();
                } else if (destType.isInterface()) {
                    destType = HashMap.class;
                }
                result = destType.newInstance();
            } else {
                result = field;
            }
            key = fieldMap.getDestKey();
            ((Map)result).put(key, sourceValue);
        } else {
            key = fieldMap.getSourceKey();
            result = ((Map)sourceValue).get(key);
        }
        return this.mapOrRecurseObject(result, destType, classMap, fieldMap, destObj);
    }

    private Object mapCustomMapToProperty(Object sourceValue, Class sourceFieldClass, FieldMap fieldMap, Object destObj, Class destType) throws IllegalAccessException, InstantiationException, InvocationTargetException, NoSuchMethodException, ClassNotFoundException, NoSuchFieldException {
        Object result = null;
        String key = null;
        Object field = null;
        if (fieldMap.getDestField().getMapGetMethod() != null && fieldMap.getDestField().getMapSetMethod() != null) {
            field = fieldMap.doesFieldExist(destObj, destType);
            if (sourceFieldClass == null) {
                return field;
            }
            if (field == null) {
                if (fieldMap.getDestinationTypeHint() != null) {
                    destType = fieldMap.getDestinationTypeHint().getHint();
                }
                result = destType.newInstance();
            } else {
                result = field;
            }
            key = fieldMap.getDestKey();
            Method resultMethod = this.reflectionUtils.getMethod(result, fieldMap.getDestField().getMapSetMethod());
            resultMethod.invoke(result, key, sourceValue);
        } else {
            key = fieldMap.getSourceKey();
            Method resultMethod = this.reflectionUtils.getMethod(sourceValue, fieldMap.getSourceField().getMapGetMethod());
            result = resultMethod.invoke(sourceValue, key);
        }
        return result;
    }

    private Object mapArrayToArray(Object sourceCollectionValue, ClassMap classMap, FieldMap fieldMap, Object destObj) throws IllegalAccessException, InstantiationException, InvocationTargetException, NoSuchMethodException, ClassNotFoundException, NoSuchFieldException {
        Class<?> destEntryType = fieldMap.getDestFieldType(classMap.getDestClass().getClassToMap()).getComponentType();
        int size = Array.getLength(sourceCollectionValue);
        if (this.mappingUtils.isPrimitiveArray(sourceCollectionValue.getClass())) {
            return this.addToPrimitiveArray(fieldMap, size, sourceCollectionValue, classMap, destObj, destEntryType);
        }
        List<Object> list = Arrays.asList((Object[])sourceCollectionValue);
        List returnList = null;
        returnList = !destEntryType.getName().equals("java.lang.Object") ? this.addOrUpdateToList(fieldMap, list, classMap, destObj, destEntryType) : this.addOrUpdateToList(fieldMap, list, classMap, destObj, null);
        return this.collectionUtils.convertListToArray(returnList, destEntryType);
    }

    private Object addToPrimitiveArray(FieldMap fieldMap, int size, Object sourceCollectionValue, ClassMap classMap, Object destObj, Class destEntryType) throws IllegalAccessException, InstantiationException, InvocationTargetException, NoSuchMethodException, ClassNotFoundException, NoSuchFieldException {
        int i;
        Object outArray = null;
        Object field = fieldMap.doesFieldExist(destObj, destEntryType);
        int arraySize = 0;
        if (field == null) {
            outArray = Array.newInstance(destEntryType, size);
        } else {
            outArray = Array.newInstance(destEntryType, size + Array.getLength(field));
            arraySize = Array.getLength(field);
            for (i = 0; i < Array.getLength(field); ++i) {
                Array.set(outArray, i, Array.get(field, i));
            }
        }
        for (i = 0; i < size; ++i) {
            Object toValue = this.mapOrRecurseObject(Array.get(sourceCollectionValue, i), destEntryType, classMap, fieldMap, destObj);
            Array.set(outArray, arraySize, toValue);
            ++arraySize;
        }
        return outArray;
    }

    private Object mapListToArray(Collection sourceCollectionValue, ClassMap classMap, FieldMap fieldMap, Object destObj) throws IllegalAccessException, InstantiationException, InvocationTargetException, NoSuchMethodException, ClassNotFoundException, NoSuchFieldException {
        List list = null;
        Class<?> destEntryType = fieldMap.getDestFieldType(classMap.getDestClass().getClassToMap()).getComponentType();
        list = !destEntryType.getName().equals("java.lang.Object") ? this.addOrUpdateToList(fieldMap, sourceCollectionValue, classMap, destObj, destEntryType) : this.addOrUpdateToList(fieldMap, sourceCollectionValue, classMap, destObj);
        return this.collectionUtils.convertListToArray(list, destEntryType);
    }

    private List mapListToList(Collection sourceCollectionValue, ClassMap classMap, FieldMap fieldMap, Object destObj) throws IllegalAccessException, InstantiationException, InvocationTargetException, NoSuchMethodException, ClassNotFoundException, NoSuchFieldException {
        return this.addOrUpdateToList(fieldMap, sourceCollectionValue, classMap, destObj);
    }

    private Set addToSet(FieldMap fieldMap, Collection sourceCollectionValue, ClassMap classMap, Object destObj) throws IllegalAccessException, InstantiationException, InvocationTargetException, NoSuchMethodException, ClassNotFoundException, NoSuchFieldException {
        Class destEntryType = null;
        ListOrderedSet result = new ListOrderedSet();
        Object field = fieldMap.doesFieldExist(destObj, null);
        if (field != null) {
            result.addAll((Collection)field);
        }
        Object destValue = null;
        Iterator iter = sourceCollectionValue.iterator();
        Object sourceValue = null;
        while (iter.hasNext()) {
            sourceValue = iter.next();
            if (destEntryType == null || fieldMap.getDestinationTypeHint() != null && fieldMap.getDestinationTypeHint().hasMoreThanOneHint()) {
                destEntryType = fieldMap.getDestHintType(sourceValue.getClass());
            }
            destValue = this.mapOrRecurseObject(sourceValue, destEntryType, classMap, fieldMap, destObj);
            if (fieldMap.isGenericFieldMap()) {
                GenericFieldMap gfm = (GenericFieldMap)fieldMap;
                if (gfm.getRelationshipType() == null || gfm.getRelationshipType().equals("cumulative")) {
                    result.add(destValue);
                    continue;
                }
                if (result.contains(destValue)) {
                    int index = result.indexOf(destValue);
                    Object obj = result.get(index);
                    if (!obj.getClass().isAssignableFrom(String.class)) {
                        this.map(null, obj, destValue, null, fieldMap);
                    }
                    result.add(destValue);
                    continue;
                }
                result.add(destValue);
                continue;
            }
            result.add(destValue);
        }
        if (field == null) {
            Class destSetType = fieldMap.getDestFieldType(destObj.getClass());
            return this.collectionUtils.createNewSet(destSetType, (Collection)result);
        }
        ((Set)field).addAll(result);
        return (Set)field;
    }

    private List addOrUpdateToList(FieldMap fieldMap, Collection sourceCollectionValue, ClassMap classMap, Object destObj, Class destEntryType) throws IllegalAccessException, InstantiationException, InvocationTargetException, NoSuchMethodException, ClassNotFoundException, NoSuchFieldException {
        List<Object> result = null;
        Object field = fieldMap.doesFieldExist(destObj, destEntryType);
        result = field == null ? new ArrayList(sourceCollectionValue.size()) : (this.collectionUtils.isList(field.getClass()) ? (List)field : (this.collectionUtils.isArray(field.getClass()) ? new ArrayList<Object>(Arrays.asList((Object[])field)) : new ArrayList(sourceCollectionValue.size())));
        Object destValue = null;
        Iterator iter = sourceCollectionValue.iterator();
        Object sourceValue = null;
        Class prevDestEntryType = null;
        while (iter.hasNext()) {
            sourceValue = iter.next();
            if (destEntryType == null || fieldMap.getDestinationTypeHint() != null && fieldMap.getDestinationTypeHint().hasMoreThanOneHint()) {
                destEntryType = sourceValue == null ? prevDestEntryType : fieldMap.getDestHintType(sourceValue.getClass());
            }
            destValue = this.mapOrRecurseObject(sourceValue, destEntryType, classMap, fieldMap, destObj);
            prevDestEntryType = destEntryType;
            if (fieldMap.isGenericFieldMap()) {
                GenericFieldMap gfm = (GenericFieldMap)fieldMap;
                if (gfm.getRelationshipType() == null || gfm.getRelationshipType().equals("cumulative")) {
                    result.add(destValue);
                    continue;
                }
                if (result.contains(destValue)) {
                    int index = result.indexOf(destValue);
                    Object obj = result.get(index);
                    if (!obj.getClass().isAssignableFrom(String.class)) {
                        this.map(null, obj, destValue, null, fieldMap);
                    }
                    result.set(index, destValue);
                    continue;
                }
                result.add(destValue);
                continue;
            }
            result.add(destValue);
        }
        return result;
    }

    private List addOrUpdateToList(FieldMap fieldMap, Collection sourceCollectionValue, ClassMap classMap, Object destObj) throws IllegalAccessException, InstantiationException, InvocationTargetException, NoSuchMethodException, ClassNotFoundException, NoSuchFieldException {
        return this.addOrUpdateToList(fieldMap, sourceCollectionValue, classMap, destObj, null);
    }

    private Set mapSetToSet(Set sourceCollectionValue, ClassMap classMap, FieldMap fieldMap, Object destObj, Class destClass) throws IllegalAccessException, InstantiationException, InvocationTargetException, NoSuchMethodException, ClassNotFoundException, NoSuchFieldException {
        Object field = fieldMap.doesFieldExist(destObj, destClass);
        Set result = null;
        if (field == null) {
            Class destFieldType = fieldMap.getDestFieldType(destObj.getClass());
            result = this.collectionUtils.createNewSet(destFieldType);
        } else {
            result = (Set)field;
        }
        Object destValue = null;
        for (Object obj : sourceCollectionValue) {
            Class destEntryType = fieldMap.getDestHintType(obj.getClass());
            destValue = this.mapOrRecurseObject(obj, destEntryType, classMap, fieldMap, destObj);
            result.add(destValue);
        }
        return result;
    }

    private Object mapSetToArray(Collection sourceCollectionValue, ClassMap classMap, FieldMap fieldMap, Object destObj) throws IllegalAccessException, InstantiationException, InvocationTargetException, NoSuchMethodException, ClassNotFoundException, NoSuchFieldException {
        return this.mapListToArray(sourceCollectionValue, classMap, fieldMap, destObj);
    }

    private List mapArrayToList(Object sourceCollectionValue, ClassMap classMap, FieldMap fieldMap, Object destObj) throws IllegalAccessException, InstantiationException, InvocationTargetException, NoSuchMethodException, ClassNotFoundException, NoSuchFieldException {
        Class<?> destEntryType = null;
        destEntryType = fieldMap.getDestinationTypeHint() != null ? fieldMap.getDestinationTypeHint().getHint() : sourceCollectionValue.getClass().getComponentType();
        return this.addOrUpdateToList(fieldMap, Arrays.asList((Object[])sourceCollectionValue), classMap, destObj, destEntryType);
    }

    private void writeDestinationValue(Object destObj, Object destFieldValue, ClassMap classMap, FieldMap fieldMapping) throws IllegalAccessException, InvocationTargetException, InstantiationException, NoSuchMethodException, ClassNotFoundException, NoSuchFieldException {
        boolean bypass = false;
        if (destFieldValue == null && !classMap.getDestClass().getMapNull().booleanValue()) {
            bypass = true;
        }
        if (destFieldValue != null && destFieldValue.getClass().equals(String.class) && StringUtils.isEmpty((String)((String)destFieldValue)) && !classMap.getDestClass().getMapEmptyString().booleanValue()) {
            bypass = true;
        }
        if (!bypass) {
            this.eventMgr.fireEvent(new DozerEvent("MAPPING_PRE_WRITING_DEST_VALUE", classMap, fieldMapping, null, destObj, destFieldValue));
            fieldMapping.writeDestinationValue(destObj, destFieldValue, classMap);
            this.eventMgr.fireEvent(new DozerEvent("MAPPING_POST_WRITING_DEST_VALUE", classMap, fieldMapping, null, destObj, destFieldValue));
        }
    }

    private Object mapUsingCustomConverter(Class customConverterClass, Class srcFieldClass, Object srcFieldValue, Class destFieldClass, Object destFieldValue, FieldMap fieldMap, boolean topLevel) throws IllegalAccessException, InvocationTargetException, InstantiationException, NoSuchMethodException, ClassNotFoundException, NoSuchFieldException {
        Object converterInstance = null;
        if (this.customConverterObjects != null) {
            for (Object customConverter : this.customConverterObjects) {
                if (!customConverter.getClass().isAssignableFrom(customConverterClass)) continue;
                converterInstance = customConverter;
            }
        }
        if (converterInstance == null) {
            converterInstance = customConverterClass.newInstance();
        }
        if (!(converterInstance instanceof CustomConverter)) {
            throw new MappingException("Custom Converter does not implement CustomConverter interface");
        }
        CustomConverter theConverter = converterInstance;
        if (topLevel) {
            return theConverter.convert(destFieldValue, srcFieldValue, destFieldClass, srcFieldClass);
        }
        Object field = this.mappingValidator.validateField(fieldMap, destFieldValue, destFieldClass);
        return theConverter.convert(field, srcFieldValue, destFieldClass, srcFieldClass);
    }

    private List checkForSuperTypeMapping(Class sourceClass, Class destClass) {
        Object cacheKey;
        Cache cache = this.cacheMgr.getCache("Super Type Mapping Dozer Cache");
        CacheEntry cacheEntry = cache.get(cacheKey = CacheKeyFactory.createKey((Object[])new Object[]{destClass, sourceClass}));
        if (cacheEntry != null) {
            return (List)cacheEntry.getValue();
        }
        Class superDestClass = destClass.getSuperclass();
        ArrayList<ClassMap> superClasses = new ArrayList<ClassMap>();
        boolean stillHasSuperClasses = true;
        for (Class superSourceClass = sourceClass.getSuperclass(); stillHasSuperClasses && (superSourceClass != null && !superSourceClass.getName().equals("java.lang.Object") || superDestClass != null && !superDestClass.getName().equals("java.lang.Object")); superSourceClass = superSourceClass.getSuperclass()) {
            ClassMap superClassMap = (ClassMap)this.customMappings.get(ClassMapKeyFactory.createKey(superSourceClass, (Class)destClass));
            if (superClassMap != null) {
                superClasses.add(superClassMap);
            }
            boolean stillHasDestSuperClasses = true;
            for (superDestClass = destClass.getSuperclass(); stillHasDestSuperClasses && superDestClass != null && !superDestClass.getName().equals("java.lang.Object"); superDestClass = superDestClass.getSuperclass()) {
                ClassMap sourceClassMap;
                ClassMap superDestClassMap = (ClassMap)this.customMappings.get(ClassMapKeyFactory.createKey(superSourceClass, superDestClass));
                if (superDestClassMap != null) {
                    superClasses.add(superDestClassMap);
                }
                if ((sourceClassMap = (ClassMap)this.customMappings.get(ClassMapKeyFactory.createKey((Class)sourceClass, superDestClass))) == null) continue;
                superClasses.add(sourceClassMap);
            }
        }
        Collections.reverse(superClasses);
        cacheEntry = new CacheEntry(cacheKey, superClasses);
        cache.put(cacheEntry);
        return superClasses;
    }

    private List processSuperTypeMapping(List superClasses, Object sourceObj, Object destObj, Class sourceClass, FieldMap parentFieldMap) throws NoSuchMethodException, NoSuchFieldException, ClassNotFoundException, IllegalAccessException, InvocationTargetException, InstantiationException {
        ArrayList<String> fieldNamesList = new ArrayList<String>();
        for (ClassMap map : superClasses) {
            this.map(map, sourceObj, destObj, map, parentFieldMap);
            List fieldMaps = map.getFieldMaps();
            Class destClassToMap = map.getDestClass().getClassToMap();
            Class srcClassToMap = map.getSourceClass().getClassToMap();
            for (int i = 0; i < fieldMaps.size(); ++i) {
                String key;
                FieldMap fieldMapping = (FieldMap)fieldMaps.get(i);
                if (!fieldMapping.isGenericFieldMap() && !(fieldMapping instanceof ExcludeFieldMap)) continue;
                String methodName = fieldMapping.getDestFieldReadMethodName(destClassToMap);
                String sourceMethodName = fieldMapping.getSourceFieldReadMethodName(srcClassToMap);
                String parentSourceField = null;
                if (parentFieldMap != null) {
                    parentSourceField = parentFieldMap.getSourceField().getName();
                }
                if (fieldNamesList.contains(key = this.mappingUtils.getParentFieldNameKey(parentSourceField, sourceObj, sourceClass.getName(), sourceMethodName, methodName, fieldMapping.getSourceField().getName(), fieldMapping.getDestField().getName()))) continue;
                fieldNamesList.add(key);
            }
        }
        return fieldNamesList;
    }

    private ClassMap getClassMap(Object sourceObj, Class destClass, String mapId, boolean isInstance) {
        ClassMap mapping = this.classMapFinder.findClassMap(this.customMappings, sourceObj, destClass, mapId, isInstance);
        if (mapping == null) {
            mapping = this.classMapBuilder.createDefaultClassMap(this.globalConfiguration, sourceObj.getClass(), destClass);
            this.customMappings.put(ClassMapKeyFactory.createKey(sourceObj.getClass(), (Class)destClass), mapping);
        }
        return mapping;
    }
}

