/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.mapping;

import gov.va.med.cds.mapping.MappingProcessor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.dozer.util.mapping.MapperIF;
import net.sf.dozer.util.mapping.MappingException;
import net.sf.dozer.util.mapping.cache.CacheManagerIF;
import net.sf.dozer.util.mapping.cache.DozerCacheManager;
import net.sf.dozer.util.mapping.config.GlobalSettings;
import net.sf.dozer.util.mapping.config.Settings;
import net.sf.dozer.util.mapping.converters.CustomConverterContainer;
import net.sf.dozer.util.mapping.converters.CustomConverterDescription;
import net.sf.dozer.util.mapping.fieldmap.ClassMap;
import net.sf.dozer.util.mapping.fieldmap.Configuration;
import net.sf.dozer.util.mapping.fieldmap.Mappings;
import net.sf.dozer.util.mapping.interceptor.StatisticsInterceptor;
import net.sf.dozer.util.mapping.stats.GlobalStatistics;
import net.sf.dozer.util.mapping.stats.StatisticsManagerIF;
import net.sf.dozer.util.mapping.util.ClassMapBuilder;
import net.sf.dozer.util.mapping.util.InitLogger;
import net.sf.dozer.util.mapping.util.MappingFileReader;
import net.sf.dozer.util.mapping.util.MappingUtils;
import net.sf.dozer.util.mapping.util.MappingValidator;
import net.sf.dozer.util.mapping.util.MappingsParser;
import org.apache.commons.collections.set.ListOrderedSet;
import org.apache.log4j.Logger;

public class DozerBeanMapper
implements MapperIF {
    private static final Logger log = Logger.getLogger(DozerBeanMapper.class);
    private List mappingFiles;
    private List customConverters;
    private List eventListeners;
    private Map customMappings;
    private Configuration globalConfiguration;
    private final CacheManagerIF cacheManager = DozerCacheManager.createNew();
    private final MappingUtils mappingUtils = new MappingUtils();
    private final MappingValidator mappingValidator = new MappingValidator();
    private final ClassMapBuilder classMapBuilder = new ClassMapBuilder();
    private static final StatisticsManagerIF statsMgr = GlobalStatistics.getInstance().getStatsMgr();
    private static final Settings settings = GlobalSettings.getInstance().getSettings();

    public DozerBeanMapper() {
        this(null);
    }

    public DozerBeanMapper(List mappingFiles) {
        this.mappingFiles = mappingFiles;
        this.init();
    }

    public void map(Object sourceObj, Object destObj, String mapId) throws MappingException {
        this.getMappingProcessor().map(sourceObj, destObj, mapId);
    }

    public Object map(Object sourceObj, Class destClass, String mapId) throws MappingException {
        return this.getMappingProcessor().map(sourceObj, destClass, mapId);
    }

    public Object map(Object sourceObj, Class destClass) throws MappingException {
        return this.getMappingProcessor().map(sourceObj, destClass);
    }

    public void map(Object sourceObj, Object destObj) throws MappingException {
        this.getMappingProcessor().map(sourceObj, destObj);
    }

    public List getMappingFiles() {
        return this.mappingFiles;
    }

    public void setMappingFiles(List mappingFiles) {
        this.mappingFiles = mappingFiles;
    }

    public void setFactories(Map factories) {
        this.mappingUtils.addFactories(factories);
    }

    public void setCustomConverters(List customConverters) {
        this.customConverters = customConverters;
    }

    public List getCustomConverters() {
        return this.customConverters;
    }

    private void init() {
        this.cacheManager.addCache("Converter By Destination Type Dozer Cache", settings.getConverterByDestTypeCacheMaxSize());
        this.cacheManager.addCache("Super Type Mapping Dozer Cache", settings.getSuperTypesCacheMaxSize());
        statsMgr.increment("Mapper Instances Count");
    }

    protected MapperIF getMappingProcessor() {
        MappingProcessor processor = new MappingProcessor(this.getCustomMappings(), this.globalConfiguration, this.cacheManager, statsMgr, this.customConverters, this.getEventListeners());
        if (statsMgr.isStatisticsEnabled()) {
            processor = (MapperIF)Proxy.newProxyInstance(processor.getClass().getClassLoader(), processor.getClass().getInterfaces(), (InvocationHandler)new StatisticsInterceptor((Object)processor, statsMgr));
        }
        return processor;
    }

    private synchronized Map getCustomMappings() {
        if (this.customMappings == null) {
            this.customMappings = Collections.synchronizedMap(this.loadCustomMappings());
        }
        return this.customMappings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Map loadCustomMappings() {
        HashMap customMappings;
        HashMap hashMap = customMappings = new HashMap();
        synchronized (hashMap) {
            ListOrderedSet customConverterDescriptions = new ListOrderedSet();
            InitLogger.log((Logger)log, (String)("Initializing a new instance of the dozer bean mapper.  Version: 2.3, Thread Name:" + Thread.currentThread().getName()));
            if (this.mappingFiles != null && this.mappingFiles.size() > 0) {
                InitLogger.log((Logger)log, (String)("Using the following xml files to load custom mappings for the bean mapper instance: " + this.mappingFiles));
                for (String mappingFileName : this.mappingFiles) {
                    InitLogger.log((Logger)log, (String)("Trying to find xml mapping file: " + mappingFileName));
                    URL url = this.mappingValidator.validateURL("" + mappingFileName);
                    InitLogger.log((Logger)log, (String)("Using URL [" + url + "] to load custom xml mappings"));
                    MappingFileReader mappingFileReader = new MappingFileReader(url);
                    Mappings mappings = mappingFileReader.read();
                    InitLogger.log((Logger)log, (String)("Successfully loaded custom xml mappings from URL: [" + url + "]"));
                    this.globalConfiguration = mappings.getConfiguration();
                    if (mappings.getConfiguration() != null && mappings.getConfiguration().getCustomConverters() != null && mappings.getConfiguration().getCustomConverters().getConverters() != null) {
                        for (CustomConverterDescription cc : mappings.getConfiguration().getCustomConverters().getConverters()) {
                            customConverterDescriptions.add((Object)cc);
                        }
                    }
                    MappingsParser mappingsParser = new MappingsParser();
                    customMappings.putAll(mappingsParser.parseMappings(mappings));
                }
            }
            if (customMappings != null) {
                this.classMapBuilder.addDefaultFieldMappings(customMappings);
            }
            for (String key : customMappings.keySet()) {
                ClassMap classMap = (ClassMap)customMappings.get(key);
                if (classMap.getConfiguration() == null) {
                    classMap.setConfiguration(new Configuration());
                }
                if (classMap.getConfiguration().getCustomConverters() != null) {
                    classMap.getConfiguration().getCustomConverters().setConverters(customConverterDescriptions.asList());
                    continue;
                }
                classMap.getConfiguration().setCustomConverters(new CustomConverterContainer());
                classMap.getConfiguration().getCustomConverters().setConverters(customConverterDescriptions.asList());
            }
        }
        return customMappings;
    }

    public List getEventListeners() {
        return this.eventListeners;
    }

    public void setEventListeners(List eventListeners) {
        this.eventListeners = eventListeners;
    }
}

