/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.filter;

import gov.va.med.cds.exception.ErrorCodeEnum;
import gov.va.med.cds.exception.InitializationException;
import gov.va.med.cds.filter.CdsFilterInterface;
import gov.va.med.cds.filter.FilterProcessorInterface;
import gov.va.med.cds.filter.FilteredResultAssemblerInterface;
import gov.va.med.cds.filter.schema.generated.Parameter;
import java.util.List;
import java.util.Map;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XpathFilterProcessor
implements FilterProcessorInterface {
    private static final Logger logger = Logger.getLogger(XpathFilterProcessor.class);
    private JXPathContext context;
    private Map<String, FilteredResultAssemblerInterface> filteredResultAssemblerMap = null;

    @Override
    public Object filterObject(CdsFilterInterface cdsFilter, Object aObjectToFilter) {
        FilteredResultAssemblerInterface assembler;
        List selection = null;
        String xpath = cdsFilter.getXpath();
        if (xpath != null && xpath.length() > 0) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Applying Domain Filter using xpath: " + xpath));
            }
            this.context = JXPathContext.newContext((Object)aObjectToFilter);
            List<Parameter> xpathParameters = cdsFilter.getXpathParameters();
            if (xpathParameters != null) {
                for (Parameter parameter : xpathParameters) {
                    String name = parameter.getName();
                    String value = parameter.getValue();
                    this.context.getVariables().declareVariable(name, (Object)value);
                }
            }
            selection = this.context.selectNodes(xpath);
        }
        if ((assembler = this.filteredResultAssemblerMap.get(aObjectToFilter.getClass().getName())) == null) {
            throw new InitializationException(ErrorCodeEnum.FILTER_RESULT_ASSEMBLER_NOT_CONFIGURED_FOR_TYPE, aObjectToFilter.getClass().getName());
        }
        return assembler.assemble(aObjectToFilter, selection);
    }

    public void setFilteredResultAssemblerMap(Map<String, FilteredResultAssemblerInterface> filteredResultAssemblerMap) {
        this.filteredResultAssemblerMap = filteredResultAssemblerMap;
    }
}

