/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.exceptionframework;

import gov.va.med.cds.exception.CdsBaseException;
import gov.va.med.cds.exceptionframework.LoggingSeverity;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import org.apache.commons.logging.Log;

public class ExceptionUtil {
    private static final int INIT_BUFFER_SIZE = 2400;

    public static void logException(Throwable e, LoggingSeverity loggingSeverity, Log logger, long loggedMessageId) {
        ExceptionUtil.logException(e, loggingSeverity, logger, null, loggedMessageId);
    }

    public static void logException(Throwable e, Log logger, String message, long loggedMessageId) {
        ExceptionUtil.logException(e, LoggingSeverity.FATAL, logger, message, loggedMessageId);
    }

    private static void logException(Throwable e, LoggingSeverity loggingSeverity, Log logger, String message, long loggedMessageId) {
        String exceptionTrace = ExceptionUtil.getExceptionLog(e, loggingSeverity, message, loggedMessageId);
        switch (loggingSeverity) {
            case WARNING: {
                logger.warn((Object)exceptionTrace, e);
                break;
            }
            case ERROR: {
                logger.error((Object)exceptionTrace, e);
                break;
            }
            default: {
                logger.fatal((Object)exceptionTrace, e);
            }
        }
    }

    private static String getExceptionLog(Throwable exception, LoggingSeverity loggingSeverity, String message, long loggedMessageId) {
        String detailedMessage = null;
        if (exception instanceof CdsBaseException) {
            CdsBaseException ie = (CdsBaseException)exception;
            detailedMessage = ExceptionUtil.getDetailedMessage(ie);
        } else {
            detailedMessage = ExceptionUtil.getDetailedMessage(exception);
        }
        StringBuffer lBuffer = new StringBuffer(2400);
        String msg = null;
        lBuffer.append((Object)((Object)loggingSeverity) + ": LOGID: ");
        lBuffer.append(loggedMessageId);
        lBuffer.append("\n");
        lBuffer.append("EXCEPTION MESSAGE :");
        lBuffer.append(message);
        lBuffer.append("\n");
        lBuffer.append(detailedMessage);
        lBuffer.append("\n");
        lBuffer.append("--------------------------------------------------------------------------------------\n");
        msg = lBuffer.toString();
        return msg;
    }

    private static String getDetailedMessage(Throwable a) {
        StringBuffer msg = new StringBuffer();
        msg.append("Message : ");
        msg.append(a.getMessage());
        msg.append("\n");
        msg.append("Exception Stack Trace\n");
        try {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            a.printStackTrace(pw);
            msg.append(sw.toString());
            sw.close();
        }
        catch (Exception e) {
            msg.append(a.toString());
        }
        String ret = msg.toString();
        return ret;
    }

    public static String formatMessage(String userMessage, String[] dataValues) {
        if (dataValues != null && dataValues.length > 0) {
            MessageFormat messageFormat = new MessageFormat(userMessage);
            userMessage = messageFormat.format(dataValues);
        }
        return userMessage;
    }
}

