/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.exceptionframework;

import gov.va.med.cds.exception.CdsBaseException;
import gov.va.med.cds.exception.ErrorCodeEnum;
import gov.va.med.cds.exception.InitializationException;
import gov.va.med.cds.exceptionframework.ExceptionDescriptorInterface;
import gov.va.med.cds.exceptionframework.ExceptionHandlerInterface;
import gov.va.med.cds.exceptionframework.ExceptionInfo;
import gov.va.med.cds.exceptionframework.ExceptionLoggerInterface;
import gov.va.med.cds.exceptionframework.ExceptionUtil;
import gov.va.med.cds.exceptionframework.LoggingSeverity;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseExceptionHandler
implements ExceptionHandlerInterface {
    private ExceptionLoggerInterface guaranteedLogger = null;
    private ThreadLocal<List<ExceptionInfo>> exceptionInfoList = new ThreadLocal();
    private Map<ErrorCodeEnum, ExceptionDescriptorInterface> exceptionDescriptorMap = null;

    public BaseExceptionHandler() {
        this.exceptionInfoList.set(new ArrayList());
    }

    private void handleCdsException(CdsBaseException businessException) {
        ErrorCodeEnum errorCodeEnum = businessException.getErrorCode();
        ExceptionDescriptorInterface exceptionDescriptor = this.exceptionDescriptorMap.get((Object)errorCodeEnum);
        String clientMessage = null;
        LoggingSeverity loggingSeverity = null;
        ExceptionInfo exceptionInfo = null;
        if (exceptionDescriptor != null) {
            clientMessage = ExceptionUtil.formatMessage(exceptionDescriptor.getClientMessage(), businessException.getCustomMsgValues());
            loggingSeverity = exceptionDescriptor.getLoggingSeverity();
            exceptionInfo = this.populateExceptionInfo(businessException, clientMessage, errorCodeEnum, loggingSeverity);
            for (ExceptionLoggerInterface logger : exceptionDescriptor.getLoggers()) {
                try {
                    logger.log((Throwable)businessException, exceptionDescriptor.getLoggingSeverity(), exceptionInfo.getLoggedMessageId());
                }
                catch (RuntimeException e) {
                    this.getGuaranteedLogger().log(e, "logger " + logger + "not configured", exceptionInfo.getLoggedMessageId());
                }
            }
            this.getGuaranteedLogger().log((Throwable)businessException, exceptionDescriptor.getLoggingSeverity(), exceptionInfo.getLoggedMessageId());
            if (exceptionDescriptor.getLoggingSeverity() == LoggingSeverity.FATAL) {
                throw businessException;
            }
        } else {
            String msg = "Exception not mapped: ";
            clientMessage = msg + businessException.getClass().getName();
            exceptionInfo = this.populateExceptionInfo(businessException, clientMessage, null, null);
            this.getGuaranteedLogger().log(businessException, clientMessage, exceptionInfo.getLoggedMessageId());
            throw businessException;
        }
    }

    @Override
    public void handleException(RuntimeException exception) {
        if (this.getGuaranteedLogger() == null) {
            throw new InitializationException(ErrorCodeEnum.GUARANTEED_LOGGER_NOT_CONFIGURED_AND_NULL);
        }
        if (!(exception instanceof CdsBaseException)) {
            ExceptionInfo exceptionInfo = this.populateExceptionInfo(exception, exception.getMessage(), null, null);
            String clientMessage = "Runtime exception occured: " + exception.getClass().getName();
            this.getGuaranteedLogger().log(exception, clientMessage, exceptionInfo.getLoggedMessageId());
            throw exception;
        }
        this.handleCdsException((CdsBaseException)exception);
    }

    @Override
    public void clear() {
        this.exceptionInfoList.get().clear();
    }

    public void setExceptionDescriptorMap(Map<ErrorCodeEnum, ExceptionDescriptorInterface> logDescriptorMap) {
        this.exceptionDescriptorMap = logDescriptorMap;
    }

    public ExceptionLoggerInterface getGuaranteedLogger() {
        return this.guaranteedLogger;
    }

    public void setGuaranteedLogger(ExceptionLoggerInterface guaranteedLogger) {
        this.guaranteedLogger = guaranteedLogger;
    }

    public Map<ErrorCodeEnum, ExceptionDescriptorInterface> getExceptionDescriptorMap() {
        return this.exceptionDescriptorMap;
    }

    @Override
    public List<ExceptionInfo> getExceptionInfoList() {
        return this.exceptionInfoList.get();
    }

    private ExceptionInfo populateExceptionInfo(Throwable businessException, String clientMessage, ErrorCodeEnum errorCode, LoggingSeverity loggingSeverity) {
        ExceptionInfo exceptionInfo = new ExceptionInfo();
        exceptionInfo.setClientMessage(clientMessage);
        exceptionInfo.setErrorCode(errorCode);
        exceptionInfo.setException(businessException);
        exceptionInfo.setExceptionMessage(businessException.getMessage());
        exceptionInfo.setLoggingSeverity(loggingSeverity);
        this.exceptionInfoList.get().add(exceptionInfo);
        return exceptionInfo;
    }

    @Override
    public boolean hasErrors() {
        return this.exceptionInfoList.get().size() > 0;
    }
}

