/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.util;

import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.springframework.core.io.Resource;

public class StreamUtil {
    public static String resourceToString(Resource resource) throws IOException {
        String resourceString = null;
        try (InputStream is = resource.getInputStream();){
            resourceString = StreamUtil.streamToString(is);
            is.close();
        }
        return resourceString;
    }

    public static byte[] resourceToBytes(Resource resource) throws IOException {
        byte[] bytes = null;
        try (InputStream is = resource.getInputStream();){
            bytes = new byte[is.available()];
            is.read(bytes);
            is.close();
        }
        return bytes;
    }

    public static String streamToString(InputStream input) throws IOException {
        StringBuilder buffer = new StringBuilder();
        BufferedReader inputBufferedReader = new BufferedReader(new InputStreamReader(input));
        char[] buff = new char[1024];
        int count = 0;
        while ((count = inputBufferedReader.read(buff)) != -1) {
            buffer.append(buff, 0, count);
        }
        inputBufferedReader.close();
        return buffer.toString();
    }

    public static String streamAsString(Reader in) throws IOException {
        int read;
        StringBuilder buf = new StringBuilder();
        char[] chars = new char[1024];
        while ((read = in.read(chars)) > 0) {
            buf.append(chars, 0, read);
        }
        try {
            in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return buf.toString();
    }

    public static void putToFile(String outStr, String fileName) throws IOException {
        try (FileWriter writer = null;){
            writer = new FileWriter(fileName);
            writer.write(outStr);
            writer.flush();
            writer.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void putToFile(byte[] bytes, String filename) {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(filename);
            fos.write(bytes);
            fos.flush();
            fos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        }
    }
}

