/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.template.generated.pharmacy;

import gov.va.med.cds.clinicaldata.ClinicalRecordInterface;
import gov.va.med.cds.template.generated.basedatatypes.HL72CodedElementLite;
import gov.va.med.cds.template.generated.basedatatypes.HL72FacilityIdentifier;
import gov.va.med.cds.template.generated.basedatatypes.PointInTime;
import gov.va.med.cds.template.generated.common.PatientLite;
import gov.va.med.cds.template.generated.common.PractitionerParticipationLite;
import gov.va.med.cds.template.generated.common.TreatmentFactor;
import gov.va.med.cds.template.generated.pharmacy.ActivityLog;
import gov.va.med.cds.template.generated.pharmacy.CancelAct;
import gov.va.med.cds.template.generated.pharmacy.MedicationInstructionComponent;
import gov.va.med.cds.template.generated.pharmacy.MedicationPromise;
import gov.va.med.cds.template.generated.pharmacy.OutpatientMedicationDispense;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(name="outpatientMedicationPromises")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="OutpatientMedicationPromise", propOrder={"patient", "expirationDate", "lastDispenseDate", "numberOfRefillsAuthorized", "patientInstructions", "otherPatientInstructions", "expandedPatientInstructions", "pharmacyInstructions", "sig", "digitalSignatureIndicator", "copayTransactionType", "transitionalRxBenefit", "treatmentFactor", "originalDispense", "refillDispense", "partialDispense", "cancel", "medicationInstructions", "finisher", "activityLog", "recordSource", "recordVersion", "recordUpdateTime", "requestId", "id"})
public class OutpatientMedicationPromise
extends MedicationPromise
implements ClinicalRecordInterface {
    @XmlElement(required=true)
    protected PatientLite patient;
    protected PointInTime expirationDate;
    protected PointInTime lastDispenseDate;
    protected Integer numberOfRefillsAuthorized;
    @XmlElement(required=false, nillable=false)
    protected List<String> patientInstructions;
    @XmlElement(required=false, nillable=false)
    protected List<String> otherPatientInstructions;
    @XmlElement(required=false, nillable=false)
    protected List<String> expandedPatientInstructions;
    @XmlElement(required=false, nillable=false)
    protected List<String> pharmacyInstructions;
    @XmlElement(required=false, nillable=false)
    protected List<String> sig;
    protected HL72CodedElementLite digitalSignatureIndicator;
    protected HL72CodedElementLite copayTransactionType;
    protected HL72CodedElementLite transitionalRxBenefit;
    @XmlElement(required=false, nillable=false)
    protected List<TreatmentFactor> treatmentFactor;
    protected OutpatientMedicationDispense originalDispense;
    @XmlElement(required=false, nillable=false)
    protected List<OutpatientMedicationDispense> refillDispense;
    @XmlElement(required=false, nillable=false)
    protected List<OutpatientMedicationDispense> partialDispense;
    protected CancelAct cancel;
    @XmlElement(required=false, nillable=false)
    protected List<MedicationInstructionComponent> medicationInstructions;
    protected PractitionerParticipationLite finisher;
    @XmlElement(required=false, nillable=false)
    protected List<ActivityLog> activityLog;
    @XmlElement(required=true, nillable=false)
    protected HL72FacilityIdentifier recordSource;
    protected Integer recordVersion;
    @XmlElement(required=true, nillable=false)
    protected PointInTime recordUpdateTime;
    protected String requestId;
    protected Long id;
    @XmlTransient
    protected List<OutpatientMedicationDispense> originalDispenseSet;
    @XmlTransient
    protected String singlePatientInstruction;
    @XmlTransient
    protected String singleOtherPatientInstruction;
    @XmlTransient
    protected String singleExpandedPatientInstruction;
    @XmlTransient
    protected String singlePharmacyInstruction;
    @XmlTransient
    protected String singleSig;
    @XmlTransient
    protected BigDecimal idV;

    public PatientLite getPatient() {
        return this.patient;
    }

    public void setPatient(PatientLite value) {
        this.patient = value;
    }

    public PointInTime getExpirationDate() {
        return this.expirationDate;
    }

    public void setExpirationDate(PointInTime value) {
        this.expirationDate = value;
    }

    public PointInTime getLastDispenseDate() {
        return this.lastDispenseDate;
    }

    public void setLastDispenseDate(PointInTime value) {
        this.lastDispenseDate = value;
    }

    public Integer getNumberOfRefillsAuthorized() {
        return this.numberOfRefillsAuthorized;
    }

    public void setNumberOfRefillsAuthorized(Integer value) {
        this.numberOfRefillsAuthorized = value;
    }

    public List<String> getPatientInstructions() {
        if (this.patientInstructions == null) {
            this.patientInstructions = new ArrayList<String>();
        }
        return this.patientInstructions;
    }

    public void setPatientInstructions(List<String> patientInstructions) {
        this.patientInstructions = patientInstructions;
    }

    public String getSinglePatientInstruction() {
        return this.singlePatientInstruction;
    }

    public void setSinglePatientInstruction(String singleInstruction) {
        this.getPatientInstructions().add(singleInstruction);
    }

    public List<String> getOtherPatientInstructions() {
        if (this.otherPatientInstructions == null) {
            this.otherPatientInstructions = new ArrayList<String>();
        }
        return this.otherPatientInstructions;
    }

    public void setOtherPatientInstructions(List<String> otherPatientInstructions) {
        this.otherPatientInstructions = otherPatientInstructions;
    }

    public String getSingleOtherPatientInstruction() {
        return this.singleOtherPatientInstruction;
    }

    public void setSingleOtherPatientInstruction(String singleInstruction) {
        this.getOtherPatientInstructions().add(singleInstruction);
    }

    public List<String> getExpandedPatientInstructions() {
        if (this.expandedPatientInstructions == null) {
            this.expandedPatientInstructions = new ArrayList<String>();
        }
        return this.expandedPatientInstructions;
    }

    public void setExpandedPatientInstructions(List<String> expandedPatientInstructions) {
        this.expandedPatientInstructions = expandedPatientInstructions;
    }

    public String getSingleExpandedPatientInstruction() {
        return this.singleExpandedPatientInstruction;
    }

    public void setSingleExpandedPatientInstruction(String singleInstruction) {
        this.getExpandedPatientInstructions().add(singleInstruction);
    }

    public List<String> getPharmacyInstructions() {
        if (this.pharmacyInstructions == null) {
            this.pharmacyInstructions = new ArrayList<String>();
        }
        return this.pharmacyInstructions;
    }

    public void setPharmacyInstructions(List<String> pharmacyInstructions) {
        this.pharmacyInstructions = pharmacyInstructions;
    }

    public String getSinglePharmacyInstruction() {
        return this.singlePharmacyInstruction;
    }

    public void setSinglePharmacyInstruction(String singleInstruction) {
        this.getPharmacyInstructions().add(singleInstruction);
    }

    public List<String> getSig() {
        if (this.sig == null) {
            this.sig = new ArrayList<String>();
        }
        return this.sig;
    }

    public void setSig(List<String> sig) {
        this.sig = sig;
    }

    public String getSingleSig() {
        return this.singleSig;
    }

    public void setSingleSig(String singleSig) {
        this.getSig().add(singleSig);
    }

    public HL72CodedElementLite getDigitalSignatureIndicator() {
        return this.digitalSignatureIndicator;
    }

    public void setDigitalSignatureIndicator(HL72CodedElementLite value) {
        this.digitalSignatureIndicator = value;
    }

    public HL72CodedElementLite getCopayTransactionType() {
        return this.copayTransactionType;
    }

    public void setCopayTransactionType(HL72CodedElementLite value) {
        this.copayTransactionType = value;
    }

    public HL72CodedElementLite getTransitionalRxBenefit() {
        return this.transitionalRxBenefit;
    }

    public void setTransitionalRxBenefit(HL72CodedElementLite value) {
        this.transitionalRxBenefit = value;
    }

    public List<TreatmentFactor> getTreatmentFactor() {
        if (this.treatmentFactor == null) {
            this.treatmentFactor = new ArrayList<TreatmentFactor>();
        }
        return this.treatmentFactor;
    }

    public void setTreatmentFactor(List<TreatmentFactor> treatmentFactor) {
        this.treatmentFactor = treatmentFactor;
    }

    public OutpatientMedicationDispense getOriginalDispense() {
        return this.originalDispense;
    }

    public void setOriginalDispense(OutpatientMedicationDispense value) {
        this.originalDispense = value;
    }

    public List<OutpatientMedicationDispense> getRefillDispense() {
        if (this.refillDispense == null) {
            this.refillDispense = new ArrayList<OutpatientMedicationDispense>();
        }
        return this.refillDispense;
    }

    public void setRefillDispense(List<OutpatientMedicationDispense> refillDispense) {
        if (this.originalDispense != null && this.originalDispense.getNumberOfRefillsRemaining() == null) {
            int numOfRefillsFromList = 0;
            for (OutpatientMedicationDispense outpatientMedicationDispense : refillDispense) {
                if (outpatientMedicationDispense == null) continue;
                ++numOfRefillsFromList;
            }
            if (this.originalDispense != null) {
                this.originalDispense.setNumberOfRefillsRemaining(this.numberOfRefillsAuthorized - numOfRefillsFromList);
            }
        }
        this.refillDispense = refillDispense;
    }

    public List<OutpatientMedicationDispense> getPartialDispense() {
        if (this.partialDispense == null) {
            this.partialDispense = new ArrayList<OutpatientMedicationDispense>();
        }
        return this.partialDispense;
    }

    public void setPartialDispense(List<OutpatientMedicationDispense> partialDispense) {
        this.partialDispense = partialDispense;
    }

    public CancelAct getCancel() {
        return this.cancel;
    }

    public void setCancel(CancelAct value) {
        this.cancel = value;
    }

    public List<MedicationInstructionComponent> getMedicationInstructions() {
        if (this.medicationInstructions == null) {
            this.medicationInstructions = new ArrayList<MedicationInstructionComponent>();
        }
        return this.medicationInstructions;
    }

    public void setMedicationInstructions(List<MedicationInstructionComponent> medicationInstructions) {
        this.medicationInstructions = medicationInstructions;
    }

    public PractitionerParticipationLite getFinisher() {
        return this.finisher;
    }

    public void setFinisher(PractitionerParticipationLite value) {
        this.finisher = value;
    }

    public List<ActivityLog> getActivityLog() {
        if (this.activityLog == null) {
            this.activityLog = new ArrayList<ActivityLog>();
        }
        return this.activityLog;
    }

    public void setActivityLog(List<ActivityLog> activityLog) {
        this.activityLog = activityLog;
    }

    public HL72FacilityIdentifier getRecordSource() {
        return this.recordSource;
    }

    public void setRecordSource(HL72FacilityIdentifier value) {
        this.recordSource = value;
    }

    public int getRecordVersion() {
        return this.recordVersion;
    }

    public void setRecordVersion(Integer value) {
        this.recordVersion = value;
    }

    public PointInTime getRecordUpdateTime() {
        return this.recordUpdateTime;
    }

    public void setRecordUpdateTime(PointInTime value) {
        this.recordUpdateTime = value;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public BigDecimal getIdV() {
        return this.idV;
    }

    public void setIdV(BigDecimal id) {
        this.idV = id;
    }

    public List<OutpatientMedicationDispense> getOriginalDispenseSet() {
        if (this.originalDispenseSet == null) {
            this.originalDispenseSet = new ArrayList<OutpatientMedicationDispense>();
            if (this.originalDispense != null) {
                this.originalDispenseSet.add(this.originalDispense);
            }
        } else if (this.originalDispenseSet.size() == 0 && this.originalDispense != null) {
            this.originalDispenseSet.add(this.originalDispense);
        }
        return this.originalDispenseSet;
    }

    public void setOriginalDispenseSet(List<OutpatientMedicationDispense> originalDispenseSet) {
        this.originalDispenseSet = originalDispenseSet;
        if (originalDispenseSet.size() > 0) {
            this.originalDispense = this.originalDispenseSet.get(0);
        }
    }
}

