/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.properties;

import gov.va.med.cds.properties.PropertiesManager;
import java.io.IOException;
import java.util.Properties;
import javax.crypto.spec.SecretKeySpec;

public class PropertiesUtil {
    public static final String PROPERTIES_KEYSTORE_FILE_PATH_PROPERTY = "cds.keystore.properties.path";
    private PropertiesManager propertiesManager = null;

    public PropertiesUtil() {
        if (this.getPropertiesManager() == null) {
            this.propertiesManager = new PropertiesManager();
        }
    }

    public void loadSystemRunProperties() throws IOException {
        String propertiesFilePath = this.propertiesManager.getPropertiesFilePathFromSystemProperties();
        if (propertiesFilePath != null) {
            String encrypt = this.propertiesManager.getEncryptSwitchFromSystemProperties();
            String keyStorePassword = this.propertiesManager.getKeyStorePasswordFromSystemProperties();
            Properties fileProps = this.propertiesManager.loadPropertiesFromPropertiesFile(propertiesFilePath);
            SecretKeySpec savedKey = null;
            String keyStoreFileLocation = fileProps.getProperty(PROPERTIES_KEYSTORE_FILE_PATH_PROPERTY);
            if (encrypt != null && encrypt.equalsIgnoreCase("true")) {
                savedKey = this.propertiesManager.configureKeyStore(keyStoreFileLocation, keyStorePassword);
                this.encryptProperties(propertiesFilePath, fileProps, savedKey);
            }
            fileProps = this.propertiesManager.decryptProperties(savedKey, keyStoreFileLocation, keyStorePassword, fileProps);
            this.propertiesManager.updateSystemProperties(fileProps);
        }
    }

    protected void encryptProperties(String propertiesFilePath, Properties fileProps, SecretKeySpec savedKey) throws IOException {
        this.propertiesManager.encryptProperties(savedKey, propertiesFilePath, (Properties)fileProps.clone());
    }

    PropertiesManager getPropertiesManager() {
        return this.propertiesManager;
    }

    void setPropertiesManager(PropertiesManager propertiesManager) {
        this.propertiesManager = propertiesManager;
    }
}

