/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.clinicaldata.vhim400;

import gov.va.med.cds.clinicaldata.vhim400.ConfigurableClinicalDataResponse;
import gov.va.med.cds.clinicaldata.vhim400.PathwaysDataResponseInterface;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.springframework.util.StringUtils;

public class ConfigurablePathwaysDataResponse
extends ConfigurableClinicalDataResponse
implements PathwaysDataResponseInterface {
    private String schemaNamespacePrefix;
    private String schemaNamespaceUri;
    private String schemaLocalName;
    private static String SCHEMA_NAMESPACE_PREFIX = "pathwaysdata";
    private static String SCHEMA_NAMESPACE_URI = "Pathwaysdata";
    private static String SCHEMA_LOCAL_NAME = "PathwaysData";

    public ConfigurablePathwaysDataResponse(String patientElementPath, String clinicalRootPath, String errorResponseTemplateId) {
        super(patientElementPath, clinicalRootPath, errorResponseTemplateId);
    }

    public ConfigurablePathwaysDataResponse(String patientElementPath, String clinicalRootPath, String errorResponseTemplateId, String schemaNamespacePrefix, String schemaNamespaceUri, String schemaLocalName) {
        super(patientElementPath, clinicalRootPath, errorResponseTemplateId);
        this.schemaNamespacePrefix = schemaNamespacePrefix;
        this.schemaNamespaceUri = schemaNamespaceUri;
        this.schemaLocalName = schemaLocalName;
    }

    @Override
    public Document buildEmptyPathwaysDocumentWithPatient(String templateId, String requestId) {
        return this.buildPathwaysDocument(templateId, requestId, true, null, null);
    }

    @Override
    public Document buildEmptyPathwaysDocumentWithPatient(String templateId, String requestId, String clName, String clReqTime) {
        return this.buildPathwaysDocument(templateId, requestId, true, clName, clReqTime);
    }

    @Override
    public Document buildEmptyPathwaysDocumentWithoutPatient(String templateId, String requestId, String clName, String clReqTime) {
        return this.buildPathwaysDocument(templateId, requestId, false, clName, clReqTime);
    }

    @Override
    public Document buildEmptyPathwaysDocumentWithoutPatient(String templateId, String requestId) {
        return this.buildPathwaysDocument(templateId, requestId, false, null, null);
    }

    private Document buildPathwaysDocument(String templateId, String requestId, boolean addPatient, String clientName, String clientReqTime) {
        if (!StringUtils.hasText((String)this.schemaNamespacePrefix)) {
            this.schemaNamespacePrefix = SCHEMA_NAMESPACE_PREFIX;
        }
        if (!StringUtils.hasText((String)this.schemaNamespaceUri)) {
            this.schemaNamespaceUri = SCHEMA_NAMESPACE_URI;
        }
        if (!StringUtils.hasText((String)this.schemaLocalName)) {
            this.schemaLocalName = SCHEMA_LOCAL_NAME;
        }
        Namespace pathwaysDataNamespace = DocumentHelper.createNamespace((String)this.schemaNamespacePrefix, (String)this.schemaNamespaceUri);
        Element pathwaysDataElement = DocumentHelper.createElement((QName)DocumentHelper.createQName((String)this.schemaLocalName, (Namespace)pathwaysDataNamespace));
        if (templateId != null) {
            this.getChildElement(pathwaysDataElement, this.templateIdElementName, true).addText(templateId);
        }
        if (requestId != null) {
            this.getChildElement(pathwaysDataElement, this.requestIdElementName, true).addText(requestId);
        }
        if (clientName != null) {
            this.getChildElement(pathwaysDataElement, "clientName", true).addText(clientName);
        }
        if (clientReqTime != null) {
            this.getChildElement(pathwaysDataElement, "clientRequestInitiationTime", true).addText(clientReqTime);
        }
        if (addPatient) {
            this.getChildElement(pathwaysDataElement, this.patientElementPath, true);
        }
        return DocumentHelper.createDocument((Element)pathwaysDataElement);
    }
}

