/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.clinicaldata;

import gov.va.med.cds.clinicaldata.DomainEntryPoint;
import gov.va.med.cds.clinicaldata.Operation;
import gov.va.med.cds.clinicaldata.TfsTemplateMetaDataInterface;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.Date;
import java.util.Set;
import javax.sql.rowset.serial.SerialBlob;
import org.hibernate.engine.jdbc.NonContextualLobCreator;

public class TfsTemplateMetaData
implements TfsTemplateMetaDataInterface {
    private Date dateAdded;
    private Date dateDeprecated;
    private Date dateActivated;
    private Date dateDeactivated;
    private Date dateUpdated;
    private String status;
    protected String[] vhimVersions;
    protected Set<DomainEntryPoint> domainEntryPoints;
    private byte[] templateJar;
    public Operation operation;
    public String cdsVdm;
    public String templateId;
    public String templateName;
    public String templateDescription;
    public boolean testOnly;

    public Date getDateAdded() {
        return this.dateAdded;
    }

    public void setDateAdded(Date dateAdded) {
        this.dateAdded = dateAdded;
    }

    public Date getDateDeprecated() {
        return this.dateDeprecated;
    }

    public void setDateDeprecated(Date dateDeprecated) {
        this.dateDeprecated = dateDeprecated;
    }

    public Date getDateActivated() {
        return this.dateActivated;
    }

    public void setDateActivated(Date dateActivated) {
        this.dateActivated = dateActivated;
    }

    public Date getDateDeactivated() {
        return this.dateDeactivated;
    }

    public void setDateDeactivated(Date dateDeactivated) {
        this.dateDeactivated = dateDeactivated;
    }

    public Date getDateUpdated() {
        return this.dateUpdated;
    }

    public void setDateUpdated(Date dateUpdated) {
        this.dateUpdated = dateUpdated;
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(String status) {
        this.status = status;
    }

    @Override
    public byte[] getTemplateJar() {
        return this.templateJar;
    }

    @Override
    public void setTemplateJar(byte[] templateJar) {
        this.templateJar = templateJar;
    }

    private void setBlob(Blob jar) {
        this.templateJar = this.toByteArray(jar);
    }

    private Blob getBlob() {
        return this.templateJar == null ? null : this.createBlob(this.templateJar);
    }

    private Blob createBlob(byte[] bytes) {
        Blob blob = null;
        blob = NonContextualLobCreator.INSTANCE.wrap(NonContextualLobCreator.INSTANCE.createBlob(bytes));
        return blob;
    }

    private Blob createBlob2(byte[] bytes) {
        SerialBlob blob = null;
        try {
            blob = new SerialBlob(bytes);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return blob;
    }

    private byte[] toByteArray(Blob fromJar) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            return this.toByteArrayImpl(fromJar, baos);
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] toByteArrayImpl(Blob fromJar, ByteArrayOutputStream baos) throws SQLException, IOException {
        byte[] buf = new byte[4000];
        try (InputStream is = fromJar.getBinaryStream();){
            int dataSize;
            while ((dataSize = is.read(buf)) != -1) {
                baos.write(buf, 0, dataSize);
            }
        }
        return baos.toByteArray();
    }

    public void setVhimVersions(Set<String> aVhimVersions) {
        this.vhimVersions = (String[])aVhimVersions.toArray();
    }

    @Override
    public String[] getVhimVersions() {
        return this.vhimVersions;
    }

    @Override
    public void setVhimVersions(String[] aVhimVersions) {
        this.vhimVersions = aVhimVersions;
    }

    @Override
    public Operation getOperation() {
        return this.operation;
    }

    public String getOperationAsString() {
        return this.operation.name();
    }

    @Override
    public void setOperation(Operation theOperation) {
        this.operation = theOperation;
    }

    public void setOperationAsString(String theOperation) {
        this.operation = Operation.valueOf(theOperation);
    }

    @Override
    public Set<DomainEntryPoint> getDomainEntryPoints() {
        return this.domainEntryPoints;
    }

    @Override
    public void setDomainEntryPoints(Set<DomainEntryPoint> theDomainEntryPoints) {
        this.domainEntryPoints = theDomainEntryPoints;
    }

    public String getWriteCdsVdm() {
        return this.cdsVdm;
    }

    public void setWriteCdsVdm(String aCdsVdm) {
        this.cdsVdm = aCdsVdm;
    }

    @Override
    public String getTemplateId() {
        return this.templateId;
    }

    @Override
    public void setTemplateId(String theTemplateId) {
        this.templateId = theTemplateId;
    }

    @Override
    public String getTemplateName() {
        return this.templateName;
    }

    @Override
    public void setTemplateName(String theTemplateName) {
        this.templateName = theTemplateName;
    }

    @Override
    public String getTemplateDescription() {
        return this.templateDescription;
    }

    @Override
    public void setTemplateDescription(String theTemplateDescription) {
        this.templateDescription = theTemplateDescription;
    }

    @Override
    public boolean getTestOnly() {
        return this.testOnly;
    }

    @Override
    public void setTestOnly(boolean aTestOnly) {
        this.testOnly = aTestOnly;
    }

    @Override
    public void setTestOnly(String aTrueOrFalse) {
        this.testOnly = Boolean.parseBoolean(aTrueOrFalse);
    }
}

