/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.clinicaldata;

import gov.va.med.cds.clinicaldata.DomainClinicalRecordElementHelperInterface;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dom4j.Element;

public class DomainClinicalRecordElementHelper
implements DomainClinicalRecordElementHelperInterface {
    private String domainIdentityOwner;
    private String facilityOwner;
    private String authorityOwner;
    private Map<String, String> childCollectionsAndIdentityOwners;

    @Override
    public void setDomainIdentityOwner(String domainIdentityOwner) {
        this.domainIdentityOwner = domainIdentityOwner;
    }

    @Override
    public Map<String, String> getChildCollectionsAndIdentityOwners() {
        return this.childCollectionsAndIdentityOwners;
    }

    @Override
    public void setChildCollectionsAndIdentityOwners(Map<String, String> childCollectionsAndIdentityOwners) {
        this.childCollectionsAndIdentityOwners = childCollectionsAndIdentityOwners;
    }

    @Override
    public void setFacilityOwner(String facilityOwner) {
        this.facilityOwner = facilityOwner;
    }

    @Override
    public void setAuthorityOwner(String authorityOwner) {
        this.authorityOwner = authorityOwner;
    }

    @Override
    public String addIdToClinicalRecordElement(Element clinicalRecordElement) {
        String parentResultId = null;
        Element recordId = this.discoverOwnerElement(this.domainIdentityOwner, clinicalRecordElement);
        if (recordId != null) {
            parentResultId = recordId.getStringValue();
            clinicalRecordElement.addElement("id").addText(parentResultId);
        }
        return parentResultId;
    }

    @Override
    public String addIdToParentAndChildElements(Element parentElement) {
        String parentResultId = null;
        Element recordId = this.discoverOwnerElement(this.domainIdentityOwner, parentElement);
        if (recordId != null) {
            parentResultId = recordId.getStringValue();
            parentElement.addElement("id").addText(parentResultId);
            if (this.childCollectionsAndIdentityOwners != null) {
                Set<String> childCollections = this.childCollectionsAndIdentityOwners.keySet();
                for (String collectionName : childCollections) {
                    Element collectionsElement = this.discoverOwnerElement(collectionName, parentElement);
                    List childCollectionElements = collectionsElement.elements();
                    for (Element childElement : childCollectionElements) {
                        String childRecordIdentityPath = this.childCollectionsAndIdentityOwners.get(collectionName);
                        Element childRecordIdentity = this.discoverOwnerElement(childRecordIdentityPath, childElement);
                        if (childRecordIdentity == null) continue;
                        childElement.addElement("id").addText(childRecordIdentity.getStringValue());
                    }
                }
            }
        }
        return parentResultId;
    }

    private Element discoverOwnerElement(String componentName, Element ownerElement) {
        Element element = null;
        if (!componentName.contains(".")) {
            return ownerElement.element(componentName);
        }
        String compName = componentName.substring(0, componentName.indexOf(46));
        element = ownerElement.element(compName);
        if (element != null) {
            String elementName = componentName.substring(componentName.indexOf(46) + 1);
            element = elementName.contains(".") ? this.discoverOwnerElement(elementName, element) : element.element(elementName);
        }
        return element;
    }

    @Override
    public String getAssigningFacilityValue(Element clinicalRecord) {
        return this.getElementValue(clinicalRecord, this.facilityOwner);
    }

    @Override
    public String getAssigningAuthorityValue(Element clinicalRecord) {
        return this.getElementValue(clinicalRecord, this.authorityOwner);
    }

    protected String getElementValue(Element clinicalRecord, String elementOwnerName) {
        String value = null;
        Element owner = this.discoverOwnerElement(elementOwnerName, clinicalRecord);
        if (owner != null) {
            value = owner.getStringValue();
        }
        return value;
    }
}

