define(['jquery',
    'backbone',
    'marionette',
    'main/UILibrary',
    'api/UIComponents',
    'jasminejquery',
    'bootstrap'
], function($, Backbone, Marionette, UI) {
    'use strict';

    var $form, form;

    var options = {
        placement: 'right'
    };
    var itemsArray = [{
        label: "Input",
        control: "input",
        name: "popinput",
        placeholder: "Enter text..."
    }];

    var popoverControlDefinition = {
        control: 'popover',
        type: 'button',
        label: 'Button',
        name: "popover1",
        options: options,
        extraClasses: ["btn-lg"],
        items: itemsArray
    };

    var formModel = new Backbone.Model();

    describe('A popover control', function() {
        afterEach(function() {
            form.remove();
        });

        describe('Basic', function() {
            beforeEach(function() {
                form = new UI.Form({
                    model: formModel,
                    fields: [popoverControlDefinition]
                });

                $form = form.render().$el;

                $('body').append($form);
            });

            it('contains correct wrapper', function() {
                expect($form.find('.popover-content-region > .popover1').length).toBe(1);
            });

            it('contains popover trigger', function() {
                //The popover content can have buttons in it
                expect($form.children().first('button').length).toBe(1);
            });

            it('contains hidden popover content container', function() {
                expect($form.find(".popover-content-region").length).toBe(1);
                //Using BS hidden class doesn't register as hidden with jasmine.
                expect($form.find(".popover-content-region > div")).toHaveClass("hidden");
            });

            it('renders popover content in hidden container div', function() {
                expect($form.find(".popover-content-region")).toContainElement($('input'));
            });

            it('renders popover on show', function() {
                $form.find('button').popover('show');

                expect($form).toContainElement('.popover');
            });

            it('moves popover content from popover content to hidden div on hide', function() {
                $form.find("#popover1-popover-trigger-container > button").popover('show');
                $form.find('#popover1-popover-trigger-container > button').popover('hide');

                //  This is a Jasmine bug. You cannot say:
                //  expect($form.find('.popover')).not.toExist.
                //  The above will incorrectly fail. Instead we
                //  have to query to entire document to see if the popover
                //  is a child element of the document. -_-
                expect($('document')).not.toContain('.popover');

                //Expect my popover content container to have what goes in the popover on next show
                expect($form.find('.popover-content-region')).toContainElement($('input'));
            });

            it('hides and shows popover when popover control events are triggered', function() {
                $('.popover-button-region').trigger('control:popover:hidden', false);
                expect($form).toContainElement('.popover');

                $('.popover-button-region').trigger('control:popover:hidden', true);
                expect($('document')).not.toContain('.popover');
            });
        });
        describe('popover event testing', function() {
            beforeEach(function() {
                form = new UI.Form({
                    model: formModel,
                    fields: [popoverControlDefinition]
                });
                this.model = {
                    control: 'button',
                    label: 'Button',
                    name: 'test'
                };
                $form = form.render().$el;
                $('body').append($form);
            });
            it('should correctly add a new control the popover collection', function() {
                expect($form.find('.popover-content-region button').length).toBe(0);
                $('.popover-content-region > ').trigger('control:items:add', this.model);
                expect($form.find('.popover-content-region button').length).toBe(1);
            });
            it('should correct remove a control from the popover collection', function() {
                expect($form.find('.popover-content-region button').length).toBe(0);
                $('.popover-content-region > ').trigger('control:items:add', this.model);
                expect($form.find('.popover-content-region button').length).toBe(1);
                $('.popover-content-region > ').trigger('control:items:remove', this.model);
                expect($form.find('.popover-content-region button').length).toBe(0);
            });
            it('should correctly reset the popover collection', function() {
                expect($form.find('.popover-content-region input').length).toBe(1);
                $('.popover-content-region > ').trigger('control:items:update', this.model);
                expect($form.find('.popover-content-region input').length).toBe(0);
                expect($form.find('.popover-content-region button').length).toBe(1);
            });
            it("update:config", function() {
                $form.find('.popover-button-region .popover-control').trigger("control:update:config", {
                    hidden: true
                });
                expect($form.find('.popover-button-region .popover-control')).toHaveClass('hidden');
                $form.find('.popover-button-region .popover-control').trigger("control:update:config", {
                    hidden: false
                });
                expect($form.find('.popover-button-region .popover-control')).not.toHaveClass('hidden');
            });
        });
    });
});