'use strict';

var _ = require('lodash');
var rdk = require('../../core/rdk');
var RdkError = rdk.utils.RdkError;
var pjdsUtil = rdk.utils.pjdsUtil;

var getList = function(req, res) {
    var filter = pjdsUtil.getRequestParameter(req, 'filter', 'eq(status,active)');
    pjdsUtil.getPermissionSet(req, {
        store: 'permset',
        filterList: filter
    }, function(error, response) {
        if (error) {
            var rdkError = new RdkError({
                code: '202.500.1002',
                logger: req.logger,
                error: error
            });
            return res.status(rdkError.status).rdkSend(rdkError);
        }
        var permissionSets = [];
        _.each(response.data.items, function(item) {
            permissionSets.push({
                label: item.label,
                val: item.uid,
                permissions: item.permissions
            });
        });
        return res.status(rdk.httpstatus.ok).rdkSend(permissionSets);
    });
};

module.exports = getList;
