'use strict';

var _ = require('lodash');
var nock = require('nock');
var httpMocks = require('node-mocks-http');
var getPermissionSets = require('./get-permission-sets');
var logger = sinon.stub(require('bunyan').createLogger({
    name: 'get-permission-sets'
}));

var permsets = [
    {
        'uid': 'drummer',
        'description': 'The Metronome of the song. This player is responsible for timing, but also the basic groove.',
        'example': 'Benny Greb, ',
        'label': 'Drummer',
        'note': 'This player has to keep any bass players in check',
        'permissions': [
            'one-solo-per-song',
            'fills-as-needed'
        ],
        'status': 'active',
        'sub-sets': [],
        'version': {
            'introduced': 'at the beginning',
            'deprecated': null
        }
    }, {
        'uid': 'bassist',
        'description': 'The link between the drum grove and the notes generated by the guiltars, lead vocals and/or the keyboards',
        'example': 'Bass players never have names. We are the underdogs.',
        'label': 'Bass Guitarist',
        'note': 'This player makes a song \'danceable\' or not',
        'permissions': [
            'sit-in-corner',
            'one-solo-per-ep'
        ],
        'status': 'active',
        'sub-sets': [],
        'version': {
            'introduced': 'long ago',
            'deprecated': null
        }
    }, {
        'uid': 'pianist',
        'description': 'Plays bass lines on the left hand while playing melody on the right.',
        'example': 'Ray Charles',
        'label': 'Pianist',
        'note': 'Usually extremely talented',
        'permissions': [
            'play-it-all',
            'one-solo-per-moment'
        ],
        'status': 'active',
        'sub-sets': [],
        'version': {
            'introduced': 'whenever pianos became a thing',
            'deprecated': null
        }
    }
];

describe('Get Permission Sets', function() {
    var req;
    var res;

    beforeEach(function(done) {
        req = httpMocks.createRequest({
            method: 'GET',
            url: 'resource/permission-sets/list'
        });
        _.set(req, 'app.config.generalPurposeJdsServer', {
            baseUrl: 'http://IP             ',
            urlLengthLimit: 120
        });
        _.set(req, 'audit', {});
        _.set(req, 'logger', logger);
        res = httpMocks.createResponse();
        done();
    });

    afterEach(function(done) {
        nock.cleanAll();
        done();
    });

    it('returns a list of permission sets', function(done) {
        nock('http://IP             ')
            .get('/permset/?filter=eq(%22status%22%2C%22active%22)')
            .reply(200, permsets);

        res.rdkSend = function(response) {
            _.each(response, function(item) {
                expect(item).to.have.property('label');
                expect(item).to.have.property('val');
                expect(item).to.have.property('permissions');
            });
            done();
        };

        getPermissionSets(req, res);
    });

    it('returns a list of permission sets', function(done) {
        nock('http://IP             ')
            .get('/permset/?filter=eq(%22status%22%2C%22active%22)')
            .replyWithError('This combination was not musical');

        res.rdkSend = function(response) {
            expect(response).to.match(/Error retrieving Permission Sets List/);
            done();
        };

        getPermissionSets(req, res);
    });
});
