/*******************************************************************************
 *
 * COPYRIGHT STATUS: © 2015, 2016.  This work, authored by Cognitive Medical Systems
 * employees, was funded in whole or in part by The Department of Veterans
 * Affairs under U.S. Government contract VA118-11-D-1011 / VA118-1011-0013.
 * The copyright holder agrees to post or allow the Government to post all or
 * part of this work in open-source repositories subject to the Apache License,
 * Version 2.0, dated January 2004. All other rights are reserved by the
 * copyright owner.
 *
 * For use outside the Government, the following notice applies:
 *
 *     Copyright 2015 © Cognitive Medical Systems
 *
 *     Licensed under the Apache License, Version 2.0 (the "License"); you may
 *     not use this file except in compliance with the License. You may obtain
 *     a copy of the License at http://www.apache.org/licenses/LICENSE-2.0
 *
 *     Unless required by applicable law or agreed to in writing, software
 *     distributed under the License is distributed on an "AS IS" BASIS,
 *     WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *     See the License for the specific language governing permissions and
 *     limitations under the License.
 *
 *
 *******************************************************************************/
package com.cognitive.cds.services.cdsresults.model;

import static org.junit.Assert.*;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

import org.junit.Test;

import com.cognitive.cds.invocation.model.InvocationConstants;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;

public class CDSResultTest {

	@Test
	public void testToJsonString() throws ParseException, IOException{

		String expected = "{\"details\":{\"detail\":\"This is the details for a Simple CDS Result\",\"provenance\":"+
		"\"Generated by unit test\"},\"doneDate\":1443878100000,\"dueDate\":1443964500000,\"generatedBy\":\"UnitTest\",\"id\":"+
		"\"TheArtifactId\",\"pid\":\"The Patient/Subject Id\",\"priority\":50,\"provider\":"+
		"\"AProviderId == The User Id passed on the calling context\",\"title\":"
		+"\"The Title\",\"type\":\"advice\"}";

		CDSResult result = new CDSResult();
		result.getDetails().setDetail("This is the details for a Simple CDS Result");
		result.setId("TheArtifactId");
		result.setPriority(50);
		result.setType(InvocationConstants.ADVICE);
		result.setTitle("The Title");
		result.getDetails().setProvenance("Generated by unit test");
		SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy/hh:mm:ss");
		formatter.setTimeZone(TimeZone.getTimeZone("GMT"));
		Date doneDate = formatter.parse("3/10/2015/13:15:00");
		result.setDoneDate(doneDate);
		Date dueDate= formatter.parse("4/10/2015/13:15:00");
		result.setDueDate(dueDate);
		result.setGeneratedBy("UnitTest");
		result.setProvider("AProviderId == The User Id passed on the calling context");
		result.setPid("The Patient/Subject Id");
		
		String json  = result.toJsonString();
		JsonParser parser = new JsonParser();
        JsonElement o1 = parser.parse(json);
        JsonElement o2 = parser.parse(expected); 
        assertEquals(o1, o2);
	}

}
