'use strict';

require('../../../../env-setup');

var log = require(global.VX_DUMMIES + '/dummy-logger');
// NOTE: be sure next lines are commented out before pushing
// var logUtil = require(global.VX_UTILS + 'log');
// log = logUtil._createLogger({
// 	name: 'test',
// 	level: 'debug',
// 	child: logUtil._createLogger
// });

var nock = require('nock');
var publisherRouterDummy = require(global.VX_DUMMIES + 'publisherRouterDummy');
var handler = require(global.VX_HANDLERS + 'sync-notification/sync-notification-handler');

describe('sync-notification-handler', function() {
	var config = {
		syncRequestApi: {
			host: '127.0.0.1',
			port: '8080',
			protocol: 'http',
			patientSyncPath: '/sync/doLoad'
		}
	};
	var environment = {};
	var job = {
		type: 'sync-notification',
		timestamp: '20170517094313',
		patientIdentifier: {
			type: 'pid',
			value: '9E7A;3'
		},
		dataDomain: 'discharge',
		record: {},
		jobId: '234ae-45a7c-293da-acd2a-4dab5',
		priority: 1,
		referenceInfo: {
			requestId: 'aaaa-bbbb-cccc'
		}
	};

	it('error path: invalid job', function(done) {
		var job = null;
		handler(log, config, environment, job, function(error, response) {
			expect(error).toBeTruthy();
			expect(response).toBeFalsy();
			done();
		});
	});

	it('error path: sync request api call returns error', function(done) {
		nock('http://127.0.0.1:8080').get('/sync/doLoad?pid=9E7A%3B3').reply(500);
		handler(log, config, environment, job, function(error, response) {
			expect(error).toBeTruthy();
			expect(response).toBeFalsy();
			done();
		});
	});

	it('normal path', function(done) {
		var environment = {
			publisherRouter: new publisherRouterDummy()
		};

		nock('http://127.0.0.1:8080').get('/sync/doLoad?pid=9E7A%3B3').reply(200);
		handler(log, config, environment, job, function(error, response) {
			expect(error).toBeFalsy();
			expect(response).toBeTruthy();
			expect(response).toEqual(jasmine.objectContaining({
				type: 'publish-data-change-event',
				timestamp: jasmine.any(String),
				patientIdentifier: jasmine.objectContaining(job.patientIdentifier),
				priority: job.priority,
				referenceInfo: jasmine.objectContaining(job.referenceInfo),
				dataDomain: job.dataDomain,
				record: jasmine.objectContaining(job.record),
				jobId: jasmine.any(String)
			}));
			done();
		});
	});
});