'use strict';

require('../../../../../env-setup');

var xformer = require(global.VX_HANDLERS + 'jmeadows-xform-domain-vpr/v2_3_3_0_2/jmeadows-dischargeSummary-xformer');
var log = require(global.VX_DUMMIES + 'dummy-logger');
// Be sure next lines are commented out before pushing
// log = require('bunyan').createLogger({
//     name: 'jmeadows-xform-domain-vpr-handler-spec',
//     level: 'debug'
// });

var mockEdipi = '00001';

var sampleDodDischargeSummary = require('../../../../data/secondary/jmeadows_v2_3_3_0_2/dischargeSummarySoap.json');

var sampleVprDischargeSummary = { referenceDateTime: 1320950895000,
  codes:
   [ { code: '28636-9', system: 'DOD_NCID' },
     { code: '28563-5', system: 'DOD_NOTES' } ],
  localTitle: 'Pulmonary Nursing Follow-Up',
  documentTypeName: 'Initial Evaluation Note',
  author: null,
  authorDisplayName: null,
  status: 'completed',
  statusName: 'completed',
  facilityName: 'DOD',
  facilityCode: 'DOD',
  uid: 'urn:va:document:DOD:00001:3cc445968192d500d5a2ddbf23ab4952605f0b0c_20110502114150',
  pid: 'DOD;00001',
  text:
   [ { content: '<?xml version=\'1.0\' encoding=\'UTF-8\'?><ClinicalDocument xsi:schemaLocation="xmlns=\'urn:hl7-org:v3\' xmlns:crs=\'urn:hl7-org:crs\' xmlns:xsi=\'http://www.w3.org/2001/XMLSchema-instance\'" xmlns="urn:hl7-org:v3" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">\n   <typeId extension="POCD_HD000040" root="2.16.840.1.113883.1.3"/>\n   <id extension="50402157_20110502113900_125" root="2.16.840.1.113883.3.42.144.100001.17"/>\n   <code codeSystem="2.16.840.1.113883.6.1" codeSystemName="LOINC" code="28636-9" displayName="&quot;Initial Evaluation Note&quot;"/>\n   <title>Pulmonary Nursing Follow-Up</title>\n   <effectiveTime value="20120829151904"/>\n   <confidentialityCode code="N" codeSystem="2.16.840.1.113883.5.25"/>\n   <versionNumber value="8"/>\n   <recordTarget>\n      <patientRole>\n         <id extension="786724" root="2.16.840.1.113883.3.42.127.125.2"/>\n         <id extension="000-00-1102" root="2.16.840.1.113883.4.1"/>\n         <addr>\n            <streetAddressLine>1234 Cherry Blossom Lane</streetAddressLine>\n            <city/>\n            <state/>\n            <postalCode/>\n            <country/>\n         </addr>\n         <telecom use="HP" value="tel:"/>\n         <patient>\n            <name>\n               <delimiter/>\n               <prefix/>\n               <suffix/>\n               <given>BOB</given>\n               <family>BTEST</family>\n            </name>\n            <administrativeGenderCode codeSystem="2.16.840.1.113883.5.1" code="F"/>\n            <birthTime value="19450101"/>\n         </patient>\n      </patientRole>\n   </recordTarget>\n   <author>\n      <time value="20110502114150"/>\n      <assignedAuthor>\n         <id extension="" root="2.16.840.1.113883.3.42.127.125.3"/>\n         <addr>\n            <streetAddressLine>9040 Fitzsimmons Ave</streetAddressLine>\n            <city>Tacoma</city>\n            <state>WA</state>\n            <postalCode>98431</postalCode>\n            <country>USA</country>\n         </addr>\n         <telecom use="WP" value="tel:(253) 968-1110"/>\n         <assignedPerson>\n            <name>\n               <delimiter/>\n               <prefix/>\n               <suffix/>\n               <given/>\n               <family>DEMO USER</family>\n            </name>\n         </assignedPerson>\n      </assignedAuthor>\n   </author>\n   <custodian>\n      <assignedCustodian>\n         <representedCustodianOrganization>\n            <id root="2.16.840.1.113883.3.42.127.125.13"/>\n         </representedCustodianOrganization>\n      </assignedCustodian>\n   </custodian>\n   <component>\n      <structuredBody>\n         <component>\n            <section>\n               <text>\n                  <table>\n                     <col valign="top" align="center" width="1050"/>\n                     <tbody>\n                        <tr>\n                           <td styleCode="Bold">PULMONARY NURSING FOLLOW-UP NOTE</td>\n                        </tr>\n                     </tbody>\n                  </table>\n               </text>\n            </section>\n         </component>\n         <component>\n            <section>\n               <text>\n                  <table>\n                     <col valign="top" width="390"/>\n                     <col valign="top" width="139"/>\n                     <col valign="top" width="521"/>\n                     <tbody>\n                        <tr>\n                           <td styleCode="Bold">- POST OPERATIVE FOLLOW UP PHONE CALL -</td>\n                           <td>Phone number</td>\n                           <td>800-555-4444</td>\n                        </tr>\n                     </tbody>\n                  </table>\n               </text>\n            </section>\n         </component>\n         <component>\n            <section>\n               <text>\n                  <table>\n                     <col width="49"/>\n                     <col valign="top" width="138"/>\n                     <col valign="top" width="124"/>\n                     <col valign="top" width="498"/>\n                     <col valign="top" width="241"/>\n                     <tbody>\n                        <tr>\n                           <td align="center"/>\n                           <td>Date</td>\n                           <td>Time</td>\n                           <td>Results</td>\n                           <td>Initials</td>\n                        </tr>\n                     </tbody>\n                  </table>\n               </text>\n            </section>\n         </component>\n         <component>\n            <section>\n               <text>\n                  <table>\n                     <col valign="top" width="103"/>\n                     <col valign="top" width="134"/>\n                     <col valign="top" width="536"/>\n                     <col valign="top" width="238"/>\n                     <tbody>\n                        <tr>\n                           <td>02May</td>\n                           <td>0600</td>\n                           <td>Left message</td>\n                           <td>DEMO</td>\n                        </tr>\n                     </tbody>\n                  </table>\n               </text>\n            </section>\n         </component>\n         <component>\n            <section>\n               <text>\n                  <table>\n                     <col valign="top" width="1050"/>\n                     <tbody>\n                        <tr>\n                           <td styleCode="Bold">- ATTEMPTS TO CONTACT PATIENT -</td>\n                        </tr>\n                     </tbody>\n                  </table>\n               </text>\n            </section>\n         </component>\n         <component>\n            <section>\n               <text>\n                  <table>\n                     <col width="91"/>\n                     <col valign="top" width="96"/>\n                     <col valign="top" width="124"/>\n                     <col valign="top" width="498"/>\n                     <col valign="top" width="241"/>\n                     <tbody>\n                        <tr>\n                           <td align="center"/>\n                           <td>Date</td>\n                           <td>Time</td>\n                           <td>Results</td>\n                           <td>Initials</td>\n                        </tr>\n                     </tbody>\n                  </table>\n               </text>\n            </section>\n         </component>\n         <component>\n            <section>\n               <text>\n                  <table>\n                     <col width="36"/>\n                     <col valign="top" width="40"/>\n                     <col valign="top" width="107"/>\n                     <col valign="top" width="108"/>\n                     <col valign="top" width="521"/>\n                     <col valign="top" width="238"/>\n                     <tbody>\n                        <tr>\n                           <td align="center"/>\n                           <td>#1</td>\n                           <td>02May</td>\n                           <td>0900</td>\n                           <td>Reached patient and discussed.</td>\n                           <td>DEMO</td>\n                        </tr>\n                     </tbody>\n                  </table>\n               </text>\n            </section>\n         </component>\n         <component>\n            <section>\n               <text>\n                  <table>\n                     <col width="33"/>\n                     <col valign="top" width="195"/>\n                     <col valign="top" width="822"/>\n                     <tbody>\n                        <tr>\n                           <td align="center"/>\n                           <td>PATIENT RESPONSE</td>\n                           <td>* Additional Comments Required For All Yes Responses *</td>\n                        </tr>\n                     </tbody>\n                  </table>\n               </text>\n            </section>\n         </component>\n         <component>\n            <section>\n               <text>\n                  <table>\n                     <col width="36"/>\n                     <col valign="top" width="27"/>\n                     <col valign="top" width="42"/>\n                     <col valign="top" width="35"/>\n                     <col valign="top" width="47"/>\n                     <col valign="top" width="863"/>\n                     <tbody>\n                        <tr>\n                           <td align="center"/>\n                           <td>NO</td>\n                           <td>[X]</td>\n                           <td>YES</td>\n                           <td>[ ]</td>\n                           <td>Color and amount  of sputum produced with cough</td>\n                        </tr>\n                     </tbody>\n                  </table>\n               </text>\n            </section>\n         </component>\n         <component>\n            <section>\n               <text>\n                  <table>\n                     <col width="36"/>\n                     <col valign="top" width="27"/>\n                     <col valign="top" width="42"/>\n                     <col valign="top" width="35"/>\n                     <col valign="top" width="47"/>\n                     <col valign="top" width="863"/>\n                     <tbody>\n                        <tr>\n                           <td align="center"/>\n                           <td>NO</td>\n                           <td>[X]</td>\n                           <td>YES</td>\n                           <td>[ ]</td>\n                           <td>Unusual Pain</td>\n                        </tr>\n                     </tbody>\n                  </table>\n               </text>\n            </section>\n         </component>\n         <component>\n            <section>\n               <text>\n                  <table>\n                     <col width="36"/>\n                     <col valign="top" width="27"/>\n                     <col valign="top" width="42"/>\n                     <col valign="top" width="35"/>\n                     <col valign="top" width="47"/>\n                     <col valign="top" width="863"/>\n                     <tbody>\n                        <tr>\n                           <td align="center"/>\n                           <td>NO</td>\n                           <td>[X]</td>\n                           <td>YES</td>\n                           <td>[ ]</td>\n                           <td>Fever</td>\n                        </tr>\n                     </tbody>\n                  </table>\n               </text>\n            </section>\n         </component>\n         <component>\n            <section>\n               <text>\n                  <table>\n                     <col width="36"/>\n                     <col valign="top" width="27"/>\n                     <col valign="top" width="42"/>\n                     <col valign="top" width="35"/>\n                     <col valign="top" width="47"/>\n                     <col valign="top" width="863"/>\n                     <tbody>\n                        <tr>\n                           <td align="center"/>\n                           <td>NO</td>\n                           <td>[ ]</td>\n                           <td>YES</td>\n                           <td>[X]</td>\n                           <td>Other Problems:</td>\n                        </tr>\n                     </tbody>\n                  </table>\n               </text>\n            </section>\n         </component>\n         <component>\n            <section>\n               <text>\n                  <table>\n                     <col valign="top" width="1014"/>\n                     <tbody>\n                        <tr>\n                           <td>A little tired today.</td>\n                        </tr>\n                     </tbody>\n                  </table>\n               </text>\n            </section>\n         </component>\n         <component>\n            <section>\n               <text>\n                  <table>\n                     <col valign="top" width="1014"/>\n                     <tbody>\n                        <tr>\n                           <td>Patient / Significant Other communicates knowledge of and understands follow-up instructions.</td>\n                        </tr>\n                     </tbody>\n                  </table>\n               </text>\n            </section>\n         </component>\n         <component>\n            <section>\n               <text>\n                  <table>\n                     <col valign="top" width="251"/>\n                     <col valign="top" width="799"/>\n                     <tbody>\n                        <tr>\n                           <td styleCode="Bold">Patient\'s condition:</td>\n                           <td>Good</td>\n                        </tr>\n                     </tbody>\n                  </table>\n               </text>\n            </section>\n         </component>\n         <component>\n            <section>\n               <text>\n                  <table>\n                     <col valign="top" width="251"/>\n                     <col valign="top" width="799"/>\n                     <tbody>\n                        <tr>\n                           <td styleCode="Bold">Additional information</td>\n                           <td/>\n                        </tr>\n                     </tbody>\n                  </table>\n               </text>\n            </section>\n         </component>\n         <component>\n            <section>\n               <text>\n                  <table>\n                     <col valign="top" width="1050"/>\n                     <tbody>\n                        <tr>\n                           <td styleCode="Bold">Signature of Nurse/Physician: See above electronic signature.</td>\n                        </tr>\n                     </tbody>\n                  </table>\n               </text>\n            </section>\n         </component>\n         <component>\n            <section>\n               <text>\n                  <table>\n                     <col width="1"/>\n                     <col valign="top" width="1049"/>\n                     <tbody>\n                        <tr>\n                           <td align="center"/>\n                           <td>SF 509 - E - Progress Notes</td>\n                        </tr>\n                     </tbody>\n                  </table>\n               </text>\n            </section>\n         </component>\n      </structuredBody>\n   </component>\n</ClinicalDocument>',
       dateTime: jasmine.any(String),
       status: 'completed',
       uid: 'urn:va:document:DOD:00001:3cc445968192d500d5a2ddbf23ab4952605f0b0c_20110502114150' } ],
  dodComplexNoteUri: null };

var result = xformer(log, sampleDodDischargeSummary[0], mockEdipi);

//console.log(result);
describe('dodDischargeSummaryToVPR', function(){
    it('verify transform sample discharge summary to VPR', function(){
        expect(result.codes).toEqual(sampleVprDischargeSummary.codes);
        expect(result.localTitle).toEqual(sampleVprDischargeSummary.localTitle);
        expect(result.documentTypeName).toEqual(sampleVprDischargeSummary.documentTypeName);
        expect(result.author).toEqual(sampleVprDischargeSummary.author);
        expect(result.authorDisplayName).toEqual(sampleVprDischargeSummary.authorDisplayName);
        expect(result.status).toEqual(sampleVprDischargeSummary.status);
        expect(result.statusName).toEqual(sampleVprDischargeSummary.statusName);
        expect(result.facilityName).toEqual(sampleVprDischargeSummary.facilityName);
        expect(result.facilityCode).toEqual(sampleVprDischargeSummary.facilityCode);
        expect(result.uid).toEqual(sampleVprDischargeSummary.uid);
        expect(result.pid).toEqual(sampleVprDischargeSummary.pid);
        expect(result.text).toEqual(sampleVprDischargeSummary.text);
        expect(result.dodComplexNoteUri).toEqual(sampleVprDischargeSummary.dodComplexNoteUri);
    });
});