'use strict';

require('../../../../env-setup');
var _ = require('underscore');
var realConfig = require(global.VX_ROOT + 'worker-config');
var fsUtil = require(global.VX_UTILS + 'fs-utils');
var jobUtils = require(global.VX_UTILS + 'job-utils');
var testHandler = require(global.VX_INTTESTS + 'framework/handler-test-framework').testHandler;
var handle = require(global.VX_HANDLERS + 'jmeadows-document/jmeadows-cda-document-conversion-handler');
var path = require('path');
var val = require(global.VX_UTILS + 'object-utils').getProperty;

var testConfig = require(global.VX_INTTESTS + 'test-config');
var vx_sync_ip = testConfig.vxsyncIP;

//var VistaClientDummy = require(global.VX_DUMMIES + 'vista-client-dummy');
//var jobStatusUpdaterDummy = require(global.VX_SUBSYSTEMS + 'jds/JobStatusUpdaterDummy');

var log = require(global.VX_DUMMIES + '/dummy-logger');

// log = require('bunyan').createLogger({
//     name: 'test',
//     level: 'debug'
// });

var config = {
    documentStorage: {
        staging: {
            path: ''
        },
        publish: {
            path: '',
            permissions: realConfig.documentStorage.publish.permissions //Need to fix these permissions!!!!
        },
        officeLocation: realConfig.documentStorage.officeLocation,
        uriRoot: realConfig.documentStorage.uriRoot
    },

};
config.documentStorage.staging.path = realConfig.documentStorage.staging.path.replace(/vxsync/, 'vxsync-test');
config.documentStorage.publish.path = realConfig.documentStorage.publish.path.replace(/vxsync/, 'vxsync-test');
config.documentStorage.staging.path = path.resolve(config.documentStorage.staging.path);
config.documentStorage.publish.path = path.resolve(config.documentStorage.publish.path);
config.documentStorage.uriRoot = 'http://' + vx_sync_ip + ':8082/documents';

var sampleVprDischargeSummary = {
    referenceDateTime: 1320950895000,
    codes: [{
        code: '28636-9',
        display: '',
        system: 'DOD_NCID'
    }, {
        code: '28563-5',
        display: '',
        system: 'DOD_NOTES'
    }],
    localTitle: 'Pulmonary Nursing Follow-Up',
    documentTypeName: 'Initial Evaluation Note',
    author: 'DEMO USER,',
    authorDisplayName: 'DEMO USER,',
    status: 'completed',
    statusName: 'completed',
    facilityName: 'DOD',
    facilityCode: 'DOD',
    uid: 'urn:va:document:DOD:00001:3cc445968192d500d5a2ddbf23ab4952605f0b0c_',
    pid: 'DOD;00001',
    text: [{
        content: '<?xml version=\'1.0\' encoding=\'UTF-8\'?><ClinicalDocument xsi:schemaLocation=\"xmlns=\'urn:hl7-org:v3\' xmlns:crs=\'urn:hl7-org:crs\' xmlns:xsi=\'http://www.w3.org/2001/XMLSchema-instance\'\" xmlns=\"urn:hl7-org:v3\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n   <typeId extension=\"POCD_HD000040\" root=\"2.16.840.1.113883.1.3\"/>\n   <id extension=\"50402157_20110502113900_125\" root=\"2.16.840.1.113883.3.42.144.100001.17\"/>\n   <code codeSystem=\"2.16.840.1.113883.6.1\" codeSystemName=\"LOINC\" code=\"28636-9\" displayName=\"&quot;Initial Evaluation Note&quot;\"/>\n   <title>Pulmonary Nursing Follow-Up</title>\n   <effectiveTime value=\"20120829151904\"/>\n   <confidentialityCode code=\"N\" codeSystem=\"2.16.840.1.113883.5.25\"/>\n   <versionNumber value=\"8\"/>\n   <recordTarget>\n      <patientRole>\n         <id extension=\"786724\" root=\"2.16.840.1.113883.3.42.127.125.2\"/>\n         <id extension=\"000-00-1102\" root=\"2.16.840.1.113883.4.1\"/>\n         <addr>\n            <streetAddressLine>1234 Cherry Blossom Lane</streetAddressLine>\n            <city/>\n            <state/>\n            <postalCode/>\n            <country/>\n         </addr>\n         <telecom use=\"HP\" value=\"tel:\"/>\n         <patient>\n            <name>\n               <delimiter/>\n               <prefix/>\n               <suffix/>\n               <given>BOB</given>\n               <family>BTEST</family>\n            </name>\n            <administrativeGenderCode codeSystem=\"2.16.840.1.113883.5.1\" code=\"F\"/>\n            <birthTime value=\"19450101\"/>\n         </patient>\n      </patientRole>\n   </recordTarget>\n   <author>\n      <time value=\"20110502114150\"/>\n      <assignedAuthor>\n         <id extension=\"\" root=\"2.16.840.1.113883.3.42.127.125.3\"/>\n         <addr>\n            <streetAddressLine>9040 Fitzsimmons Ave</streetAddressLine>\n            <city>Tacoma</city>\n            <state>WA</state>\n            <postalCode>98431</postalCode>\n            <country>USA</country>\n         </addr>\n         <telecom use=\"WP\" value=\"tel:(253) 968-1110\"/>\n         <assignedPerson>\n            <name>\n               <delimiter/>\n               <prefix/>\n               <suffix/>\n               <given/>\n               <family>DEMO USER</family>\n            </name>\n         </assignedPerson>\n      </assignedAuthor>\n   </author>\n   <custodian>\n      <assignedCustodian>\n         <representedCustodianOrganization>\n            <id root=\"2.16.840.1.113883.3.42.127.125.13\"/>\n         </representedCustodianOrganization>\n      </assignedCustodian>\n   </custodian>\n   <component>\n      <structuredBody>\n         <component>\n            <section>\n               <text>\n                  <table>\n                     <col valign=\"top\" align=\"center\" width=\"1050\"/>\n                     <tbody>\n                        <tr>\n                           <td styleCode=\"Bold\">PULMONARY NURSING FOLLOW-UP NOTE</td>\n                        </tr>\n                     </tbody>\n                  </table>\n               </text>\n            </section>\n         </component>\n         <component>\n            <section>\n               <text>\n                  <table>\n                     <col valign=\"top\" width=\"390\"/>\n                     <col valign=\"top\" width=\"139\"/>\n                     <col valign=\"top\" width=\"521\"/>\n                     <tbody>\n                        <tr>\n                           <td styleCode=\"Bold\">- POST OPERATIVE FOLLOW UP PHONE CALL -</td>\n                           <td>Phone number</td>\n                           <td>800-555-4444</td>\n                        </tr>\n                     </tbody>\n                  </table>\n               </text>\n            </section>\n         </component>\n         <component>\n            <section>\n               <text>\n                  <table>\n                     <col width=\"49\"/>\n                     <col valign=\"top\" width=\"138\"/>\n                     <col valign=\"top\" width=\"124\"/>\n                     <col valign=\"top\" width=\"498\"/>\n                     <col valign=\"top\" width=\"241\"/>\n                     <tbody>\n                        <tr>\n                           <td align=\"center\"/>\n                           <td>Date</td>\n                           <td>Time</td>\n                           <td>Results</td>\n                           <td>Initials</td>\n                        </tr>\n                     </tbody>\n                  </table>\n               </text>\n            </section>\n         </component>\n         <component>\n            <section>\n               <text>\n                  <table>\n                     <col valign=\"top\" width=\"103\"/>\n                     <col valign=\"top\" width=\"134\"/>\n                     <col valign=\"top\" width=\"536\"/>\n                     <col valign=\"top\" width=\"238\"/>\n                     <tbody>\n                        <tr>\n                           <td>02May</td>\n                           <td>0600</td>\n                           <td>Left message</td>\n                           <td>DEMO</td>\n                        </tr>\n                     </tbody>\n                  </table>\n               </text>\n            </section>\n         </component>\n         <component>\n            <section>\n               <text>\n                  <table>\n                     <col valign=\"top\" width=\"1050\"/>\n                     <tbody>\n                        <tr>\n                           <td styleCode=\"Bold\">- ATTEMPTS TO CONTACT PATIENT -</td>\n                        </tr>\n                     </tbody>\n                  </table>\n               </text>\n            </section>\n         </component>\n         <component>\n            <section>\n               <text>\n                  <table>\n                     <col width=\"91\"/>\n                     <col valign=\"top\" width=\"96\"/>\n                     <col valign=\"top\" width=\"124\"/>\n                     <col valign=\"top\" width=\"498\"/>\n                     <col valign=\"top\" width=\"241\"/>\n                     <tbody>\n                        <tr>\n                           <td align=\"center\"/>\n                           <td>Date</td>\n                           <td>Time</td>\n                           <td>Results</td>\n                           <td>Initials</td>\n                        </tr>\n                     </tbody>\n                  </table>\n               </text>\n            </section>\n         </component>\n         <component>\n            <section>\n               <text>\n                  <table>\n                     <col width=\"36\"/>\n                     <col valign=\"top\" width=\"40\"/>\n                     <col valign=\"top\" width=\"107\"/>\n                     <col valign=\"top\" width=\"108\"/>\n                     <col valign=\"top\" width=\"521\"/>\n                     <col valign=\"top\" width=\"238\"/>\n                     <tbody>\n                        <tr>\n                           <td align=\"center\"/>\n                           <td>#1</td>\n                           <td>02May</td>\n                           <td>0900</td>\n                           <td>Reached patient and discussed.</td>\n                           <td>DEMO</td>\n                        </tr>\n                     </tbody>\n                  </table>\n               </text>\n            </section>\n         </component>\n         <component>\n            <section>\n               <text>\n                  <table>\n                     <col width=\"33\"/>\n                     <col valign=\"top\" width=\"195\"/>\n                     <col valign=\"top\" width=\"822\"/>\n                     <tbody>\n                        <tr>\n                           <td align=\"center\"/>\n                           <td>PATIENT RESPONSE</td>\n                           <td>* Additional Comments Required For All Yes Responses *</td>\n                        </tr>\n                     </tbody>\n                  </table>\n               </text>\n            </section>\n         </component>\n         <component>\n            <section>\n               <text>\n                  <table>\n                     <col width=\"36\"/>\n                     <col valign=\"top\" width=\"27\"/>\n                     <col valign=\"top\" width=\"42\"/>\n                     <col valign=\"top\" width=\"35\"/>\n                     <col valign=\"top\" width=\"47\"/>\n                     <col valign=\"top\" width=\"863\"/>\n                     <tbody>\n                        <tr>\n                           <td align=\"center\"/>\n                           <td>NO</td>\n                           <td>[X]</td>\n                           <td>YES</td>\n                           <td>[ ]</td>\n                           <td>Color and amount  of sputum produced with cough</td>\n                        </tr>\n                     </tbody>\n                  </table>\n               </text>\n            </section>\n         </component>\n         <component>\n            <section>\n               <text>\n                  <table>\n                     <col width=\"36\"/>\n                     <col valign=\"top\" width=\"27\"/>\n                     <col valign=\"top\" width=\"42\"/>\n                     <col valign=\"top\" width=\"35\"/>\n                     <col valign=\"top\" width=\"47\"/>\n                     <col valign=\"top\" width=\"863\"/>\n                     <tbody>\n                        <tr>\n                           <td align=\"center\"/>\n                           <td>NO</td>\n                           <td>[X]</td>\n                           <td>YES</td>\n                           <td>[ ]</td>\n                           <td>Unusual Pain</td>\n                        </tr>\n                     </tbody>\n                  </table>\n               </text>\n            </section>\n         </component>\n         <component>\n            <section>\n               <text>\n                  <table>\n                     <col width=\"36\"/>\n                     <col valign=\"top\" width=\"27\"/>\n                     <col valign=\"top\" width=\"42\"/>\n                     <col valign=\"top\" width=\"35\"/>\n                     <col valign=\"top\" width=\"47\"/>\n                     <col valign=\"top\" width=\"863\"/>\n                     <tbody>\n                        <tr>\n                           <td align=\"center\"/>\n                           <td>NO</td>\n                           <td>[X]</td>\n                           <td>YES</td>\n                           <td>[ ]</td>\n                           <td>Fever</td>\n                        </tr>\n                     </tbody>\n                  </table>\n               </text>\n            </section>\n         </component>\n         <component>\n            <section>\n               <text>\n                  <table>\n                     <col width=\"36\"/>\n                     <col valign=\"top\" width=\"27\"/>\n                     <col valign=\"top\" width=\"42\"/>\n                     <col valign=\"top\" width=\"35\"/>\n                     <col valign=\"top\" width=\"47\"/>\n                     <col valign=\"top\" width=\"863\"/>\n                     <tbody>\n                        <tr>\n                           <td align=\"center\"/>\n                           <td>NO</td>\n                           <td>[ ]</td>\n                           <td>YES</td>\n                           <td>[X]</td>\n                           <td>Other Problems:</td>\n                        </tr>\n                     </tbody>\n                  </table>\n               </text>\n            </section>\n         </component>\n         <component>\n            <section>\n               <text>\n                  <table>\n                     <col valign=\"top\" width=\"1014\"/>\n                     <tbody>\n                        <tr>\n                           <td>A little tired today.</td>\n                        </tr>\n                     </tbody>\n                  </table>\n               </text>\n            </section>\n         </component>\n         <component>\n            <section>\n               <text>\n                  <table>\n                     <col valign=\"top\" width=\"1014\"/>\n                     <tbody>\n                        <tr>\n                           <td>Patient / Significant Other communicates knowledge of and understands follow-up instructions.</td>\n                        </tr>\n                     </tbody>\n                  </table>\n               </text>\n            </section>\n         </component>\n         <component>\n            <section>\n               <text>\n                  <table>\n                     <col valign=\"top\" width=\"251\"/>\n                     <col valign=\"top\" width=\"799\"/>\n                     <tbody>\n                        <tr>\n                           <td styleCode=\"Bold\">Patient\'s condition:</td>\n                           <td>Good</td>\n                        </tr>\n                     </tbody>\n                  </table>\n               </text>\n            </section>\n         </component>\n         <component>\n            <section>\n               <text>\n                  <table>\n                     <col valign=\"top\" width=\"251\"/>\n                     <col valign=\"top\" width=\"799\"/>\n                     <tbody>\n                        <tr>\n                           <td styleCode=\"Bold\">Additional information</td>\n                           <td/>\n                        </tr>\n                     </tbody>\n                  </table>\n               </text>\n            </section>\n         </component>\n         <component>\n            <section>\n               <text>\n                  <table>\n                     <col valign=\"top\" width=\"1050\"/>\n                     <tbody>\n                        <tr>\n                           <td styleCode=\"Bold\">Signature of Nurse/Physician: See above electronic signature.</td>\n                        </tr>\n                     </tbody>\n                  </table>\n               </text>\n            </section>\n         </component>\n         <component>\n            <section>\n               <text>\n                  <table>\n                     <col width=\"1\"/>\n                     <col valign=\"top\" width=\"1049\"/>\n                     <tbody>\n                        <tr>\n                           <td align=\"center\"/>\n                           <td>SF 509 - E - Progress Notes</td>\n                        </tr>\n                     </tbody>\n                  </table>\n               </text>\n            </section>\n         </component>\n      </structuredBody>\n   </component>\n</ClinicalDocument>',
        dateTime: 1320950895000,
        status: 'completed',
        uid: 'urn:va:document:DOD:00001:3cc445968192d500d5a2ddbf23ab4952605f0b0c_'
    }],
    dodComplexNoteUri: null
};

var corruptedSampleVprDischargeSummary = {
    referenceDateTime: 1320950895000,
    codes: [{
        code: '28636-9',
        display: '',
        system: 'DOD_NCID'
    }, {
        code: '28563-5',
        display: '',
        system: 'DOD_NOTES'
    }],
    localTitle: 'Pulmonary Nursing Follow-Up',
    documentTypeName: 'Initial Evaluation Note',
    author: 'DEMO USER,',
    authorDisplayName: 'DEMO USER,',
    status: 'completed',
    statusName: 'completed',
    facilityName: 'DOD',
    facilityCode: 'DOD',
    uid: 'urn:va:document:DOD:00001:3cc445968192d500d5a2ddbf23ab4952605f0b0c_',
    pid: 'DOD;00001',
    text: [{
        content: '<?xml version=\'1.0\' encoding=\'UTF-8\'?><ClinicalDocument xsi:schemaLocation="xmlns=\'urn:hl7-org:v3\' xmlns:crs=\'urn:hl7-org:crs\' xmlns:xsi=\'http://www.w3.org/2001/XMLSchema-instance\'" xmlns="urn:hl7-org:v3" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">\n   <typeId extension="POCD_HD000040" root="2.16.840.1.113883.1.3"/>\n   <id extension="50402157_20110502113900_125" root="2.16.840.1.113883.3.42.144.100001.17"/>\n   <code codeSystem="2.16.840.1.113883.6.1" codeSystemName="LOINC" code="28636-9" displayName="&quot;Initial Evaluation Note&quot;"/>\n   <title>Pulmonary Nursing Follow-Up</title>\n   <effectiveTime value="20120829151904"/>\n   <confidentialityCode code="N" codeSystem="2.16.840.1.113883.5.25"/>\n   <versionNumber value="8"/>\n   <recordTarget>\n      <patientRole>\n         <id extension="786724" root="2.16.840.1.113883.3.42.127.125.2"/>\n         <id extension="000-00-1102" root="2.16.840.1.113883.4.1"/>\n         <addr>\n            <streetAddressLine>1234 Cherry Blossom Lane</streetAddressLine>\n            <city/>\n            <state/>\n            <postalCode/>\n            <country/>\n         </addr>\n         <telecom use="HP" value="tel:"/>\n         <patient>\n            <name>\n               <delimiter/>\n               <prefix/>\n               <suffix/>\n               <given>BOB</given>\n               <family>BTEST</family>\n            </name>\n            <administrativeGenderCode codeSystem="2.16.840.1.113883.5.1" code="F"/>\n            <birthTime value="19450101"/>\n         </patient>\n      </patientRole>\n   </recordTarget>\n   <author>\n      <time value="20110502114150"/>\n      <assignedAuthor>\n         <id extension="" root="2.16.840.1.113883.3.42.127.125.3"/>\n         <addr>\n            <streetAddressLine>9040 Fitzsimmons Ave</streetAddressLine>\n            <city>Tacoma</city>\n            <state>WA</state>\n            <postalCode>98431</postalCode>\n            <country>USA</country>\n         </addr>\n         <telecom use="WP" value="tel:(253) 968-1110"/>\n         <assignedPerson>\n            <name>\n               <delimiter/>\n               <prefix/>\n               <suffix/>\n               <given/>\n               <family>DEMO USER</family>\n            </name>\n         </assignedPerson>\n      </assignedAuthor>\n   </author>\n   <custodian>\n      <assignedCustodian>\n         <representedCustodianOrganization>\n            <id root="2.16.840.1.113883.3.42.127.125.13"/>\n         </representedCustodianOrganization>\n      </assignedCustodian>\n   </custodian>\n   <component>\n      <structuredBody>\n         <component>\n            <section>\n               <text>\n                  <table>\n                     <col valign="top" align="center" width="1050"/>\n                     <tbody>\n                        <tr>\n                           <td styleCode="Bold">PULMONARY NURSING FOLLOW-UP NOTE</td>\n                        </tr>\n                     </tbody>\n                  </table>\n               </text>\n            </section>\n         </component>\n         <component>\n            <section>\n               <text>\n                  <table>\n                     <col valign="top" width="390"/>\n                     <col valign="top" width="139"/>\n                     <col valign="top" width="521"/>\n                     <tbody>\n                        <tr>\n                           <td styleCode="Bold">- POST OPERATIVE FOLLOW UP PHONE CALL -</td>\n                           <td>Phone number</td>\n                           <td>800-555-4444</td>\n                        </tr>\n                     </tbody>\n                  </table>\n               </text>\n            </section>\n         </component>\n         <component>\n            <section>\n               <text>\n                  <table>\n                     <col width="49"/>\n                     <col valign="top" width="138"/>\n                     <col valign="top" width="124"/>\n                     <col valign="top" width="498"/>\n                     <col valign="top" width="241"/>\n                     <tbody>\n                        <tr>\n                           <td align="center"/>\n                           <td>Date</td>\n                           <td>Time</td>\n                           <td>Results</td>\n                           <td>Initials</td>\n                        </tr>\n                     </tbody>\n                  </table>\n               </text>\n            </section>\n         </component>\n         <component>\n            <section>\n               <text>\n                  <table>\n                     <col valign="top" width="103"/>\n                     <col valign="top" width="134"/>\n                     <col valign="top" width="536"/>\n                     <col valign="top" width="238"/>\n                     <tbody>\n                        <tr>\n                           <td>02May</td>\n                           <td>0600</td>\n                           <td>Left message</td>\n                           <td>DEMO</td>\n                        </tr>\n                     </tbody>\n                  </table>\n               </text>\n            </section>\n         </component>\n         <component>\n            <section>\n               <text>\n                  <table>\n                     <col valign="top" width="1050"/>\n                     <tbody>\n                        <tr>\n                           <td styleCode="Bold">- ATTEMPTS TO CONTACT PATIENT -</td>\n                        </tr>\n                     </tbody>\n                  </table>\n               </text>\n            </section>\n         </component>\n         <component>\n            <section>\n               <text>\n                  <table>\n                     <col width="91"/>\n                     <col valign="top" width="96"/>\n                     <col valign="top" width="124"/>\n                     <col valign="top" width="498"/>\n                     <col valign="top" width="241"/>\n                     <tbody>\n                        <tr>\n                           <td align="center"/>\n                           <td>Date</td>\n                           <td>Time</td>\n                           <td>Results</td>\n                           <td>Initials</td>\n                        </tr>\n                     </tbody>\n                  </table>\n               </text>\n            </section>\n         </component>\n         <component>\n            <section>\n               <text>\n                  <table>\n                     <col width="36"/>\n                     <col valign="top" width="40"/>\n                     <col valign="top" width="107"/>\n                     <col valign="top" width="108"/>\n                     <col valign="top" width="521"/>\n                     <col valign="top" width="238"/>\n                     <tbody>\n                        <tr>\n                           <td align="center"/>\n                           <td>#1</td>\n                           <td>02May</td>\n                           <td>0900</td>\n                           <td>Reached patient and discussed.</td>\n                           <td>DEMO</td>\n                        </tr>\n                     </tbody>\n                  </table>\n               </text>\n            </section>\n         </component>\n         <component>\n            <section>\n               <text>\n                  <table>\n                     <col width="33"/>\n                     <col valign="top" width="195"/>\n                     <col valign="top" width="822"/>\n                     <tbody>\n                        <tr>\n                           <td align="center"/>\n                           <td>PATIENT RESPONSE</td>\n                           <td>* Additional Comments Required For All Yes Responses *</td>\n                        </tr>\n                     </tbody>\n                  </table>\n               </text>\n            </section>\n         </component>\n         <component>\n            <section>\n               <text>\n                  <table>\n                     <col width="36"/>\n                     <col valign="top" width="27"/>\n                     <col valign="top" width="42"/>\n                     <col valign="top" width="35"/>\n                     <col valign="top" width="47"/>\n                     <col valign="top" width="863"/>\n                     <tbody>\n                        <tr>\n                           <td align="center"/>\n                           <td>NO</td>\n                           <td>[X]</td>\n                           <td>YES</td>\n                           <td>[ ]</td>\n                           <td>Color and amount  of sputum produced with cough</td>\n                        </tr>\n                     </tbody>\n                  </table>\n               </text>\n            </section>\n         </component>\n         <component>\n            <section>\n               <text>\n                  <table>\n                     <col width="36"/>\n                     <col valign="top" width="27"/>\n                     <col valign="top" width="42"/>\n                     <col valign="top" width="35"/>\n                     <col valign="top" width="47"/>\n                     <col valign="top" width="863"/>\n                     <tbody>\n                        <tr>\n                           <td align="center"/>\n                           <td>NO</td>\n                           <td>[X]</td>\n                           <td>YES</td>\n                           <td>[ ]</td>\n                           <td>Unusual Pain</td>\n                        </tr>\n                     </tbody>\n                  </table>\n               </text>\n            </section>\n         </component>\n         <component>\n            <section>\n               <text>\n                  <table>\n                     <col width="36"/>\n                     <col valign="top" width="27"/>\n                     <col valign="top" width="42"/>\n                     <col valign="top" width="35"/>\n                     <col valign="top" width="47"/>\n                     <col valign="top" width="863"/>\n                     <tbody>\n                        <tr>\n                           <td align="center"/>\n                           <td>NO</td>\n                           <td>[X]</td>\n                           <td>YES</td>\n                           <td>[ ]</td>\n                           <td>Fever</td>\n                        </tr>\n                     </tbody>\n                  </table>\n               </text>\n            </section>\n         </component>\n         <component>\n            <section>\n               <text>\n                  <table>\n                     <col width="36"/>\n                     <col valign="top" width="27"/>\n                     <col valign="top" width="42"/>\n                     <col valign="top" width="35"/>\n                     <col valign="top" width="47"/>\n                     <col valign="top" width="863"/>\n                     <tbody>\n                        <tr>\n                           <td align="center"/>\n                           <td>NO</td>\n                           <td>[ ]</td>\n                           <td>YES</td>\n                           <td>[X]</td>\n                           <td>Other Problems:</td>\n                        </tr>\n                     </tbody>\n                  </table>\n               </text>\n            </section>\n         </component>\n         <component>\n            <section>\n               <text>\n                  <table>\n                     <col valign="top" width="1014"/>\n                     <tbody>\n                        <tr>\n                           <td>A little tired today.</td>\n                        </tr>\n                     </tbody>\n                  </table>\n               </text>\n            </section>\n         </component>\n         <component>\n            <section>\n               <text>\n                  <table>\n                     <col valign="top" width="1014"/>\n                     <tbody>\n                        <tr>\n                           <td>Patient / Significant Other communicates knowledge of and understands follow-up instructions.</td>\n                        </tr>\n                     </tbody>\n                  </table>\n               </text>\n            </section>\n         </component>\n         <component>\n            <section>\n               <text>\n                  <table>\n                     <col valign="top" width="251"/>\n                     <col valign="top" width="799"/>\n                     <tbody>\n                        <tr>\n                           <td styleCode="Bold">Patient\'s condition:</td>\n                           <td>Good</td>\n                        </tr>\n                     </tbody>\n                  </table>\n               </text>\n            </section>\n         </component>\n         <component>\n            <section>\n               <text>\n                  <table>\n                     <col valign="top" width="251"/>\n                     <col valign="top" width="799"/>\n                     <tbody>\n                        <tr>\n                           <td styleCode="Bold">Additional information</td>\n                           <td/>\n                        </tr>\n                     </tbody>\n                  </table>\n               </text>\n            </section>\n         </component>\n         <component>\n            <section>\n               <text>\n                  <table>\n                     <col valign="top" width="1050"/>\n                     <tbody>\n                        <tr>\n                           <td styleCode="Bold">Signature of Nurse/Physician: See above electronic signature.</td>\n                        </tr>\n                     </tbody>\n                  </table>\n               </text>\n            </section>\n         </component>\n         <component>\n            <section>\n               <text>\n                  <table>\n                     <col width="1"/>\n                     <col valign="top" width="1049"/>\n                     <tbody>\n                        <tr>\n                           <td align="center"/>\n                           <td>SF 509 - E - Progress Notes</td>\n                        </tr>\n                     </tbody>\n                  </table>\n               </text>\n            </section>\n         </component>\n      </structuredBody>\n   </component>\n',
        dateTime: 1320950895000,
        status: 'completed',
        uid: 'urn:va:document:DOD:00001:3cc445968192d500d5a2ddbf23ab4952605f0b0c_'
    }],
    dodComplexNoteUri: null
};

// Note: \ufeff is a zero-width non-breaking space
var plaintextContent = 'Personal Data  Privacy Act of 1974 (PL 93 579)                                                                        \nPatient:                                          BOB BTEST                            SSN:            000-00-1102    \n                                                  1234 Cherry Blossom Lane ,    HP:                                   \nBirthdate:                                        January 1, 1945                      Sex:            Female         \nConsultant:                                                                            Created On:     May 2, 2011    \n\n\n\n\nPULMONARY NURSING FOLLOW-UP \n * PULMONARY NURSING FOLLOW-UP NOTE \n\n * - POST OPERATIVE FOLLOW UP PHONE CALL - Phone number 800-555-4444 \n\n * Date Time Results Initials \n\n * 02May 0600 Left message DEMO \n\n * - ATTEMPTS TO CONTACT PATIENT - \n\n * Date Time Results Initials \n\n * #1 02May 0900 Reached patient and discussed. DEMO \n\n * PATIENT RESPONSE * Additional Comments Required For All Yes Responses * \n\n * NO [X] YES [ ] Color and amount&nbsp;&nbsp;of sputum produced with cough \n\n * NO [X] YES [ ] Unusual Pain \n\n * NO [X] YES [ ] Fever \n\n * NO [ ] YES [X] Other Problems: \n\n * A little tired today. \n\n * Patient / Significant Other communicates knowledge of and understands follow-up instructions. \n\n * Patient\'s condition: Good \n\n * Additional information \n\n * Signature of Nurse/Physician: See above electronic signature. \n\n * SF 509 - E - Progress Notes \n\n\n\n\nAuthored by:     DEMO USER  on May 2, 2011                                     \n                 9040 Fitzsimmons Ave Tacoma, WA  98431 WP:  (253) 968-1110    \n\n\n\n\nHEALTHCARE PROVIDERS \n\n\n\n\nSUPPORT PROVIDERS \n\n\n\n\nINSURANCE INFORMATION \n\nFOR OFFICIAL USE ONLY (FOUO)';
var expectedDodComplexNoteUri = config.documentStorage.uriRoot + '?dir=444f443b3030303030303033/3cc445968192d500d5a2ddbf23ab4952605f0b0c_&file=52434099d66a4f3f609d0e931b762ec6538ddca9.html';

var placeholderText = '-Placeholder for a DOD Patient Document- Unfortunately this document is corrupted and cannot be displayed.  Please report it so the problem can be rectified.';

describe('jmeadows-cda-document-conversion-handler', function() {
    // var environment = {
    //     publisherRouter: {
    //         publish: function() {

    //         }
    //     }
    // };

    describe('handle', function() {
        beforeEach(function() {
            fsUtil.deleteAllFiles(config.documentStorage.publish.path);
        });

        // Disabled for AWS testing
        xit('successful conversion', function() {
            var done = false;

            var job = {
                type: 'jmeadows-cda-document-conversion',
                requestStampTime: '20150103120000',
                dataDomain: 'dischargeSummary',
                patientIdentifier: {
                    type: 'pid',
                    value: 'DOD;00000003'
                },
                record: sampleVprDischargeSummary
            };

            var environment = {
                publisherRouter: {
                    publish: function(job, callback) {
                        callback();
                    }
                }
            };

            spyOn(environment.publisherRouter, 'publish').andCallThrough();

            runs(function() {
                handle(log, config, environment, job, function() {
                    expect(environment.publisherRouter.publish.calls).toBeTruthy();
                    var publishCalls = environment.publisherRouter.publish.calls;
                    expect(publishCalls).toBeTruthy();
                    expect(_.isArray(publishCalls)).toBe(true);
                    expect(val(publishCalls, 'length')).toEqual(1);
                    var resultJob = val(publishCalls, 0, 'args', 0);
                    expect(resultJob).toBeTruthy();
                    //console.log(resultJob);
                    expect(val(resultJob, 'record', 'text', 0, 'content')).toEqual(plaintextContent);
                    expect(val(resultJob, 'record', 'dodComplexNoteUri')).toEqual(expectedDodComplexNoteUri);
                    done = true;
                });
            });

            waitsFor(function() {
                return done;
            }, 'Call failed to return in time.', 10000);
        });

        it('error in conversion', function() {
            var done = false;

            var job = {
                type: 'jmeadows-cda-document-conversion',
                requestStampTime: '20150103120000',
                dataDomain: 'dischargeSummary',
                patientIdentifier: {
                    type: 'pid',
                    value: 'DOD;00000003'
                },
                record: corruptedSampleVprDischargeSummary
            };

            var environment = {
                publisherRouter: {
                    publish: function(job, callback) {
                        callback();
                    }
                }
            };

            spyOn(environment.publisherRouter, 'publish').andCallThrough();

            runs(function() {
                handle(log, config, environment, job, function() {
                    expect(environment.publisherRouter.publish.calls).toBeTruthy();
                    var publishCalls = environment.publisherRouter.publish.calls;
                    expect(val(publishCalls, 'length')).toEqual(1);
                    var resultJob = val(publishCalls, 0, 'args', 0);
                    expect(resultJob).toBeTruthy();
                    expect(val(resultJob, 'record', 'text', 0, 'content')).toEqual(placeholderText);
                    done = true;
                });
            });

            waitsFor(function() {
                return done;
            }, 'Call failed to return in time.', 10000);
        });

        xdescribe('job output test', function() {
            var testJob = {
                type: 'jmeadows-cda-document-conversion',
                requestStampTime: '20150103120000',
                dataDomain: 'dischargeSummary',
                patientIdentifier: {
                    type: 'pid',
                    value: 'DOD;102319283'
                },
                record: {
                    referenceDateTime: 1320950895000,
                    codes: [{
                        code: '28636-9',
                        display: '',
                        system: 'DOD_NCID'
                    }, {
                        code: '28563-5',
                        display: '',
                        system: 'DOD_NOTES'
                    }],
                    localTitle: 'Pulmonary Nursing Follow-Up',
                    documentTypeName: 'Initial Evaluation Note',
                    author: 'DEMO USER,',
                    authorDisplayName: 'DEMO USER,',
                    status: 'completed',
                    statusName: 'completed',
                    facilityName: 'DOD',
                    facilityCode: 'DOD',
                    uid: 'urn:va:document:DOD:00001:3cc445968192d500d5a2ddbf23ab4952605f0b0c_',
                    pid: 'DOD;00001',
                    text: [{
                        content: '<?xml version=\'1.0\' encoding=\'UTF-8\'?><ClinicalDocument xsi:schemaLocation="xmlns=\'urn:hl7-org:v3\' xmlns:crs=\'urn:hl7-org:crs\' xmlns:xsi=\'http://www.w3.org/2001/XMLSchema-instance\'" xmlns="urn:hl7-org:v3" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">\n   <typeId extension="POCD_HD000040" root="2.16.840.1.113883.1.3"/>\n   <id extension="50402157_20110502113900_125" root="2.16.840.1.113883.3.42.144.100001.17"/>\n   <code codeSystem="2.16.840.1.113883.6.1" codeSystemName="LOINC" code="28636-9" displayName="&quot;Initial Evaluation Note&quot;"/>\n   <title>Pulmonary Nursing Follow-Up</title>\n   <effectiveTime value="20120829151904"/>\n   <confidentialityCode code="N" codeSystem="2.16.840.1.113883.5.25"/>\n   <versionNumber value="8"/>\n   <recordTarget>\n      <patientRole>\n         <id extension="786724" root="2.16.840.1.113883.3.42.127.125.2"/>\n         <id extension="000-00-1102" root="2.16.840.1.113883.4.1"/>\n         <addr>\n            <streetAddressLine>1234 Cherry Blossom Lane</streetAddressLine>\n            <city/>\n            <state/>\n            <postalCode/>\n            <country/>\n         </addr>\n         <telecom use="HP" value="tel:"/>\n         <patient>\n            <name>\n               <delimiter/>\n               <prefix/>\n               <suffix/>\n               <given>BOB</given>\n               <family>BTEST</family>\n            </name>\n            <administrativeGenderCode codeSystem="2.16.840.1.113883.5.1" code="F"/>\n            <birthTime value="19450101"/>\n         </patient>\n      </patientRole>\n   </recordTarget>\n   <author>\n      <time value="20110502114150"/>\n      <assignedAuthor>\n         <id extension="" root="2.16.840.1.113883.3.42.127.125.3"/>\n         <addr>\n            <streetAddressLine>9040 Fitzsimmons Ave</streetAddressLine>\n            <city>Tacoma</city>\n            <state>WA</state>\n            <postalCode>98431</postalCode>\n            <country>USA</country>\n         </addr>\n         <telecom use="WP" value="tel:(253) 968-1110"/>\n         <assignedPerson>\n            <name>\n               <delimiter/>\n               <prefix/>\n               <suffix/>\n               <given/>\n               <family>DEMO USER</family>\n            </name>\n         </assignedPerson>\n      </assignedAuthor>\n   </author>\n   <custodian>\n      <assignedCustodian>\n         <representedCustodianOrganization>\n            <id root="2.16.840.1.113883.3.42.127.125.13"/>\n         </representedCustodianOrganization>\n      </assignedCustodian>\n   </custodian>\n   <component>\n      <structuredBody>\n         <component>\n            <section>\n               <text>\n                  <table>\n                     <col valign="top" align="center" width="1050"/>\n                     <tbody>\n                        <tr>\n                           <td styleCode="Bold">PULMONARY NURSING FOLLOW-UP NOTE</td>\n                        </tr>\n                     </tbody>\n                  </table>\n               </text>\n            </section>\n         </component>\n         <component>\n            <section>\n               <text>\n                  <table>\n                     <col valign="top" width="390"/>\n                     <col valign="top" width="139"/>\n                     <col valign="top" width="521"/>\n                     <tbody>\n                        <tr>\n                           <td styleCode="Bold">- POST OPERATIVE FOLLOW UP PHONE CALL -</td>\n                           <td>Phone number</td>\n                           <td>800-555-4444</td>\n                        </tr>\n                     </tbody>\n                  </table>\n               </text>\n            </section>\n         </component>\n         <component>\n            <section>\n               <text>\n                  <table>\n                     <col width="49"/>\n                     <col valign="top" width="138"/>\n                     <col valign="top" width="124"/>\n                     <col valign="top" width="498"/>\n                     <col valign="top" width="241"/>\n                     <tbody>\n                        <tr>\n                           <td align="center"/>\n                           <td>Date</td>\n                           <td>Time</td>\n                           <td>Results</td>\n                           <td>Initials</td>\n                        </tr>\n                     </tbody>\n                  </table>\n               </text>\n            </section>\n         </component>\n         <component>\n            <section>\n               <text>\n                  <table>\n                     <col valign="top" width="103"/>\n                     <col valign="top" width="134"/>\n                     <col valign="top" width="536"/>\n                     <col valign="top" width="238"/>\n                     <tbody>\n                        <tr>\n                           <td>02May</td>\n                           <td>0600</td>\n                           <td>Left message</td>\n                           <td>DEMO</td>\n                        </tr>\n                     </tbody>\n                  </table>\n               </text>\n            </section>\n         </component>\n         <component>\n            <section>\n               <text>\n                  <table>\n                     <col valign="top" width="1050"/>\n                     <tbody>\n                        <tr>\n                           <td styleCode="Bold">- ATTEMPTS TO CONTACT PATIENT -</td>\n                        </tr>\n                     </tbody>\n                  </table>\n               </text>\n            </section>\n         </component>\n         <component>\n            <section>\n               <text>\n                  <table>\n                     <col width="91"/>\n                     <col valign="top" width="96"/>\n                     <col valign="top" width="124"/>\n                     <col valign="top" width="498"/>\n                     <col valign="top" width="241"/>\n                     <tbody>\n                        <tr>\n                           <td align="center"/>\n                           <td>Date</td>\n                           <td>Time</td>\n                           <td>Results</td>\n                           <td>Initials</td>\n                        </tr>\n                     </tbody>\n                  </table>\n               </text>\n            </section>\n         </component>\n         <component>\n            <section>\n               <text>\n                  <table>\n                     <col width="36"/>\n                     <col valign="top" width="40"/>\n                     <col valign="top" width="107"/>\n                     <col valign="top" width="108"/>\n                     <col valign="top" width="521"/>\n                     <col valign="top" width="238"/>\n                     <tbody>\n                        <tr>\n                           <td align="center"/>\n                           <td>#1</td>\n                           <td>02May</td>\n                           <td>0900</td>\n                           <td>Reached patient and discussed.</td>\n                           <td>DEMO</td>\n                        </tr>\n                     </tbody>\n                  </table>\n               </text>\n            </section>\n         </component>\n         <component>\n            <section>\n               <text>\n                  <table>\n                     <col width="33"/>\n                     <col valign="top" width="195"/>\n                     <col valign="top" width="822"/>\n                     <tbody>\n                        <tr>\n                           <td align="center"/>\n                           <td>PATIENT RESPONSE</td>\n                           <td>* Additional Comments Required For All Yes Responses *</td>\n                        </tr>\n                     </tbody>\n                  </table>\n               </text>\n            </section>\n         </component>\n         <component>\n            <section>\n               <text>\n                  <table>\n                     <col width="36"/>\n                     <col valign="top" width="27"/>\n                     <col valign="top" width="42"/>\n                     <col valign="top" width="35"/>\n                     <col valign="top" width="47"/>\n                     <col valign="top" width="863"/>\n                     <tbody>\n                        <tr>\n                           <td align="center"/>\n                           <td>NO</td>\n                           <td>[X]</td>\n                           <td>YES</td>\n                           <td>[ ]</td>\n                           <td>Color and amount  of sputum produced with cough</td>\n                        </tr>\n                     </tbody>\n                  </table>\n               </text>\n            </section>\n         </component>\n         <component>\n            <section>\n               <text>\n                  <table>\n                     <col width="36"/>\n                     <col valign="top" width="27"/>\n                     <col valign="top" width="42"/>\n                     <col valign="top" width="35"/>\n                     <col valign="top" width="47"/>\n                     <col valign="top" width="863"/>\n                     <tbody>\n                        <tr>\n                           <td align="center"/>\n                           <td>NO</td>\n                           <td>[X]</td>\n                           <td>YES</td>\n                           <td>[ ]</td>\n                           <td>Unusual Pain</td>\n                        </tr>\n                     </tbody>\n                  </table>\n               </text>\n            </section>\n         </component>\n         <component>\n            <section>\n               <text>\n                  <table>\n                     <col width="36"/>\n                     <col valign="top" width="27"/>\n                     <col valign="top" width="42"/>\n                     <col valign="top" width="35"/>\n                     <col valign="top" width="47"/>\n                     <col valign="top" width="863"/>\n                     <tbody>\n                        <tr>\n                           <td align="center"/>\n                           <td>NO</td>\n                           <td>[X]</td>\n                           <td>YES</td>\n                           <td>[ ]</td>\n                           <td>Fever</td>\n                        </tr>\n                     </tbody>\n                  </table>\n               </text>\n            </section>\n         </component>\n         <component>\n            <section>\n               <text>\n                  <table>\n                     <col width="36"/>\n                     <col valign="top" width="27"/>\n                     <col valign="top" width="42"/>\n                     <col valign="top" width="35"/>\n                     <col valign="top" width="47"/>\n                     <col valign="top" width="863"/>\n                     <tbody>\n                        <tr>\n                           <td align="center"/>\n                           <td>NO</td>\n                           <td>[ ]</td>\n                           <td>YES</td>\n                           <td>[X]</td>\n                           <td>Other Problems:</td>\n                        </tr>\n                     </tbody>\n                  </table>\n               </text>\n            </section>\n         </component>\n         <component>\n            <section>\n               <text>\n                  <table>\n                     <col valign="top" width="1014"/>\n                     <tbody>\n                        <tr>\n                           <td>A little tired today.</td>\n                        </tr>\n                     </tbody>\n                  </table>\n               </text>\n            </section>\n         </component>\n         <component>\n            <section>\n               <text>\n                  <table>\n                     <col valign="top" width="1014"/>\n                     <tbody>\n                        <tr>\n                           <td>Patient / Significant Other communicates knowledge of and understands follow-up instructions.</td>\n                        </tr>\n                     </tbody>\n                  </table>\n               </text>\n            </section>\n         </component>\n         <component>\n            <section>\n               <text>\n                  <table>\n                     <col valign="top" width="251"/>\n                     <col valign="top" width="799"/>\n                     <tbody>\n                        <tr>\n                           <td styleCode="Bold">Patient\'s condition:</td>\n                           <td>Good</td>\n                        </tr>\n                     </tbody>\n                  </table>\n               </text>\n            </section>\n         </component>\n         <component>\n            <section>\n               <text>\n                  <table>\n                     <col valign="top" width="251"/>\n                     <col valign="top" width="799"/>\n                     <tbody>\n                        <tr>\n                           <td styleCode="Bold">Additional information</td>\n                           <td/>\n                        </tr>\n                     </tbody>\n                  </table>\n               </text>\n            </section>\n         </component>\n         <component>\n            <section>\n               <text>\n                  <table>\n                     <col valign="top" width="1050"/>\n                     <tbody>\n                        <tr>\n                           <td styleCode="Bold">Signature of Nurse/Physician: See above electronic signature.</td>\n                        </tr>\n                     </tbody>\n                  </table>\n               </text>\n            </section>\n         </component>\n         <component>\n            <section>\n               <text>\n                  <table>\n                     <col width="1"/>\n                     <col valign="top" width="1049"/>\n                     <tbody>\n                        <tr>\n                           <td align="center"/>\n                           <td>SF 509 - E - Progress Notes</td>\n                        </tr>\n                     </tbody>\n                  </table>\n               </text>\n            </section>\n         </component>\n      </structuredBody>\n   </component>\n</ClinicalDocument>',
                        dateTime: 1320950895000,
                        status: 'completed',
                        uid: 'urn:va:document:DOD:00001:3cc445968192d500d5a2ddbf23ab4952605f0b0c_'
                    }],
                    dodComplexNoteUri: null
                }
            };

            var testConfig = require(global.VX_INTTESTS + 'test-config');
            var vx_sync_ip = testConfig.vxsyncIP;

            var host = vx_sync_ip;
            var port = PORT;
            var tubename = 'vx-sync-test';

            var jobTypes = [jobUtils.recordEnrichmentType()];

            testHandler(handle, log, config, null, host, port, tubename, testJob, jobTypes);
        });
    });

    afterEach(function() {
        fsUtil.deleteAllFiles(config.documentStorage.publish.path);
    });
});