'use strict';
var _ = require('underscore');
var errorUtil = require(global.VX_UTILS + 'error');
var loadPatient = require(global.VX_HANDLERS + 'resync-request/load-patient');
var jobUtils = require(global.VX_UTILS + 'job-utils');

function handle(log, config, environment, job, handlerCallback) {
	log.debug('sync-notification-handler.handle(): Entering method with job %j', job);

	if (!_.has(job, 'patientIdentifier')) {
		log.error('sync-notification-handler.handle(): Invalid job: missing patientIdentifier. job: %j', job);
		return setTimeout(handlerCallback, 0, errorUtil.createFatal('Job missing patientIdentifier', job));
	}

	loadPatient(log, config.syncRequestApi, job, function(error) {
		if (error) {
			log.error('sync-notification-handler.handle(): loadPatient returned error: %s', error);
			return handlerCallback(errorUtil.createTransient(error, job));
		}

		var meta = {
			jpid: job.jpid,
			rootJobId: job.rootJobId,
			priority: job.priority,
			param: job.param
		};

		if (job.referenceInfo) {
			meta.referenceInfo = job.referenceInfo;
		}

		var jobToPublish = jobUtils.createPublishVxDataChange(job.patientIdentifier, job.dataDomain, job.record, meta);

		log.debug('sync-notification-handler.handle(): Publishing job: %j', jobToPublish);
		environment.publisherRouter.publish(jobToPublish, handlerCallback);
	});
}

module.exports = handle;