user = ENV['OPSCODE_USER'] || "jenkins"
orgname = ENV['ORGNAME'] || "vistacore"

log_level                :info
log_location             STDOUT
node_name                user
client_key               "#{ENV['HOST_KEY_PATH']}"
chef_server_url          "https://pantry.vistacore.us/organizations/#{orgname}"
ssl_verify_mode          :verify_none
cache_type               'BasicFile'
cache_options( :path => "#{ENV['HOME']}/chef-repo/.chef/checksums" )
workspace = ENV["WORKSPACE"] || "#{ENV["HOME"]}/workspace/#{ENV["JOB_NAME"]}"
cookbook_path [
  "#{workspace}/project_cookbooks",
  "#{workspace}/wrapper_cookbooks",
  "#{workspace}/third_party_cookbooks",
  "#{workspace}/machine_cookbooks"
]
chef_provisioning({:image_max_wait_time => 600, :machine_max_wait_time => 300})
