#
# Cookbook Name:: vxsync
# Recipe:: artifact
#

include_recipe "vxsync::cleanup_old_vxsync"

remote_file "#{node['vxsync']['artifact_path']}" do
  use_conditional_get true
  source node['vxsync']['source']
  mode   "0755"
  owner node[:vxsync][:user]
  group node[:vxsync][:group]
  node['vxsync']['vxsync_applications'].each { |app| notifies :delete, "directory[#{node["vxsync_#{app}"]['home_dir']}]", :immediately }
end

node['vxsync']['vxsync_applications'].each do |app|

  directory node["vxsync_#{app}"]['home_dir'] do
    owner node[:vxsync][:user]
    group node[:vxsync][:group]
    mode "0755"
    recursive true
    action :create
  end

  execute "install modules for vxsync_#{app}" do
    cwd node["vxsync_#{app}"]['home_dir']
    command "scl enable python27 devtoolset-3 'CC=/opt/rh/devtoolset-3/root/usr/bin/gcc CXX=/opt/rh/devtoolset-3/root/usr/bin/g++ /usr/local/bin/npm install --unsafe-perm'"
    action :nothing
    not_if { "#{node['vxsync']['source']}".start_with?("http") }
  end

  execute "npm run install on xslt4node java for vxsync_#{app}" do
    cwd "#{node["vxsync_#{app}"]['home_dir']}/node_modules/java"
    command "scl enable python27 devtoolset-3 'CC=/opt/rh/devtoolset-3/root/usr/bin/gcc CXX=/opt/rh/devtoolset-3/root/usr/bin/g++ /usr/local/bin/npm run install --build-from-source'"
    action :nothing
    not_if { "#{node['vxsync']['source']}".start_with?("http") }
  end

  execute "extract_vxsync for vxsync_#{app}" do
    cwd node["vxsync_#{app}"]['home_dir']
    command "unzip #{node['vxsync']['artifact_path']}"
    user node[:vxsync][:user]
    action :run
    notifies :run, "execute[install modules for vxsync_#{app}]", :immediately
    notifies :run, "execute[npm run install on xslt4node java for vxsync_#{app}]", :immediately
    notifies :execute, "vxsync_reset_sync[reset_vxsync]", :delayed
    only_if { (Dir.entries(node["vxsync_#{app}"]['home_dir']) - %w{ . .. }).empty? }
  end

end
