#
# Cookbook Name:: role_cookbook
# Recipe:: default
#

include_recipe "ohai"
include_recipe "timezone-ii"
include_recipe "ntp"
include_recipe "sssd_ldap_wrapper"
include_recipe "beats" if node[:beats][:logging]
include_recipe "beats::disable" unless node[:beats][:logging]

if node[:chef_provisioning][:driver_url] == "aws"
  node.default[:set_fqdn] = "#{node[:stack].gsub('.','-').gsub('build-','')}.vistacore.us"
else
  node.default[:set_fqdn] = "#{node[:chef_provisioning][:reference][:target_name].gsub('.','-').gsub('build-','')}.vistacore.us"
end
include_recipe "hostnames"

# override aws specific solr attributes here

node.default[:vx_solr][:bin_solr][:memory] = "1g"

# service users
user 'node' do
  uid '1000'
end

group 'node' do
  gid '1000'
  members 'node'
end

user 'solr' do
  uid '1001'
end

group 'solr' do
  gid '1001'
  members 'solr'
end

user 'zookeeper' do
  uid '1002'
end

group 'zookeeper' do
  gid '1002'
  members 'zookeeper'
end

user 'dropwizard' do
  uid '1003'
end

group 'dropwizard' do
  gid '1003'
  members 'dropwizard'
end

user 'asu' do
  uid '1004'
end

group 'asu' do
  gid '1004'
  members 'asu'
end

user 'jena' do
  uid '1005'
end

group 'jena' do
  gid '1005'
  members 'jena'
end