#
# Cookbook Name:: jds
# Recipe:: configure_ecp_settings
#

user_password = Chef::EncryptedDataBagItem.load("credentials", "jds_passwords", node[:data_bag_string])["user_password"]

jds_mumps_block "configure ecp settings" do
  cache_username node[:jds][:default_admin_user]
  cache_password user_password
  namespace "%SYS"
  command [
    "Set P(\"MaxServers\")=#{node[:jds][:ecp][:max_servers]}",
    "Set P(\"MaxServerConn\")=#{node[:jds][:ecp][:max_servers]}",
    "Set P(\"globals8kb\")=#{node[:jds][:ecp][:globals8kb]}",
    "Set P(\"gmheap\")=#{node[:jds][:ecp][:gmheap]}",
    "Set P(\"routines\")=#{node[:jds][:ecp][:routines]}",
    "Set Status=##class(Config.config).Modify(.P)",
    "Set Status=##class(Config.config).Get(.P)",
    "ZW P"
  ]
  log node[:jds][:chef_log]
  notifies :restart, "service[#{node[:jds][:service_name]}]", :immediately
end
