#
# Cookbook Name:: fetch_server
# Recipe:: nerve
#

include_recipe 'nerve_wrapper'

config = node[:fetch_server][:service_config]
1.upto(config[:processes]) do |index|

	nerve_wrapper "#{config[:name]}-#{index}" do
		host node[:ipaddress]
		port config[:port] - 1 + index
		checks config[:nerve][:checks]
		check_interval config[:nerve][:check_interval]
		service_type config[:name]
	end
end
