define :ehmp_ui_manifest, :path => "" do
  release_version = node[:'ehmp-ui_provision'][:artifacts][:'ehmp-ui'][:version].split(".")[0..2].join(".") rescue "unknown"

  overall_version = 0
  unset_versions = []
  versions = {}

  version_host_path = "/tmp/artifact-versions-shell.sh"
  File.open(version_host_path, "w") do |f|
    ENV.each do |key,value|
      if key.end_with?("_VERSION") || key.end_with?("_PROVISION") || key.end_with?("_HASH")
        f.write("export #{key}=#{value}\n")
      end
      if key.end_with?("_VERSION") && value != "LATEST" && !value.nil?
        overall_version += value.to_s.split(".").last.to_i
        versions[key.to_sym] = value.to_s
      end
    end
  end

  overall_version = ENV["APP_VERSION"] || "#{release_version}.#{overall_version}"
  puts "overall_version = #{overall_version}"
  puts "\nAPP_VERSION='#{overall_version}'\n"

  node.default[:'ehmp-ui_provision'][:manifest][:versions] = versions
  node.default[:'ehmp-ui_provision'][:manifest][:overall_version] = overall_version

  puts "\nAPP_VERSION='#{overall_version}'\n"

  if ENV.has_key?("UPLOAD_RELEASE_MANIFEST")

    raise "UPLOAD_RELEASE_MANIFEST was set, however no Nexus credentials are available." unless ENV.has_key?("NEXUSAUTH")
    publish_repo = ENV["NEXUS_UPLOAD_REPO"] || "releases"

    execute "uploading artifact version shell to nexus" do
      command "curl -v -F r=#{publish_repo} -F hasPom=false -F e=sh -F g=us.vistacore -F a=artifact-versions-shell -F v=#{overall_version} -F p=sh -F file=@#{version_host_path} -H 'Authorization: Basic #{ENV['NEXUSAUTH']}' #{node[:common][:nexus_url]}/nexus/service/local/artifact/maven/content"
      sensitive true
    end

  end

end
