

DROP USER CISS CASCADE;
DROP USER CISS_EXT CASCADE;
DROP USER PCMM_EXT CASCADE;
DROP USER sdsadm CASCADE;

CREATE USER CISS IDENTIFIED BY CISS;
CREATE USER CISS_EXT IDENTIFIED BY CISS_EXT;
CREATE USER PCMM_EXT IDENTIFIED BY PCMM_EXT;
CREATE USER sdsadm IDENTIFIED BY sdsadm;

GRANT "DBA" TO CISS; 
GRANT "DBA" TO CISS_EXT; 
GRANT "DBA" TO PCMM_EXT; 
GRANT "DBA" TO sdsadm; 

GRANT "CONNECT" TO CISS;
GRANT "CONNECT" TO CISS_EXT;
GRANT "CONNECT" TO PCMM_EXT;
GRANT "CONNECT" TO sdsadm;

GRANT "RESOURCE" TO CISS;
GRANT "RESOURCE" TO CISS_EXT;
GRANT "RESOURCE" TO PCMM_EXT;
GRANT "RESOURCE" TO sdsadm;




CREATE TABLE CISS.ADMIN_STATION(
  ADMIN_STATION_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  STATION_id NUMBER(20, 0) NOT NULL UNIQUE,
  APP_USER_id NUMBER(20, 0) NOT NULL UNIQUE,
  RECORD_CREATED_BY VARCHAR(30) NOT NULL,
  RECORD_CREATED_DATE DATE NOT NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NOT NULL,
  RECORD_MODIFIED_DATE DATE NOT NULL,
  RECORD_MODIFIED_COUNT NUMBER(10, 0) NOT NULL,
  RECORD_CREATED_DATE_TZ VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE_TZ VARCHAR(30) NULL);

/****** Object:  Table CISS.ADMIN_STATION_H    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE CISS.ADMIN_STATION_H(
  ADMIN_STATION_H_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  TRANSACTION_TYPE_CODE char(1) NULL,
  ADMIN_STATION_id NUMBER(20, 0) NOT NULL UNIQUE,
  STATION_ID NUMBER(20, 0) NULL,
  APP_USER_ID NUMBER(20, 0) NULL,
  RECORD_CREATED_BY VARCHAR(30) NOT NULL,
  RECORD_CREATED_DATE DATE NOT NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NOT NULL,
  RECORD_MODIFIED_DATE DATE NOT NULL,
  RECORD_MODIFIED_COUNT NUMBER(10, 0) NOT NULL,
  RECORD_CREATED_DATE_TZ VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE_TZ VARCHAR(30) NULL,
  HISTORY_RECORD_CREATE_DATE DATE NOT NULL);




/****** Object:  Table CISS.AGENT_CONFIG    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE CISS.AGENT_CONFIG(
  AGENT_CONFIG_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  APP_USER_ID NUMBER(20, 0) NULL,
  AGENT_OS VARCHAR(30) NULL,
  AGENT_OS_BITS VARCHAR(30) NULL,
  AGENT_HOST VARCHAR(50) NULL,
  AGENT_BROWSER VARCHAR(100) NULL,
  AGENT_BROWSER_VERSION VARCHAR(20) NULL,
  AGENT_ACCESSIBLE_IND NUMBER(1, 0) NULL,
  AGENT_ACCESSIBLE_DEVICE VARCHAR(30) NULL,
  RECORD_CREATED_BY VARCHAR(30) NULL,
  RECORD_CREATED_DATE DATE NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE DATE NULL,
  RECORD_MODIFIED_COUNT NUMBER(10, 0) NOT NULL,
  RECORD_CREATED_DATE_TZ VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE_TZ VARCHAR(30) NULL);



/****** Object:  Table CISS.AGENT_RIA_CONFIG    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE CISS.AGENT_RIA_CONFIG(
  AGENT_RIA_CONFIG_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  APP_USER_ID NUMBER(20, 0) NULL,
  AGENT_RIA_TYPE VARCHAR(30) NULL,
  AGENT_RIA_VERSION VARCHAR(20) NULL,
  AGENT_RIA_DEBUG_IND NUMBER(1, 0) NULL,
  AGENT_RIA_OS VARCHAR(30) NULL,
  AGENT_RIA_OS_BITS VARCHAR(30) NULL,
  RECORD_CREATED_BY VARCHAR(30) NULL,
  RECORD_CREATED_DATE DATE NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE DATE NULL,
  RECORD_MODIFIED_COUNT NUMBER(10, 0) NOT NULL,
  RECORD_CREATED_DATE_TZ VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE_TZ VARCHAR(30) NULL);



/****** Object:  Table CISS.APP_PARAMETER    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE CISS.APP_PARAMETER(
  APP_PARAMETER_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  CISS_STD_APPLICATION_ID NUMBER(20, 0) NULL,
  STD_APPPARAMETERUNIT_ID NUMBER(20, 0) NULL,
  PARAMETER_NAME VARCHAR(50) NULL,
  PARAMETER_DESCRIPTION VARCHAR(250) NULL,
  INACTIVE_IND NUMBER(1, 0) NULL,
  INACTIVE_DATE DATE NULL,
  INACTIVE_DATE_TZ VARCHAR(30) NULL,
  APP_PARAMETER_TYPE_ID NUMBER(20, 0) NULL,
  PARAMATER_VALUE_FORMAT VARCHAR(50) NULL,
  PARAMETER_DATA_LENGTH NUMBER(10, 0) NULL,
  RECORD_CREATED_BY VARCHAR(30) NULL,
  RECORD_CREATED_DATE DATE NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE DATE NULL,
  RECORD_MODIFIED_COUNT NUMBER(10, 0) NOT NULL,
  RECORD_CREATED_DATE_TZ VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE_TZ VARCHAR(30) NULL);




/****** Object:  Table CISS.APP_PARAMETER_H    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE CISS.APP_PARAMETER_H(
  APP_PARAMETER_H_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  TRANSACTION_TYPE_CODE char(1) NULL,
  APP_PARAMETER_id NUMBER(20, 0) NOT NULL UNIQUE,
  CISS_STD_APPLICATION_ID NUMBER(20, 0) NULL,
  STD_APPPARAMETERUNIT_ID NUMBER(20, 0) NULL,
  PARAMETER_NAME VARCHAR(50) NULL,
  PARAMETER_DESCRIPTION VARCHAR(250) NULL,
  APP_PARAMETER_TYPE_ID NUMBER(20, 0) NULL,
  INACTIVE_IND NUMBER(1, 0) NULL,
  INACTIVE_DATE DATE NULL,
  INACTIVE_DATE_TZ VARCHAR(30) NULL,
  PARAMATER_VALUE_FORMAT VARCHAR(50) NULL,
  PARAMETER_DATA_LENGTH NUMBER(10, 0) NULL,
  RECORD_CREATED_BY VARCHAR(30) NULL,
  RECORD_CREATED_DATE DATE NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE DATE NULL,
  RECORD_MODIFIED_COUNT NUMBER(10, 0) NOT NULL,
  RECORD_CREATED_DATE_TZ VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE_TZ VARCHAR(30) NULL,
  HISTORY_RECORD_CREATE_DATE DATE NOT NULL);




/****** Object:  Table CISS.APP_PARAMETER_VALUE    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE CISS.APP_PARAMETER_VALUE(
  APP_PARAMETER_VALUE_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  APP_PARAMETER_ID NUMBER(20, 0) NULL,
  APP_PARAMETER_VALUE VARCHAR(250) NULL,
  APP_PARAMETER_MIN_VALUE VARCHAR(250) NULL,
  APP_PARAMETER_MAX_VALUE VARCHAR(250) NULL,
  RECORD_CREATED_BY VARCHAR(30) NULL,
  RECORD_CREATED_DATE DATE NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE DATE NULL,
  RECORD_MODIFIED_COUNT NUMBER(10, 0) NOT NULL,
  RECORD_CREATED_DATE_TZ VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE_TZ VARCHAR(30) NULL);

/****** Object:  Table CISS.APP_USER    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE CISS.APP_USER(
  APP_USER_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  ACTIVE_DIRECTORY_NAME VARCHAR(20) NULL,
  ACCOUNT_LOCK_DATE DATE NULL,
  LAST_LOGIN_DATE DATE NULL,
  NUMBER_OF_LOGIN_ATTEMPTS NUMBER(3, 0) NULL,
  LAST_FAILED_LOGIN_DATE DATE NULL,
  LAST_VISITED_DUTY_STATION NUMBER(20, 0) NULL,
  FIRST_NAME VARCHAR(30) NULL,
  MIDDLE_NAME VARCHAR(30) NULL,
  LAST_NAME VARCHAR(40) NULL,
  RECORD_CREATED_BY VARCHAR(30) NULL,
  RECORD_CREATED_DATE DATE NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE DATE NULL,
  RECORD_MODIFIED_COUNT NUMBER(10, 0) NOT NULL,
  RECORD_CREATED_DATE_TZ VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE_TZ VARCHAR(30) NULL,
  PHONE_NUMBER VARCHAR(30) NULL,
  EMAIL_ADDRESS VARCHAR(128) NULL,
  LDAP_DISABLED_IND char(1) NOT NULL,
  TIME_ZONE VARCHAR(50) NULL,
  PASSWORD_HASH VARCHAR(250) NULL);

/****** Object:  Table CISS.APP_USER_APPLICATION_PROFILE    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE CISS.APP_USER_APPLICATION_PROFILE(
  APP_USR_APPLICATION_PROFILE_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  APP_USER_id NUMBER(20, 0) NOT NULL UNIQUE,
  CISS_STD_APPLICATION_id NUMBER(20, 0) NOT NULL UNIQUE,
  LAST_ACCESSED_DATE DATE NOT NULL,
  RECORD_CREATED_BY VARCHAR(30) NOT NULL,
  RECORD_CREATED_DATE DATE NOT NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NOT NULL,
  RECORD_MODIFIED_DATE DATE NOT NULL,
  RECORD_MODIFIED_COUNT NUMBER(10, 0) NOT NULL,
  RECORD_CREATED_DATE_TZ VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE_TZ VARCHAR(30) NULL,
  INACTIVE_IND NUMBER(1, 0) NOT NULL,
  INACTIVE_DATE DATE NULL,
  CISS_STD_INACTIVE_REASON_ID NUMBER(20, 0) NULL);




/****** Object:  Table CISS.APP_USER_APPLICATION_PROFILE_H    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE CISS.APP_USER_APPLICATION_PROFILE_H(
  APP_USER_APP_PROFILE_H_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  TRANSACTION_TYPE_CODE char(1) NULL,
  APP_USER_APP_PROFILE_ID NUMBER(20, 0) NULL,
  APP_USER_id NUMBER(20, 0) NOT NULL UNIQUE,
  CISS_STD_APPLICATION_id NUMBER(20, 0) NOT NULL UNIQUE,
  LAST_ACCESSED_DATE DATE NOT NULL,
  RECORD_CREATED_BY VARCHAR(30) NOT NULL,
  RECORD_CREATED_DATE DATE NOT NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NOT NULL,
  RECORD_MODIFIED_DATE DATE NOT NULL,
  RECORD_MODIFIED_COUNT NUMBER(10, 0) NOT NULL,
  RECORD_CREATED_DATE_TZ VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE_TZ VARCHAR(30) NULL,
  INACTIVE_IND NUMBER(1, 0) NULL,
  INACTIVE_DATE DATE NULL,
  CISS_STD_INACTIVE_REASON_ID NUMBER(20, 0) NULL,
  HISTORY_RECORD_CREATE_DATE DATE NOT NULL);



/****** Object:  Table CISS.APP_USER_H    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE CISS.APP_USER_H(
  APP_USER_H_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  TRANSACTION_TYPE_CODE char(1) NULL,
  APP_USER_id NUMBER(20, 0) NOT NULL UNIQUE,
  ACTIVE_DIRECTORY_NAME VARCHAR(20) NULL,
  ACCOUNT_LOCK_DATE DATE NULL,
  LAST_LOGIN_DATE DATE NULL,
  NUMBER_OF_LOGIN_ATTEMPTS NUMBER(3, 0) NULL,
  LAST_FAILED_LOGIN_DATE DATE NULL,
  LAST_VISITED_DUTY_STATION NUMBER(20, 0) NULL,
  FIRST_NAME VARCHAR(30) NULL,
  MIDDLE_NAME VARCHAR(30) NULL,
  LAST_NAME VARCHAR(40) NULL,
  RECORD_CREATED_BY VARCHAR(30) NULL,
  RECORD_CREATED_DATE DATE NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE DATE NULL,
  RECORD_MODIFIED_COUNT NUMBER(10, 0) NOT NULL,
  RECORD_CREATED_DATE_TZ VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE_TZ VARCHAR(30) NULL,
  PHONE_NUMBER VARCHAR(30) NULL,
  EMAIL_ADDRESS VARCHAR(128) NULL,
  LDAP_DISABLED_IND char(1) NULL,
  TIME_ZONE VARCHAR(50) NULL,
  PASSWORD_HASH VARCHAR(250) NULL,
  HISTORY_RECORD_CREATE_DATE DATE NOT NULL);


/****** Object:  Table CISS.APP_USER_ROLE    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE CISS.APP_USER_ROLE(
  APP_USER_ROLE_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  APP_USER_ID NUMBER(20, 0) NULL,
  ROLE_ID NUMBER(20, 0) NULL,
  RECORD_CREATED_BY VARCHAR(30) NOT NULL,
  RECORD_CREATED_DATE DATE NOT NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NOT NULL,
  RECORD_MODIFIED_DATE DATE NOT NULL,
  RECORD_MODIFIED_COUNT NUMBER(10, 0) NOT NULL,
  RECORD_CREATED_DATE_TZ VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE_TZ VARCHAR(30) NULL);

/****** Object:  Table CISS.APP_USER_ROLE_H    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE CISS.APP_USER_ROLE_H(
  APP_USER_ROLE_H_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  TRANSACTION_TYPE_CODE char(1) NULL,
  APP_USER_ROLE_id NUMBER(20, 0) NOT NULL UNIQUE,
  APP_USER_ID NUMBER(20, 0) NULL,
  ROLE_ID NUMBER(20, 0) NULL,
  RECORD_CREATED_BY VARCHAR(30) NOT NULL,
  RECORD_CREATED_DATE DATE NOT NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NOT NULL,
  RECORD_MODIFIED_DATE DATE NOT NULL,
  RECORD_MODIFIED_COUNT NUMBER(10, 0) NOT NULL,
  RECORD_CREATED_DATE_TZ VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE_TZ VARCHAR(30) NULL,
  HISTORY_RECORD_CREATE_DATE DATE NOT NULL);

/****** Object:  Table CISS.ARCHIVE_LOG_ENTRY    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE CISS.ARCHIVE_LOG_ENTRY(
  ARCHIVE_LOG_ENTRY_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  SNAPSHOT_CREDENTIAL VARCHAR(250) NULL,
  SOURCE VARCHAR(250) NULL,
  HASH VARCHAR(250) NULL,
  RECORD_CREATED_BY VARCHAR(30) NOT NULL,
  RECORD_CREATED_DATE DATE NOT NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NOT NULL,
  RECORD_MODIFIED_DATE DATE NOT NULL,
  RECORD_MODIFIED_COUNT NUMBER(10, 0) NOT NULL,
  RECORD_CREATED_DATE_TZ VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE_TZ VARCHAR(30) NULL);

/****** Object:  Table CISS.ARCHIVE_LOG_ENTRY_SNAPSHOT    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE CISS.ARCHIVE_LOG_ENTRY_SNAPSHOT(
  ARCHIVE_LOG_ENTRY_SNAPSHOT_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  ARCHIVE_LOG_ENTRY_ID NUMBER(20, 0) NULL,
  BINARY_SNAPSHOT_DATA VARCHAR(100) NULL,
  RECORD_CREATED_BY VARCHAR(30) NOT NULL,
  SNAPSHOT_DATA VARCHAR(100) NULL,
  BINARY_COMPRESSED_IND char(1) NULL,
  RECORD_CREATED_DATE DATE NOT NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NOT NULL,
  RECORD_MODIFIED_DATE DATE NOT NULL,
  RECORD_MODIFIED_COUNT NUMBER(10, 0) NOT NULL,
  RECORD_CREATED_DATE_TZ VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE_TZ VARCHAR(30) NULL);

/****** Object:  Table CISS.BATCH_JOB_PERMISSION    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE CISS.BATCH_JOB_PERMISSION(
  BATCH_JOB_PERMISSION_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  PERMISSION_ID NUMBER(20, 0) NULL,
  JOB_CONFIG_ID NUMBER(20, 0) NULL,
  RECORD_CREATED_BY VARCHAR(30) NULL,
  RECORD_CREATED_DATE DATE NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE DATE NULL,
  RECORD_MODIFIED_COUNT NUMBER(10, 0) NULL,
  RECORD_CREATED_DATE_TZ VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE_TZ VARCHAR(30) NULL);


/****** Object:  Table CISS.BATCH_JOB_PERMISSION_H    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE CISS.BATCH_JOB_PERMISSION_H(
  BATCH_JOB_PERMISSION_H_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  TRANSACTION_TYPE_CODE char(1) NULL,
  BATCH_JOB_PERMISSION_ID NUMBER(20, 0) NULL,
  PERMISSION_ID NUMBER(20, 0) NULL,
  JOB_CONFIG_ID NUMBER(20, 0) NULL,
  RECORD_CREATED_BY VARCHAR(30) NULL,
  RECORD_CREATED_DATE DATE NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE DATE NULL,
  RECORD_MODIFIED_COUNT NUMBER(10, 0) NULL,
  RECORD_CREATED_DATE_TZ VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE_TZ VARCHAR(30) NULL,
  HISTORY_RECORD_CREATE_DATE DATE NOT NULL);


/****** Object:  Table CISS.CISS_STD_APPLICATION    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE CISS.CISS_STD_APPLICATION(
  CISS_STD_APPLICATION_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  APPLICATION_NAME VARCHAR(50) NULL,
  APPLICATION_DESCRIPTION VARCHAR(250) NULL,
  RECORD_CREATED_BY VARCHAR(30) NOT NULL,
  RECORD_CREATED_DATE DATE NOT NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NOT NULL,
  RECORD_MODIFIED_DATE DATE NOT NULL,
  RECORD_MODIFIED_COUNT NUMBER(10, 0) NOT NULL,
  RECORD_CREATED_DATE_TZ VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE_TZ VARCHAR(30) NULL);

/****** Object:  Table CISS.CISS_STD_APPPARAMETERTYPE    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE CISS.CISS_STD_APPPARAMETERTYPE(
  CISS_STD_APPPARAMETERTYPE_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  CODE VARCHAR(50) NOT NULL,
  NAME VARCHAR(80) NULL,
  DESCRIPTION VARCHAR(250) NULL,
  SORT_ORDER NUMBER(6, 0) NULL,
  ISACTIVE char(1) NOT NULL,
  EFFECTIVEDATE DATE NULL,
  EXPIRATIONDATE DATE NULL,
  RECORD_CREATED_BY VARCHAR(30) NOT NULL,
  RECORD_CREATED_DATE DATE NOT NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NOT NULL,
  RECORD_MODIFIED_DATE DATE NOT NULL);

/****** Object:  Table CISS.CISS_STD_APPPARAMETERUNIT    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE CISS.CISS_STD_APPPARAMETERUNIT(
  CISS_STD_APPPARAMETERUNIT_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  CODE VARCHAR(50) NOT NULL,
  NAME VARCHAR(80) NULL,
  DESCRIPTION VARCHAR(250) NULL,
  SORT_ORDER NUMBER(6, 0) NULL,
  ISACTIVE char(1) NOT NULL,
  EFFECTIVEDATE DATE NULL,
  EXPIRATIONDATE DATE NULL,
  RECORD_CREATED_BY VARCHAR(30) NOT NULL,
  RECORD_CREATED_DATE DATE NOT NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NOT NULL,
  RECORD_MODIFIED_DATE DATE NOT NULL);

/****** Object:  Table CISS.CISS_STD_INACTIVE_REASON    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE CISS.CISS_STD_INACTIVE_REASON(
  CISS_STD_INACTIVE_REASON_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  CODE VARCHAR(50) NOT NULL,
  NAME VARCHAR(80) NULL,
  DESCRIPTION VARCHAR(250) NULL,
  SORT_ORDER NUMBER(6, 0) NULL,
  ISACTIVE char(1) NOT NULL,
  EFFECTIVEDATE DATE NULL,
  EXPIRATIONDATE DATE NULL,
  RECORD_CREATED_BY VARCHAR(30) NOT NULL,
  RECORD_CREATED_DATE DATE NOT NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NOT NULL,
  RECORD_MODIFIED_DATE DATE NOT NULL,
  CISS_STD_APPLICATION_ID NUMBER(20, 0) NULL);

/****** Object:  Table CISS.CISS_STD_OCCUPATION    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE CISS.CISS_STD_OCCUPATION(
  CISS_STD_OCCUPATION_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  CODE VARCHAR(50) NOT NULL,
  NAME VARCHAR(80) NULL,
  DESCRIPTION VARCHAR(250) NULL,
  SORT_ORDER NUMBER(6, 0) NULL,
  ISACTIVE char(1) NOT NULL,
  EFFECTIVEDATE DATE NULL,
  EXPIRATIONDATE DATE NULL,
  RECORD_CREATED_BY VARCHAR(30) NOT NULL,
  RECORD_CREATED_DATE DATE NOT NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NOT NULL,
  RECORD_MODIFIED_DATE DATE NOT NULL);


/****** Object:  Table CISS.CISS_STD_REFERENCE_TABLE    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE CISS.CISS_STD_REFERENCE_TABLE(
  CISS_STD_REFERENCE_TABLE_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  CODE VARCHAR(50) NOT NULL,
  NAME VARCHAR(80) NULL,
  DESCRIPTION VARCHAR(250) NULL,
  SORT_ORDER NUMBER(6, 0) NULL,
  ISACTIVE char(1) NOT NULL,
  EFFECTIVEDATE DATE NULL,
  EXPIRATIONDATE DATE NULL,
  RECORD_CREATED_BY VARCHAR(30) NOT NULL,
  RECORD_CREATED_DATE DATE NOT NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NOT NULL,
  RECORD_MODIFIED_DATE DATE NOT NULL);

/****** Object:  Table CISS.CISS_STD_REPORT_FILE_TYPE    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE CISS.CISS_STD_REPORT_FILE_TYPE(
  CISS_STD_REPORT_FILE_TYPE_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  CODE VARCHAR(50) NOT NULL,
  NAME VARCHAR(80) NULL,
  DESCRIPTION VARCHAR(250) NULL,
  SORT_ORDER NUMBER(6, 0) NULL,
  ISACTIVE char(1) NOT NULL,
  EFFECTIVEDATE DATE NULL,
  EXPIRATIONDATE DATE NULL,
  RECORD_CREATED_BY VARCHAR(30) NOT NULL,
  RECORD_CREATED_DATE DATE NOT NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NOT NULL,
  RECORD_MODIFIED_DATE DATE NOT NULL);

/****** Object:  Table CISS.CISS_STD_RPTDAYOFMONTHTYPE    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE CISS.CISS_STD_RPTDAYOFMONTHTYPE(
  CISS_STD_RPTDAYOFMONTHTYPE_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  CODE VARCHAR(50) NOT NULL,
  NAME VARCHAR(80) NULL,
  DESCRIPTION VARCHAR(250) NULL,
  SORT_ORDER NUMBER(6, 0) NULL,
  ISACTIVE char(1) NOT NULL,
  EFFECTIVEDATE DATE NULL,
  EXPIRATIONDATE DATE NULL,
  RECORD_CREATED_BY VARCHAR(30) NOT NULL,
  RECORD_CREATED_DATE DATE NOT NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NOT NULL,
  RECORD_MODIFIED_DATE DATE NOT NULL);

/****** Object:  Table CISS.CISS_STD_RPTDAYOFQUARTERTYPE    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE CISS.CISS_STD_RPTDAYOFQUARTERTYPE(
  CISS_STD_RPTDAYOFQUARTTYPE_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  CODE VARCHAR(50) NOT NULL,
  NAME VARCHAR(80) NULL,
  DESCRIPTION VARCHAR(250) NULL,
  SORT_ORDER NUMBER(6, 0) NULL,
  ISACTIVE char(1) NOT NULL,
  EFFECTIVEDATE DATE NULL,
  EXPIRATIONDATE DATE NULL,
  RECORD_CREATED_BY VARCHAR(30) NOT NULL,
  RECORD_CREATED_DATE DATE NOT NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NOT NULL,
  RECORD_MODIFIED_DATE DATE NOT NULL);

/****** Object:  Table CISS.CISS_STD_RPTDAYOFWEEKTYPE    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE CISS.CISS_STD_RPTDAYOFWEEKTYPE(
  CISS_STD_RPTDAYOFWEEKTYPE_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  CODE VARCHAR(50) NOT NULL,
  NAME VARCHAR(80) NULL,
  DESCRIPTION VARCHAR(250) NULL,
  SORT_ORDER NUMBER(6, 0) NULL,
  ISACTIVE char(1) NOT NULL,
  EFFECTIVEDATE DATE NULL,
  EXPIRATIONDATE DATE NULL,
  RECORD_CREATED_BY VARCHAR(30) NOT NULL,
  RECORD_CREATED_DATE DATE NOT NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NOT NULL,
  RECORD_MODIFIED_DATE DATE NOT NULL);

/****** Object:  Table CISS.CISS_STD_RPTMONTHLIST    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE CISS.CISS_STD_RPTMONTHLIST(
  CISS_STD_RPTMONTHLIST_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  CODE VARCHAR(50) NOT NULL,
  NAME VARCHAR(80) NULL,
  DESCRIPTION VARCHAR(250) NULL,
  SORT_ORDER NUMBER(6, 0) NULL,
  ISACTIVE char(1) NOT NULL,
  EFFECTIVEDATE DATE NULL,
  EXPIRATIONDATE DATE NULL,
  RECORD_CREATED_BY VARCHAR(30) NOT NULL,
  RECORD_CREATED_DATE DATE NOT NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NOT NULL,
  RECORD_MODIFIED_DATE DATE NOT NULL);



/****** Object:  Table CISS.CISS_STD_RPTOUTFORMATTYPE    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE CISS.CISS_STD_RPTOUTFORMATTYPE(
  CISS_STD_RPTOUTFORMATTYPE_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  CODE VARCHAR(50) NOT NULL,
  NAME VARCHAR(80) NULL,
  DESCRIPTION VARCHAR(250) NULL,
  SORT_ORDER NUMBER(6, 0) NULL,
  ISACTIVE char(1) NOT NULL,
  EFFECTIVEDATE DATE NULL,
  EXPIRATIONDATE DATE NULL,
  RECORD_CREATED_BY VARCHAR(30) NOT NULL,
  RECORD_CREATED_DATE DATE NOT NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NOT NULL,
  RECORD_MODIFIED_DATE DATE NOT NULL);


/****** Object:  Table CISS.CISS_STD_RPTPERIODTYPE    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE CISS.CISS_STD_RPTPERIODTYPE(
  CISS_STD_RPTPERIODTYPE_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  CODE VARCHAR(50) NOT NULL,
  NAME VARCHAR(80) NULL,
  DESCRIPTION VARCHAR(250) NULL,
  SORT_ORDER NUMBER(6, 0) NULL,
  ISACTIVE char(1) NOT NULL,
  EFFECTIVEDATE DATE NULL,
  EXPIRATIONDATE DATE NULL,
  RECORD_CREATED_BY VARCHAR(30) NOT NULL,
  RECORD_CREATED_DATE DATE NOT NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NOT NULL,
  RECORD_MODIFIED_DATE DATE NOT NULL);




/****** Object:  Table CISS.CISS_STD_RPTQUARTERLIST    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE CISS.CISS_STD_RPTQUARTERLIST(
  CISS_STD_RPTQUARTERLIST_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  CODE VARCHAR(50) NOT NULL,
  NAME VARCHAR(80) NULL,
  DESCRIPTION VARCHAR(250) NULL,
  SORT_ORDER NUMBER(6, 0) NULL,
  ISACTIVE char(1) NOT NULL,
  EFFECTIVEDATE DATE NULL,
  EXPIRATIONDATE DATE NULL,
  RECORD_CREATED_BY VARCHAR(30) NOT NULL,
  RECORD_CREATED_DATE DATE NOT NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NOT NULL,
  RECORD_MODIFIED_DATE DATE NOT NULL);


/****** Object:  Table CISS.CISS_STD_RPTRUNFREQUENCYTYPE    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE CISS.CISS_STD_RPTRUNFREQUENCYTYPE(
  CISS_STD_RPTRUNFREQTYPE_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  CODE VARCHAR(50) NOT NULL,
  NAME VARCHAR(80) NULL,
  DESCRIPTION VARCHAR(250) NULL,
  SORT_ORDER NUMBER(6, 0) NULL,
  ISACTIVE char(1) NOT NULL,
  EFFECTIVEDATE DATE NULL,
  EXPIRATIONDATE DATE NULL,
  RECORD_CREATED_BY VARCHAR(30) NOT NULL,
  RECORD_CREATED_DATE DATE NOT NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NOT NULL,
  RECORD_MODIFIED_DATE DATE NOT NULL);


/****** Object:  Table CISS.CISS_STD_RPTSCHEDULETYPE    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE CISS.CISS_STD_RPTSCHEDULETYPE(
  CISS_STD_RPTSCHEDULETYPE_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  CODE VARCHAR(50) NOT NULL,
  NAME VARCHAR(80) NULL,
  DESCRIPTION VARCHAR(250) NULL,
  SORT_ORDER NUMBER(6, 0) NULL,
  ISACTIVE char(1) NOT NULL,
  EFFECTIVEDATE DATE NULL,
  EXPIRATIONDATE DATE NULL,
  RECORD_CREATED_BY VARCHAR(30) NOT NULL,
  RECORD_CREATED_DATE DATE NOT NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NOT NULL,
  RECORD_MODIFIED_DATE DATE NOT NULL);

/****** Object:  Table CISS.CISS_STD_RPTWEEKOFMONTHTYPE    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE CISS.CISS_STD_RPTWEEKOFMONTHTYPE(
  CISS_STD_RPTWEEKOFMONTHTYPE_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  CODE VARCHAR(50) NOT NULL,
  NAME VARCHAR(80) NULL,
  DESCRIPTION VARCHAR(250) NULL,
  SORT_ORDER NUMBER(6, 0) NULL,
  ISACTIVE char(1) NOT NULL,
  EFFECTIVEDATE DATE NULL,
  EXPIRATIONDATE DATE NULL,
  RECORD_CREATED_BY VARCHAR(30) NOT NULL,
  RECORD_CREATED_DATE DATE NOT NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NOT NULL,
  RECORD_MODIFIED_DATE DATE NOT NULL);


/****** Object:  Table CISS.DUTY_STATION    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE CISS.DUTY_STATION(
  DUTY_STATION_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  APP_USER_ID NUMBER(20, 0) NULL,
  INSTITUTION_ID NUMBER(20, 0) NULL,
  VISTA_ID VARCHAR(80) NULL,
  RECORD_CREATED_BY VARCHAR(30) NOT NULL,
  RECORD_CREATED_DATE DATE NOT NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NOT NULL,
  RECORD_MODIFIED_DATE DATE NOT NULL,
  RECORD_MODIFIED_COUNT NUMBER(10, 0) NOT NULL,
  RECORD_CREATED_DATE_TZ VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE_TZ VARCHAR(30) NULL);



/****** Object:  Table CISS.DUTY_STATION_H    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE CISS.DUTY_STATION_H(
  DUTY_STATION_H_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  TRANSACTION_TYPE_CODE char(1) NULL,
  DUTY_STATION_id NUMBER(20, 0) NOT NULL UNIQUE,
  APP_USER_ID NUMBER(20, 0) NULL,
  INSTITUTION_ID NUMBER(20, 0) NULL,
  VISTA_ID VARCHAR(80) NULL,
  RECORD_CREATED_BY VARCHAR(30) NOT NULL,
  RECORD_CREATED_DATE DATE NOT NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NOT NULL,
  RECORD_MODIFIED_DATE DATE NOT NULL,
  RECORD_MODIFIED_COUNT NUMBER(10, 0) NOT NULL,
  RECORD_CREATED_DATE_TZ VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE_TZ VARCHAR(30) NULL,
  HISTORY_RECORD_CREATE_DATE DATE NOT NULL);



/****** Object:  Table CISS.EXCEPTION_LOG    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE CISS.EXCEPTION_LOG(
  EXCEPTION_LOG_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  VSS_LOAD_ERRORS_ID NUMBER(20, 0) NULL,
  PAID_LOAD_ERRORS_ID NUMBER(20, 0) NULL,
  APPLICATION_NAME VARCHAR(30) NULL,
  SEVERITY_TYPE VARCHAR(20) NULL,
  EXCEPTION_DETAIL VARCHAR(4000) NULL,
  EXCEPTION_DETAIL_EXT VARCHAR(4000) NULL,
  RECORD_CREATED_BY VARCHAR(30) NOT NULL,
  RECORD_CREATED_DATE DATE NOT NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NOT NULL,
  RECORD_MODIFIED_DATE DATE NOT NULL,
  RECORD_MODIFIED_COUNT NUMBER(10, 0) NOT NULL,
  RECORD_CREATED_DATE_TZ VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE_TZ VARCHAR(30) NULL,
  PATIENT_IMPORT_LOAD_ERRORS_ID NUMBER(20, 0) NULL);




/****** Object:  Table CISS.JOB_CONFIG    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE CISS.JOB_CONFIG(
  JOB_CONFIG_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  CISS_STD_APPLICATION_ID NUMBER(20, 0) NULL,
  JOB_NAME VARCHAR(80) NULL,
  JOB_GROUP_NAME VARCHAR(80) NULL,
  EMAIL_DISTRIBUTION_LIST VARCHAR(4000) NULL,
  RECORD_CREATED_BY VARCHAR(30) NULL,
  RECORD_CREATED_DATE DATE NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE DATE NULL,
  RECORD_MODIFIED_COUNT NUMBER(10, 0) NULL,
  RECORD_CREATED_DATE_TZ VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE_TZ VARCHAR(30) NULL);




/****** Object:  Table CISS.JOB_CONFIG_H    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE CISS.JOB_CONFIG_H(
  JOB_CONFIG_H_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  TRANSACTION_TYPE_CODE char(1) NULL,
  JOB_CONFIG_id NUMBER(20, 0) NOT NULL UNIQUE,
  CISS_STD_APPLICATION_ID NUMBER(20, 0) NULL,
  JOB_NAME VARCHAR(80) NULL,
  JOB_GROUP_NAME VARCHAR(80) NULL,
  EMAIL_DISTRIBUTION_LIST VARCHAR(4000) NULL,
  RECORD_CREATED_BY VARCHAR(30) NULL,
  RECORD_CREATED_DATE DATE NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE DATE NULL,
  RECORD_MODIFIED_COUNT NUMBER(10, 0) NULL,
  RECORD_CREATED_DATE_TZ VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE_TZ VARCHAR(30) NULL,
  HISTORY_RECORD_CREATE_DATE DATE NOT NULL);



/****** Object:  Table CISS.JOB_RESULT    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE CISS.JOB_RESULT(
  JOB_RESULT_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  CISS_STD_APPLICATION_ID NUMBER(20, 0) NULL,
  JOB_NAME VARCHAR(80) NULL,
  JOB_GROUP_NAME VARCHAR(80) NULL,
  JOB_STATUS_CODE VARCHAR(50) NULL,
  JOB_CONTEXT VARCHAR(250) NULL,
  JOB_STATISTICS VARCHAR(4000) NULL,
  JOB_START_DATE DATE NULL,
  JOB_END_DATE DATE NULL,
  RECORD_CREATED_BY VARCHAR(30) NULL,
  RECORD_CREATED_DATE DATE NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE DATE NULL,
  RECORD_MODIFIED_COUNT NUMBER(10, 0) NULL,
  RECORD_CREATED_DATE_TZ VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE_TZ VARCHAR(30) NULL);



/****** Object:  Table CISS.JOB_RESULT_H    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE CISS.JOB_RESULT_H(
  JOB_RESULT_H_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  TRANSACTION_TYPE_CODE char(1) NULL,
  JOB_RESULT_id NUMBER(20, 0) NOT NULL UNIQUE,
  CISS_STD_APPLICATION_ID NUMBER(20, 0) NULL,
  JOB_NAME VARCHAR(80) NULL,
  JOB_GROUP_NAME VARCHAR(80) NULL,
  JOB_STATUS_CODE VARCHAR(50) NULL,
  JOB_CONTEXT VARCHAR(250) NULL,
  JOB_STATISTICS VARCHAR(4000) NULL,
  JOB_START_DATE DATE NULL,
  JOB_END_DATE DATE NULL,
  RECORD_CREATED_BY VARCHAR(30) NULL,
  RECORD_CREATED_DATE DATE NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE DATE NULL,
  RECORD_MODIFIED_COUNT NUMBER(10, 0) NULL,
  RECORD_CREATED_DATE_TZ VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE_TZ VARCHAR(30) NULL,
  HISTORY_RECORD_CREATE_DATE DATE NOT NULL);



/****** Object:  Table CISS.OCC_SER_TRANSFORM    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE CISS.OCC_SER_TRANSFORM(
  OLD_CODE VARCHAR(20) NOT NULL,
  NEW_CODE VARCHAR(20) NOT NULL);




/****** Object:  Table CISS.PAID_LOAD    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE CISS.PAID_LOAD(
  SSN VARCHAR(9) NULL,
  PSEUDO_SSN VARCHAR(9) NULL,
  STATION VARCHAR(3) NULL,
  DUTY_STATION VARCHAR(2) NULL,
  WORK_LOCATION VARCHAR(20) NULL,
  LAST_NAME VARCHAR(25) NULL,
  FIRST_NAME VARCHAR(35) NULL,
  MIDDLE_NAME VARCHAR(25) NULL,
  NAME_TITLE VARCHAR(8) NULL,
  OCCUPATION_SERIES VARCHAR(8) NULL,
  JOB_TITLE VARCHAR(50) NULL,
  ACCESSION_DATE DATE NULL,
  SEPARATION_DATE DATE NULL,
  ADDRESS_LINE1 VARCHAR(35) NULL,
  ADDRESS_LINE2 VARCHAR(30) NULL,
  ADDRESS_LINE3 VARCHAR(30) NULL,
  CITY VARCHAR(15) NULL,
  STATE VARCHAR(2) NULL,
  ZIPCODE VARCHAR(10) NULL,
  SEX char(1) NULL,
  DATE_OF_BIRTH DATE NULL,
  EMAIL_ADDRESS VARCHAR(78) NULL,
  COST_CENTER VARCHAR(8) NULL,
  LAST_CHAR char(1) NULL,
  PAID_LOAD_ID NUMBER PRIMARY KEY NOT NULL);




/****** Object:  Table CISS.PAID_LOAD_ERRORS    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE CISS.PAID_LOAD_ERRORS(
  PAID_LOAD_ERRORS_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  PAID_LOAD_LOG_ID NUMBER(20, 0) NULL,
  ERRORS VARCHAR(100) NULL,
  FAILED_DATA VARCHAR(100) NULL,
  RECORD_CREATED_BY VARCHAR(30) NOT NULL,
  RECORD_CREATED_DATE DATE NOT NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NOT NULL,
  RECORD_MODIFIED_DATE DATE NOT NULL,
  RECORD_MODIFIED_COUNT NUMBER(10, 0) NOT NULL,
  RECORD_CREATED_DATE_TZ VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE_TZ VARCHAR(30) NULL);



/****** Object:  Table CISS.PAID_LOAD_LOG    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE CISS.PAID_LOAD_LOG(
  PAID_LOAD_LOG_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  LOAD_START_DATE DATE NULL,
  LOAD_COMPLETE_DATE DATE NULL,
  PROCESS_START_DATE DATE NULL,
  PROCESS_COMPLETE_DATE DATE NULL,
  NOTES VARCHAR(1024) NULL,
  RECORD_CREATED_BY VARCHAR(30) NOT NULL,
  RECORD_CREATED_DATE DATE NOT NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NOT NULL,
  RECORD_MODIFIED_DATE DATE NOT NULL,
  RECORD_MODIFIED_COUNT NUMBER(10, 0) NOT NULL,
  RECORD_CREATED_DATE_TZ VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE_TZ VARCHAR(30) NULL);



/****** Object:  Table CISS.PERMISSION    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE CISS.PERMISSION(
  PERMISSION_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  CISS_STD_APPLICATION_ID NUMBER(20, 0) NULL,
  PERMISSION_NAME VARCHAR(100) NOT NULL,
  DESCRIPTION VARCHAR(250) NULL,
  ACTIVE_DATE DATE NULL,
  ACTIVE_DATE_TZ VARCHAR(30) NULL,
  INACTIVE_IND NUMBER(1, 0) NULL,
  INACTIVE_DATE DATE NULL,
  INACTIVE_DATE_TZ VARCHAR(30) NULL,
  RECORD_CREATED_BY VARCHAR(30) NOT NULL,
  RECORD_CREATED_DATE DATE NOT NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NOT NULL,
  RECORD_MODIFIED_DATE DATE NOT NULL,
  RECORD_MODIFIED_COUNT NUMBER(10, 0) NOT NULL,
  RECORD_CREATED_DATE_TZ VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE_TZ VARCHAR(30) NULL);


/****** Object:  Table CISS.PERMISSION_H    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE CISS.PERMISSION_H(
  PERMISSION_H_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  TRANSACTION_TYPE_CODE char(1) NULL,
  PERMISSION_id NUMBER(20, 0) NOT NULL UNIQUE,
  CISS_STD_APPLICATION_ID NUMBER(20, 0) NULL,
  PERMISSION_NAME VARCHAR(100) NOT NULL,
  DESCRIPTION VARCHAR(250) NULL,
  ACTIVE_DATE DATE NULL,
  ACTIVE_DATE_TZ VARCHAR(30) NULL,
  INACTIVE_IND NUMBER(1, 0) NULL,
  INACTIVE_DATE DATE NULL,
  INACTIVE_DATE_TZ VARCHAR(30) NULL,
  RECORD_CREATED_BY VARCHAR(30) NOT NULL,
  RECORD_CREATED_DATE DATE NOT NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NOT NULL,
  RECORD_MODIFIED_DATE DATE NOT NULL,
  RECORD_MODIFIED_COUNT NUMBER(10, 0) NOT NULL,
  RECORD_CREATED_DATE_TZ VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE_TZ VARCHAR(30) NULL,
  HISTORY_RECORD_CREATE_DATE DATE NOT NULL);


/****** Object:  Table CISS.ROLE    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE CISS.ROLE(
  ROLE_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  CISS_STD_APPLICATION_ID NUMBER(20, 0) NULL,
  ROLE_NAME VARCHAR(50) NOT NULL,
  DESCRIPTION VARCHAR(250) NULL,
  SORT_ORDER NUMBER(6, 0) NULL,
  ACTIVE_DATE DATE NULL,
  ACTIVE_DATE_TZ VARCHAR(30) NULL,
  INACTIVE_IND NUMBER(1, 0) NOT NULL,
  INACTIVE_DATE DATE NULL,
  INACTIVE_DATE_TZ VARCHAR(30) NULL,
  RECORD_CREATED_BY VARCHAR(30) NOT NULL,
  RECORD_CREATED_DATE DATE NOT NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NOT NULL,
  RECORD_MODIFIED_DATE DATE NOT NULL,
  RECORD_MODIFIED_COUNT NUMBER(10, 0) NOT NULL,
  RECORD_CREATED_DATE_TZ VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE_TZ VARCHAR(30) NULL);


/****** Object:  Table CISS.ROLE_GRANTS_WHITELIST    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE CISS.ROLE_GRANTS_WHITELIST(
  ROLE_GRANTS_WHITELIST_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  ROLE_id NUMBER(20, 0) NOT NULL UNIQUE,
  GRANTABLE_ROLE_id NUMBER(20, 0) NOT NULL UNIQUE,
  INACTIVE_IND NUMBER(1, 0) NOT NULL,
  INACTIVE_DATE DATE NULL,
  INACTIVE_DATE_TZ VARCHAR(30) NULL,
  RECORD_CREATED_BY VARCHAR(30) NOT NULL,
  RECORD_CREATED_DATE DATE NOT NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NOT NULL,
  RECORD_MODIFIED_DATE DATE NOT NULL,
  RECORD_MODIFIED_COUNT NUMBER(10, 0) NOT NULL,
  RECORD_CREATED_DATE_TZ VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE_TZ VARCHAR(30) NULL);



/****** Object:  Table CISS.ROLE_H    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE CISS.ROLE_H(
  ROLE_H_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  TRANSACTION_TYPE_CODE char(1) NULL,
  ROLE_id NUMBER(20, 0) NOT NULL UNIQUE,
  CISS_STD_APPLICATION_ID NUMBER(20, 0) NULL,
  ROLE_NAME VARCHAR(50) NOT NULL,
  DESCRIPTION VARCHAR(250) NULL,
  SORT_ORDER NUMBER(6, 0) NULL,
  ACTIVE_DATE DATE NULL,
  ACTIVE_DATE_TZ VARCHAR(30) NULL,
  INACTIVE_IND NUMBER(1, 0) NOT NULL,
  INACTIVE_DATE DATE NULL,
  INACTIVE_DATE_TZ VARCHAR(30) NULL,
  RECORD_CREATED_BY VARCHAR(30) NOT NULL,
  RECORD_CREATED_DATE DATE NOT NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NOT NULL,
  RECORD_MODIFIED_DATE DATE NOT NULL,
  RECORD_MODIFIED_COUNT NUMBER(10, 0) NOT NULL,
  RECORD_CREATED_DATE_TZ VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE_TZ VARCHAR(30) NULL,
  HISTORY_RECORD_CREATE_DATE DATE NOT NULL);


/****** Object:  Table CISS.ROLE_PERMISSION    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE CISS.ROLE_PERMISSION(
  ROLE_PERMISSION_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  PERMISSION_ID NUMBER(20, 0) NULL,
  ROLE_ID NUMBER(20, 0) NULL,
  INACTIVE_IND NUMBER(1, 0) NOT NULL,
  INACTIVE_DATE DATE NULL,
  INACTIVE_DATE_TZ VARCHAR(30) NULL,
  RECORD_CREATED_BY VARCHAR(30) NOT NULL,
  RECORD_CREATED_DATE DATE NOT NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NOT NULL,
  RECORD_MODIFIED_DATE DATE NOT NULL,
  RECORD_MODIFIED_COUNT NUMBER(10, 0) NOT NULL,
  RECORD_CREATED_DATE_TZ VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE_TZ VARCHAR(30) NULL);


/****** Object:  Table CISS.ROLE_PERMISSION_H    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE CISS.ROLE_PERMISSION_H(
  ROLE_PERMISSION_H_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  TRANSACTION_TYPE_CODE char(1) NULL,
  ROLE_PERMISSION_id NUMBER(20, 0) NOT NULL UNIQUE,
  PERMISSION_ID NUMBER(20, 0) NULL,
  ROLE_ID NUMBER(20, 0) NULL,
  INACTIVE_IND NUMBER(1, 0) NOT NULL,
  INACTIVE_DATE DATE NULL,
  INACTIVE_DATE_TZ VARCHAR(30) NULL,
  RECORD_CREATED_BY VARCHAR(30) NOT NULL,
  RECORD_CREATED_DATE DATE NOT NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NOT NULL,
  RECORD_MODIFIED_DATE DATE NOT NULL,
  RECORD_MODIFIED_COUNT NUMBER(10, 0) NOT NULL,
  RECORD_CREATED_DATE_TZ VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE_TZ VARCHAR(30) NULL,
  HISTORY_RECORD_CREATE_DATE DATE NOT NULL);


/****** Object:  Table CISS.TEMPLATE    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE CISS.TEMPLATE(
  TEMPLATE_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  TEMPLATE_NAME VARCHAR(250) NOT NULL,
  TEMPLATE_BODY VARCHAR(100) NOT NULL,
  RECORD_CREATED_BY VARCHAR(30) NOT NULL,
  RECORD_CREATED_DATE DATE NOT NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NOT NULL,
  RECORD_MODIFIED_DATE DATE NOT NULL,
  RECORD_MODIFIED_COUNT NUMBER(10, 0) NOT NULL);


/****** Object:  Table CISS.UNIQUE_IDENTIFIER    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE CISS.UNIQUE_IDENTIFIER(
  UNIQUE_IDENTIFIER_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  CISS_STD_APPLICATION_ID NUMBER(20, 0) NULL,
  SEQUENCE_NUMBER NUMBER(20, 0) NULL,
  RECORD_CREATED_BY VARCHAR(30) NOT NULL,
  RECORD_CREATED_DATE DATE NOT NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NOT NULL,
  RECORD_MODIFIED_DATE DATE NOT NULL,
  RECORD_MODIFIED_COUNT NUMBER(10, 0) NOT NULL,
  RECORD_CREATED_DATE_TZ VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE_TZ VARCHAR(30) NULL);


/****** Object:  Table CISS.VISTA_ACCESS_AUDIT_LOG    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE CISS.VISTA_ACCESS_AUDIT_LOG(
  VISTA_ACCESS_AUDIT_LOG_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  STATION_NUMBER VARCHAR(7) NULL,
  VISTA_DUZ VARCHAR(50) NULL,
  VISTA_FULL_NAME VARCHAR(80) NULL,
  VISTA_ACCESS_STATUS VARCHAR(250) NULL,
  ACTION VARCHAR(20) NULL,
  RECORD_CREATED_BY VARCHAR(30) NOT NULL,
  RECORD_CREATED_DATE DATE NOT NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NOT NULL,
  RECORD_MODIFIED_DATE DATE NOT NULL,
  RECORD_MODIFIED_COUNT NUMBER(10, 0) NOT NULL,
  RECORD_CREATED_DATE_TZ VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE_TZ VARCHAR(30) NULL);


/****** Object:  Table CISS.VSS_LOAD    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE CISS.VSS_LOAD(
  VSS_ID NUMBER NULL,
  entrydate DATE NULL,
  terminationdate DATE NULL,
  stationnumber VARCHAR(7) NULL,
  Nameofinstitution VARCHAR(30) NULL,
  firstname VARCHAR(30) NULL,
  lastname VARCHAR(30) NULL,
  middlename VARCHAR(20) NULL,
  dateofbirth DATE NULL,
  sex VARCHAR(1) NULL,
  streetaddress1 VARCHAR(35) NULL,
  streetaddress2 VARCHAR(35) NULL,
  city VARCHAR(30) NULL,
  state char(2) NULL,
  zipcode VARCHAR(10) NULL,
  telephone VARCHAR(30) NULL,
  emailaddress VARCHAR(50) NULL,
  kinsname VARCHAR(30) NULL,
  kintelephone VARCHAR(30) NULL,
  isvaemployee VARCHAR(1) NULL);


/****** Object:  Table CISS.VSS_LOAD_LOG    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE CISS.VSS_LOAD_LOG(
  VSS_LOAD_LOG_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  LOAD_START_DATE DATE NULL,
  LOAD_COMPLETE_DATE DATE NULL,
  PROCESS_START_DATE DATE NULL,
  PROCESS_COMPLETE_DATE DATE NULL,
  NOTES VARCHAR(1024) NULL,
  RECORD_CREATED_BY VARCHAR(30) NOT NULL,
  RECORD_CREATED_DATE DATE NOT NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NOT NULL,
  RECORD_MODIFIED_DATE DATE NOT NULL,
  RECORD_MODIFIED_COUNT NUMBER(10, 0) NOT NULL,
  RECORD_CREATED_DATE_TZ VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE_TZ VARCHAR(30) NULL);



/****** Object:  Table CISS.WL_LLR_CISS_ADMINSERVER    Script Date: 8/20/2015 6:11:42 PM ******/




CREATE TABLE CISS.WL_LLR_CISS_ADMINSERVER(
  XIDSTR varchar(40) NOT NULL PRIMARY KEY,
  POOLNAMESTR varchar(64) NULL,
  RECORDSTR VARCHAR(1000) NULL);

/****** Object:  Table CISS_EXT.LLR_Srv1_WL    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE CISS_EXT.LLR_Srv1_WL(
  XIDSTR VARCHAR(40) NOT NULL PRIMARY KEY,
  POOLNAMESTR VARCHAR(64) NULL,
  RECORDSTR VARCHAR(1000) NULL);



/****** Object:  Table CISS_EXT.LLR_Srv2_WL    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE CISS_EXT.LLR_Srv2_WL(
  XIDSTR VARCHAR(40) NOT NULL PRIMARY KEY,
  POOLNAMESTR VARCHAR(64) NULL,
  RECORDSTR VARCHAR(1000) NULL);



/****** Object:  Table CISS_EXT.LLR_Srv3_WL    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE CISS_EXT.LLR_Srv3_WL(
  XIDSTR VARCHAR(40) NOT NULL PRIMARY KEY,
  POOLNAMESTR VARCHAR(64) NULL,
  RECORDSTR VARCHAR(1000) NULL);



/****** Object:  Table CISS_EXT.LLR_Srv4_WL    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE CISS_EXT.LLR_Srv4_WL(
  XIDSTR VARCHAR(40) NOT NULL PRIMARY KEY,
  POOLNAMESTR VARCHAR(64) NULL,
  RECORDSTR VARCHAR(1000) NULL);


/****** Object:  Table PCMM.APP_USER_VISTA_INFO    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE PCMM.APP_USER_VISTA_INFO(
  APP_USER_VISTA_INFO_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  APP_USER_id NUMBER(20, 0) NOT NULL UNIQUE,
  VA_INSTITUTION_id NUMBER(20, 0) NOT NULL UNIQUE,
  VISTA_ID VARCHAR(20) NOT NULL,
  RECORD_CREATED_BY VARCHAR(30) NOT NULL,
  RECORD_CREATED_DATE DATE NOT NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NOT NULL,
  RECORD_MODIFIED_DATE DATE NOT NULL,
  RECORD_MODIFIED_COUNT NUMBER(10, 0) NOT NULL,
  RECORD_CREATED_DATE_TZ VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE_TZ VARCHAR(30) NULL);




/****** Object:  Table PCMM.AUDIT_LOG    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE PCMM.AUDIT_LOG(
  AUDIT_LOG_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  APP_USER_ID VARCHAR(512) NOT NULL,
  EXECUTION_DATE DATE NOT NULL,
  METHOD_NAME VARCHAR(512) NOT NULL,
  PARAMETER_VALUES VARCHAR(100) NULL,
  RECORD_CREATED_BY VARCHAR(30) NOT NULL,
  RECORD_CREATED_DATE DATE NOT NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NOT NULL,
  RECORD_MODIFIED_DATE DATE NOT NULL);




/****** Object:  Table PCMM.AUTO_INACTIVATION_ENCOUNTERS    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE PCMM.AUTO_INACTIVATION_ENCOUNTERS(
  AUTO_INACTIVATION_ENCOUNTER_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  USE_FOR_BATCH NUMBER NOT NULL,
  STA3N NUMBER NOT NULL,
  VISIT_DATE DATE NOT NULL,
  PATIENT_IEN VARCHAR(50) NOT NULL,
  STAFF_IEN VARCHAR(50) NOT NULL);




/****** Object:  Table PCMM.FACILITY_ROOM    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE PCMM.FACILITY_ROOM(
  FACILITY_ROOM_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  PCM_STD_FACILITY_ROOM_TYPE_ID NUMBER(20, 0) NULL,
  VA_FACILITY_ID NUMBER(20, 0) NULL,
  ROOM_NAME VARCHAR(30) NULL,
  ROOM_NUMBER VARCHAR(20) NULL,
  ROOM_DESCRIPTION VARCHAR(250) NULL,
  EXPECTED_EXAM_FTEE NUMBER(5, 2) NOT NULL,
  EXPECTED_INTERVIEW_FTEE NUMBER(5, 2) NOT NULL,
  ROOM_ACTIVE_IND VARCHAR(1) NOT NULL,
  RECORD_CREATED_BY VARCHAR(30) NULL,
  RECORD_CREATED_DATE DATE NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE DATE NULL,
  RECORD_MODIFIED_COUNT NUMBER(10, 0) NOT NULL,
  RECORD_CREATED_DATE_TZ VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE_TZ VARCHAR(30) NULL);




/****** Object:  Table PCMM.HL7_MSG_CTRL_ID    Script Date: 8/20/2015 6:11:42 PM ******/




CREATE TABLE PCMM.HL7_MSG_CTRL_ID(
  ID NUMBER PRIMARY KEY NOT NULL);

/****** Object:  Table PCMM.HZC_STORE_PATIENT_INBOUND_MSGS    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE PCMM.HZC_STORE_PATIENT_INBOUND_MSGS(
  KEY VARCHAR(100) NOT NULL PRIMARY KEY,
  VALUE VARCHAR(100) NOT NULL);



/****** Object:  Table PCMM.MODEL_TEAM    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE PCMM.MODEL_TEAM(
  MODEL_TEAM_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  VA_INSTITUTION_ID NUMBER(20, 0) NULL,
  PCM_STD_TEAM_CARE_TYPE_ID NUMBER(20, 0) NULL,
  PCM_STD_TEAM_FOCUS_ID NUMBER(20, 0) NULL,
  RECORD_CREATED_BY VARCHAR(30) NULL,
  RECORD_CREATED_DATE DATE NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE DATE NULL,
  RECORD_MODIFIED_COUNT NUMBER(10, 0) NOT NULL,
  RECORD_CREATED_DATE_TZ VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE_TZ VARCHAR(30) NULL);



/****** Object:  Table PCMM.MODEL_TEAM_POSITION    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE PCMM.MODEL_TEAM_POSITION(
  MODEL_TEAM_POSITION_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  PCM_STD_TEAM_ROLE_ID NUMBER(20, 0) NULL,
  MODEL_TEAM_ID NUMBER(20, 0) NULL,
  REQUIRED_IND VARCHAR(1) NOT NULL,
  RECORD_CREATED_BY VARCHAR(30) NULL,
  RECORD_CREATED_DATE DATE NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE DATE NULL,
  RECORD_MODIFIED_COUNT NUMBER(10, 0) NOT NULL,
  RECORD_CREATED_DATE_TZ VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE_TZ VARCHAR(30) NULL);




/****** Object:  Table PCMM.MULTI_PCP    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE PCMM.MULTI_PCP(
  MULTI_PCP_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  TEAM_ID NUMBER(20, 0) NULL,
  PCM_STD_MULTIPCP_STAT_RESON_ID NUMBER(20, 0) NULL,
  PCM_STD_MULTIPCP_STATUS_id NUMBER(20, 0) NOT NULL UNIQUE,
  SOURCE_STATION_id NUMBER(20, 0) NOT NULL UNIQUE,
  DESTINATION_STATION_id NUMBER(20, 0) NOT NULL UNIQUE,
  PCMM_PATIENT_id NUMBER(20, 0) NOT NULL UNIQUE,
  REQUEST_APPROVED_DATE DATE NULL,
  EFFECTIVE_DATE DATE NULL,
  COMMENTS VARCHAR(250) NULL,
  PCM_STD_MULTIPCP_CANCEL_RSN_ID NUMBER(20, 0) NULL,
  CANCEL_COMMENTS VARCHAR(250) NULL,
  RECORD_CREATED_BY VARCHAR(30) NULL,
  RECORD_CREATED_DATE DATE NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE DATE NULL,
  RECORD_MODIFIED_COUNT NUMBER(10, 0) NOT NULL,
  RECORD_CREATED_DATE_TZ VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE_TZ VARCHAR(30) NULL);



/****** Object:  Table PCMM.MULTI_PCP_APPROVALS    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE PCMM.MULTI_PCP_APPROVALS(
  MULTI_PCP_APPROVALS_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  MULTI_PCP_id NUMBER(20, 0) NOT NULL UNIQUE,
  APPROVING_STATION_id NUMBER(20, 0) NOT NULL UNIQUE,
  TVC_APPROVER_ID NUMBER(20, 0) NULL,
  CLINICAL_APPROVER_ID NUMBER(20, 0) NULL,
  CLINICAL_APPROVER_STAFF_ID NUMBER(20, 0) NULL,
  APPROVAL_DECISION_DT DATE NULL,
  TEAM_PATIENT_ASSIGN_ID NUMBER(20, 0) NULL,
  APPROVED char(1) NULL,
  COMMENTS VARCHAR(250) NULL,
  RECORD_CREATED_BY VARCHAR(30) NULL,
  RECORD_CREATED_DATE DATE NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE DATE NULL,
  RECORD_MODIFIED_COUNT NUMBER(10, 0) NOT NULL,
  RECORD_CREATED_DATE_TZ VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE_TZ VARCHAR(30) NULL);




/****** Object:  Table PCMM.MULTI_PCP_H    Script Date: 8/20/2015 6:11:42 PM ******/





CREATE TABLE PCMM.MULTI_PCP_H(
  MULTI_PCP_H_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  TRANSACTION_TYPE_CODE VARCHAR(1) NULL,
  MULTI_PCP_id NUMBER(20, 0) NOT NULL UNIQUE,
  TEAM_ID NUMBER(20, 0) NULL,
  PCM_STD_MULTIPCP_STATUS_RSN_ID NUMBER(20, 0) NULL,
  PCM_STD_MULTIPCP_STATUS_ID NUMBER(20, 0) NULL,
  SOURCE_STATION_ID NUMBER(20, 0) NULL,
  DESTINATION_STATION_ID NUMBER(20, 0) NULL,
  PCMM_PATIENT_ID NUMBER(20, 0) NULL,
  REQUEST_APPROVED_DATE DATE NULL,
  EFFECTIVE_DATE DATE NULL,
  COMMENTS VARCHAR(250) NULL,
  PCM_STD_MULTIPCP_CANCEL_RSN_ID NUMBER(20, 0) NULL,
  CANCEL_COMMENTS VARCHAR(250) NULL,
  RECORD_CREATED_BY VARCHAR(30) NULL,
  RECORD_CREATED_DATE DATE NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE DATE NULL,
  RECORD_MODIFIED_COUNT NUMBER(10, 0) NOT NULL,
  RECORD_CREATED_DATE_TZ VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE_TZ VARCHAR(30) NULL,
  HISTORY_RECORD_CREATE_DATE DATE NOT NULL);




/****** Object:  Table PCMM.NON_VA_PRACTICE    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE PCMM.NON_VA_PRACTICE(
  NON_VA_PRACTICE_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  name VARCHAR(80) NOT NULL UNIQUE,
  ADDRESS_LINE1 VARCHAR(100) NOT NULL,
  ADDRESS_LINE2 VARCHAR(100) NULL,
  ADDRESS_LINE3 VARCHAR(100) NULL,
  CITY VARCHAR(50) NULL,
  STATE VARCHAR(2) NULL,
  ZIP_CODE VARCHAR(12) NULL,
  EMAIL_ADDRESS VARCHAR(128) NULL,
  PHONE_NUMBER VARCHAR(30) NULL,
  FAX_NUMBER VARCHAR(30) NULL,
  RECORD_CREATED_BY VARCHAR(30) NULL,
  RECORD_CREATED_DATE DATE NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE DATE NULL,
  RECORD_MODIFIED_COUNT NUMBER(10, 0) NOT NULL,
  RECORD_CREATED_DATE_TZ VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE_TZ VARCHAR(30) NULL);




/****** Object:  Table PCMM.NON_VA_PRACTICE_H    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE PCMM.NON_VA_PRACTICE_H(
  NON_VA_PRACTICE_H_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  TRANSACTION_TYPE_CODE VARCHAR(1) NULL,
  NON_VA_PRACTICE_ID NUMBER(20, 0) NULL,
  NAME VARCHAR(80) NULL,
  ADDRESS_LINE1 VARCHAR(100) NULL,
  ADDRESS_LINE2 VARCHAR(100) NULL,
  ADDRESS_LINE3 VARCHAR(100) NULL,
  CITY VARCHAR(50) NULL,
  STATE VARCHAR(2) NULL,
  ZIP_CODE VARCHAR(12) NULL,
  EMAIL_ADDRESS VARCHAR(128) NULL,
  PHONE_NUMBER VARCHAR(30) NULL,
  FAX_NUMBER VARCHAR(30) NULL,
  RECORD_CREATED_BY VARCHAR(30) NULL,
  RECORD_CREATED_DATE DATE NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE DATE NULL,
  RECORD_MODIFIED_COUNT NUMBER(10, 0) NULL,
  RECORD_CREATED_DATE_TZ VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE_TZ VARCHAR(30) NULL,
  HISTORY_RECORD_CREATE_DATE DATE NOT NULL);



/****** Object:  Table PCMM.NON_VA_PROVIDER    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE PCMM.NON_VA_PROVIDER(
  NON_VA_PROVIDER_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  PREFIX VARCHAR(20) NULL,
  LAST_NAME VARCHAR(40) NOT NULL,
  FIRST_name VARCHAR(30) NOT NULL UNIQUE,
  MIDDLE_NAME VARCHAR(30) NULL,
  SUFFIX VARCHAR(20) NULL,
  ADDRESS_LINE1 VARCHAR(100) NULL,
  ADDRESS_LINE2 VARCHAR(100) NULL,
  ADDRESS_LINE3 VARCHAR(1000) NULL,
  CITY VARCHAR(50) NULL,
  STATE VARCHAR(2) NULL,
  ZIP_CODE VARCHAR(12) NULL,
  EMAIL_ADDRESS VARCHAR(128) NULL,
  PHONE_NUMBER VARCHAR(30) NOT NULL,
  RECORD_CREATED_BY VARCHAR(30) NULL,
  RECORD_CREATED_DATE DATE NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE DATE NULL,
  RECORD_MODIFIED_COUNT NUMBER(10, 0) NOT NULL,
  RECORD_CREATED_DATE_TZ VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE_TZ VARCHAR(30) NULL);




/****** Object:  Table PCMM.NON_VA_PROVIDER_H    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE PCMM.NON_VA_PROVIDER_H(
  NON_VA_PROVIDER_H_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  TRANSACTION_TYPE_CODE VARCHAR(1) NULL,
  NON_VA_PROVIDER_ID NUMBER(20, 0) NULL,
  PREFIX VARCHAR(20) NULL,
  LAST_NAME VARCHAR(40) NULL,
  FIRST_NAME VARCHAR(30) NULL,
  MIDDLE_NAME VARCHAR(30) NULL,
  SUFFIX VARCHAR(20) NULL,
  ADDRESS_LINE1 VARCHAR(100) NULL,
  ADDRESS_LINE2 VARCHAR(100) NULL,
  ADDRESS_LINE3 VARCHAR(1000) NULL,
  CITY VARCHAR(50) NULL,
  STATE VARCHAR(2) NULL,
  ZIP_CODE VARCHAR(12) NULL,
  EMAIL_ADDRESS VARCHAR(128) NULL,
  PHONE_NUMBER VARCHAR(30) NULL,
  RECORD_CREATED_BY VARCHAR(30) NULL,
  RECORD_CREATED_DATE DATE NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE DATE NULL,
  RECORD_MODIFIED_COUNT NUMBER(10, 0) NULL,
  RECORD_CREATED_DATE_TZ VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE_TZ VARCHAR(30) NULL,
  HISTORY_RECORD_CREATE_DATE DATE NOT NULL);


/****** Object:  Table PCMM.NON_VA_PROVIDER_NON_VA_PRACTICE    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE PCMM.NON_VA_PROVIDER_NONVA_PRACTICE(
  NON_VA_PROVIDER_PRACTICE_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  NON_VA_PROVIDER_id NUMBER(20, 0) NOT NULL UNIQUE,
  NON_VA_PRACTICE_id NUMBER(20, 0) NOT NULL UNIQUE,
  RECORD_CREATED_BY VARCHAR(30) NULL,
  RECORD_CREATED_DATE DATE NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE DATE NULL,
  RECORD_MODIFIED_COUNT NUMBER(10, 0) NOT NULL,
  RECORD_CREATED_DATE_TZ VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE_TZ VARCHAR(30) NULL);


/****** Object:  Table PCMM.NON_VA_PROVIDER_NON_VA_PROVIDER_CATERY    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE PCMM.NON_VA_PROVIDER_NVP_CATERY(
  NON_VA_PROVIDER_CATERY_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  NON_VA_PROVIDER_id NUMBER(20, 0) NOT NULL UNIQUE,
  PCM_NON_VA_PROVIDER_CATERY_id NUMBER(20, 0) NOT NULL UNIQUE,
  RECORD_CREATED_BY VARCHAR(30) NULL,
  RECORD_CREATED_DATE DATE NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE DATE NULL,
  RECORD_MODIFIED_COUNT NUMBER(10, 0) NOT NULL,
  RECORD_CREATED_DATE_TZ VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE_TZ VARCHAR(30) NULL);


/****** Object:  Table PCMM.NON_VA_PROVIDER_NON_VA_PROVIDER_ROLE    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE PCMM.NON_VA_PROVIDER_NVP_ROLE(
  NON_VA_PROVIDER_NVP_ROLE_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  NON_VA_PROVIDER_id NUMBER(20, 0) NOT NULL UNIQUE,
  PCM_STD_NVP_ROLE_id NUMBER(20, 0) NOT NULL UNIQUE,
  RECORD_CREATED_BY VARCHAR(30) NULL,
  RECORD_CREATED_DATE DATE NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE DATE NULL,
  RECORD_MODIFIED_COUNT NUMBER(10, 0) NOT NULL,
  RECORD_CREATED_DATE_TZ VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE_TZ VARCHAR(30) NULL);



/****** Object:  Table PCMM.NON_VA_PROVIDER_NON_VA_SPECIALTY    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE PCMM.NON_VA_PROVIDER_NON_VA_SPLTY(
  NON_VA_PROVIDER_NVS_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  NON_VA_PROVIDER_id NUMBER(20, 0) NOT NULL UNIQUE,
  PCM_STD_NVP_SPECIALTY_id NUMBER(20, 0) NOT NULL UNIQUE,
  RECORD_CREATED_BY VARCHAR(30) NULL,
  RECORD_CREATED_DATE DATE NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE DATE NULL,
  RECORD_MODIFIED_COUNT NUMBER(10, 0) NOT NULL,
  RECORD_CREATED_DATE_TZ VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE_TZ VARCHAR(30) NULL);


/****** Object:  Table PCMM.NON_VA_PROVIDER_PATIENT_RELATIONSHIP    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE PCMM.NVP_PATIENT_RELATIONSHIP(
  NVP_PATIENT_RELATIONSHIP_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  NON_VA_PROVIDER_id NUMBER(20, 0) NOT NULL UNIQUE,
  PCMM_PATIENT_id NUMBER(20, 0) NOT NULL UNIQUE,
  TEAM_ID NUMBER(20, 0) NULL,
  NON_VA_PRACTICE_ID NUMBER(20, 0) NULL,
  PCM_STD_NVP_ROLE_id NUMBER(20, 0) NOT NULL UNIQUE,
  PCM_STD_NVP_SPECIALTY_ID NUMBER(20, 0) NULL,
  PCM_STD_NVP_CATERY_ID NUMBER(20, 0) NULL,
  START_DATE DATE NOT NULL,
  END_DATE DATE NULL,
  RECORD_CREATED_BY VARCHAR(30) NULL,
  RECORD_CREATED_DATE DATE NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE DATE NULL,
  RECORD_MODIFIED_COUNT NUMBER(10, 0) NOT NULL,
  RECORD_CREATED_DATE_TZ VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE_TZ VARCHAR(30) NULL);


/****** Object:  Table PCMM.NON_VA_PROVIDER_PATIENT_RELATIONSHIP_H    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE PCMM.NVP_PATIENT_RELATIONSHIP_H(
  NVP_PATIENT_RELATIONSHIP_H_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  TRANSACTION_TYPE_CODE VARCHAR(1) NULL,
  NVP_PATIENT_RELATIONSHIP_ID NUMBER(20, 0) NULL,
  NON_VA_PROVIDER_ID NUMBER(20, 0) NULL,
  PCMM_PATIENT_ID NUMBER(20, 0) NULL,
  TEAM_ID NUMBER(20, 0) NULL,
  NON_VA_PRACTICE_ID NUMBER(20, 0) NULL,
  PCM_STD_NVP_ROLE_ID NUMBER(20, 0) NULL,
  PCM_STD_NVP_SPECIALTY_ID NUMBER(20, 0) NULL,
  PCM_STD_NVP_CATERY_ID NUMBER(20, 0) NULL,
  START_DATE DATE NULL,
  END_DATE DATE NULL,
  RECORD_CREATED_BY VARCHAR(30) NULL,
  RECORD_CREATED_DATE DATE NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE DATE NULL,
  RECORD_MODIFIED_COUNT NUMBER(10, 0) NULL,
  RECORD_CREATED_DATE_TZ VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE_TZ VARCHAR(30) NULL,
  HISTORY_RECORD_CREATE_DATE DATE NOT NULL);

/****** Object:  Table PCMM.PANEL_PLACEMENT_REQUEST    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE PCMM.PANEL_PLACEMENT_REQUEST(
  PANEL_PLACEMENT_REQUEST_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  PATIENT_PANEL_REASON_id NUMBER(20, 0) NOT NULL UNIQUE,
  PCM_STD_PANEL_STATUS_id NUMBER(20, 0) NOT NULL UNIQUE,
  TEAM_ID NUMBER(20, 0) NULL,
  PCMM_GROUP_ID NUMBER(20, 0) NULL,
  VA_FACILITY_id NUMBER(20, 0) NOT NULL UNIQUE,
  PCMM_PATIENT_ID NUMBER(20, 0) NULL,
  PANEL_PLACEMENT_REQ_id NUMBER(20, 0) NOT NULL UNIQUE,
  EFFECTIVE_DATE DATE NOT NULL,
  COMMENTS VARCHAR(250) NULL,
  RECORD_CREATED_BY VARCHAR(30) NULL,
  RECORD_CREATED_DATE DATE NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE DATE NULL,
  RECORD_MODIFIED_COUNT NUMBER(10, 0) NOT NULL,
  RECORD_CREATED_DATE_TZ VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE_TZ VARCHAR(30) NULL);


/****** Object:  Table PCMM.PANEL_SIZE_ADJUSTMENT_HISTORY    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE PCMM.PANEL_SIZE_ADJ_HISTORY(
  PANEL_SIZE_ADJ_HISTORY_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  PCM_STD_PANEL_SIZE_ADJ_id NUMBER(20, 0) NOT NULL UNIQUE,
  ADJUSTED_MODEL_PANEL_SIZE NUMBER(4, 0) NULL,
  SUPPORT_STAFF_TOTAL_FTE NUMBER(4, 2) NULL,
  PCP_TOTAL_FTE NUMBER(4, 2) NULL,
  SUPPORT_STAFF_PER_PC_FTE NUMBER(4, 2) NULL,
  SUPPORT_STAFF_PER_PC_ADJ NUMBER(4, 0) NULL,
  ROOMS_TOTAL_FTE NUMBER(4, 2) NULL,
  ROOMS_PER_PC_FTE NUMBER(4, 2) NULL,
  ROOMS_ADJUSTMENT NUMBER(4, 0) NULL,
  PC_INTENSITY NUMBER(4, 2) NULL,
  PC_INTENSITY_ADJUSTMENT NUMBER(4, 0) NULL,
  START_DATE DATE NULL,
  END_DATE DATE NULL,
  RECORD_CREATED_BY VARCHAR(30) NULL,
  RECORD_CREATED_DATE DATE NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE DATE NULL,
  RECORD_MODIFIED_COUNT NUMBER(10, 0) NOT NULL,
  RECORD_CREATED_DATE_TZ VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE_TZ VARCHAR(30) NULL);




/****** Object:  Table PCMM.PATIENT_ASSIGN_TEAM_POSITION    Script Date: 8/20/2015 6:11:42 PM ******/








/****** Object:     Table PCMM.PATIENT_ASSIGN_TEAM_POSITION_H    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE PCMM.PATIENT_ASSIGN_TEAM_POSITION_H(
  PATIENT_ASSIGN_TEAM_POS_H_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  TRANSACTION_TYPE_CODE VARCHAR(1) NULL,
  PATIENT_ASSIGN_TEAM_POS_id NUMBER(20, 0) NOT NULL UNIQUE,
  TEAM_PATIENT_ASSIGN_ID NUMBER(20, 0) NULL,
  TEAM_POSITION_ID NUMBER(20, 0) NULL,
  START_DATE DATE NULL,
  END_DATE DATE NULL,
  IEN VARCHAR(30) NULL,
  PatientPositionAssignmentSID NUMBER NULL,
  LEGACY_PC_ROLE VARCHAR(50) NULL,
  Sta3n VARCHAR(7) NULL,
  BATCH_UPDATE_NOTE VARCHAR(250) NULL,
  RECORD_CREATED_BY VARCHAR(30) NULL,
  RECORD_CREATED_DATE DATE NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE DATE NULL,
  RECORD_MODIFIED_COUNT NUMBER(10, 0) NOT NULL,
  RECORD_CREATED_DATE_TZ VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE_TZ VARCHAR(30) NULL,
  HISTORY_RECORD_CREATE_DATE DATE NOT NULL);



/****** Object:  Table PCMM.PCM_STD_ALERT_TEMPLATE    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE PCMM.PCM_STD_ALERT_TEMPLATE(
  PCM_STD_ALERT_TEMPLATE_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  CODE VARCHAR(50) NOT NULL,
  NAME VARCHAR(80) NULL,
  DESCRIPTION VARCHAR(250) NULL,
  SORT_ORDER NUMBER(6, 0) NULL,
  ISACTIVE char(1) NOT NULL,
  EFFECTIVEDATE DATE NULL,
  EXPIRATIONDATE DATE NULL,
  MESSAGE VARCHAR(250) NULL,
  ALERT_TYPE char(1) NOT NULL,
  EMAIL_RECIPIENTS_IND VARCHAR(1) NOT NULL,
  PCM_STD_TEMPLATE_id NUMBER(20, 0) NOT NULL UNIQUE,
  RECORD_CREATED_BY VARCHAR(30) NOT NULL,
  RECORD_CREATED_DATE DATE NOT NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NOT NULL,
  RECORD_MODIFIED_DATE DATE NOT NULL);


/****** Object:  Table PCMM.PCM_STD_ALERT_TEMPLATE_RECIPIENT    Script Date: 8/20/2015 6:11:42 PM ******/





CREATE TABLE PCMM.PCM_STD_ALERT_TEMPL_RECIPIENT(
  PCM_STD_ALERT_RECIPIENT_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  APP_USER_ID NUMBER(20, 0) NULL,
  ROLE_ID NUMBER(20, 0) NULL,
  PCM_STD_ALERT_TEMP_id NUMBER(20, 0) NOT NULL UNIQUE,
  HIBERNATE_CLASS_TYPE VARCHAR(20) NOT NULL,
  RECORD_CREATED_BY VARCHAR(30) NULL,
  RECORD_CREATED_DATE DATE NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE DATE NULL,
  RECORD_MODIFIED_COUNT NUMBER(10, 0) NOT NULL,
  RECORD_CREATED_DATE_TZ VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE_TZ VARCHAR(30) NULL);


/****** Object:  Table PCMM.PCM_STD_AUTO_INACTIVATION_EXTEND_REASON    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE PCMM.PCM_STD_AUTO_INACT_EXT_REASON(
  PCM_STD_AUTO_INACT_EXT_REASON NUMBER(20, 0) PRIMARY KEY NOT NULL,
  CODE VARCHAR(50) NOT NULL,
  NAME VARCHAR(80) NULL,
  DESCRIPTION VARCHAR(250) NULL,
  ISACTIVE char(1) NOT NULL,
  SORT_ORDER NUMBER(6, 0) NULL,
  EFFECTIVEDATE DATE NULL,
  EXPIRATIONDATE DATE NULL,
  RECORD_CREATED_BY VARCHAR(30) NOT NULL,
  RECORD_CREATED_DATE DATE NOT NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NOT NULL,
  RECORD_MODIFIED_DATE DATE NOT NULL);



/****** Object:  Table PCMM.PCM_STD_CDW_PCMM_INSTITUTION_TRANSFORM    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE PCMM.PCM_STD_CDW_PCM_INST_TRANSFORM(
  CDW_InstitutionSID NUMBER NOT NULL,
  CDW_InstitutionIEN VARCHAR(50) NOT NULL,
  CDW_Sta3n NUMBER NOT NULL,
  CDW_InstitutionName VARCHAR(50) NULL,
  CDW_InstitutionCode VARCHAR(10) NULL,
  PCMM_InstitutionID NUMBER(20, 0) NULL,
  PCMM_InstitutionName VARCHAR(80) NULL,
  PCMM_VistaName VARCHAR(30) NULL,
  PCMM_stationNumber VARCHAR(7) NULL
);




/****** Object:  Table PCMM.PCM_STD_CDW_STANDARDPOS_STAFF_ROLE    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE PCMM.PCM_STD_CDW_STDPOS_STAFF_ROLE(
  PCM_STD_CDW_STDPOS_STAFF_ROLE NUMBER(20, 0) PRIMARY KEY NOT NULL,
  StandardPosition VARCHAR(50) NULL,
  PCM_STD_STAFF_ROLE_ID NUMBER(20, 0) NULL,
  PCM_STD_TEAM_ROLE_ID NUMBER(20, 0) NULL,
  PCM_STD_TEAM_CARE_TYPE VARCHAR(80) NULL,
  RECORD_CREATED_BY VARCHAR(30) NULL,
  RECORD_CREATED_DATE DATE NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE DATE NULL,
  RECORD_MODIFIED_COUNT NUMBER(10, 0) NOT NULL,
  RECORD_CREATED_DATE_TZ VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE_TZ VARCHAR(30) NULL);



/****** Object:  Table PCMM.PCM_STD_FACILITY_ROOM_TYPE    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE PCMM.PCM_STD_FACILITY_ROOM_TYPE(
  PCM_STD_FACILITY_ROOM_TYPE_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  CODE VARCHAR(50) NOT NULL,
  NAME VARCHAR(80) NULL,
  DESCRIPTION VARCHAR(250) NULL,
  ISACTIVE char(1) NOT NULL,
  SORT_ORDER NUMBER(6, 0) NULL,
  EFFECTIVEDATE DATE NULL,
  EXPIRATIONDATE DATE NULL,
  RECORD_CREATED_BY VARCHAR(30) NOT NULL,
  RECORD_CREATED_DATE DATE NOT NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NOT NULL,
  RECORD_MODIFIED_DATE DATE NOT NULL);


/****** Object:  Table PCMM.PCM_STD_FTEE_REQUIRED_TYPE    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE PCMM.PCM_STD_FTEE_REQUIRED_TYPE(
  PCM_STD_FTEE_REQUIRED_TYPE_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  CODE VARCHAR(50) NOT NULL,
  NAME VARCHAR(80) NULL,
  DESCRIPTION VARCHAR(250) NULL,
  ISACTIVE char(1) NOT NULL,
  SORT_ORDER NUMBER(6, 0) NULL,
  EFFECTIVEDATE DATE NULL,
  EXPIRATIONDATE DATE NULL,
  RECORD_CREATED_BY VARCHAR(30) NOT NULL,
  RECORD_CREATED_DATE DATE NOT NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NOT NULL,
  RECORD_MODIFIED_DATE DATE NOT NULL);



/****** Object:  Table PCMM.PCM_STD_JOB_EXECUTION_TYPE    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE PCMM.PCM_STD_JOB_EXECUTION_TYPE(
  PCM_STD_JOB_EXECUTION_TYPE_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  CODE VARCHAR(50) NOT NULL,
  NAME VARCHAR(80) NULL,
  DESCRIPTION VARCHAR(250) NULL,
  ISACTIVE char(1) NOT NULL,
  SORT_ORDER NUMBER(6, 0) NULL,
  EFFECTIVEDATE DATE NULL,
  EXPIRATIONDATE DATE NULL,
  RECORD_CREATED_BY VARCHAR(30) NOT NULL,
  RECORD_CREATED_DATE DATE NOT NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NOT NULL,
  RECORD_MODIFIED_DATE DATE NOT NULL);



/****** Object:  Table PCMM.PCM_STD_MULTIPCP_STATUS    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE PCMM.PCM_STD_MULTIPCP_STATUS(
  PCM_STD_MULTIPCP_STATUS_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  CODE VARCHAR(50) NOT NULL,
  NAME VARCHAR(80) NULL,
  DESCRIPTION VARCHAR(250) NULL,
  ISACTIVE char(1) NOT NULL,
  SORT_ORDER NUMBER(6, 0) NULL,
  EFFECTIVEDATE DATE NULL,
  EXPIRATIONDATE DATE NULL,
  RECORD_CREATED_BY VARCHAR(30) NOT NULL,
  RECORD_CREATED_DATE DATE NOT NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NOT NULL,
  RECORD_MODIFIED_DATE DATE NOT NULL);

/****** Object:  Table PCMM.PCM_STD_MULTIPCP_STATUS_REASON    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE PCMM.PCM_STD_MULTIPCP_STAT_REASON(
  PCM_STD_MULTIPCP_STAT_RSN_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  PCM_STD_MULTIPCP_STATUS_id NUMBER(20, 0) NOT NULL UNIQUE,
  CODE VARCHAR(50) NOT NULL,
  NAME VARCHAR(80) NULL,
  DESCRIPTION VARCHAR(250) NULL,
  ISACTIVE char(1) NOT NULL,
  SORT_ORDER NUMBER(6, 0) NULL,
  EFFECTIVEDATE DATE NULL,
  EXPIRATIONDATE DATE NULL,
  ISMANUALLYASSIGNABLE char(1) NOT NULL,
  RECORD_CREATED_BY VARCHAR(30) NOT NULL,
  RECORD_CREATED_DATE DATE NOT NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NOT NULL,
  RECORD_MODIFIED_DATE DATE NOT NULL);



/****** Object:  Table PCMM.PCM_STD_NON_VA_PROVIDER_CATERY    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE PCMM.PCM_STD_NONVA_PROVIDER_CATERY(
  PCM_STD_NVP_CATERY_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  CODE VARCHAR(50) NOT NULL,
  NAME VARCHAR(80) NULL,
  DESCRIPTION VARCHAR(250) NULL,
  ISACTIVE char(1) NOT NULL,
  SORT_ORDER NUMBER(6, 0) NULL,
  EFFECTIVEDATE DATE NULL,
  EXPIRATIONDATE DATE NULL,
  RECORD_CREATED_BY VARCHAR(30) NOT NULL,
  RECORD_CREATED_DATE DATE NOT NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NOT NULL,
  RECORD_MODIFIED_DATE DATE NOT NULL);


/****** Object:  Table PCMM.PCM_STD_NON_VA_PROVIDER_ROLE    Script Date: 8/20/2015 6:11:42 PM ******/





CREATE TABLE PCMM.PCM_STD_NON_VA_PROVIDER_ROLE(
  PCM_STD_NVP_ROLE_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  CODE VARCHAR(50) NOT NULL,
  NAME VARCHAR(80) NULL,
  DESCRIPTION VARCHAR(250) NULL,
  ISACTIVE char(1) NOT NULL,
  SORT_ORDER NUMBER(6, 0) NULL,
  EFFECTIVEDATE DATE NULL,
  EXPIRATIONDATE DATE NULL,
  RECORD_CREATED_BY VARCHAR(30) NOT NULL,
  RECORD_CREATED_DATE DATE NOT NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NOT NULL,
  RECORD_MODIFIED_DATE DATE NOT NULL);


/****** Object:  Table PCMM.PCM_STD_NON_VA_PROVIDER_ROLE_HISTORY    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE PCMM.PCM_STD_NON_VA_PROV_ROLE_HIST(
  PCM_STD_NVP_ROLE_HISTORY_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  PCM_STD_NVP_ROLE_id NUMBER(20, 0) NOT NULL UNIQUE,
  NAME VARCHAR(80) NULL,
  DESCRIPTION VARCHAR(250) NULL,
  SORT_ORDER NUMBER(6, 0) NULL,
  ISACTIVE char(1) NOT NULL,
  EFFECTIVEDATE DATE NULL,
  EXPIRATIONDATE DATE NULL,
  CHANGE_JUSTIFICATION VARCHAR(250) NULL,
  INACTIVATE_REASON VARCHAR(250) NULL,
  RECORD_CREATED_BY VARCHAR(30) NOT NULL,
  RECORD_CREATED_DATE DATE NOT NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NOT NULL,
  RECORD_MODIFIED_DATE DATE NOT NULL);


/****** Object:  Table PCMM.PCM_STD_NON_VA_PROVIDER_SPECIALTY    Script Date: 8/20/2015 6:11:42 PM ******/





CREATE TABLE PCMM.PCM_STD_NON_VA_PROV_SPECIALTY(
  PCM_STD_NVP_SPECIALTY_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  CODE VARCHAR(50) NOT NULL,
  NAME VARCHAR(80) NULL,
  DESCRIPTION VARCHAR(250) NULL,
  ISACTIVE char(1) NOT NULL,
  SORT_ORDER NUMBER(6, 0) NULL,
  EFFECTIVEDATE DATE NULL,
  EXPIRATIONDATE DATE NULL,
  RECORD_CREATED_BY VARCHAR(30) NOT NULL,
  RECORD_CREATED_DATE DATE NOT NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NOT NULL,
  RECORD_MODIFIED_DATE DATE NOT NULL);


/****** Object:  Table PCMM.PCM_STD_NOTIFICATION_CATERY_TYPE    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE PCMM.PCM_STD_NOTIFY_CATERY_TYPE(
  NOTIFY_CATERY_TYPE_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  CODE VARCHAR(50) NOT NULL,
  NAME VARCHAR(80) NULL,
  DESCRIPTION VARCHAR(250) NULL,
  ISACTIVE char(1) NOT NULL,
  SORT_ORDER NUMBER(6, 0) NULL,
  EFFECTIVEDATE DATE NULL,
  EXPIRATIONDATE DATE NULL,
  RECORD_CREATED_BY VARCHAR(30) NOT NULL,
  RECORD_CREATED_DATE DATE NOT NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NOT NULL,
  RECORD_MODIFIED_DATE DATE NOT NULL);


/****** Object:  Table PCMM.PCM_STD_NOTIFICATION_TYPE    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE PCMM.PCM_STD_NOTIFICATION_TYPE(
  PCM_STD_NOTIFICATION_TYPE_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  PCM_STD_NOTIFY_CATERY_TYPE_id NUMBER(20, 0) NOT NULL UNIQUE,
  CODE VARCHAR(50) NOT NULL,
  NAME VARCHAR(80) NULL,
  DESCRIPTION VARCHAR(250) NULL,
  ISACTIVE char(1) NOT NULL,
  SORT_ORDER NUMBER(6, 0) NULL,
  EFFECTIVEDATE DATE NULL,
  EXPIRATIONDATE DATE NULL,
  RECORD_CREATED_BY VARCHAR(30) NOT NULL,
  RECORD_CREATED_DATE DATE NOT NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NOT NULL,
  RECORD_MODIFIED_DATE DATE NOT NULL);


/****** Object:  Table PCMM.PCM_STD_PANEL_PLACEMENT_REQUESTER    Script Date: 8/20/2015 6:11:42 PM ******/





CREATE TABLE PCMM.PCM_STD_PANEL_PLACEMENT_REQ(
  PANEL_PLACEMENT_REQ_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  CODE VARCHAR(50) NOT NULL,
  NAME VARCHAR(80) NULL,
  DESCRIPTION VARCHAR(250) NULL,
  ISACTIVE char(1) NOT NULL,
  SORT_ORDER NUMBER(6, 0) NULL,
  EFFECTIVEDATE DATE NULL,
  EXPIRATIONDATE DATE NULL,
  RECORD_CREATED_BY VARCHAR(30) NOT NULL,
  RECORD_CREATED_DATE DATE NOT NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NOT NULL,
  RECORD_MODIFIED_DATE DATE NOT NULL);


/****** Object:  Table PCMM.PCM_STD_PANEL_PLACEMENT_STATUS    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE PCMM.PCM_STD_PANEL_PLACEMENT_STATUS(
  PANEL_PLACEMENT_STATUS_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  CODE VARCHAR(50) NOT NULL,
  NAME VARCHAR(80) NULL,
  DESCRIPTION VARCHAR(250) NULL,
  ISACTIVE char(1) NOT NULL,
  SORT_ORDER NUMBER(6, 0) NULL,
  EFFECTIVEDATE DATE NULL,
  EXPIRATIONDATE DATE NULL,
  RECORD_CREATED_BY VARCHAR(30) NOT NULL,
  RECORD_CREATED_DATE DATE NOT NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NOT NULL,
  RECORD_MODIFIED_DATE DATE NOT NULL);


/****** Object:  Table PCMM.PCM_STD_PANEL_SIZE_ADJUSTMENT    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE PCMM.PCM_STD_PANEL_SIZE_ADJUSTMENT(
  PANEL_SIZE_ADJUSTMENT_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  VA_FACILITY_id NUMBER(20, 0) NOT NULL UNIQUE,
  PCM_STD_TEAM_CARE_TYPE_id NUMBER(20, 0) NOT NULL UNIQUE,
  BASE_MODEL_PANEL_SIZE NUMBER(4, 0) NOT NULL,
  ADJUSTED_MODEL_PANEL_SIZE NUMBER(4, 0) NULL,
  RECORD_CREATED_BY VARCHAR(30) NOT NULL,
  RECORD_CREATED_DATE DATE NOT NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NOT NULL,
  RECORD_MODIFIED_DATE DATE NOT NULL);



/****** Object:  Table PCMM.PCM_STD_PATIENT_INTENSITY_LOAD    Script Date: 8/20/2015 6:11:42 PM ******/





CREATE TABLE PCMM.PCM_STD_PATIENT_INTENSITY_LOAD(
  PATIENT_INTENSITY_LOAD_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  NormScore NUMBER(8, 2) NULL,
  PATIENT_ICN VARCHAR(50) NULL,
  ScrSSN VARCHAR(50) NULL,
  RECORD_CREATED_BY VARCHAR(30) NULL,
  RECORD_CREATED_DATE DATE NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE DATE NULL);



/****** Object:  Table PCMM.PCM_STD_PATIENT_PANEL_PLACEMENT_REASON    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE PCMM.PATIENT_PANEL_PLACEMENT_REASON(
  PANEL_PLACEMENT_REASON_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  CODE VARCHAR(50) NOT NULL,
  NAME VARCHAR(80) NULL,
  DESCRIPTION VARCHAR(250) NULL,
  ISACTIVE char(1) NOT NULL,
  SORT_ORDER NUMBER(6, 0) NULL,
  EFFECTIVEDATE DATE NULL,
  EXPIRATIONDATE DATE NULL,
  RECORD_CREATED_BY VARCHAR(30) NOT NULL,
  RECORD_CREATED_DATE DATE NOT NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NOT NULL,
  RECORD_MODIFIED_DATE DATE NOT NULL);



/****** Object:  Table PCMM.PCM_STD_PATIENT_UNASSIGN_REASON    Script Date: 8/20/2015 6:11:42 PM ******/




CREATE TABLE PCMM.PATIENT_UNASSIGN_REASON(
  PATIENT_UNASSIGN_REASON_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  CODE VARCHAR(50) NOT NULL,
  NAME VARCHAR(80) NULL,
  DESCRIPTION VARCHAR(250) NULL,
  ISACTIVE char(1) NOT NULL,
  SORT_ORDER NUMBER(6, 0) NULL,
  EFFECTIVEDATE DATE NULL,
  EXPIRATIONDATE DATE NULL,
  RECORD_CREATED_BY VARCHAR(30) NOT NULL,
  RECORD_CREATED_DATE DATE NOT NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NOT NULL,
  RECORD_MODIFIED_DATE DATE NOT NULL);


/****** Object:  Table PCMM.PCM_STD_PC_INTENSITY_ADJUSTMENT    Script Date: 8/20/2015 6:11:42 PM ******/





CREATE TABLE PCMM.PC_INTENSITY_ADJUSTMENT(
  PC_INTENSITY_ADJUSTMENT_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  PC_INTENSITY_BEGIN_VALUE NUMBER(4, 2) NOT NULL,
  PC_INTENSITY_END_VALUE NUMBER(4, 2) NULL,
  PANEL_SIZE_ADJUSTMENT_PERCENT NUMBER(4, 2) NOT NULL,
  RECORD_CREATED_BY VARCHAR(30) NOT NULL,
  RECORD_CREATED_DATE DATE NOT NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NOT NULL,
  RECORD_MODIFIED_DATE DATE NOT NULL);



/****** Object:  Table PCMM.PCM_STD_PERSON_CLASS_CLASSIFICATION_CISS_ROLE    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE PCMM.PERSON_CLASS_CISS_ROLE(
  PERSON_CLASS_CISS_ROLE_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  PERSON_CLASS_CLASSIFICATION_id NUMBER(20, 0) NOT NULL UNIQUE,
  CISS_ROLE_id NUMBER(20, 0) NOT NULL UNIQUE,
  RECORD_CREATED_BY VARCHAR(30) NULL,
  RECORD_CREATED_DATE DATE NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE DATE NULL,
  RECORD_MODIFIED_COUNT NUMBER(10, 0) NOT NULL,
  RECORD_CREATED_DATE_TZ VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE_TZ VARCHAR(30) NULL);


/****** Object:  Table PCMM.PCM_STD_PERSON_CLASS_CLASSIFICATION_STAFF_ROLE    Script Date: 8/20/2015 6:11:42 PM ******/





CREATE TABLE PCMM.PERSON_CLASS_STAFF_ROLE(
  PERSON_CLASS_STAFF_ROLE_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  PERSON_CLASS_CLASSIFICATION_id NUMBER(20, 0) NOT NULL UNIQUE,
  PCM_STD_STAFF_ROLE_id NUMBER(20, 0) NOT NULL UNIQUE,
  RECORD_CREATED_BY VARCHAR(30) NULL,
  RECORD_CREATED_DATE DATE NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE DATE NULL,
  RECORD_MODIFIED_COUNT NUMBER(10, 0) NOT NULL,
  RECORD_CREATED_DATE_TZ VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE_TZ VARCHAR(30) NULL);




/****** Object:  Table PCMM.PCM_STD_PERSONCLASS_STAFF_ROLE    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE PCMM.PCM_STD_PERSONCLASS_STAFF_ROLE(
  PERSONCLASS_STAFF_ROLE_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  PERSON_CLASS_id NUMBER(20, 0) NOT NULL UNIQUE,
  PCM_STD_STAFF_ROLE_id NUMBER(20, 0) NOT NULL UNIQUE,
  RECORD_CREATED_BY VARCHAR(30) NULL,
  RECORD_CREATED_DATE DATE NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE DATE NULL,
  RECORD_MODIFIED_COUNT NUMBER(10, 0) NOT NULL,
  RECORD_CREATED_DATE_TZ VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE_TZ VARCHAR(30) NULL);



/****** Object:  Table PCMM.PCM_STD_PRECEPTOR_TRANSFORM    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE PCMM.PCM_STD_PRECEPTOR_TRANSFORM(
  PCM_STD_PRECEPTOR_TRANSFORM_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  PRECEPTEE_ROLE_id NUMBER(20, 0) NOT NULL UNIQUE,
  PRECEPTOR_ROLE_id NUMBER(20, 0) NOT NULL UNIQUE,
  PRECEPTEE_TEAM_ROLE_ID NUMBER(20, 0) NULL,
  PRECEPTOR_TEAM_ROLE_ID NUMBER(20, 0) NULL,
  RECORD_CREATED_BY VARCHAR(30) NOT NULL,
  RECORD_CREATED_DATE DATE NOT NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NOT NULL);



/****** Object:  Table PCMM.PCM_STD_PRIMARY_CARE_INTENSITY    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE PCMM.PCM_STD_PRIMARY_CARE_INTENSITY(
  PRIMARY_CARE_INTENSITY_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  VA_FACILITY_id NUMBER(20, 0) NOT NULL UNIQUE,
  PC_INTENSITY_VALUE NUMBER(4, 2) NOT NULL,
  RECORD_CREATED_BY VARCHAR(30) NOT NULL,
  RECORD_CREATED_DATE DATE NOT NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NOT NULL,
  RECORD_MODIFIED_DATE DATE NOT NULL);


/****** Object:  Table PCMM.PCM_STD_ROOMS_ADJUSTMENT    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE PCMM.PCM_STD_ROOMS_ADJUSTMENT(
  PCM_STD_ROOMS_ADJUSTMENT_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  ROOMS_PER_PCP_BEGIN_VALUE NUMBER(4, 2) NOT NULL,
  ROOMS_PER_PCP_END_VALUE NUMBER(4, 2) NULL,
  PANEL_SIZE_ADJUSTMENT_PERCENT NUMBER(4, 2) NOT NULL,
  RECORD_CREATED_BY VARCHAR(30) NOT NULL,
  RECORD_CREATED_DATE DATE NOT NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NOT NULL,
  RECORD_MODIFIED_DATE DATE NOT NULL);



/****** Object:  Table PCMM.PCM_STD_STAFF_ASSIGN_REASON    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE PCMM.PCM_STD_STAFF_ASSIGN_REASON(
  PCM_STD_STAFF_ASSIGN_REASON_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  CODE VARCHAR(50) NOT NULL,
  NAME VARCHAR(80) NULL,
  DESCRIPTION VARCHAR(250) NULL,
  ISACTIVE char(1) NOT NULL,
  SORT_ORDER NUMBER(6, 0) NULL,
  EFFECTIVEDATE DATE NULL,
  EXPIRATIONDATE DATE NULL,
  IEN VARCHAR(30) NULL,
  RECORD_CREATED_BY VARCHAR(30) NOT NULL,
  RECORD_CREATED_DATE DATE NOT NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NOT NULL,
  RECORD_MODIFIED_DATE DATE NOT NULL);



/****** Object:  Table PCMM.PCM_STD_STAFF_ROLE    Script Date: 8/20/2015 6:11:42 PM ******/








/****** Object:  Table PCMM.PCM_STD_STATUS    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE PCMM.PCM_STD_STATUS(
  PCM_STD_STATUS_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  CODE VARCHAR(50) NOT NULL,
  NAME VARCHAR(80) NULL,
  DESCRIPTION VARCHAR(250) NULL,
  ISACTIVE char(1) NOT NULL,
  SORT_ORDER NUMBER(6, 0) NULL,
  EXPIRATIONDATE DATE NULL,
  EFFECTIVEDATE DATE NULL,
  RECORD_CREATED_BY VARCHAR(30) NOT NULL,
  RECORD_CREATED_DATE DATE NOT NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NOT NULL,
  RECORD_MODIFIED_DATE DATE NOT NULL);


/****** Object:  Table PCMM.PCM_STD_STOP_CODE_VALID_FOR_ENC    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE PCMM.STOP_CODE_VALID_FOR_ENC(
  STOP_CODE_VALID_FOR_ENC_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  PCM_STD_TEAM_CARE_TYPE_id NUMBER(20, 0) NOT NULL UNIQUE,
  STOP_CODE VARCHAR(50) NULL,
  SECONDARY_STOP_CODE VARCHAR(50) NULL,
  EFFECTIVEDATE DATE NULL,
  EXPIRATIONDATE DATE NULL,
  RECORD_CREATED_BY VARCHAR(30) NOT NULL,
  RECORD_CREATED_DATE DATE NOT NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NOT NULL,
  RECORD_MODIFIED_DATE DATE NOT NULL);



/****** Object:  Table PCMM.PCM_STD_SUPPORT_STAFF_ADJUSTMENT    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE PCMM.SUPPORT_STAFF_ADJUSTMENT(
  SUPPORT_STAFF_ADJUSTMENT_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  SUPPORT_STAFF_BEGIN_VALUE NUMBER(4, 2) NOT NULL,
  SUPPORT_STAFF_END_VALUE NUMBER(4, 2) NULL,
  PANEL_SIZE_ADJUSTMENT_PERCENT NUMBER(4, 2) NOT NULL,
  RECORD_CREATED_BY VARCHAR(30) NOT NULL,
  RECORD_CREATED_DATE DATE NOT NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NOT NULL,
  RECORD_MODIFIED_DATE DATE NOT NULL);



/****** Object:  Table PCMM.PCM_STD_TEAM_CARE_TYPE    Script Date: 8/20/2015 6:11:42 PM ******/







/****** Object:  Table PCMM.PCM_STD_TEAM_CARE_TYPE_HISTORY    Script Date: 8/20/2015 6:11:42 PM ******/





CREATE TABLE PCMM.PCM_STD_TEAM_CARE_TYPE_HISTORY(
  PCM_STD_TEAM_CARE_TYPE_HIST_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  PCM_STD_TEAM_CARE_TYPE_ID NUMBER(20, 0) NULL,
  NAME VARCHAR(80) NULL,
  DESCRIPTION VARCHAR(250) NULL,
  SORT_ORDER NUMBER(6, 0) NULL,
  ISACTIVE char(1) NOT NULL,
  EFFECTIVEDATE DATE NULL,
  EXPIRATIONDATE DATE NULL,
  CHANGE_JUSTIFICATION VARCHAR(250) NULL,
  INACTIVATE_REASON VARCHAR(250) NULL,
  RECORD_CREATED_BY VARCHAR(30) NOT NULL,
  RECORD_CREATED_DATE DATE NOT NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NOT NULL,
  RECORD_MODIFIED_DATE DATE NOT NULL);



/****** Object:  Table PCMM.PCM_STD_TEAM_CARE_TYPE_TEAM_ROLE    Script Date: 8/20/2015 6:11:42 PM ******/





CREATE TABLE PCMM.TEAM_CARE_TYPE_TEAM_ROLE(
  TEAM_CARE_TYPE_TEAM_ROLE_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  PCM_STD_TEAM_ROLE_ID NUMBER(20, 0) NULL,
  PCM_STD_TEAM_CARE_TYPE_ID NUMBER(20, 0) NULL,
  PCM_STD_FTEE_REQUIRED_TYPE_id NUMBER(20, 0) NOT NULL UNIQUE,
  TEAMLET_IND VARCHAR(1) NOT NULL,
  TEAMLET_ENCOUNTER_QUALIFY_IND VARCHAR(1) NOT NULL,
  ONE_ACTIVE_ALLOWED_IND VARCHAR(1) NOT NULL,
  DIRECT_CARE_PROVIDER_IND VARCHAR(1) NOT NULL,
  RESTRICT_1_PATIENT_STA3N_IND VARCHAR(1) NULL,
  RECORD_CREATED_BY VARCHAR(30) NOT NULL,
  RECORD_CREATED_DATE DATE NOT NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NOT NULL,
  RECORD_MODIFIED_DATE DATE NOT NULL);


/****** Object:  Table PCMM.PCM_STD_TEAM_FOCUS    Script Date: 8/20/2015 6:11:42 PM ******/









/****** Object:  Table PCMM.PCM_STD_TEAM_FOCUS_HISTORY    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE PCMM.PCM_STD_TEAM_FOCUS_HISTORY(
  PCM_STD_TEAM_FOCUS_HISTORY_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  PCM_STD_TEAM_FOCUS_ID NUMBER(20, 0) NULL,
  NAME VARCHAR(80) NULL,
  DESCRIPTION VARCHAR(250) NULL,
  SORT_ORDER NUMBER(6, 0) NULL,
  ISACTIVE char(1) NOT NULL,
  EFFECTIVEDATE DATE NULL,
  EXPIRATIONDATE DATE NULL,
  CHANGE_JUSTIFICATION VARCHAR(250) NULL,
  INACTIVATE_REASON VARCHAR(250) NULL,
  RECORD_CREATED_BY VARCHAR(30) NOT NULL,
  RECORD_CREATED_DATE DATE NOT NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NOT NULL,
  RECORD_MODIFIED_DATE DATE NOT NULL);


/****** Object:  Table PCMM.PCM_STD_TEAM_PATIENT_ASSIGN_STATUS    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE PCMM.TEAM_PATIENT_ASSIGN_STATUS(
  TEAM_PATIENT_ASSIGN_STATUS_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  CODE VARCHAR(50) NOT NULL,
  NAME VARCHAR(80) NULL,
  DESCRIPTION VARCHAR(250) NULL,
  ISACTIVE char(1) NOT NULL,
  SORT_ORDER NUMBER(6, 0) NULL,
  EFFECTIVEDATE DATE NULL,
  EXPIRATIONDATE DATE NULL,
  RECORD_CREATED_BY VARCHAR(30) NOT NULL,
  RECORD_CREATED_DATE DATE NOT NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NOT NULL,
  RECORD_MODIFIED_DATE DATE NOT NULL);


/****** Object:  Table PCMM.PCM_STD_TEAM_POSITION_STATUS_REASON    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE PCMM.TEAM_POSITION_STATUS_REASON_ID(
  TEAM_POSITION_STATUS_REASON_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  CODE VARCHAR(50) NOT NULL,
  NAME VARCHAR(80) NULL,
  DESCRIPTION VARCHAR(250) NULL,
  ISACTIVE char(1) NOT NULL,
  SORT_ORDER NUMBER(6, 0) NULL,
  EFFECTIVEDATE DATE NULL,
  EXPIRATIONDATE DATE NULL,
  IEN VARCHAR(30) NULL,
  RECORD_CREATED_BY VARCHAR(30) NOT NULL,
  RECORD_CREATED_DATE DATE NOT NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NOT NULL,
  RECORD_MODIFIED_DATE DATE NOT NULL);



/****** Object:  Table PCMM.PCM_STD_TEAM_ROLE    Script Date: 8/20/2015 6:11:42 PM ******/







/****** Object:  Table PCMM.PCM_STD_TEAM_ROLE_STAFF_ROLE    Script Date: 8/20/2015 6:11:42 PM ******/


/****** Object:     Table PCMM.PCM_STD_TEAM_ROLE_VISTA_INSTANCE    Script Date: 8/20/2015 6:11:42 PM ******/





CREATE TABLE PCMM.TEAM_ROLE_VISTA_INSTANCE(
  TEAM_ROLE_VISTA_INSTANCE_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  PCM_STD_TEAM_ROLE_id NUMBER(20, 0) NOT NULL UNIQUE,
  PCMM_VISTA_INSTANCE_id NUMBER(20, 0) NOT NULL UNIQUE,
  IEN_OVERRIDE VARCHAR(30) NOT NULL,
  RECORD_CREATED_BY VARCHAR(30) NOT NULL,
  RECORD_CREATED_DATE DATE NOT NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NOT NULL,
  RECORD_MODIFIED_DATE DATE NOT NULL);



/****** Object:  Table PCMM.PCM_STD_TEAM_STATUS_REASON    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE PCMM.PCM_STD_TEAM_STATUS_REASON(
  PCM_STD_TEAM_STATUS_REASON_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  CODE VARCHAR(50) NOT NULL,
  NAME VARCHAR(80) NULL,
  DESCRIPTION VARCHAR(250) NULL,
  ISACTIVE char(1) NOT NULL,
  SORT_ORDER NUMBER(6, 0) NULL,
  EFFECTIVEDATE DATE NULL,
  EXPIRATIONDATE DATE NULL,
  IEN VARCHAR(30) NULL,
  RECORD_CREATED_BY VARCHAR(30) NOT NULL,
  RECORD_CREATED_DATE DATE NOT NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NOT NULL,
  RECORD_MODIFIED_DATE DATE NOT NULL);



/****** Object:  Table PCMM.PCM_STD_TEMPLATE    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE PCMM.PCM_STD_TEMPLATE(
  PCM_STD_TEMPLATE_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  TEMPLATE_NAME VARCHAR(40) NOT NULL,
  TEMPLATE_BODY VARCHAR(100) NOT NULL,
  RECORD_CREATED_BY VARCHAR(30) NOT NULL,
  RECORD_CREATED_DATE DATE NOT NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NOT NULL,
  RECORD_MODIFIED_DATE DATE NOT NULL,
  RECORD_MODIFIED_COUNT NUMBER(10, 0) NOT NULL);




/****** Object:  Table PCMM.PCMM_ALERT    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE PCMM.PCMM_ALERT(
  PCMM_ALERT_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  MULTI_PCP_ID NUMBER(20, 0) NULL,
  PCMM_PATIENT_ID NUMBER(20, 0) NULL,
  PCM_STD_ALERT_TEMPLATE_id NUMBER(20, 0) NOT NULL UNIQUE,
  TEAM_ID NUMBER(20, 0) NULL,
  STAFF_ID NUMBER(20, 0) NULL,
  SENDER_APP_USER_ID NUMBER(20, 0) NULL,
  CLOSED_BY_APP_USER_ID NUMBER(20, 0) NULL,
  PCMM_JOB_EXECUTION_RESULT_ID NUMBER(20, 0) NULL,
  MESSAGE VARCHAR(512) NULL,
  ALERT_CLOSED_IND VARCHAR(1) NOT NULL,
  ALERT_CLOSED_DATE DATE NULL,
  ALERT_BATCH_INDEX NUMBER NULL,
  ALERT_ACTIVATION_DATE DATE NOT NULL,
  RECORD_CREATED_BY VARCHAR(30) NOT NULL,
  RECORD_CREATED_DATE DATE NOT NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NOT NULL,
  RECORD_MODIFIED_DATE DATE NOT NULL,
  RECORD_MODIFIED_COUNT NUMBER(10, 0) NOT NULL,
  RECORD_CREATED_DATE_TZ VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE_TZ VARCHAR(30) NULL);



/****** Object:  Table PCMM.PCMM_ALERT_COMMENT    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE PCMM.PCMM_ALERT_COMMENT(
  PCMM_ALERT_COMMENT_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  APP_USER_id NUMBER(20, 0) NOT NULL UNIQUE,
  PCMM_ALERT_id NUMBER(20, 0) NOT NULL UNIQUE,
  COMMENTS VARCHAR(250) NOT NULL,
  RECORD_CREATED_BY VARCHAR(30) NULL,
  RECORD_CREATED_DATE DATE NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE DATE NULL,
  RECORD_MODIFIED_COUNT NUMBER(10, 0) NOT NULL,
  RECORD_CREATED_DATE_TZ VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE_TZ VARCHAR(30) NULL);


/****** Object:  Table PCMM.PCMM_ALERT_H    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE PCMM.PCMM_ALERT_H(
  PCMM_ALERT_H_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  TRANSACTION_TYPE_CODE VARCHAR(1) NULL,
  PCMM_ALERT_id NUMBER(20, 0) NOT NULL UNIQUE,
  MULTI_PCP_ID NUMBER(20, 0) NULL,
  PCMM_PATIENT_ID NUMBER(20, 0) NULL,
  PCM_STD_ALERT_TEMPLATE_id NUMBER(20, 0) NOT NULL UNIQUE,
  TEAM_ID NUMBER(20, 0) NULL,
  STAFF_ID NUMBER(20, 0) NULL,
  SENDER_APP_USER_ID NUMBER(20, 0) NULL,
  CLOSED_BY_APP_USER_ID NUMBER(20, 0) NULL,
  PCMM_JOB_EXECUTION_RESULT_ID NUMBER(20, 0) NULL,
  MESSAGE VARCHAR(512) NULL,
  ALERT_CLOSED_IND VARCHAR(1) NOT NULL,
  ALERT_CLOSED_DATE DATE NULL,
  ALERT_BATCH_INDEX NUMBER NULL,
  ALERT_ACTIVATION_DATE DATE NOT NULL,
  RECORD_CREATED_BY VARCHAR(30) NOT NULL,
  RECORD_CREATED_DATE DATE NOT NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NOT NULL,
  RECORD_MODIFIED_DATE DATE NOT NULL,
  RECORD_MODIFIED_COUNT NUMBER(10, 0) NOT NULL,
  RECORD_CREATED_DATE_TZ VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE_TZ VARCHAR(30) NULL,
  HISTORY_RECORD_CREATE_DATE DATE NOT NULL);


/****** Object:  Table PCMM.PCMM_ALERT_RECIPIENT    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE PCMM.PCMM_ALERT_RECIPIENT(
  PCMM_ALERT_RECIPIENT_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  PCMM_ALERT_id NUMBER(20, 0) NOT NULL UNIQUE,
  VA_FACILITY_id NUMBER(20, 0) NOT NULL UNIQUE,
  ROLE_ID NUMBER(20, 0) NULL,
  APP_USER_ID NUMBER(20, 0) NULL,
  HIBERNATE_CLASS_TYPE VARCHAR(20) NOT NULL,
  RECORD_CREATED_BY VARCHAR(30) NOT NULL,
  RECORD_CREATED_DATE DATE NOT NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NOT NULL,
  RECORD_MODIFIED_DATE DATE NOT NULL,
  RECORD_MODIFIED_COUNT NUMBER(10, 0) NOT NULL,
  RECORD_CREATED_DATE_TZ VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE_TZ VARCHAR(30) NULL);



/****** Object:  Table PCMM.PCMM_ALERT_RECIPIENT_INACTIVATION    Script Date: 8/20/2015 6:11:42 PM ******/

CREATE TABLE PCMM.ALERT_RECIPIENT_INACTIVATION(
  RECIPIENT_INACTIVATION_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  VA_FACILITY_id NUMBER(20, 0) NOT NULL UNIQUE,
  ALERT_TEMPLATE_RECIPIENT_id NUMBER(20, 0) NOT NULL UNIQUE,
  RECORD_CREATED_BY VARCHAR(30) NULL,
  RECORD_CREATED_DATE DATE NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE DATE NULL,
  RECORD_MODIFIED_COUNT NUMBER(10, 0) NOT NULL,
  RECORD_CREATED_DATE_TZ VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE_TZ VARCHAR(30) NULL);

/****** Object:  Table PCMM.PCMM_APP_PARAMETERS    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE PCMM.PCMM_APP_PARAMETERS(
  PCMM_APP_PARAMETERS_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  PARAMETER_name VARCHAR(80) NOT NULL UNIQUE,
  PARAMETER_VALUE VARCHAR(250) NOT NULL,
  RECORD_CREATED_BY VARCHAR(30) NULL,
  RECORD_CREATED_DATE DATE NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE DATE NULL,
  RECORD_MODIFIED_COUNT NUMBER(10, 0) NULL,
  RECORD_CREATED_DATE_TZ VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE_TZ VARCHAR(30) NULL);



/****** Object:  Table PCMM.PCMM_BATCH_JOB_EXECUTION    Script Date: 8/20/2015 6:11:42 PM ******/




CREATE TABLE PCMM.PCMM_BATCH_JOB_EXECUTION(
  JOB_EXECUTION_ID NUMBER UNIQUE NOT NULL,
  VERSION_NUMBER NUMBER NULL,
  JOB_INSTANCE_ID NUMBER NOT NULL,
  CREATE_TIME DATE NOT NULL,
  START_TIME DATE NULL,
  END_TIME DATE NULL,
  STATUS VARCHAR(10) NULL,
  EXIT_CODE VARCHAR(100) NULL,
  EXIT_MESSAGE VARCHAR(2500) NULL,
  LAST_UPDATED DATE NULL);



/****** Object:  Table PCMM.PCMM_BATCH_JOB_EXECUTION_CONTEXT    Script Date: 8/20/2015 6:11:42 PM ******/







CREATE TABLE PCMM.BATCH_JOB_EXECUTION_CONTEXT(
  JOB_EXECUTION_ID NUMBER NOT NULL PRIMARY KEY,
  SHORT_CONTEXT VARCHAR(2500) NOT NULL,
  SERIALIZED_CONTEXT VARCHAR(20) NULL);




/****** Object:  Table PCMM.PCMM_BATCH_JOB_EXECUTION_PARAMS    Script Date: 8/20/2015 6:11:42 PM ******/





CREATE TABLE PCMM.PCMM_BATCH_JOB_EXECUTION_PARAM(
  JOB_EXECUTION_ID NUMBER NOT NULL,
  TYPE_CD VARCHAR(6) NOT NULL,
  KEY_NAME VARCHAR(100) NOT NULL,
  STRING_VAL VARCHAR(100) NULL,
  DATE_VAL DATE NULL,
  LONG_VAL NUMBER NULL,
  DOUBLE_VAL float NULL,
  IDENTIFYING char(1) NOT NULL
);




/****** Object:  Table PCMM.PCMM_BATCH_JOB_EXECUTION_SEQ    Script Date: 8/20/2015 6:11:42 PM ******/




CREATE TABLE PCMM.PCMM_BATCH_JOB_EXECUTION_SEQ(
  ID NUMBER PRIMARY KEY NOT NULL
);


/****** Object:  Table PCMM.PCMM_BATCH_JOB_INSTANCE    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE PCMM.PCMM_BATCH_JOB_INSTANCE(
  JOB_INSTANCE_ID NUMBER NOT NULL PRIMARY KEY,
  VERSION NUMBER NULL,
  JOB_NAME VARCHAR(100) NOT NULL UNIQUE,
  JOB_KEY VARCHAR(32) NOT NULL UNIQUE);




/****** Object:  Table PCMM.PCMM_BATCH_JOB_SEQ    Script Date: 8/20/2015 6:11:42 PM ******/




CREATE TABLE PCMM.PCMM_BATCH_JOB_SEQ(
  ID NUMBER PRIMARY KEY NOT NULL
);


/****** Object:  Table PCMM.PCMM_BATCH_STEP_EXECUTION    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE PCMM.PCMM_BATCH_STEP_EXECUTION(
  STEP_EXECUTION_ID NUMBER NOT NULL PRIMARY KEY,
  VERSION NUMBER NOT NULL,
  STEP_NAME VARCHAR(100) NOT NULL,
  JOB_EXECUTION_ID NUMBER NOT NULL,
  START_TIME DATE NOT NULL,
  END_TIME DATE NULL,
  STATUS VARCHAR(10) NULL,
  COMMIT_COUNT NUMBER NULL,
  READ_COUNT NUMBER NULL,
  FILTER_COUNT NUMBER NULL,
  WRITE_COUNT NUMBER NULL,
  READ_SKIP_COUNT NUMBER NULL,
  WRITE_SKIP_COUNT NUMBER NULL,
  PROCESS_SKIP_COUNT NUMBER NULL,
  ROLLBACK_COUNT NUMBER NULL,
  EXIT_CODE VARCHAR(100) NULL,
  EXIT_MESSAGE VARCHAR(2500) NULL,
  LAST_UPDATED DATE NULL);



/****** Object:  Table PCMM.PCMM_BATCH_STEP_EXECUTION_CONTEXT    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE PCMM.PCMM_BATCH_STEP_EXE_CONTEXT(
  STEP_EXECUTION_ID NUMBER NOT NULL PRIMARY KEY,
  SHORT_CONTEXT VARCHAR(2500) NOT NULL,
  SERIALIZED_CONTEXT varchar(20) NULL);




/****** Object:  Table PCMM.PCMM_BATCH_STEP_EXECUTION_SEQ    Script Date: 8/20/2015 6:11:42 PM ******/




CREATE TABLE PCMM.PCMM_BATCH_STEP_EXECUTION_SEQ(
  ID NUMBER PRIMARY KEY NOT NULL
);


/****** Object:  Table PCMM.PCMM_BINARY_OBJECTS    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE PCMM.PCMM_BINARY_OBJECTS(
  PCMM_BINARY_OBJECTS_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  BINARY_OBJECT VARCHAR(100) NOT NULL,
  RECORD_CREATED_BY VARCHAR(30) NULL,
  RECORD_CREATED_DATE DATE NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE DATE NULL,
  RECORD_MODIFIED_COUNT NUMBER(10, 0) NOT NULL,
  RECORD_CREATED_DATE_TZ VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE_TZ VARCHAR(30) NULL);




/****** Object:  Table PCMM.PCMM_FUTURE_LOCAL_VISTA_MERGE    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE PCMM.PCMM_FUTURE_LOCAL_VISTA_MERGE(
  FUTURE_LOCAL_VISTA_MERGE_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  FROM_DFN VARCHAR(30) NOT NULL,
  FROM_STATION_NUMBER VARCHAR(7) NOT NULL,
  FROM_ICN VARCHAR(30) NOT NULL,
  TO_DFN VARCHAR(30) NOT NULL,
  TO_STATION_NUMBER VARCHAR(7) NULL,
  TO_ICN VARCHAR(30) NOT NULL,
  RECORD_CREATED_BY VARCHAR(30) NULL,
  RECORD_CREATED_DATE DATE NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE DATE NULL,
  RECORD_MODIFIED_COUNT NUMBER(10, 0) NOT NULL,
  RECORD_CREATED_DATE_TZ VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE_TZ VARCHAR(30) NULL);



/****** Object:  Table PCMM.PCMM_GROUP    Script Date: 8/20/2015 6:11:42 PM ******/








/******   Object:  Table PCMM.PCMM_JOB_EXECUTION_METADATA    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE PCMM.PCMM_JOB_EXECUTION_METADATA(
  PCMM_JOB_EXECUTION_METADATA_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  PCM_STD_JOB_EXECUTION_TYPE_id NUMBER(20, 0) NOT NULL UNIQUE,
  JOB_NAME VARCHAR(50) NOT NULL,
  JOB_VALUE VARCHAR(250) NULL,
  RECORD_CREATED_BY VARCHAR(30) NOT NULL,
  RECORD_CREATED_DATE DATE NOT NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NOT NULL,
  RECORD_MODIFIED_DATE DATE NOT NULL,
  RECORD_MODIFIED_COUNT NUMBER(10, 0) NOT NULL,
  RECORD_CREATED_DATE_TZ VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE_TZ VARCHAR(30) NULL);



/****** Object:  Table PCMM.PCMM_JOB_EXECUTION_RESULT    Script Date: 8/20/2015 6:11:42 PM ******/




CREATE TABLE PCMM.PCMM_JOB_EXECUTION_RESULT(
  PCMM_JOB_EXECUTION_RESULT_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  PCM_STD_JOB_EXECUTION_TYPE_id NUMBER(20, 0) NOT NULL UNIQUE,
  EXECUTE_REQUEST_BY NUMBER(20, 0) NULL,
  VA_INSTITUTION_ID NUMBER(20, 0) NULL,
  JOB_EXECUTION_ID NUMBER NULL,
  START_TIME DATE NOT NULL,
  END_TIME DATE NULL);

/****** Object:  Table PCMM.PCMM_JOB_EXECUTION_RESULT_ITEM    Script Date: 8/20/2015 6:11:42 PM ******/

CREATE TABLE PCMM.PCMM_JOB_EXECUTION_RESULT_ITEM(
  PCMM_JOB_EXECUTION_RES_ITEM_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  STATUS_EXCEPTION_BINARY_OBJ_ID NUMBER(20, 0) NULL,
  PCMM_JOB_EXECUTION_RESULT_ID NUMBER(20, 0) NULL,
  TEAM_ID NUMBER(20, 0) NULL,
  TEAM_POSITION_ID NUMBER(20, 0) NULL,
  PCMM_PATIENT_ID NUMBER(20, 0) NULL,
  START_TIME DATE NULL,
  END_TIME DATE NULL,
  STATUS_MESSAGE VARCHAR(2500) NULL,
  JOB_SUCCESS_IND VARCHAR(1) NOT NULL);



/****** Object:  Table PCMM.PCMM_PATIENT    Script Date: 8/20/2015 6:11:42 PM ******/









/****** Object:    Table PCMM.PCMM_PATIENT_H    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE PCMM.PCMM_PATIENT_H(
  PCMM_PATIENT_H_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  TRANSACTION_TYPE_CODE VARCHAR(1) NULL,
  PCMM_PATIENT_id NUMBER(20, 0) NOT NULL UNIQUE,
  GENDER_ID NUMBER(20, 0) NULL,
  FIRST_NAME VARCHAR(30) NULL,
  MIDDLE_NAME VARCHAR(30) NULL,
  LAST_NAME VARCHAR(40) NOT NULL,
  SSN VARCHAR(15) NULL,
  PSEUDO_SSN VARCHAR(9) NULL,
  BIRTH_DATE VARCHAR(15) NULL,
  BIRTH_DATE_VISTA_FORMAT VARCHAR(20) NULL,
  DEATH_DATE VARCHAR(15) NULL,
  DEATH_DATE_VISTA_FORMAT VARCHAR(20) NULL,
  VISTA_PATIENT_NAME VARCHAR(100) NULL,
  FORMER_LAST_NAME VARCHAR(40) NULL,
  PREFIX VARCHAR(20) NULL,
  SUFFIX VARCHAR(20) NULL,
  VPID_VALUE VARCHAR(30) NULL,
  ICN VARCHAR(80) NULL,
  PRIMARY_ELIGIBILITY VARCHAR(30) NULL,
  PRIMARY_ELIGIBILITY_DATE DATE NULL,
  MEANS_TEST_RESULT VARCHAR(50) NULL,
  MEANS_TEST_RESULT_DATE DATE NULL,
  PATIENT_VERIFIED_IND VARCHAR(1) NULL,
  EMAIL_ADDRESS VARCHAR(128) NULL,
  DUAL_PRIMARY_CARE_PROV_IND VARCHAR(1) NULL,
  LAST_VISIT_DATE DATE NULL,
  INACTIVITY_DATE DATE NULL,
  HOME_STATION_NUMBER VARCHAR(7) NULL,
  PatientSID NUMBER(20, 0) NULL,
  SSN_VERIFICATION_STATUS_ID NUMBER(20, 0) NULL,
  ROI_INDICATOR VARCHAR(1) NULL,
  SENSITIVE_PATIENT_IND VARCHAR(1) NULL,
  ADDR_CITY VARCHAR(30) NULL,
  ADDR_STATE VARCHAR(30) NULL,
  PHONE VARCHAR(25) NULL,
  ENROLLMENT_STATUS_ID NUMBER(20, 0) NULL,
  RECORD_CREATED_BY VARCHAR(30) NULL,
  RECORD_CREATED_DATE DATE NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE DATE NULL,
  RECORD_MODIFIED_COUNT NUMBER(10, 0) NOT NULL,
  RECORD_CREATED_DATE_TZ VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE_TZ VARCHAR(30) NULL,
  HISTORY_RECORD_CREATE_DATE DATE NOT NULL);




/****** Object:  Table PCMM.PCMM_SENSITIVE_PATIENTS_ACCESS_LOG    Script Date: 8/20/2015 6:11:42 PM ******/





CREATE TABLE PCMM.SENSITIVE_PATIENTS_ACCESS_LOG(
  SENSITIVE_PATIENTS_LOG_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  PCMM_PATIENT_id NUMBER(20, 0) NOT NULL UNIQUE,
  DFN VARCHAR(30) NULL,
  STATION_NUMBER VARCHAR(7) NOT NULL,
  RECORD_ACCESSED_BY VARCHAR(30) NOT NULL,
  RECORD_ACCESSED_DATE DATE NOT NULL,
  RECORD_CREATED_BY VARCHAR(30) NULL,
  RECORD_CREATED_DATE DATE NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE DATE NULL,
  RECORD_MODIFIED_COUNT NUMBER(10, 0) NOT NULL,
  RECORD_CREATED_DATE_TZ VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE_TZ VARCHAR(30) NULL);



/****** Object:  Table PCMM.PCMM_VISTA_INSTANCE    Script Date: 8/20/2015 6:11:42 PM ******/





CREATE TABLE PCMM.PCMM_VISTA_INSTANCE(
  PCMM_VISTA_INSTANCE_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  STATION_NUMBER VARCHAR(7) NOT NULL,
  INACTIV_PROCESS_LAST_EXE_DATE DATE NULL,
  TIME_ZONE VARCHAR(50) NULL,
  PATIENT_INACTIVATE_ENABLED_IND VARCHAR(1) NOT NULL,
  VISTA_SYNC_PROCESS_ENABLED_IND VARCHAR(1) NOT NULL,
  VISTA_CLEANUP_ENABLED_IND VARCHAR(1) NOT NULL,
  MVI_REGISTRATION_ENABLED_IND VARCHAR(1) NOT NULL,
  VISTA_CLEANUP_LAST_EXE_DATE DATE NULL,
  STAFF_UPDATE_PROCESS_ENABL_IND VARCHAR(1) NOT NULL,
  STAFF_UPDATE_LAST_EXE_DATE DATE NULL,
  CPRS_SYNC_PROCESS_ENABLED_IND VARCHAR(1) NOT NULL,
  CPRS_SYNC_PROCESS_EXE_DATE DATE NULL,
  TRANSITION_DATE DATE NULL,
  MAILMAN_ENABLED_IND VARCHAR(1) NOT NULL,
  RECORD_CREATED_BY VARCHAR(30) NULL,
  RECORD_CREATED_DATE DATE NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE DATE NULL,
  RECORD_MODIFIED_COUNT NUMBER(10, 0) NOT NULL,
  RECORD_CREATED_DATE_TZ VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE_TZ VARCHAR(30) NULL);



/****** Object:  Table PCMM.PCMM_VISTA_PATIENT    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE PCMM.PCMM_VISTA_PATIENT(
  PCMM_VISTA_PATIENT_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  PCMM_PATIENT_id NUMBER(20, 0) NOT NULL UNIQUE,
  DFN VARCHAR(30) NOT NULL UNIQUE,
  LAST_PC_COUNT_SYNCED_TO_VISTA NUMBER(4, 0) NULL,
  MVI_REGISTRATION_IND VARCHAR(1) NOT NULL,
  CPRS_HEADER_TEXT VARCHAR(500) NOT NULL,
  CPRS_HEAD_VISTA_SYNC_NEED_IND VARCHAR(1) NOT NULL,
  CPRS_HEAD_VISTA_SYNC_DATE DATE NULL,
  DEATH_DATE VARCHAR(15) NULL,
  DEATH_DATE_VISTA_FORMAT VARCHAR(20) NULL,
  VA_INSTITUTION_ID NUMBER(20, 0) NULL UNIQUE,
  PatientSID NUMBER NULL,
  MVI_CORRELATED_ICN VARCHAR(30) NULL,
  Sta3n VARCHAR(7) NULL,
  RECORD_CREATED_BY VARCHAR(30) NULL,
  RECORD_CREATED_DATE DATE NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE DATE NULL,
  RECORD_MODIFIED_COUNT NUMBER(10, 0) NOT NULL,
  RECORD_CREATED_DATE_TZ VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE_TZ VARCHAR(30) NULL);




/****** Object:  Table PCMM.PCMM_VISTA_PATIENT_H    Script Date: 8/20/2015 6:11:42 PM ******/





 
 CREATE TABLE PCMM.PCMM_VISTA_PATIENT_H(
  PCMM_VISTA_PATIENT_H_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  TRANSACTION_TYPE_CODE VARCHAR(1) NULL,
  PCMM_VISTA_PATIENT_id NUMBER(20, 0) NOT NULL UNIQUE,
  PCMM_PATIENT_ID NUMBER(20, 0) NULL,
  DFN VARCHAR(30) NULL,
  ASSIGN_COUNT_SYNCED_TO_VISTA NUMBER(4, 0) NULL,
  MVI_REGISTRATION_IND VARCHAR(1) NOT NULL,
  CPRS_HEADER_TEXT VARCHAR(500) NULL,
  CPRS_HEAD_VISTA_SYNC_NEED_IND VARCHAR(1) NULL,
  CPRS_HEAD_VISTA_SYNC_DATE DATE NULL,
  DEATH_DATE VARCHAR(15) NULL,
  DEATH_DATE_VISTA_FORMAT VARCHAR(20) NULL,
  VA_INSTITUTION_ID NUMBER(20, 0) NULL,
  PatientSID NUMBER NULL,
  MVI_CORRELATED_ICN VARCHAR(30) NULL,
  Sta3n VARCHAR(7) NULL,
  RECORD_CREATED_BY VARCHAR(30) NULL,
  RECORD_CREATED_DATE DATE NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE DATE NULL,
  RECORD_MODIFIED_COUNT NUMBER(10, 0) NOT NULL,
  RECORD_CREATED_DATE_TZ VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE_TZ VARCHAR(30) NULL,
  HISTORY_REC_CREATE_DATE DATE NOT NULL);




/****** Object:  Table PCMM.PRECEPTOR_ASSIGNMENT    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE PCMM.PRECEPTOR_ASSIGNMENT(
  PRECEPTOR_ASSIGNMENT_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  PRECEPTOR_id NUMBER(20, 0) NOT NULL UNIQUE,
  PRECEPTEE_id NUMBER(20, 0) NOT NULL UNIQUE,
  START_DATE DATE NULL,
  END_DATE DATE NULL,
  ASSIGNMENT_IEN VARCHAR(30) NULL,
  UNASSIGNMENT_IEN VARCHAR(30) NULL,
  RECORD_CREATED_BY VARCHAR(30) NULL,
  RECORD_CREATED_DATE DATE NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE DATE NULL,
  RECORD_MODIFIED_COUNT NUMBER(10, 0) NOT NULL,
  RECORD_CREATED_DATE_TZ VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE_TZ VARCHAR(30) NULL,
  ProviderPreceptorRelationSID NUMBER(20, 0) NULL);


/****** Object:  Table PCMM.PRECEPTOR_ASSIGNMENT_H    Script Date: 8/20/2015 6:11:42 PM ******/





 
CREATE TABLE PCMM.PRECEPTOR_ASSIGNMENT_H(
  PRECEPTOR_ASSIGNMENT_H_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  TRANSACTION_TYPE_CODE char(1) NULL,
  PRECEPTOR_ASSIGNMENT_id NUMBER(20, 0) NOT NULL UNIQUE,
  PRECEPTOR_id NUMBER(20, 0) NOT NULL UNIQUE,
  PRECEPTEE_id NUMBER(20, 0) NOT NULL UNIQUE,
  START_DATE DATE NULL,
  END_DATE DATE NULL,
  ASSIGNMENT_IEN VARCHAR(30) NULL,
  UNASSIGNMENT_IEN VARCHAR(30) NULL,
  RECORD_CREATED_BY VARCHAR(30) NULL,
  RECORD_CREATED_DATE DATE NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE DATE NULL,
  RECORD_MODIFIED_COUNT NUMBER(10, 0) NULL,
  RECORD_CREATED_DATE_TZ VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE_TZ VARCHAR(30) NULL,
  ProviderPreceptorRelationSID VARCHAR(30) NULL,
  HISTORY_RECORD_CREATE_DATE DATE NOT NULL);




/****** Object:  Table PCMM.STAFF    Script Date: 8/20/2015 6:11:42 PM ******/







/****** Object:  Table PCMM.STAFF_H    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE PCMM.STAFF_H(
  STAFF_H_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  TRANSACTION_TYPE_CODE char(1) NULL,
  STAFF_id NUMBER(20, 0) NOT NULL UNIQUE,
  VA_INSTITUTION_ID NUMBER(20, 0) NULL,
  STAFF_IEN VARCHAR(30) NULL,
  ACTIVE_DIRECTORY_NAME VARCHAR(20) NULL,
  STA3N VARCHAR(7) NULL,
  FIRST_NAME VARCHAR(30) NULL,
  MIDDLE_NAME VARCHAR(30) NULL,
  LAST_NAME VARCHAR(40) NOT NULL,
  SSN VARCHAR(15) NULL,
  BIRTH_DATE VARCHAR(15) NULL,
  BIRTH_DATE_VISTA_FORMAT VARCHAR(20) NULL,
  PREFIX VARCHAR(20) NULL,
  SUFFIX VARCHAR(20) NULL,
  TITLE VARCHAR(255) NULL,
  MAIL_CODE VARCHAR(20) NULL,
  PHONE_NUMBER VARCHAR(30) NULL,
  BEEPER_NUMBER VARCHAR(30) NULL,
  EMAIL_ADDRESS VARCHAR(128) NULL,
  ADDRESS_LINE1 VARCHAR(100) NULL,
  ADDRESS_LINE2 VARCHAR(100) NULL,
  ADDRESS_LINE3 VARCHAR(100) NULL,
  CITY VARCHAR(60) NULL,
  STATE VARCHAR(50) NULL,
  ZIP_CODE VARCHAR(10) NULL,
  PERSON_CLASS_VA_CODE VARCHAR(7) NULL,
  STAFFSID NUMBER NULL,
  TERMINATION_DATE VARCHAR(15) NULL,
  TERMINATION_DATE_VISTA_FORMAT VARCHAR(20) NULL,
  RECORD_CREATED_BY VARCHAR(30) NULL,
  RECORD_CREATED_DATE DATE NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE DATE NULL,
  RECORD_MODIFIED_COUNT NUMBER(10, 0) NULL,
  RECORD_CREATED_DATE_TZ VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE_TZ VARCHAR(30) NULL,
  HISTORY_RECORD_CREATE_DATE DATE NOT NULL);



/****** Object:  Table PCMM.SURROGATE_STAFF_ASSIGN_TEAM_POSITION    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE PCMM.SURR_STAFF_ASSIGN_TEAM_POS(
  STAFF_ASSIGN_TEAM_POS_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  TEAM_id NUMBER(20, 0) NOT NULL UNIQUE,
  TEAM_POSITION_id NUMBER(20, 0) NOT NULL UNIQUE,
  STAFF_id NUMBER(20, 0) NOT NULL UNIQUE,
  START_DATE DATE NOT NULL,
  END_DATE DATE NOT NULL,
  SURROGATE_UNASSIGN_IND VARCHAR(1) NOT NULL,
  RECORD_CREATED_BY VARCHAR(30) NULL,
  RECORD_CREATED_DATE DATE NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE DATE NULL,
  RECORD_MODIFIED_COUNT NUMBER(10, 0) NOT NULL,
  RECORD_CREATED_DATE_TZ VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE_TZ VARCHAR(30) NULL);




/****** Object:  Table PCMM.TEAM    Script Date: 8/20/2015 6:11:42 PM ******/







/****** Object:  Table PCMM.TEAM_GROUP    Script Date: 8/20/2015 6:11:42 PM ******/










/****** Object:     Table PCMM.TEAM_H    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE PCMM.TEAM_H(
  TEAM_H_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  TRANSACTION_TYPE_CODE char(1) NULL,
  TEAM_id NUMBER(20, 0) NOT NULL UNIQUE,
  PCM_STD_TEAM_FOCUS_ID NUMBER(20, 0) NULL,
  PCM_STD_TEAM_FOCUS2_ID NUMBER(20, 0) NULL,
  VA_INSTITUTION_ID NUMBER(20, 0) NULL,
  PCM_STD_TEAM_CARE_TYPE_ID NUMBER(20, 0) NULL,
  LAST_ERROR_BINARY_OBJECT_ID NUMBER(20, 0) NULL,
  UPDATED_BY_VISTA_AUTH_TOKEN_ID NUMBER(20, 0) NULL,
  TEAM_NAME VARCHAR(30) NULL,
  TEAM_DESCRIPTION VARCHAR(250) NULL,
  ADJUSTED_OVERRIDE_CAPACITY NUMBER(10, 0) NULL,
  TEAM_CLOSED_IND VARCHAR(1) NULL,
  ALLOW_OVERRIDE_IND VARCHAR(1) NULL,
  CAPACITY_OVERRIDE_REASON VARCHAR(250) NULL,
  MODELED_CAPACITY NUMBER(10, 0) NULL,
  IEN VARCHAR(30) NULL,
  VALIDATION_NEEDED_IND VARCHAR(1) NULL,
  TeamSID NUMBER(20, 0) NULL,
  LAST_VISTA_SYNC_DATE DATE NULL,
  LAST_ERROR_STR VARCHAR(100) NULL,
  SYNC_AFTER_VALIDATION_NEED_IND VARCHAR(1) NULL,
  Sta3n VARCHAR(7) NULL,
  RECORD_CREATED_BY VARCHAR(30) NULL,
  RECORD_CREATED_DATE DATE NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE DATE NULL,
  RECORD_MODIFIED_COUNT NUMBER(10, 0) NULL,
  RECORD_CREATED_DATE_TZ VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE_TZ VARCHAR(30) NULL,
  HISTORY_RECORD_CREATE_DATE DATE NOT NULL);



/****** Object:  Table PCMM.TEAM_MEMBERSHIP    Script Date: 8/20/2015 6:11:42 PM ******/







/****** Object:  Table   PCMM.TEAM_MEMBERSHIP_DETAIL_HISTORY    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE PCMM.TEAM_MEMBERSHIP_DETAIL_HISTORY(
  TEAM_MEMB_DETAIL_HISTORY_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  TEAM_MEMBERSHIP_id NUMBER(20, 0) NOT NULL UNIQUE,
  EFFECTIVE_DATE DATE NOT NULL,
  FTEE_ASSIGNMENT NUMBER(10, 2) NULL,
  FTEEHistoryIEN VARCHAR(30) NULL,
  ProviderFTEESID NUMBER NULL,
  BATCH_UPDATE_NOTE VARCHAR(250) NULL,
  RECORD_CREATED_BY VARCHAR(30) NULL,
  RECORD_CREATED_DATE DATE NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE DATE NULL,
  RECORD_MODIFIED_COUNT NUMBER(10, 0) NOT NULL,
  RECORD_CREATED_DATE_TZ VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE_TZ VARCHAR(30) NULL);




/****** Object:  Table PCMM.TEAM_MEMBERSHIP_DETAIL_HISTORY_H    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE PCMM.TEAM_MEMB_DETAIL_HISTORY_H(
  TEAM_MEMB_DETAIL_HISTORY_H_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  TRANSACTION_TYPE_CODE char(1) NULL,
  TEAM_MEMB_DETAIL_HISTORY_ID NUMBER(20, 0) NULL,
  TEAM_MEMBERSHIP_id NUMBER(20, 0) NOT NULL UNIQUE,
  EFFECTIVE_DATE DATE NULL,
  FTEE_ASSIGNMENT NUMBER(10, 2) NULL,
  FTEEHistoryIEN VARCHAR(30) NULL,
  ProviderFTEESID NUMBER NULL,
  BATCH_UPDATE_NOTE VARCHAR(250) NULL,
  RECORD_CREATED_BY VARCHAR(30) NULL,
  RECORD_CREATED_DATE DATE NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE DATE NULL,
  RECORD_MODIFIED_COUNT NUMBER(10, 0) NULL,
  RECORD_CREATED_DATE_TZ VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE_TZ VARCHAR(30) NULL,
  HISTORY_RECORD_CREATE_DATE DATE NOT NULL);



/****** Object:  Table PCMM.TEAM_MEMBERSHIP_H    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE PCMM.TEAM_MEMBERSHIP_H(
  TEAM_MEMBERSHIP_H_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  TRANSACTION_TYPE_CODE char(1) NULL,
  TEAM_MEMBERSHIP_id NUMBER(20, 0) NOT NULL UNIQUE,
  PCM_STD_TEAM_ROLE_ID NUMBER(20, 0) NULL,
  PCM_STD_STAFF_ROLE_ID NUMBER(20, 0) NULL,
  STAFF_ID NUMBER(20, 0) NULL,
  TEAM_POSITION_ID NUMBER(20, 0) NULL,
  PCM_STD_STAFF_ASSIGN_REASON_ID NUMBER(20, 0) NULL,
  TEAM_ID NUMBER(20, 0) NULL,
  START_DATE DATE NULL,
  END_DATE DATE NULL,
  ASSIGNMENT_IEN VARCHAR(30) NULL,
  UNASSIGNMENT_IEN VARCHAR(30) NULL,
  ProviderPositionAssignmentSID NUMBER(20, 0) NULL,
  TEMPORARY_PCP_IND VARCHAR(1) NULL,
  BATCH_UPDATE_NOTE VARCHAR(250) NULL,
  RECORD_CREATED_BY VARCHAR(30) NULL,
  RECORD_CREATED_DATE DATE NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE DATE NULL,
  RECORD_MODIFIED_COUNT NUMBER(10, 0) NULL,
  RECORD_CREATED_DATE_TZ VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE_TZ VARCHAR(30) NULL,
  HISTORY_RECORD_CREATE_DATE DATE NOT NULL);




/****** Object:  Table PCMM.TEAM_NOTIFICATION_DISTRIBUTION_RULES    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE PCMM.TEAM_NOTIFY_DISTRIBUTION_RULES(
  NOTIFY_DISTRIBUTION_RULE_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  PCM_STD_NOTIFICATION_TYPE_id NUMBER(20, 0) NOT NULL UNIQUE,
  TEAM_ID NUMBER(20, 0) NULL,
  TEAM_POSITION_ID NUMBER(20, 0) NULL,
  DO_NOT_SEND_IND VARCHAR(1) NOT NULL,
  PRECEPTOR_IND VARCHAR(1) NOT NULL,
  ALL_TEAM_PATIENTS_IND VARCHAR(1) NOT NULL,
  RECORD_CREATED_BY VARCHAR(30) NULL,
  RECORD_CREATED_DATE DATE NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE DATE NULL,
  RECORD_MODIFIED_COUNT NUMBER(10, 0) NOT NULL,
  RECORD_CREATED_DATE_TZ VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE_TZ VARCHAR(30) NULL);



/****** Object:  Table PCMM.TEAM_PATIENT_ASSIGN    Script Date: 8/20/2015 6:11:42 PM ******/








/****** Object:     Table PCMM.TEAM_PATIENT_ASSIGN_H    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE PCMM.TEAM_PATIENT_ASSIGN_H(
  TEAM_PATIENT_ASSIGN_H_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  TRANSACTION_TYPE_CODE VARCHAR(1) NULL,
  TEAM_PATIENT_ASSIGN_id NUMBER(20, 0) NOT NULL UNIQUE,
  PCMM_PATIENT_ID NUMBER(20, 0) NULL,
  TEAM_ID NUMBER(20, 0) NULL,
  PATIENT_UNASSIGN_REASON_ID NUMBER(20, 0) NULL,
  INACTIVATION_EXTEND_REASON_ID NUMBER(20, 0) NULL,
  START_DATE DATE NULL,
  END_DATE DATE NULL,
  IEN VARCHAR(30) NULL,
  AUTO_INACTIVATION_DATE DATE NULL,
  LAST_ENCOUNTER_DATE DATE NULL,
  INACTIVATION_EXT_REC_COMMENT VARCHAR(250) NULL,
  PatientTeamAssignmentSID NUMBER(20, 0) NULL,
  FIRST_ENCOUNTER_DATE DATE NULL,
  MULTI_PCP_ID NUMBER(20, 0) NULL,
  PCM_STD_MULTIPCP_STATUS_ID NUMBER(20, 0) NULL,
  TEAM_PATIENT_ASSIGN_STATUS_ID NUMBER(20, 0) NULL,
  REQUESTED_START_DATE DATE NULL,
  LEGACY_ASSIGNMENT_TYPE VARCHAR(50) NULL,
  PREV_TEAM_PATIENT_ASSIGN_ID NUMBER(20, 0) NULL,
  Sta3n VARCHAR(7) NULL,
  BATCH_UPDATE_NOTE VARCHAR(250) NULL,
  LAST_ENCOUNTER_STAFF_ID NUMBER(20, 0) NULL,
  RECORD_CREATED_BY VARCHAR(30) NULL,
  RECORD_CREATED_DATE DATE NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE DATE NULL,
  RECORD_MODIFIED_COUNT NUMBER(10, 0) NOT NULL,
  RECORD_CREATED_DATE_TZ VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE_TZ VARCHAR(30) NULL,
  HISTORY_RECORD_CREATE_DATE DATE NOT NULL);



/****** Object:  Table PCMM.TEAM_POSITION    Script Date: 8/20/2015 6:11:42 PM ******/









/****** Object:     Table PCMM.TEAM_POSITION_H    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE PCMM.TEAM_POSITION_H(
  TEAM_POSITION_H_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  TRANSACTION_TYPE_CODE char(1) NULL,
  TEAM_POSITION_ID NUMBER(20, 0) NULL,
  PCM_STD_TEAM_ROLE_ID NUMBER(20, 0) NULL,
  TEAM_ID NUMBER(20, 0) NULL,
  MODEL_TEAM_ID NUMBER(20, 0) NULL,
  POSITION_DESCRIPTION VARCHAR(50) NULL,
  EXPECTED_FTEE NUMBER(6, 2) NULL,
  PATIENT_ALLOWED_CAPACITY NUMBER(10, 0) NULL,
  TEAM_LEAD_IND VARCHAR(1) NULL,
  PRIMARY_TEAM_CONTACT_IND VARCHAR(1) NULL,
  REQUIRED_IND VARCHAR(1) NULL,
  SECONDARY_TEAM_CONTACT_IND VARCHAR(1) NULL,
  IEN VARCHAR(30) NULL,
  ALLOW_OVERRIDE_IND VARCHAR(1) NULL,
  CAPACITY_OVERRIDE_REASON VARCHAR(250) NULL,
  TeamPositionSID NUMBER(20, 0) NULL,
  LEGACY_PCM_STD_TEAM_ROLE_ID NUMBER(20, 0) NULL,
  BATCH_UPDATE_NOTE VARCHAR(250) NULL,
  RECORD_CREATED_BY VARCHAR(30) NULL,
  RECORD_CREATED_DATE DATE NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE DATE NULL,
  RECORD_MODIFIED_COUNT NUMBER(10, 0) NOT NULL,
  RECORD_CREATED_DATE_TZ VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE_TZ VARCHAR(30) NULL,
  HISTORY_RECORD_CREATE_DATE DATE NOT NULL);




/****** Object:  Table PCMM.TEAM_POSITION_HISTORY    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE PCMM.TEAM_POSITION_HISTORY(
  TEAM_POSITION_HISTORY_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  TEAM_POSITION_id NUMBER(20, 0) NOT NULL UNIQUE,
  TEAM_POSITION_STATUS_REASON_ID NUMBER(20, 0) NULL,
  PCM_STD_STATUS_id NUMBER(20, 0) NOT NULL UNIQUE,
  EFFECTIVE_DATE DATE NOT NULL,
  IEN VARCHAR(30) NULL,
  TeamPositionStatusHistoryID NUMBER NULL,
  RECORD_CREATED_BY VARCHAR(30) NULL,
  RECORD_CREATED_DATE DATE NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE DATE NULL,
  RECORD_MODIFIED_COUNT NUMBER(10, 0) NOT NULL,
  RECORD_CREATED_DATE_TZ VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE_TZ VARCHAR(30) NULL);


/****** Object:  Table PCMM.TEAM_ROOM    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE PCMM.TEAM_ROOM(
  TEAM_ROOM_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  TEAM_id NUMBER(20, 0) NOT NULL UNIQUE,
  FACILITY_ROOM_id NUMBER(20, 0) NOT NULL UNIQUE,
  START_DATE DATE NOT NULL,
  END_DATE DATE NULL,
  ACTUAL_EXAM_FTEE NUMBER(5, 2) NULL,
  ACTUAL_INTERVIEW_FTEE NUMBER(5, 2) NULL,
  RECORD_CREATED_BY VARCHAR(30) NULL,
  RECORD_CREATED_DATE DATE NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE DATE NULL,
  RECORD_MODIFIED_COUNT NUMBER(10, 0) NOT NULL,
  RECORD_CREATED_DATE_TZ VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE_TZ VARCHAR(30) NULL);



/****** Object:  Table PCMM.TEAM_STATUS_HISTORY    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE PCMM.TEAM_STATUS_HISTORY(
  TEAM_STATUS_HISTORY_ID NUMBER(20, 0) PRIMARY KEY NOT NULL,
  TEAM_id NUMBER(20, 0) NOT NULL UNIQUE,
  PCM_STD_TEAM_STATUS_REASON_id NUMBER(20, 0) NOT NULL UNIQUE,
  PCM_STD_STATUS_id NUMBER(20, 0) NOT NULL UNIQUE,
  EFFECTIVE_DATE DATE NOT NULL,
  IEN VARCHAR(30) NULL,
  TeamStatusHistoryID NUMBER NULL,
  RECORD_CREATED_BY VARCHAR(30) NULL,
  RECORD_CREATED_DATE DATE NULL,
  RECORD_MODIFIED_BY VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE DATE NULL,
  RECORD_MODIFIED_COUNT NUMBER(10, 0) NOT NULL,
  RECORD_CREATED_DATE_TZ VARCHAR(30) NULL,
  RECORD_MODIFIED_DATE_TZ VARCHAR(30) NULL);



/****** Object:  Table PCMM.WL_LLR_PCMM_ADMINSERVER    Script Date: 8/20/2015 6:11:42 PM ******/




CREATE TABLE PCMM.WL_LLR_PCMM_ADMINSERVER(
  XIDSTR VARCHAR(40) NOT NULL,
  POOLNAMESTR VARCHAR(64) NULL,
  RECORDSTR VARCHAR(1000) NULL);


/****** Object:  Table PCMM_EXT.JMS_Srv1_WLStore    Script Date: 8/20/2015 6:11:42 PM ******/




CREATE TABLE PCMM_EXT.JMS_Srv1_WLStore(
  id NUMBER NOT NULL,
  type NUMBER NOT NULL,
  handle NUMBER NOT NULL,
  record BLOB NOT NULL);


/****** Object:  Table PCMM_EXT.JMS_Srv2_WLStore    Script Date: 8/20/2015 6:11:42 PM ******/




CREATE TABLE PCMM_EXT.JMS_Srv2_WLStore(
  id NUMBER NOT NULL,
  type NUMBER NOT NULL,
  handle NUMBER NOT NULL,
  record BLOB NOT NULL);


/****** Object:  Table PCMM_EXT.JMS_Srv3_WLStore    Script Date: 8/20/2015 6:11:42 PM ******/




CREATE TABLE PCMM_EXT.JMS_Srv3_WLStore(
  id NUMBER NOT NULL,
  type NUMBER NOT NULL,
  handle NUMBER NOT NULL,
  record BLOB NOT NULL);


/****** Object:  Table PCMM_EXT.JMS_Srv4_WLStore    Script Date: 8/20/2015 6:11:42 PM ******/




CREATE TABLE PCMM_EXT.JMS_Srv4_WLStore(
  id NUMBER NOT NULL,
  type NUMBER NOT NULL,
  handle NUMBER NOT NULL,
  record BLOB NOT NULL);


/****** Object:  Table PCMM_EXT.LLR_Srv1_WL    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE PCMM_EXT.LLR_Srv1_WL(
  XIDSTR VARCHAR(40) NOT NULL,
  POOLNAMESTR VARCHAR(64) NULL,
  RECORDSTR VARCHAR(1000) NULL);




/****** Object:  Table PCMM_EXT.LLR_Srv2_WL    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE PCMM_EXT.LLR_Srv2_WL(
  XIDSTR VARCHAR(40) NOT NULL,
  POOLNAMESTR VARCHAR(64) NULL,
  RECORDSTR VARCHAR(1000) NULL);




/****** Object:  Table PCMM_EXT.LLR_Srv3_WL    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE PCMM_EXT.LLR_Srv3_WL(
  XIDSTR VARCHAR(40) NOT NULL,
  POOLNAMESTR VARCHAR(64) NULL,
  RECORDSTR VARCHAR(1000) NULL);



/****** Object:  Table PCMM_EXT.LLR_Srv4_WL    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE PCMM_EXT.LLR_Srv4_WL(
  XIDSTR VARCHAR(40) NOT NULL,
  POOLNAMESTR VARCHAR(64) NULL,
  RECORDSTR VARCHAR(1000) NULL);




/****** Object:  Table sdsadm.STD_AddressChangeSource    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_AddressChangeSource(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  code VARCHAR(5) NOT NULL UNIQUE,
  name VARCHAR(30) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_AddressChangeSourceHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_AddressChangeSourceHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_AddressDeliveryFailureCode    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_AddressDeliveryFailureCode(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  code VARCHAR(30) NOT NULL UNIQUE,
  name VARCHAR(30) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_AddressInvalidReason    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_AddressInvalidReason(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  code NUMBER(10, 0) NOT NULL UNIQUE,
  name VARCHAR(40) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_AddressType    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_AddressType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  name VARCHAR(30) NOT NULL UNIQUE,
  description VARCHAR(250) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);


/****** Object:  Table sdsadm.STD_AddressTypeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_AddressTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_AdministrativeEntity    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_AdministrativeEntity(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  name VARCHAR(80) NOT NULL UNIQUE,
  administrativeParent_id NUMBER(20, 0) NULL,
  agency_id NUMBER(20, 0) NULL,
  institution_id NUMBER(20, 0) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_AdrsDlvryFlrCdHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_AdrsDlvryFlrCdHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);


/****** Object:  Table sdsadm.STD_AdrsInvalRsnHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_AdrsInvalRsnHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_AffectedExtremity    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_AffectedExtremity(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  code NUMBER(10, 0) NOT NULL UNIQUE,
  name VARCHAR(40) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_AffectedExtremityHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_AffectedExtremityHistory(
  id_num NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_Agency    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_Agency(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  code VARCHAR(4) NOT NULL UNIQUE,
  name VARCHAR(15) NOT NULL UNIQUE,
  description VARCHAR(60) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_AgencyHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_AgencyHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_AgentOrangeLocation    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_AgentOrangeLocation(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  code VARCHAR(1) NOT NULL UNIQUE,
  name VARCHAR(30) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_AgentOrangeLocnHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_AgentOrangeLocnHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_AlliedCountry    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_AlliedCountry(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  code NUMBER(10, 0) NOT NULL UNIQUE,
  name VARCHAR(50) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_AlliedCountryHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_AlliedCountryHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_AppParameterType    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_AppParameterType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  code NUMBER(10, 0) NOT NULL UNIQUE,
  name VARCHAR(30) NOT NULL UNIQUE,
  description VARCHAR(250) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_AppParameterTypeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_AppParameterTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_AppParameterUnit    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_AppParameterUnit(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  code NUMBER(10, 0) NOT NULL UNIQUE,
  name VARCHAR(30) NOT NULL UNIQUE,
  description VARCHAR(250) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_AppParameterUnitHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_AppParameterUnitHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_AppParamGrpType    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_AppParamGrpType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  name VARCHAR(30) NOT NULL UNIQUE,
  description VARCHAR(250) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_AppParamGrpTypeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_AppParamGrpTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_AssetType    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_AssetType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  code VARCHAR(4) NOT NULL ,
  name VARCHAR(80) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_AssetTypeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_AssetTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_AssigningAuthority    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_AssigningAuthority(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  code VARCHAR(6) NOT NULL UNIQUE,
  name VARCHAR(80) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  country_id NUMBER(20, 0) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_AssigningAuthorityHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_AssigningAuthorityHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_BenefitsCoordType    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_BenefitsCoordType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  code char(1) NOT NULL UNIQUE,
  name VARCHAR(80) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_BenefitsCoordTypeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_BenefitsCoordTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_BillingTransType    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_BillingTransType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  code VARCHAR(3) NOT NULL UNIQUE,
  name VARCHAR(80) NOT NULL UNIQUE,
  description VARCHAR(250) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);


/****** Object:  Table sdsadm.STD_BillingTransTypeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_BillingTransTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_CancelDeclineHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_CancelDeclineHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_CancelDeclineReason    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_CancelDeclineReason(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  code NUMBER(10, 0) NOT NULL UNIQUE,
  name VARCHAR(30) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_CancelDeclineStTyp    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_CancelDeclineStTyp(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  code NUMBER(10, 0) NOT NULL UNIQUE,
  name VARCHAR(50) NOT NULL,
  description VARCHAR(250) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_CancelDeclineStTypHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_CancelDeclineStTypHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_CataDisabilityExtCd    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_CataDisabilityExtCd(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  code VARCHAR(4) NOT NULL UNIQUE,
  name VARCHAR(80) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_CataDisabilityExtCdHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_CataDisabilityExtCdHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_ClinDeterType    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_ClinDeterType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  code NUMBER(10, 0) NOT NULL UNIQUE,
  name VARCHAR(30) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_ClinDeterTypeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_ClinDeterTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_CodeSet    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_CodeSet(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  code VARCHAR(30) NULL,
  name VARCHAR(70) NOT NULL UNIQUE,
  description VARCHAR(2000) NULL,
  implementor VARCHAR(10) NOT NULL,
  className VARCHAR(100) NOT NULL UNIQUE,
  tablename VARCHAR(30) NOT NULL UNIQUE,
  dataContentSteward VARCHAR(60) NULL,
  pocEmailAddress VARCHAR(200) NULL,
  applicationServiceOwner VARCHAR(60) NULL,
  registeredUsers VARCHAR(2000) NULL,
  integrationAgreements char(1) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);


/****** Object:  Table sdsadm.STD_CodingSystem    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_CodingSystem(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  code VARCHAR(20) NOT NULL UNIQUE,
  name VARCHAR(45) NOT NULL UNIQUE,
  description VARCHAR(60) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_CodingSystemHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_CodingSystemHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_CollectionHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_CollectionHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_CollectionMethod    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_CollectionMethod(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  hl7code VARCHAR(8) NOT NULL UNIQUE,
  name VARCHAR(30) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_CombatLocation    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_CombatLocation(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  code VARCHAR(2) NOT NULL UNIQUE,
  name VARCHAR(30) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  oeif_ind NUMBER(10, 0) NULL,
  startDate DATE NOT NULL,
  endDate DATE NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_CombatLocationHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_CombatLocationHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_CombatPayType    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_CombatPayType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  code VARCHAR(2) NOT NULL UNIQUE,
  name VARCHAR(80) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_CombatPayTypeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_CombatPayTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_CombatSvcLocation    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_CombatSvcLocation(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  code VARCHAR(2) NOT NULL UNIQUE,
  area VARCHAR(120) NOT NULL,
  included_locations VARCHAR(120) NOT NULL,
  startDate DATE NOT NULL,
  endDate DATE NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_CombatSvcLocationHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_CombatSvcLocationHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_CombatSvcSource    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_CombatSvcSource(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  code VARCHAR(4) NOT NULL UNIQUE,
  name VARCHAR(80) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);


/****** Object:  Table sdsadm.STD_CombatSvcSourceHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_CombatSvcSourceHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_CommErrorType    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_CommErrorType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  code char(3) NOT NULL UNIQUE,
  name VARCHAR(100) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_CommErrorTypeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_CommErrorTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_CommLetterGenType    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_CommLetterGenType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  code VARCHAR(2) NOT NULL UNIQUE,
  name VARCHAR(30) NOT NULL UNIQUE,
  description VARCHAR(250) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_CommLetterGenTypeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_CommLetterGenTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_CommLetterType    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_CommLetterType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  code VARCHAR(2) NOT NULL UNIQUE,
  name VARCHAR(30) NOT NULL UNIQUE,
  description VARCHAR(250) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_CommLetterTypeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_CommLetterTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_CommMailingStType    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_CommMailingStType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  code VARCHAR(2) NOT NULL UNIQUE,
  name VARCHAR(40) NOT NULL UNIQUE,
  description VARCHAR(250) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);


/****** Object:  Table sdsadm.STD_CommMailingStTypeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_CommMailingStTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_CommMlTriggerType    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_CommMlTriggerType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  code NUMBER(10, 0) NOT NULL UNIQUE,
  name VARCHAR(30) NOT NULL UNIQUE,
  description VARCHAR(250) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_CommMlTriggerTypeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_CommMlTriggerTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_ComRejectReasonType    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_ComRejectReasonType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  code char(1) NOT NULL,
  name VARCHAR(100) NOT NULL,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_ComRejectReasonTypeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_ComRejectReasonTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_ConditionCode    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_ConditionCode(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  code NUMBER(10, 0) NOT NULL UNIQUE,
  name VARCHAR(50) NOT NULL,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);


/****** Object:  Table sdsadm.STD_ConditionCodeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_ConditionCodeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_ConfAddrCatHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_ConfAddrCatHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_ConfidentialAddressCat    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_ConfidentialAddressCat(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  code NUMBER(10, 0) NOT NULL UNIQUE,
  name VARCHAR(50) NOT NULL UNIQUE,
  hl7Value VARCHAR(10) NULL,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_Country    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_Country(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  numericCode char(3) NOT NULL UNIQUE,
  shortName VARCHAR(64) NOT NULL,
  alpha3Code char(3) NOT NULL UNIQUE,
  fipsCode char(2) NOT NULL UNIQUE,
  postalName VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_CountryHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_CountryHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_County    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_County(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  name VARCHAR(35) NOT NULL,
  countyNumber char(3) NOT NULL,
  description VARCHAR(60) NULL,
  state_id NUMBER(20, 0) NOT NULL UNIQUE,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_CountyHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_CountyHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_DatabaseVersion    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_DatabaseVersion(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  versionNumber VARCHAR(10) NULL,
  installationDate DATE NULL,
  description VARCHAR(50) NULL,
  version NUMBER NULL,
  created DATE NULL,
  updated DATE NULL,
  createdBy VARCHAR(50) NULL,
  updatedBy VARCHAR(50) NULL);




/****** Object:  Table sdsadm.STD_DataCollectJobType    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_DataCollectJobType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  code VARCHAR(3) NOT NULL UNIQUE,
  name VARCHAR(80) NOT NULL UNIQUE,
  description VARCHAR(250) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_DataCollectJobTypeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_DataCollectJobTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_DeathNotification    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_DeathNotification(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  code NUMBER(10, 0) NOT NULL UNIQUE,
  name VARCHAR(30) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_DeathNotificationHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_DeathNotificationHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_DecorationDocumentType    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_DecorationDocumentType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code NUMBER(10, 0) NOT NULL UNIQUE,
  name VARCHAR(50) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_DecorationStatus    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_DecorationStatus(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  code NUMBER(10, 0) NOT NULL UNIQUE,
  name VARCHAR(30) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_DecorationStatusHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_DecorationStatusHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_DecorationType    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_DecorationType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  code NUMBER(10, 0) NOT NULL UNIQUE,
  name VARCHAR(30) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_DecorationTypeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_DecorationTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);


/****** Object:  Table sdsadm.STD_DecoratnDocTypHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_DecoratnDocTypHistory(
 id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_Degree    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_Degree(
 id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  code VARCHAR(10) NOT NULL UNIQUE,
  name VARCHAR(50) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_DegreeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_DegreeHistory(
 id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_DetailedIncFinDoc    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_DetailedIncFinDoc(
 id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  detailedIncomeType_id NUMBER(20, 0) NOT NULL UNIQUE,
  financialDocumType_id NUMBER(20, 0) NOT NULL UNIQUE,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_DetailedIncFinDocHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_DetailedIncFinDocHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);


/****** Object:  Table sdsadm.STD_DetailedIncomeType    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_DetailedIncomeType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  code VARCHAR(3) NOT NULL UNIQUE,
  name VARCHAR(80) NOT NULL UNIQUE,
  earned_income NUMBER(10, 0) NULL,
  income_summary_type_id NUMBER(10, 0) NULL,
  description VARCHAR(250) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_DetailedIncomeTypeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_DetailedIncomeTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_DiagnosisCode    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_DiagnosisCode(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  code VARCHAR(6) NOT NULL UNIQUE,
  name VARCHAR(50) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_DiagnosisCodeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_DiagnosisCodeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY ,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_DiagnosisCodSch    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_DiagnosisCodSch(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code VARCHAR(6) NOT NULL UNIQUE,
  name VARCHAR(30) NOT NULL UNIQUE,
  description VARCHAR(200) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_DiagnosisCodSchHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_DiagnosisCodSchHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_DiagnosisType    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_DiagnosisType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code char(1) NOT NULL UNIQUE,
  name VARCHAR(30) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_DiagnosisTypeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_DiagnosisTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);


/****** Object:  Table sdsadm.STD_DisabilityCondition    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_DisabilityCondition(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  ien NUMBER(10, 0) NOT NULL UNIQUE,
  dxcode VARCHAR(4) NOT NULL UNIQUE,
  name VARCHAR(50) NOT NULL,
  description VARCHAR(200) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_DisabilityConditionHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_DisabilityConditionHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);


/****** Object:  Table sdsadm.STD_DistributionCode    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_DistributionCode(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code VARCHAR(3) NOT NULL UNIQUE,
  name VARCHAR(80) NOT NULL UNIQUE,
  description VARCHAR(250) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_DistributionCodeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_DistributionCodeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_DistributionType    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_DistributionType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code VARCHAR(3) NOT NULL UNIQUE,
  name VARCHAR(80) NOT NULL UNIQUE,
  description VARCHAR(250) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_DistributionTypeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_DistributionTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_DocumentSourceType    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_DocumentSourceType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code VARCHAR(3) NOT NULL UNIQUE,
  name VARCHAR(80) NOT NULL UNIQUE,
  description VARCHAR(250) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_DocumentSourceTypeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_DocumentSourceTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_EgtProcessStatus    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_EgtProcessStatus(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code NUMBER(10, 0) NOT NULL UNIQUE,
  name VARCHAR(30) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_EgtProcessStatusHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_EgtProcessStatusHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_EgtType    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_EgtType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code NUMBER(10, 0) NOT NULL UNIQUE,
  name VARCHAR(50) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_EgtTypeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_EgtTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_ElectronicPlanType    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_ElectronicPlanType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code VARCHAR(4) NOT NULL UNIQUE,
  name VARCHAR(80) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_ElectronicPlanTypeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_ElectronicPlanTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_EligDocType    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_EligDocType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code VARCHAR(5) NOT NULL UNIQUE,
  name VARCHAR(100) NOT NULL UNIQUE,
  description VARCHAR(200) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_EligDocTypeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_EligDocTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_EligibilityCode    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_EligibilityCode(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code NUMBER(10, 0) NOT NULL UNIQUE,
  name VARCHAR(30) NOT NULL UNIQUE,
  vaCodeType NUMBER(10, 0) NOT NULL,
  type_id NUMBER(20, 0) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_EligibilityCodeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_EligibilityCodeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_EligibilityCodeType    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_EligibilityCodeType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code char(1) NOT NULL UNIQUE,
  name VARCHAR(20) NOT NULL UNIQUE,
  description VARCHAR(60) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_EligibilityCodeTypeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_EligibilityCodeTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_EligibilityFactor    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_EligibilityFactor(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code char(2) NOT NULL UNIQUE,
  name VARCHAR(100) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);


/****** Object:  Table sdsadm.STD_EligibilityFactorHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_EligibilityFactorHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_EligibilityPrimaryDataSrc    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_EligibilityPrimaryDataSrc(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code VARCHAR(30) NOT NULL UNIQUE,
  name VARCHAR(50) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_EligibilityStatus    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_EligibilityStatus(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code char(1) NOT NULL UNIQUE,
  name VARCHAR(30) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_EligibilityStatusHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_EligibilityStatusHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);


/****** Object:  Table sdsadm.STD_EligibilityVrScTyp    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_EligibilityVrScTyp(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code VARCHAR(30) NOT NULL UNIQUE,
  name VARCHAR(50) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);


/****** Object:  Table sdsadm.STD_EligibilityVrScTypHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_EligibilityVrScTypHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_EligPrmryDataSrcHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_EligPrmryDataSrcHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_Email_Domain    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_Email_Domain(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  institution_id NUMBER(20, 0) NOT NULL UNIQUE,
  email_domain_name VARCHAR(50) NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_Email_DomainHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_Email_DomainHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);


/****** Object:  Table sdsadm.STD_EmailAddressType    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_EmailAddressType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code NUMBER(10, 0) NOT NULL UNIQUE,
  name VARCHAR(30) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_EmailAddressTypeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_EmailAddressTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);


/****** Object:  Table sdsadm.STD_EmailChangeSource    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_EmailChangeSource(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code VARCHAR(2) NOT NULL UNIQUE,
  name VARCHAR(50) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_EmailChangeSourceHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_EmailChangeSourceHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_EmergencyResponse    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_EmergencyResponse(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code char(1) NOT NULL UNIQUE,
  name VARCHAR(50) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_EmergencyResponseHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_EmergencyResponseHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);


/****** Object:  Table sdsadm.STD_EmploymentStatus    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_EmploymentStatus(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code NUMBER(10, 0) NOT NULL UNIQUE,
  name VARCHAR(30) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_EmploymentStatusHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_EmploymentStatusHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_EnrollmentCatType    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_EnrollmentCatType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code char(1) NOT NULL UNIQUE,
  name VARCHAR(50) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_EnrollmentCatTypeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_EnrollmentCatTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_EnrollmentOverrideReason    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_EnrollmentOverrideReason(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code NUMBER(10, 0) NOT NULL UNIQUE,
  name VARCHAR(80) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_EnrollmentOvrdeRsnHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_EnrollmentOvrdeRsnHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_EnrollmentPriorGrp    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_EnrollmentPriorGrp(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code NUMBER(10, 0) NOT NULL UNIQUE,
  name VARCHAR(30) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_EnrollmentPriorGrpHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_EnrollmentPriorGrpHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_EnrollmentPriorSGrp    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_EnrollmentPriorSGrp(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code NUMBER(10, 0) NOT NULL UNIQUE,
  name VARCHAR(50) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_EnrollmentPriorSGrpHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_EnrollmentPriorSGrpHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_EnrollmentSource    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_EnrollmentSource(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code NUMBER(10, 0) NOT NULL UNIQUE,
  name VARCHAR(30) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_EnrollmentSourceHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_EnrollmentSourceHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_EnrollmentStatus    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_EnrollmentStatus(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code NUMBER(10, 0) NOT NULL UNIQUE,
  name VARCHAR(50) NOT NULL UNIQUE,
  enrollmentCat_id NUMBER(20, 0) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_EnrollmentStatusHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_EnrollmentStatusHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_EntitlementCode    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_EntitlementCode(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code VARCHAR(3) NOT NULL UNIQUE,
  name VARCHAR(50) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);


/****** Object:  Table sdsadm.STD_EntitlementCodeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_EntitlementCodeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_EthCollMthdHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_EthCollMthdHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_Ethnicity    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_Ethnicity(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  abbreviation VARCHAR(5) NOT NULL UNIQUE,
  name VARCHAR(30) NOT NULL UNIQUE,
  description VARCHAR(60) NULL,
  hl7Value VARCHAR(10) NULL,
  cdcValue VARCHAR(6) NULL,
  ptfValue char(1) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_EthnicityCollectionMethod    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_EthnicityCollectionMethod(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code NUMBER(10, 0) NOT NULL UNIQUE,
  name VARCHAR(30) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_EthnicityHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_EthnicityHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_EvaluationMethod    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_EvaluationMethod(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code NUMBER(10, 0) NOT NULL UNIQUE,
  name VARCHAR(30) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_EvaluationMethodHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_EvaluationMethodHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);


/****** Object:  Table sdsadm.STD_ExclusionRsnType    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_ExclusionRsnType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code VARCHAR(3) NOT NULL UNIQUE,
  name VARCHAR(80) NOT NULL UNIQUE,
  description VARCHAR(250) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_ExclusionRsnTypeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_ExclusionRsnTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_ExpenseType    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_ExpenseType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code NUMBER(10, 0) NULL,
  name VARCHAR(40) NOT NULL UNIQUE,
  description VARCHAR(2000) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_ExpenseTypeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_ExpenseTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_ExtremityCode    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_ExtremityCode(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code VARCHAR(2) NOT NULL UNIQUE,
  name VARCHAR(50) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_ExtremityCodeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_ExtremityCodeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);


/****** Object:  Table sdsadm.STD_FacilityType    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_FacilityType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code VARCHAR(11) NOT NULL UNIQUE,
  name VARCHAR(45) NOT NULL UNIQUE,
  description VARCHAR(60) NULL,
  isMedicalTreating char(1) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_FacilityTypeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_FacilityTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_FeeBasisPrgrmHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_FeeBasisPrgrmHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);


/****** Object:  Table sdsadm.STD_FeeBasisProgram    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_FeeBasisProgram(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code NUMBER(10, 0) NOT NULL UNIQUE,
  name VARCHAR(50) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);


/****** Object:  Table sdsadm.STD_FeeBasisTreatmentCodeType    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_FeeBasisTreatmentCodeType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code NUMBER(10, 0) NOT NULL UNIQUE,
  name VARCHAR(30) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_FeeBasisTrtmntHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_FeeBasisTrtmntHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_FilipinoVeteranProof    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_FilipinoVeteranProof(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code VARCHAR(2) NOT NULL UNIQUE,
  name VARCHAR(50) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_FilipinoVetProofHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_FilipinoVetProofHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_FinancialDocumType    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_FinancialDocumType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code VARCHAR(3) NOT NULL UNIQUE,
  name VARCHAR(80) NOT NULL UNIQUE,
  description VARCHAR(250) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_FinancialDocumTypeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_FinancialDocumTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_FinancialMapping    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_FinancialMapping(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code VARCHAR(6) NOT NULL UNIQUE,
  name VARCHAR(50) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_FinancialMappingHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_FinancialMappingHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_FinanInfoSource    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_FinanInfoSource(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code NUMBER(10, 0) NOT NULL UNIQUE,
  name VARCHAR(30) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_FinanInfoSourceHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_FinanInfoSourceHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_FTITransStatus    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_FTITransStatus(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code VARCHAR(3) NOT NULL UNIQUE,
  name VARCHAR(80) NOT NULL UNIQUE,
  description VARCHAR(250) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);


/****** Object:  Table sdsadm.STD_FTITransStatusHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_FTITransStatusHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_FTITransType    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_FTITransType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code VARCHAR(10) NOT NULL UNIQUE,
  name VARCHAR(80) NOT NULL UNIQUE,
  description VARCHAR(250) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_FTITransTypeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_FTITransTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_Gender    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_Gender(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code VARCHAR(4) NOT NULL UNIQUE,
  name VARCHAR(20) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_GenderHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_GenderHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_GMTThresholds    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_GMTThresholds(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  effectiveYear char(4) NOT NULL,
  stateName VARCHAR(50) NOT NULL,
  countyName VARCHAR(50) NOT NULL,
  FIPS char(5) NOT NULL,
  TRHD1 NUMBER(18, 0) NOT NULL,
  TRHD2 NUMBER(18, 0) NOT NULL,
  TRHD3 NUMBER(18, 0) NOT NULL,
  TRHD4 NUMBER(18, 0) NOT NULL,
  TRHD5 NUMBER(18, 0) NOT NULL,
  TRHD6 NUMBER(18, 0) NOT NULL,
  TRHD7 NUMBER(18, 0) NOT NULL,
  TRHD8 NUMBER(18, 0) NOT NULL,
  MSA NUMBER(10, 0) NOT NULL,
  msaName VARCHAR(40) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_HealthBenefitType    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_HealthBenefitType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code VARCHAR(3) NOT NULL UNIQUE,
  name VARCHAR(50) NOT NULL UNIQUE,
  description VARCHAR(200) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_HealthBenefitTypeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_HealthBenefitTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_HL724EthnicityMap    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_HL724EthnicityMap(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  hl7value VARCHAR(8) NOT NULL UNIQUE,
  name VARCHAR(80) NOT NULL UNIQUE,
  ethnicity_id NUMBER(20, 0) NOT NULL UNIQUE,
  description VARCHAR(250) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_HL724EthnicityMapHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_HL724EthnicityMapHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_HL724MaritalStaMap    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_HL724MaritalStaMap(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  hl7value VARCHAR(8) NOT NULL UNIQUE, 
  name VARCHAR(80) NOT NULL UNIQUE,
  maritalstatus_id NUMBER(20, 0) NOT NULL UNIQUE,
  description VARCHAR(250) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_HL724MaritalStaMapHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_HL724MaritalStaMapHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_HL724RaceMap    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_HL724RaceMap(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  hl7value VARCHAR(8) NOT NULL UNIQUE,
  name VARCHAR(80) NOT NULL UNIQUE,
  race_id NUMBER(20, 0) NOT NULL UNIQUE,
  description VARCHAR(250) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_HL724RaceMapHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_HL724RaceMapHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_HL7AckCodeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_HL7AckCodeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_HL7AcknowledgementCode    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_HL7AcknowledgementCode(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code char(2) NOT NULL UNIQUE,
  name VARCHAR(100) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_HL7AcknowledgementType    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_HL7AcknowledgementType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code char(2) NOT NULL UNIQUE,
  name VARCHAR(30) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_HL7AckTypeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_HL7AckTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_HL7ActionCode    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_HL7ActionCode(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code char(2) NOT NULL UNIQUE,
  name VARCHAR(15) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_HL7ActionCodeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_HL7ActionCodeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_HL7DataType    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_HL7DataType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code VARCHAR(3) NOT NULL UNIQUE,
  name VARCHAR(70) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_HL7DataTypeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_HL7DataTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_HL7EventType    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_HL7EventType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code VARCHAR(6) NOT NULL UNIQUE,
  name VARCHAR(80) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_HL7EventTypeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_HL7EventTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_HL7FileLevelEvent    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_HL7FileLevelEvent(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code char(3) NOT NULL UNIQUE,
  name VARCHAR(100) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_HL7FileLevelEventHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_HL7FileLevelEventHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_HL7MasterFileIDCode    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_HL7MasterFileIDCode(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code char(3) NOT NULL UNIQUE,
  name VARCHAR(80) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_HL7MasterFileIDCodeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_HL7MasterFileIDCodeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_HL7MessageStruc    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_HL7MessageStruc(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code VARCHAR(7) NOT NULL UNIQUE,
  name VARCHAR(80) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_HL7MessageStrucHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_HL7MessageStrucHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_HL7MessageType    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_HL7MessageType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code char(3) NOT NULL UNIQUE,
  name VARCHAR(80) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_HL7MessageTypeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_HL7MessageTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_HL7ObservResultCode    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_HL7ObservResultCode(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code char(1) NOT NULL UNIQUE,
  name VARCHAR(30) NOT NULL UNIQUE,
  description VARCHAR(1000) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_HL7ObservResultCodeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_HL7ObservResultCodeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_HL7PrimaryKeyValueType    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_HL7PrimaryKeyValueType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code char(2) NOT NULL UNIQUE,
  name VARCHAR(30) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_HL7PrimKeyValTypeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_HL7PrimKeyValTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_HL7ProcessingID    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_HL7ProcessingID(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code char(1) NOT NULL UNIQUE,
  name VARCHAR(20) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_HL7ProcessingMode    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_HL7ProcessingMode(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code char(1) NOT NULL UNIQUE,
  name VARCHAR(80) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_HL7ProcIDHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_HL7ProcIDHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_HL7ProcModeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_HL7ProcModeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_HL7QryRespFmtCode    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_HL7QryRespFmtCode(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code char(1) NOT NULL UNIQUE,
  name VARCHAR(40) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_HL7QryRespFmtCodeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_HL7QryRespFmtCodeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_HL7QryRespStatusHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_HL7QryRespStatusHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_HL7QuanLimReqHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_HL7QuanLimReqHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_HL7QuantityLimitedRequest    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_HL7QuantityLimitedRequest(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code char(2) NOT NULL UNIQUE,
  name VARCHAR(30) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_HL7QueryPriority    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_HL7QueryPriority(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code VARCHAR(1) NOT NULL UNIQUE,
  name VARCHAR(30) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_HL7QueryPriorityHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_HL7QueryPriorityHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_HL7QueryResponseStatus    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_HL7QueryResponseStatus(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code char(2) NOT NULL UNIQUE,
  name VARCHAR(50) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_HL7QueryResults    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_HL7QueryResults(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code char(1) NOT NULL UNIQUE,
  name VARCHAR(30) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_HL7QueryResultsHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_HL7QueryResultsHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_HL7RecLevErrRet    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_HL7RecLevErrRet(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code char(1) NOT NULL UNIQUE,
  name VARCHAR(70) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_HL7RecLevErrRetHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_HL7RecLevErrRetHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_HL7RecLevEvCode    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_HL7RecLevEvCode(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code char(3) NOT NULL UNIQUE,
  name VARCHAR(100) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_HL7RecLevEvCodeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_HL7RecLevEvCodeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_HL7RespLevCode    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_HL7RespLevCode(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code char(2) NOT NULL UNIQUE,
  name VARCHAR(50) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_HL7RespLevCodeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_HL7RespLevCodeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_HL7RespModality    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_HL7RespModality(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code char(1) NOT NULL UNIQUE,
  name VARCHAR(100) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_HL7RespModalityHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_HL7RespModalityHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_HL7SrcOfComment    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_HL7SrcOfComment(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code VARCHAR(1) NOT NULL UNIQUE,
  name VARCHAR(60) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_HL7SrcOfCommentHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_HL7SrcOfCommentHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_HL7ValueType    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_HL7ValueType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code VARCHAR(3) NOT NULL UNIQUE,
  name VARCHAR(60) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_HL7ValueTypeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_HL7ValueTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_HL7VersionID    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_HL7VersionID(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code VARCHAR(7) NOT NULL UNIQUE,
  name VARCHAR(30) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_HL7VersionIDHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_HL7VersionIDHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);


/****** Object:  Table sdsadm.STD_HL7WhatSubjectFltr    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_HL7WhatSubjectFltr(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code char(3) NOT NULL UNIQUE,
  name VARCHAR(90) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);


/****** Object:  Table sdsadm.STD_HL7WhatSubjectFltrHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_HL7WhatSubjectFltrHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_IdentifierType    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_IdentifierType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code VARCHAR(5) NOT NULL UNIQUE,
  name VARCHAR(100) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_IdentifierTypeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_IdentifierTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_IdEventType    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_IdEventType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code VARCHAR(20) NOT NULL UNIQUE,
  name VARCHAR(80) NOT NULL UNIQUE,
  description VARCHAR(250) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_IdEventTypeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_IdEventTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_IdExcepTypeGroup    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_IdExcepTypeGroup(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  name VARCHAR(50) NOT NULL UNIQUE,
  create_task_ind NUMBER(10, 0) NOT NULL UNIQUE,
  description VARCHAR(60) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_IdExcepTypeGroupHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_IdExcepTypeGroupHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_IdTaskProbCatery    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_IdTaskProbCatery(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code VARCHAR(20) NOT NULL UNIQUE,
  name VARCHAR(80) NOT NULL UNIQUE,
  description VARCHAR(250) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_IdTaskProbCateryHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_IdTaskProbCateryHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_IdTaskStatusType    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_IdTaskStatusType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code VARCHAR(20) NOT NULL UNIQUE,
  name VARCHAR(80) NOT NULL UNIQUE,
  description VARCHAR(250) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_IdTaskStatusTypeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_IdTaskStatusTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_IncomeTestSource    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_IncomeTestSource(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code NUMBER(10, 0) NOT NULL UNIQUE,
  name VARCHAR(30) NOT NULL,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_IncomeTestSourceHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_IncomeTestSourceHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_IncomeTestType    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_IncomeTestType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code NUMBER(10, 0) NOT NULL UNIQUE,
  name VARCHAR(80) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);


/****** Object:  Table sdsadm.STD_IncomeTestTypeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_IncomeTestTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_IncomeThreshold    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_IncomeThreshold(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  income_threshold_year NUMBER(4, 0) NOT NULL,
  exempt_amount NUMBER(18, 0) NULL,
  medical_expense_deductible NUMBER(18, 0) NULL,
  child_income_exclusion NUMBER(18, 0) NULL,
  dependent NUMBER(18, 0) NULL,
  add_dependent_threshold NUMBER(18, 0) NULL,
  property_threshold NUMBER(18, 0) NULL,
  pension_threshold NUMBER(18, 0) NULL,
  pension_1_dependent NUMBER(18, 0) NULL,
  add_dependent_pension NUMBER(18, 0) NULL,
  ninety_day_hospital_copay NUMBER(18, 0) NULL,
  add_90_day_hospital_copay NUMBER(18, 0) NULL,
  outpatient_basic_care_copay NUMBER(18, 0) NULL,
  outpatient_specialty_copay NUMBER(18, 0) NULL,
  threshold_effective_date DATE NULL,
  aid_and_attendance_threshold NUMBER(18, 0) NULL,
  outpatient_preventive_copay NUMBER(18, 0) NULL,
  medication_copay NUMBER(18, 0) NULL,
  medication_copay_annual_cap NUMBER(18, 0) NULL,
  ltc_inpatient_copay NUMBER(18, 0) NULL,
  ltc_outpatient_copay NUMBER(18, 0) NULL,
  ltc_domiciliary_copay NUMBER(18, 0) NULL,
  inpatient_per_diem NUMBER(18, 0) NULL,
  description VARCHAR(2000) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_IncomeThresholdHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_IncomeThresholdHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_IncomeType    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_IncomeType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code NUMBER(10, 0) NOT NULL UNIQUE,
  name VARCHAR(80) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_IncomeTypeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_IncomeTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_IncomeVerifStatus    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_IncomeVerifStatus(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code NUMBER(10, 0) NOT NULL UNIQUE,
  name VARCHAR(40) NOT NULL UNIQUE, 
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_IncomeVerifStatusHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_IncomeVerifStatusHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_InsPlanTypeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_InsPlanTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_InsRprtSrcHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_InsRprtSrcHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_Institution    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_Institution(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  activationDate DATE NULL,
  deactivationDate DATE NULL,
  name VARCHAR(80) NOT NULL UNIQUE,
  stationNumber VARCHAR(7) NULL,
  vistaname VARCHAR(30) NOT NULL UNIQUE,
  agency_id NUMBER(20, 0) NULL,
  streetCountry_id NUMBER(20, 0) NULL,
  streetAddressLine1 VARCHAR(64) NULL,
  streetAddressLine2 VARCHAR(64) NULL,
  streetAddressLine3 VARCHAR(64) NULL,
  streetCity VARCHAR(50) NULL,
  streetState_id NUMBER(20, 0) NULL,
  streetCounty_id NUMBER(20, 0) NULL,
  streetPostalCode VARCHAR(10) NULL,
  mailingCountry_id NUMBER(20, 0) NULL,
  mailingAddressLine1 VARCHAR(64) NULL,
  mailingAddressLine2 VARCHAR(64) NULL,
  mailingAddressLine3 VARCHAR(64) NULL,
  mailingCity VARCHAR(50) NULL,
  mailingState_id NUMBER(20, 0) NULL,
  mailingCounty_id NUMBER(20, 0) NULL,
  mailingPostalCode VARCHAR(10) NULL,
  facilityType_id NUMBER(20, 0) NOT NULL UNIQUE,
  mfn_zeg_recipient char(1) NOT NULL,
  parent_id NUMBER(20, 0) NULL,
  realignedFrom_id NUMBER(20, 0) NULL,
  realignedTo_id NUMBER(20, 0) NULL,
  visn_id NUMBER(20, 0) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_InstitutionCode    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_InstitutionCode(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  institution_id NUMBER(20, 0) NOT NULL,
  codingSystem_id NUMBER(20, 0) NOT NULL,
  codeValue VARCHAR(20) NOT NULL UNIQUE,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_InsuranceHolderType    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_InsuranceHolderType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code VARCHAR(1) NOT NULL UNIQUE,
  name VARCHAR(40) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_InsuranceHolderTypeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_InsuranceHolderTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_InsuranceMapping    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_InsuranceMapping(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code VARCHAR(5) NOT NULL UNIQUE,
  name VARCHAR(50) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_InsuranceMappingHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_InsuranceMappingHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_InsurancePlanType    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_InsurancePlanType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code NUMBER(10, 0) NOT NULL UNIQUE,
  name VARCHAR(50) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_InsuranceReportSource    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_InsuranceReportSource(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code NUMBER(10, 0) NOT NULL UNIQUE,
  name VARCHAR(30) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_InsuranceType    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_InsuranceType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code NUMBER(10, 0) NOT NULL UNIQUE,
  name VARCHAR(30) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_InsuranceTypeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_InsuranceTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_IVMCasePriorCrit    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_IVMCasePriorCrit(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code VARCHAR(3) NOT NULL UNIQUE,
  name VARCHAR(80) NOT NULL UNIQUE,
  description VARCHAR(250) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_IVMCasePriorCritHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_IVMCasePriorCritHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);


/****** Object:  Table sdsadm.STD_IVMDecisionType    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_IVMDecisionType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code VARCHAR(3) NOT NULL UNIQUE,
  name VARCHAR(80) NOT NULL UNIQUE,
  description VARCHAR(250) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_IVMDecisionTypeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_IVMDecisionTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_IVMMigrateType    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_IVMMigrateType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code NUMBER(10, 0) NOT NULL UNIQUE,
  name VARCHAR(30) NOT NULL,
  description VARCHAR(250) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_IVMMigrateTypeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_IVMMigrateTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_IVMUnit    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_IVMUnit(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code VARCHAR(3) NOT NULL UNIQUE,
  name VARCHAR(80) NOT NULL UNIQUE,
  description VARCHAR(250) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_IVMUnitHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_IVMUnitHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_LocationType    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_LocationType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code char(1) NOT NULL UNIQUE,
  name VARCHAR(30) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);


/****** Object:  Table sdsadm.STD_LocationTypeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_LocationTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_MaritalStatus    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_MaritalStatus(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code VARCHAR(3) NOT NULL UNIQUE,
  name VARCHAR(30) NOT NULL UNIQUE,
  description VARCHAR(70) NULL,
  abbreviation VARCHAR(5) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_MaritalStatusHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_MaritalStatusHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_MASMovementTransactionType    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_MASMovementTransactionType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  name VARCHAR(30) NOT NULL UNIQUE,
  description VARCHAR(60) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_MASMTTHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_MASMTTHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_MeansTestSigStatus    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_MeansTestSigStatus(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code NUMBER(10, 0) NOT NULL UNIQUE,
  name VARCHAR(30) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_MeansTestSigStatusHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_MeansTestSigStatusHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_MeansTestStatus    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_MeansTestStatus(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code VARCHAR(1) NOT NULL UNIQUE,
  name VARCHAR(50) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_MeansTestStatusHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_MeansTestStatusHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_MessageStatus    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_MessageStatus(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code VARCHAR(2) NOT NULL UNIQUE,
  name VARCHAR(50) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_MessageStatusHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_MessageStatusHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_MessageType    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_MessageType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code char(8) NOT NULL UNIQUE,
  name VARCHAR(60) NOT NULL UNIQUE,
  direction char(1) NOT NULL,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_MessageTypeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_MessageTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_MilHistoryType    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_MilHistoryType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code VARCHAR(4) NOT NULL UNIQUE,
  name VARCHAR(40) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_MilHistoryTypeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_MilHistoryTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_MilitarySvcComp    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_MilitarySvcComp(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code VARCHAR(2) NOT NULL UNIQUE,
  name VARCHAR(80) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_MilitarySvcCompHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_MilitarySvcCompHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_MonetaryBenefitType    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_MonetaryBenefitType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code char(2) NOT NULL UNIQUE,
  name VARCHAR(50) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_MonetaryBenefitTypeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_MonetaryBenefitTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);


/****** Object:  Table sdsadm.STD_MSTStatus    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_MSTStatus(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code VARCHAR(1) NOT NULL UNIQUE,
  name VARCHAR(50) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_MSTStatusHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_MSTStatusHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_MTNotReqRsnType    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_MTNotReqRsnType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code VARCHAR(2) NOT NULL UNIQUE,
  name VARCHAR(60) NOT NULL UNIQUE,
  description VARCHAR(60) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_MTNotReqRsnTypeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_MTNotReqRsnTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);


/****** Object:  Table sdsadm.STD_NameType    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_NameType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code VARCHAR(3) NOT NULL UNIQUE,
  name VARCHAR(32) NOT NULL UNIQUE,
  description VARCHAR(250) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);


/****** Object:  Table sdsadm.STD_NameTypeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_NameTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_NCOADeliveryType    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_NCOADeliveryType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code char(1) NOT NULL UNIQUE,
  name VARCHAR(100) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_NCOADeliveryTypeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_NCOADeliveryTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_NCOAStatusType    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_NCOAStatusType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code NUMBER(10, 0) NOT NULL UNIQUE,
  name VARCHAR(30) NOT NULL UNIQUE,
  description VARCHAR(250) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_NCOAStatusTypeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_NCOAStatusTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_NCOAZipMatchType    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_NCOAZipMatchType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code char(1) NOT NULL UNIQUE,
  name VARCHAR(100) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);


/****** Object:  Table sdsadm.STD_NCOAZipMatchTypeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_NCOAZipMatchTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);


/****** Object:  Table sdsadm.STD_NCOAZipNoMatchType    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_NCOAZipNoMatchType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code VARCHAR(1) NOT NULL UNIQUE,
  name VARCHAR(30) NOT NULL UNIQUE,
  description VARCHAR(60) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_NCOAZipNoMatchTypeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_NCOAZipNoMatchTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_NoSiteUploadReason    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_NoSiteUploadReason(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code NUMBER(10, 0) NOT NULL UNIQUE,
  name VARCHAR(50) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_NoSiteUploadReasonHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_NoSiteUploadReasonHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_NPPESOrgAliasType    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_NPPESOrgAliasType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  aliasTypecode NUMBER(10, 0) NOT NULL UNIQUE,
  shortDescription VARCHAR(30) NULL,
  longDescription VARCHAR(60) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_NPPESOrgAliasTypeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_NPPESOrgAliasTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_NPPESOrgAltId    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_NPPESOrgAltId(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  typecode NUMBER(10, 0) NOT NULL UNIQUE,
  shortDescription VARCHAR(30) NULL,
  longDescription VARCHAR(60) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_NPPESOrgAltIdHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_NPPESOrgAltIdHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_NPPESOrgAltRsn    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_NPPESOrgAltRsn(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  reasoncode NUMBER(10, 0) NOT NULL UNIQUE,
  shortDescription VARCHAR(30) NULL,
  longDescription VARCHAR(60) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_NPPESOrgAltRsnHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_NPPESOrgAltRsnHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);


/****** Object:  Table sdsadm.STD_NTRQualifier    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_NTRQualifier(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code NUMBER(10, 0) NOT NULL UNIQUE,
  name VARCHAR(30) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_NTRQualifierHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_NTRQualifierHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_NTRVerificationMethod    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_NTRVerificationMethod(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code VARCHAR(1) NOT NULL UNIQUE,
  name VARCHAR(50) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_NTRVerificatnMthdHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_NTRVerificatnMthdHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);


/****** Object:  Table sdsadm.STD_OefOifSource    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_OefOifSource(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code VARCHAR(4) NOT NULL UNIQUE,
  name VARCHAR(80) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_OefOifSourceHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_OefOifSourceHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_ORGPROVTAXONOMY    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_ORGPROVTAXONOMY(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  nuccCode VARCHAR(15) NOT NULL UNIQUE,
  providerType VARCHAR(200) NOT NULL,
  classification VARCHAR(200) NULL,
  areaOfSpecialization VARCHAR(100) NULL,
  description VARCHAR(2000) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_ORGPROVTAXONOMYHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_ORGPROVTAXONOMYHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_OtherFederalAgency    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_OtherFederalAgency(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code NUMBER(10, 0) NOT NULL UNIQUE,
  name VARCHAR(50) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_OtherFederalAgencyHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_OtherFederalAgencyHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_PatientType    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_PatientType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code NUMBER(10, 0) NOT NULL UNIQUE,
  name VARCHAR(30) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_PatientTypeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_PatientTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);


/****** Object:  Table sdsadm.STD_PeriodOfService    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_PeriodOfService(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code char(1) NOT NULL UNIQUE,
  name VARCHAR(25) NOT NULL UNIQUE,
  description VARCHAR(26) NULL,
  alternateName VARCHAR(9) NULL,
  beginDate DATE NULL,
  endDate DATE NULL,
  warPeace char(1) NULL,
  latestDateOfBirth char(4) NULL,
  ptfCode char(1) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_PeriodOfServiceHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_PeriodOfServiceHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);


/****** Object:  Table sdsadm.STD_PermanentCode    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_PermanentCode(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code NUMBER(10, 0) NOT NULL UNIQUE,
  name VARCHAR(30) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);


/****** Object:  Table sdsadm.STD_PermanentCodeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_PermanentCodeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_PermissionType    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_PermissionType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code VARCHAR(4) NOT NULL UNIQUE,
  name VARCHAR(120) NOT NULL UNIQUE,
  description VARCHAR(60) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);


/****** Object:  Table sdsadm.STD_PermissionTypeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_PermissionTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);


/****** Object:  Table sdsadm.STD_PersonCatery    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_PersonCatery(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code VARCHAR(2) NOT NULL UNIQUE,
  name VARCHAR(30) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_PersonCateryHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_PersonCateryHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_PersonClass    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_PersonClass(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  ien NUMBER(10, 0) NOT NULL UNIQUE,
  vaCode VARCHAR(7) NOT NULL UNIQUE,
  areaOfSpecialization VARCHAR(100) NULL,
  isTraineePersonClass char(1) NULL,
  classification_id NUMBER(20, 0) NULL,
  providerType_id NUMBER(20, 0) NOT NULL UNIQUE,
  x12Code VARCHAR(10) NULL,
  nuccCode VARCHAR(10) NULL,
  description VARCHAR(2000) NULL,
  source VARCHAR(1000) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_PersonClassCHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_PersonClassCHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_PersonClassClassification    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_PersonClassClassification(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  name VARCHAR(100) NOT NULL UNIQUE,
  description VARCHAR(60) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_PersonClassHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_PersonClassHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);


/****** Object:  Table sdsadm.STD_PersonClassProviderType    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_PersonClassProviderType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  name VARCHAR(100) NOT NULL UNIQUE,
  description VARCHAR(60) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_PersonClassPTHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_PersonClassPTHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_PersonContactType    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_PersonContactType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code NUMBER(10, 0) NOT NULL UNIQUE,
  name VARCHAR(30) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);


/****** Object:  Table sdsadm.STD_PersonContactTypeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_PersonContactTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_PersonMergeStatus    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_PersonMergeStatus(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code VARCHAR(5) NOT NULL UNIQUE,
  name VARCHAR(80) NOT NULL UNIQUE,
  description VARCHAR(250) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_PersonMergeStatusHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_PersonMergeStatusHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_PersonRelation    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_PersonRelation(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code VARCHAR(5) NOT NULL UNIQUE,
  name VARCHAR(50) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_PersonRelationHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_PersonRelationHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_PHDataSrcType    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_PHDataSrcType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code VARCHAR(2) NOT NULL UNIQUE,
  name VARCHAR(60) NOT NULL UNIQUE,
  description VARCHAR(60) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_PHDataSrcTypeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_PHDataSrcTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_PhoneChangeSource    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_PhoneChangeSource(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code VARCHAR(2) NOT NULL UNIQUE,
  name VARCHAR(50) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_PhoneChangeSourceHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_PhoneChangeSourceHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_PhoneContactType    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_PhoneContactType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code NUMBER(10, 0) NOT NULL UNIQUE,
  name VARCHAR(30) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_PhoneContactTypeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_PhoneContactTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_PlaceofAdmission    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_PlaceofAdmission(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code VARCHAR(2) NOT NULL UNIQUE,
  name VARCHAR(20) NOT NULL UNIQUE,
  description VARCHAR(60) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_PlaceofAdmissionHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_PlaceofAdmissionHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_PlanCateryType    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_PlanCateryType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code VARCHAR(4) NOT NULL UNIQUE,
  name VARCHAR(80) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_PlanCateryTypeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_PlanCateryTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_PolicyHolderType    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_PolicyHolderType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code NUMBER(10, 0) NOT NULL UNIQUE,
  name VARCHAR(30) NOT NULL,
  description VARCHAR(250) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_PolicyHolderTypeHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_PolicyHolderTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_PowCasLocnHistory    Script Date: 8/20/2015 6:11:42 PM ******/






CREATE TABLE sdsadm.STD_PowCasLocnHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_PowCasualtyLocation    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_PowCasualtyLocation(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code VARCHAR(3) NOT NULL UNIQUE,
  name VARCHAR(60) NOT NULL,
  location VARCHAR(60) NULL,
  city VARCHAR(60) NULL,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_POWConfineLocnType    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_POWConfineLocnType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code NUMBER(10, 0) NOT NULL UNIQUE,
  name VARCHAR(30) NOT NULL UNIQUE,
  description VARCHAR(250) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_POWConfineLocnTypeHistory    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_POWConfineLocnTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_POWDataSourceType    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_POWDataSourceType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code VARCHAR(10) NOT NULL UNIQUE,
  name VARCHAR(60) NOT NULL UNIQUE,
  description VARCHAR(60) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_POWDataSourceTypeHistory    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_POWDataSourceTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_POWDocumentType    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_POWDocumentType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code NUMBER(10, 0) NOT NULL UNIQUE,
  name VARCHAR(30) NOT NULL UNIQUE,
  description VARCHAR(250) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_POWDocumentTypeHistory    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_POWDocumentTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_POWPeriod    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_POWPeriod(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code char(1) NOT NULL UNIQUE,
  name VARCHAR(30) NOT NULL UNIQUE,
  alternateName VARCHAR(14) NOT NULL,
  shortenedName VARCHAR(28) NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_POWPeriodHistory    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_POWPeriodHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_ProcedureCode    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_ProcedureCode(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code VARCHAR(50) NOT NULL UNIQUE,
  name VARCHAR(50) NOT NULL,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_ProcedureCodeHistory    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_ProcedureCodeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);


/****** Object:  Table sdsadm.STD_ProgramOfStudy    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_ProgramOfStudy(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code VARCHAR(10) NOT NULL UNIQUE,
  name VARCHAR(100) NOT NULL UNIQUE,
  description VARCHAR(150) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_ProgramOfStudyHistory    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_ProgramOfStudyHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_PseudoSSNReason    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_PseudoSSNReason(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code char(1) NOT NULL UNIQUE,
  name VARCHAR(50) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);


/****** Object:  Table sdsadm.STD_PseudoSSNReasonHistory    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_PseudoSSNReasonHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);


/****** Object:  Table sdsadm.STD_PTFDischargeCode    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_PTFDischargeCode(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code NUMBER(10, 0) NOT NULL UNIQUE,
  name VARCHAR(30) NOT NULL UNIQUE,
  description VARCHAR(60) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_PTFDischargeCodeHistory    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_PTFDischargeCodeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);


/****** Object:  Table sdsadm.STD_PublicationTopic    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_PublicationTopic(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  datatype VARCHAR(256) NOT NULL UNIQUE,
  topic VARCHAR(256) NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);


/****** Object:  Table sdsadm.STD_PublicationTopicHistory    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_PublicationTopicHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);


/****** Object:  Table sdsadm.STD_Race    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_Race(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  hl7Code VARCHAR(8) NOT NULL UNIQUE,
  name VARCHAR(45) NOT NULL UNIQUE,
  description VARCHAR(60) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_RaceHistory    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_RaceHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_RadiationExposureMethod    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_RadiationExposureMethod(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code NUMBER(10, 0) NOT NULL UNIQUE,
  name VARCHAR(30) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_RadiatnExpsrMthdHistory    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_RadiatnExpsrMthdHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_RegistryType    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_RegistryType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code NUMBER(10, 0) NOT NULL UNIQUE,
  name VARCHAR(30) NOT NULL UNIQUE,
  description VARCHAR(250) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_RegistryTypeHistory    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_RegistryTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_RejectedRemarks    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_RejectedRemarks(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code NUMBER(10, 0) NOT NULL UNIQUE,
  name VARCHAR(30) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_RejectedRemarksHistory    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_RejectedRemarksHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_RelationalConjunction    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_RelationalConjunction(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code VARCHAR(3) NOT NULL UNIQUE,
  name VARCHAR(25) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);


/****** Object:  Table sdsadm.STD_RelationalOperator    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_RelationalOperator(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code VARCHAR(2) NOT NULL UNIQUE,
  name VARCHAR(25) NOT NULL UNIQUE,
  description VARCHAR(150) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_Relationship    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_Relationship(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code NUMBER(10, 0) NOT NULL UNIQUE,
  name VARCHAR(30) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_RelationshipHistory    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_RelationshipHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_RelatnlConjunctnHistory    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_RelatnlConjunctnHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_RelatnlOperatorHistory    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_RelatnlOperatorHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_Religion    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_Religion(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code VARCHAR(4) NOT NULL UNIQUE,
  name VARCHAR(49) NOT NULL UNIQUE,
  description VARCHAR(60) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);


/****** Object:  Table sdsadm.STD_ReligionHistory    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_ReligionHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_RelToVetInsurance    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_RelToVetInsurance(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code char(2) NOT NULL UNIQUE,
  name VARCHAR(30) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_RelToVetInsuranceHistory    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_RelToVetInsuranceHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_ReportEligFactor    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_ReportEligFactor(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code VARCHAR(5) NOT NULL UNIQUE,
  name VARCHAR(80) NOT NULL UNIQUE,
  description VARCHAR(250) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_ReportEligFactorHistory    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_ReportEligFactorHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_ReportEnrollPrStat    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_ReportEnrollPrStat(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code VARCHAR(5) NOT NULL UNIQUE,
  name VARCHAR(80) NOT NULL UNIQUE,
  description VARCHAR(250) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_ReportEnrollPrStatHistory    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_ReportEnrollPrStatHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_ReportType    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_ReportType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code NUMBER(10, 0) NOT NULL UNIQUE,
  name VARCHAR(30) NOT NULL UNIQUE,
  description VARCHAR(250) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_ReportTypeHistory    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_ReportTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_RPTDayOfMonthType    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_RPTDayOfMonthType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code NUMBER(10, 0) NOT NULL UNIQUE,
  name VARCHAR(30) NOT NULL UNIQUE,
  description VARCHAR(250) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_RPTDayOfMonthTypeHistory    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_RPTDayOfMonthTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_RPTDayOfQuarterTyp    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_RPTDayOfQuarterTyp(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code NUMBER(10, 0) NOT NULL UNIQUE,
  name VARCHAR(30) NOT NULL UNIQUE,
  description VARCHAR(250) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_RPTDayOfQuarterTypHistory    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_RPTDayOfQuarterTypHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_RPTDayOfWeekType    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_RPTDayOfWeekType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code NUMBER(10, 0) NOT NULL UNIQUE,
  name VARCHAR(30) NOT NULL UNIQUE,
  description VARCHAR(250) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_RPTDayOfWeekTypeHistory    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_RPTDayOfWeekTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_RPTDetailByType    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_RPTDetailByType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code NUMBER(10, 0) NOT NULL UNIQUE,
  name VARCHAR(30) NOT NULL UNIQUE,
  description VARCHAR(250) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_RPTDetailByTypeHistory    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_RPTDetailByTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_RPTDetailForType    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_RPTDetailForType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code NUMBER(10, 0) NOT NULL UNIQUE,
  name VARCHAR(50) NOT NULL,
  description VARCHAR(250) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_RPTDetailForTypeHistory    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_RPTDetailForTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_RPTDivisionType    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_RPTDivisionType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code NUMBER(10, 0) NOT NULL UNIQUE,
  name VARCHAR(40) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_RPTDivisionTypeHistory    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_RPTDivisionTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_RPTEEDWeeklyType    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_RPTEEDWeeklyType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code NUMBER(10, 0) NOT NULL UNIQUE,
  name VARCHAR(30) NOT NULL UNIQUE,
  description VARCHAR(250) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);


/****** Object:  Table sdsadm.STD_RPTEEDWeeklyTypeHistory    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_RPTEEDWeeklyTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_RPTExceptionType    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_RPTExceptionType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code NUMBER(10, 0) NOT NULL UNIQUE,
  name VARCHAR(100) NOT NULL,
  description VARCHAR(250) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_RPTExceptionTypeHistory    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_RPTExceptionTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_RPTLetterFileType    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_RPTLetterFileType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code NUMBER(10, 0) NOT NULL UNIQUE,
  name VARCHAR(30) NOT NULL UNIQUE,
  description VARCHAR(250) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_RPTLetterFileTypeHistory    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_RPTLetterFileTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_RPTMonthList    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_RPTMonthList(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code NUMBER(10, 0) NOT NULL UNIQUE,
  name VARCHAR(30) NOT NULL,
  description VARCHAR(250) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_RPTMonthListHistory    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_RPTMonthListHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);


/****** Object:  Table sdsadm.STD_RPTOutFormatType    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_RPTOutFormatType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code NUMBER(10, 0) NOT NULL UNIQUE,
  name VARCHAR(100) NOT NULL,
  description VARCHAR(250) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_RPTOutFormatTypeHistory    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_RPTOutFormatTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_RPTOutputFileType    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_RPTOutputFileType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code VARCHAR(3) NOT NULL UNIQUE,
  name VARCHAR(30) NOT NULL UNIQUE,
  description VARCHAR(250) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_RPTOutputFileTypeHistory    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_RPTOutputFileTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_RPTPeriodType    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_RPTPeriodType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code NUMBER(10, 0) NOT NULL UNIQUE,
  name VARCHAR(30) NOT NULL UNIQUE,
  description VARCHAR(250) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_RPTPeriodTypeHistory    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_RPTPeriodTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_RPTQuarterList    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_RPTQuarterList(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code NUMBER(10, 0) NOT NULL UNIQUE,
  name VARCHAR(30) NOT NULL UNIQUE,
  description VARCHAR(250) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_RPTQuarterListHistory    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_RPTQuarterListHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_RPTRunFrequencyTyp    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_RPTRunFrequencyTyp(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code NUMBER(10, 0) NOT NULL UNIQUE,
  name VARCHAR(30) NOT NULL UNIQUE,
  description VARCHAR(250) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);


/****** Object:  Table sdsadm.STD_RPTRunFrequencyTypHistory    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_RPTRunFrequencyTypHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_RPTScheduleType    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_RPTScheduleType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code NUMBER(10, 0) NOT NULL UNIQUE,
  name VARCHAR(30) NOT NULL UNIQUE,
  description VARCHAR(250) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_RPTScheduleTypeHistory    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_RPTScheduleTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);


/****** Object:  Table sdsadm.STD_RPTSiteDisplayType    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_RPTSiteDisplayType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code NUMBER(10, 0) NOT NULL UNIQUE,
  name VARCHAR(30) NOT NULL UNIQUE,
  description VARCHAR(250) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_RPTSiteDisplayTypeHistory    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_RPTSiteDisplayTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);


/****** Object:  Table sdsadm.STD_RPTStandardReports    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_RPTStandardReports(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code VARCHAR(10) NOT NULL,
  name VARCHAR(80) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  type_id NUMBER(20, 0) NOT NULL UNIQUE,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_RPTStandardReportsHistory    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_RPTStandardReportsHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_RPTStatusComponent    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_RPTStatusComponent(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code VARCHAR(5) NOT NULL UNIQUE,
  name VARCHAR(80) NOT NULL UNIQUE,
  description VARCHAR(250) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_RPTStatusComponentHistory    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_RPTStatusComponentHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_RPTWeekOfMonthType    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_RPTWeekOfMonthType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code NUMBER(10, 0) NOT NULL UNIQUE,
  name VARCHAR(30) NOT NULL UNIQUE,
  description VARCHAR(250) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_RPTWeekOfMonthTypeHistory    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_RPTWeekOfMonthTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_RPTWorkItemStType    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_RPTWorkItemStType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code NUMBER(10, 0) NOT NULL UNIQUE,
  name VARCHAR(40) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_RPTWorkItemStTypeHistory    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_RPTWorkItemStTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_SensitivityChangeSource    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_SensitivityChangeSource(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code NUMBER(10, 0) NOT NULL UNIQUE,
  name VARCHAR(50) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_SensitivityChngSrcHistory    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_SensitivityChngSrcHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_Service    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_Service(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  name VARCHAR(50) NOT NULL UNIQUE,
  routingSymbol VARCHAR(7) NULL,
  dssServiceCode char(1) NULL,
  vaCostCenter char(3) NULL,
  generalPrivilege VARCHAR(1000) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);


/****** Object:  Table sdsadm.STD_ServiceBranch    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_ServiceBranch(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code NUMBER(10, 0) NOT NULL UNIQUE,
  name VARCHAR(30) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_ServiceBranchHistory    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_ServiceBranchHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_ServiceDischargeCode    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_ServiceDischargeCode(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code NUMBER(10, 0) NOT NULL UNIQUE,
  name VARCHAR(30) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_ServiceHistory    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_ServiceHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_SHADDocumentType    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_SHADDocumentType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code VARCHAR(1) NOT NULL UNIQUE,
  name VARCHAR(60) NOT NULL UNIQUE,
  description VARCHAR(60) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_SHADDocumentTypeHistory    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_SHADDocumentTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_SignatureIndType    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_SignatureIndType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code NUMBER(10, 0) NOT NULL UNIQUE,
  name VARCHAR(40) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_SignatureIndTypeHistory    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_SignatureIndTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_SiteUploadStatus    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_SiteUploadStatus(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code NUMBER(10, 0) NOT NULL UNIQUE,
  name VARCHAR(50) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_SiteUploadStatusHistory    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_SiteUploadStatusHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_SpecialFactorMap    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_SpecialFactorMap(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code VARCHAR(5) NOT NULL UNIQUE,
  name VARCHAR(50) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_SpecialFactorMapHistory    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_SpecialFactorMapHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_SpecialtyService    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_SpecialtyService(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code VARCHAR(3) NOT NULL UNIQUE,
  name VARCHAR(20) NOT NULL UNIQUE,
  description VARCHAR(60) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_SpecialtyServiceHistory    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_SpecialtyServiceHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_SpinalInjuryCode    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_SpinalInjuryCode(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code VARCHAR(3) NOT NULL UNIQUE,
  name VARCHAR(50) NOT NULL UNIQUE,
  description VARCHAR(200) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_SpinalInjuryCodeHistory    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_SpinalInjuryCodeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_SSAMessageType    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_SSAMessageType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code VARCHAR(3) NOT NULL UNIQUE,
  name VARCHAR(30) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_SSAMessageTypeHistory    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_SSAMessageTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_SSAVerifCode    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_SSAVerifCode(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code char(1) NOT NULL UNIQUE,
  name VARCHAR(70) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_SSAVerifCodeHistory    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_SSAVerifCodeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);


/****** Object:  Table sdsadm.STD_SSNChangeSource    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_SSNChangeSource(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code VARCHAR(2) NOT NULL UNIQUE,
  name VARCHAR(50) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_SSNChangeSourceHistory    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_SSNChangeSourceHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_SSNType    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_SSNType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code VARCHAR(30) NOT NULL UNIQUE,
  name VARCHAR(30) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_SSNTypeHistory    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_SSNTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_SSNVerificationStatus    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_SSNVerificationStatus(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code NUMBER(10, 0) NOT NULL UNIQUE,
  name VARCHAR(70) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_SSNVerifStatusHistory    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_SSNVerifStatusHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);


/****** Object:  Table sdsadm.STD_StatCntyXref    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_StatCntyXref(
  county_id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  statisticalArea_id NUMBER(20, 0) NOT NULL UNIQUE,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_State    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_State(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  name VARCHAR(50) NOT NULL,
  postalname VARCHAR(30) NOT NULL UNIQUE,
  fipsCode char(2) NULL,
  country_id NUMBER(20, 0) NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_StateHistory    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_StateHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);


/****** Object:  Table sdsadm.STD_StatisticalArea    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_StatisticalArea(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code NUMBER(10, 0) NOT NULL UNIQUE,
  title VARCHAR(100) NOT NULL,
  statisticalAreaType_id NUMBER(20, 0) NOT NULL,
  parent_id NUMBER(20, 0) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_StatisticalAreaHistory    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_StatisticalAreaHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_StatisticalAreaType    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_StatisticalAreaType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code VARCHAR(11) NOT NULL UNIQUE,
  name VARCHAR(45) NOT NULL UNIQUE,
  description VARCHAR(60) NULL,
  parentType_id NUMBER(20, 0) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_StatisticalAreaTypeHistory    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_StatisticalAreaTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_SvcDschrgCdHistory    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_SvcDschrgCdHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_TableManager    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_TableManager(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  tableName VARCHAR(31) NOT NULL UNIQUE,
  releaseNumber VARCHAR(5) NOT NULL,
  releaseDate VARCHAR(15) NULL,
  lastPopulated VARCHAR(15) NULL,
  lastUpdated DATE NOT NULL);




/****** Object:  Table sdsadm.STD_TransactionType    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_TransactionType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code char(2) NOT NULL UNIQUE,
  name VARCHAR(30) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_TransactionTypeHistory    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_TransactionTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_UserAbsenceType    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_UserAbsenceType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code VARCHAR(3) NOT NULL UNIQUE,
  name VARCHAR(80) NOT NULL UNIQUE,
  description VARCHAR(250) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_UserAbsenceTypeHistory    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_UserAbsenceTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_UserGroupType    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_UserGroupType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code NUMBER(10, 0) NOT NULL UNIQUE,
  name VARCHAR(40) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_UserGroupTypeHistory    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_UserGroupTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_VBAQueryStatusType    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_VBAQueryStatusType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code VARCHAR(2) NOT NULL UNIQUE,
  name VARCHAR(60) NOT NULL UNIQUE,
  description VARCHAR(60) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_VBAQueryStatusTypeHistory    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_VBAQueryStatusTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_WkfDataJobAction    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_WkfDataJobAction(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code VARCHAR(3) NOT NULL UNIQUE,
  name VARCHAR(80) NOT NULL UNIQUE,
  description VARCHAR(250) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_WkfDataJobActionHistory    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_WkfDataJobActionHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_WkfDataJobStatus    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_WkfDataJobStatus(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code VARCHAR(3) NOT NULL UNIQUE,
  name VARCHAR(80) NOT NULL UNIQUE,
  description VARCHAR(250) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_WkfDataJobStatusHistory    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_WkfDataJobStatusHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_WKFIssueType    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_WKFIssueType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code VARCHAR(4) NOT NULL UNIQUE,
  name VARCHAR(120) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_WKFIssueTypeHistory    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_WKFIssueTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_WkfloCaseActivityHistory    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_WkfloCaseActivityHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_WkfloCaseRequestHistory    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_WkfloCaseRequestHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_WkfloCaseStatusHistory    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_WkfloCaseStatusHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_WkfloCaseTypeHistory    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_WkfloCaseTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_WkfloUpdateTypeHistory    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_WkfloUpdateTypeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_WorkflowCaseActivity    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_WorkflowCaseActivity(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code VARCHAR(2) NOT NULL UNIQUE,
  name VARCHAR(50) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_WorkflowCaseRequest    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_WorkflowCaseRequest(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code VARCHAR(2) NOT NULL UNIQUE,
  name VARCHAR(100) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_WorkflowCaseStatus    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_WorkflowCaseStatus(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code VARCHAR(2) NOT NULL UNIQUE,
  name VARCHAR(30) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_WorkflowCaseType    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_WorkflowCaseType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code VARCHAR(3) NOT NULL UNIQUE,
  name VARCHAR(60) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_WorkflowUpdateType    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_WorkflowUpdateType(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code VARCHAR(2) NOT NULL UNIQUE,
  name VARCHAR(50) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_YesNoCode    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_YesNoCode(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code NUMBER(10, 0) NOT NULL UNIQUE,
  alphaCode VARCHAR(1) NOT NULL UNIQUE,
  name VARCHAR(30) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_YesNoCodeHistory    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_YesNoCodeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_ZipAssignment    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_ZipAssignment(
  zipcode_id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  zipplace_id NUMBER(20, 0) NOT NULL UNIQUE,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_ZipClassification    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_ZipClassification(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code VARCHAR(4) NOT NULL UNIQUE,
  name VARCHAR(20) NOT NULL UNIQUE,
  description VARCHAR(75) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_ZipClassificationHistory    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_ZipClassificationHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_ZipCode    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_ZipCode(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  zipCode VARCHAR(10) NOT NULL UNIQUE,
  zipClassification_id NUMBER(20, 0) NULL,
  preferredZipPlace_id NUMBER(20, 0) NULL,
  state_id NUMBER(20, 0) NOT NULL UNIQUE,
  countyNumber char(3) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_ZipCodeHistory    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_ZipCodeHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_ZipPlace    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_ZipPlace(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  zipPlaceKey VARCHAR(6) NOT NULL UNIQUE,
  name VARCHAR(28) NOT NULL,
  isApprovedMailingName char(1) NOT NULL,
  abbreviatedName VARCHAR(13) NULL,
  zipPlaceFacility_id NUMBER(20, 0) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);


/****** Object:  Table sdsadm.STD_ZipPlaceFacility    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_ZipPlaceFacility(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  code char(1) NOT NULL UNIQUE,
  name VARCHAR(75) NOT NULL UNIQUE,
  description VARCHAR(100) NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_ZipPlaceFacilityHistory    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_ZipPlaceFacilityHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);


/****** Object:  Table sdsadm.STD_ZipPlaceHistory    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_ZipPlaceHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);



/****** Object:  Table sdsadm.STD_ZipToMSA    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_ZipToMSA(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  zipCode char(5) NOT NULL UNIQUE,
  msaCodeFrom1990 VARCHAR(4) NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  Table sdsadm.STD_ZipToMSAHistory    Script Date: 8/20/2015 6:11:43 PM ******/






CREATE TABLE sdsadm.STD_ZipToMSAHistory(
  id NUMBER(20, 0) NOT NULL PRIMARY KEY,
  owner_id NUMBER(20, 0) NOT NULL,
  isActive char(1) NOT NULL,
  effectiveDate DATE NOT NULL,
  expirationDate DATE NOT NULL,
  version NUMBER NOT NULL,
  created DATE NOT NULL,
  updated DATE NULL,
  createdBy VARCHAR(32) NOT NULL,
  updatedBy VARCHAR(32) NULL);




/****** Object:  View CISS.AppUser_View    Script Date: 8/20/2015 6:11:43 PM ******/




/****** Object:  Index XP_CDW_InstitutionSID    Script Date: 8/20/2015 6:11:43 PM ******/
CREATE INDEX XP_CDW_InstitutionSID ON PCMM.PCM_STD_CDW_PCM_INST_TRANSFORM
(
  CDW_InstitutionSID ASC
);



/****** Object:  Index IX_FK_AGENT_CONFIG_APP_USER_ID    Script Date: 8/20/2015 6:11:43 PM ******/
CREATE INDEX IX_FK_AGENT_CONFIG_APP_USER_ID ON CISS.AGENT_CONFIG
(
  APP_USER_ID ASC
);

/****** Object:  Index IX_FK_AGENT_RIA_CONFIG_APP_USER_ID    Script Date: 8/20/2015 6:11:43 PM ******/
CREATE INDEX XAGENT_RIA_CONFIG_APP_USER_ID ON CISS.AGENT_RIA_CONFIG
(
  APP_USER_ID ASC
);

/****** Object:  Index XIFAppParameterTypeID_AppParameter    Script Date: 8/20/2015 6:11:43 PM ******/
CREATE INDEX XAppParamTypeID_AppParameter ON CISS.APP_PARAMETER
(
  APP_PARAMETER_TYPE_ID ASC
);

/****** Object:  Index XIFCissStdApplication_AppParameter    Script Date: 8/20/2015 6:11:43 PM ******/
CREATE INDEX XStdApplication_AppParameter ON CISS.APP_PARAMETER
(
  CISS_STD_APPLICATION_ID ASC
);

/****** Object:  Index XIFStdAppParameterUnitID_AppParameter    Script Date: 8/20/2015 6:11:43 PM ******/
CREATE INDEX XAppParamUnitID_AppParameter ON CISS.APP_PARAMETER
(
  STD_APPPARAMETERUNIT_ID ASC
);

/****** Object:  Index XIFAppParameterID_AppParameterValue    Script Date: 8/20/2015 6:11:43 PM ******/
CREATE INDEX XAppParamID_AppParameterValue ON CISS.APP_PARAMETER_VALUE
(
  APP_PARAMETER_ID ASC
);

/****** Object:  Index Idx_ActiveDirectoryName_Unq    Script Date: 8/20/2015 6:11:43 PM ******/
CREATE INDEX Idx_ActiveDirectoryName_Unq ON CISS.APP_USER
(
  ACTIVE_DIRECTORY_NAME ASC
);

/****** Object:  Index XIFLastVisitedDutyStationID_AppUser    Script Date: 8/20/2015 6:11:43 PM ******/
CREATE INDEX XLastVisitDutyStation_AppUser ON CISS.APP_USER
(
  LAST_VISITED_DUTY_STATION ASC
);



/****** Object:  Index XIFAppUserID_AppUserRole    Script Date: 8/20/2015 6:11:43 PM ******/
CREATE INDEX XIFAppUserID_AppUserRole ON CISS.APP_USER_ROLE
(
  APP_USER_ID ASC
);

/****** Object:  Index XIFRoleID_AppUserRole    Script Date: 8/20/2015 6:11:43 PM ******/
CREATE INDEX XIFRoleID_AppUserRole ON CISS.APP_USER_ROLE
(
  ROLE_ID ASC
);

/****** Object:  Index IX_FK_ARCHIVE_LOG_ENTRY_SNAPSHOT_ARCHIVE_LOG_ENTRY_ID    Script Date: 8/20/2015 6:11:43 PM ******/
CREATE INDEX XCISS_ARC_LOG_ENTRY_SNAPSHOT1 ON CISS.ARCHIVE_LOG_ENTRY_SNAPSHOT
(
  ARCHIVE_LOG_ENTRY_ID ASC
);

/****** Object:  Index XIFJobConfigID_BatchJobPermission    Script Date: 8/20/2015 6:11:43 PM ******/
CREATE INDEX XIFJobConfigID_BatchJobPerm ON CISS.BATCH_JOB_PERMISSION
(
  JOB_CONFIG_ID ASC
);

/****** Object:  Index XIFPermissionID_BatchJobPermission    Script Date: 8/20/2015 6:11:43 PM ******/
CREATE INDEX XIFPermissionID_BatchJobPerm ON CISS.BATCH_JOB_PERMISSION
(
  PERMISSION_ID ASC
);

/****** Object:  Index IX_FK_CISS_STD_INACTIVE_REASON_CISS_STD_APPLICATION_ID    Script Date: 8/20/2015 6:11:43 PM ******/
CREATE INDEX X_CISS_STD_INACTIVE_REASON1 ON CISS.CISS_STD_INACTIVE_REASON
(
  CISS_STD_APPLICATION_ID ASC
);

/****** Object:  Index IX_FK_MULTI_PCP_PCM_STD_MULTIPCP_CANCEL_REASON_ID    Script Date: 8/20/2015 6:11:43 PM ******/
CREATE INDEX XMULTI_PCP_CANCEL_RSN_ID ON PCMM.MULTI_PCP
(
  PCM_STD_MULTIPCP_CANCEL_RSN_ID ASC
);



/****** Object:  Index IX_FK_MULTI_PCP_PCM_STD_MULTIPCP_STATUS_REASON_ID    Script Date: 8/20/2015 6:11:43 PM ******/
CREATE INDEX XMULTI_PCP_STATUS_REASON_ID ON PCMM.MULTI_PCP
(
  PCM_STD_MULTIPCP_STAT_RESON_ID ASC
);

/****** Object:  Index XIFAppUserID_DutyStation    Script Date: 8/20/2015 6:11:43 PM ******/
CREATE INDEX XIFAppUserID_DutyStation ON CISS.DUTY_STATION
(
  APP_USER_ID ASC
);

/****** Object:  Index XIFInstitutionID_DutyStation    Script Date: 8/20/2015 6:11:43 PM ******/
CREATE INDEX XIFInstitutionID_DutyStation ON CISS.DUTY_STATION
(
  INSTITUTION_ID ASC
);

/****** Object:  Index XIFPaidLoadErrorsID_ExceptionLog    Script Date: 8/20/2015 6:11:43 PM ******/
CREATE INDEX XIFPaidLoadErrID_ExceptionLog ON CISS.EXCEPTION_LOG
(
  PAID_LOAD_ERRORS_ID ASC
);

/****** Object:  Index XIFVssLoadErrorsID_ExceptionLog    Script Date: 8/20/2015 6:11:43 PM ******/
CREATE INDEX XIFVssLoadErrID_ExceptionLog ON CISS.EXCEPTION_LOG
(
  VSS_LOAD_ERRORS_ID ASC
);

/****** Object:  Index XIFCissStdApplicationID_JobConfig    Script Date: 8/20/2015 6:11:43 PM ******/
CREATE INDEX XCissStdAppID_JobConfig ON CISS.JOB_CONFIG
(
  CISS_STD_APPLICATION_ID ASC
);

/****** Object:  Index XIFCissStdApplicationID_JobResult    Script Date: 8/20/2015 6:11:43 PM ******/
CREATE INDEX XIFCissStdAppID_JobResult ON CISS.JOB_RESULT
(
  CISS_STD_APPLICATION_ID ASC
);

/****** Object:  Index XIS_PAID_LOAD_PSEUDO_SSN    Script Date: 8/20/2015 6:11:43 PM ******/
CREATE INDEX XIS_PAID_LOAD_PSEUDO_SSN ON CISS.PAID_LOAD
(
  PSEUDO_SSN ASC
);

/****** Object:  Index XIS_PAID_LOAD_SSN    Script Date: 8/20/2015 6:11:43 PM ******/
CREATE INDEX XIS_PAID_LOAD_SSN ON CISS.PAID_LOAD
(
  SSN ASC
);

/****** Object:  Index XIFPaidLoadLogID_PaidLoadErrors    Script Date: 8/20/2015 6:11:43 PM ******/
CREATE INDEX XPaidLoadLogID_PaidLoadErrors ON CISS.PAID_LOAD_ERRORS
(
  PAID_LOAD_LOG_ID ASC
);

/****** Object:  Index XIFCissStdApplicationID_Permission    Script Date: 8/20/2015 6:11:43 PM ******/
CREATE INDEX XCissStdAppID_Permission ON CISS.PERMISSION
(
  CISS_STD_APPLICATION_ID ASC
);




/****** Object:  Index ROLE_U_CODE_UK    Script Date: 8/20/2015 6:11:43 PM ******/
CREATE INDEX ROLE_U_CODE_UK ON CISS.ROLE
(
  ROLE_NAME ASC
);

/****** Object:  Index XIFCissStdApplicationID_Role    Script Date: 8/20/2015 6:11:43 PM ******/
CREATE INDEX XIFCissStdApplicationID_Role ON CISS.ROLE
(
  CISS_STD_APPLICATION_ID ASC
);

/****** Object:  Index XIFPermissionID_RolePermission    Script Date: 8/20/2015 6:11:43 PM ******/
CREATE INDEX XIFPermissionID_RolePermission ON CISS.ROLE_PERMISSION
(
  PERMISSION_ID ASC
);

/****** Object:  Index XIFRoleID_RolePermission    Script Date: 8/20/2015 6:11:43 PM ******/
CREATE INDEX XIFRoleID_RolePermission ON CISS.ROLE_PERMISSION
(
  ROLE_ID ASC
);

/****** Object:  Index XISVSSLoad_VSS_id    Script Date: 8/20/2015 6:11:43 PM ******/
CREATE INDEX XISVSSLoad_VSS_id ON CISS.VSS_LOAD
(
  VSS_ID ASC
);


/****** Object:  Index IX_FK_FACILITY_ROOM_PCM_STD_FACILITY_ROOM_TYPE_ID    Script Date: 8/20/2015 6:11:43 PM ******/
CREATE INDEX X_FACILITY_ROOM_TYPE_ID ON PCMM.FACILITY_ROOM
(
  PCM_STD_FACILITY_ROOM_TYPE_ID ASC
);

/****** Object:  Index IX_FK_FACILITY_ROOM_VA_FACILITY_ID    Script Date: 8/20/2015 6:11:43 PM ******/
CREATE INDEX XFACILITY_ROOM_VA_FACILITY_ID ON PCMM.FACILITY_ROOM
(
  VA_FACILITY_ID ASC
);

/****** Object:  Index IX_FK_MODEL_TEAM_PCM_STD_TEAM_CARE_TYPE_ID    Script Date: 8/20/2015 6:11:43 PM ******/
CREATE INDEX XMODEL_TEAM_TEAM_CARE_TYPE_ID ON PCMM.MODEL_TEAM
(
  PCM_STD_TEAM_CARE_TYPE_ID ASC
);

/****** Object:  Index IX_FK_MODEL_TEAM_PCM_STD_TEAM_FOCUS_ID    Script Date: 8/20/2015 6:11:43 PM ******/
CREATE INDEX XMODEL_TEAM_FOCUS_ID ON PCMM.MODEL_TEAM
(
  PCM_STD_TEAM_FOCUS_ID ASC
);

/****** Object:  Index IX_FK_MODEL_TEAM_VA_INSTITUTION_ID    Script Date: 8/20/2015 6:11:43 PM ******/
CREATE INDEX XMODEL_TEAM_VA_INSTITUTION_ID ON PCMM.MODEL_TEAM
(
  VA_INSTITUTION_ID ASC
);

/****** Object:  Index IX_FK_MODEL_TEAM_POSITION_MODEL_TEAM_ID    Script Date: 8/20/2015 6:11:43 PM ******/
CREATE INDEX XMODEL_TEAM_POSITION_M_TEAM_ID ON PCMM.MODEL_TEAM_POSITION
(
  MODEL_TEAM_ID ASC
);

/****** Object:  Index IX_FK_MODEL_TEAM_POSITION_PCM_STD_TEAM_ROLE_ID    Script Date: 8/20/2015 6:11:43 PM ******/
CREATE INDEX XMODEL_TEAM_POSITION_T_ROLE_ID ON PCMM.MODEL_TEAM_POSITION
(
  PCM_STD_TEAM_ROLE_ID ASC
);



/****** Object:  Index IX_FK_MULTI_PCP_TEAM_ID    Script Date: 8/20/2015 6:11:43 PM ******/
CREATE INDEX IX_FK_MULTI_PCP_TEAM_ID ON PCMM.MULTI_PCP
(
  TEAM_ID ASC
);


/****** Object:  Index IX_FK_MULTI_PCP_APPROVALS_TEAM_PATIENT_ASSIGN_ID    Script Date: 8/20/2015 6:11:43 PM ******/
CREATE INDEX XMULTI_PCP_APPROVAL_ASSIGN_ID ON PCMM.MULTI_PCP_APPROVALS
(
  TEAM_PATIENT_ASSIGN_ID ASC
);

/****** Object:  Index IX_FK_MULTI_PCP_APPROVALS_TVC_APPROVER_ID    Script Date: 8/20/2015 6:11:43 PM ******/
CREATE INDEX XMULTI_PCP_APPROVAL_APPROV_ID ON PCMM.MULTI_PCP_APPROVALS
(
  TVC_APPROVER_ID ASC
);




/****** Object:  Index IX_FK_PANEL_PLACEMENT_REQUEST_PCMM_GROUP_ID    Script Date: 8/20/2015 6:11:43 PM ******/
CREATE INDEX IXPANEL_PLACEMENT_REQ_GROUP_ID ON PCMM.PANEL_PLACEMENT_REQUEST
(
  PCMM_GROUP_ID ASC
);

/****** Object:  Index IX_FK_PANEL_PLACEMENT_REQUEST_PCMM_PATIENT_ID    Script Date: 8/20/2015 6:11:43 PM ******/
CREATE INDEX XPANEL_PLACEMENT_REQ_PATIEN_ID ON PCMM.PANEL_PLACEMENT_REQUEST
(
  PCMM_PATIENT_ID ASC
);

/****** Object:  Index IX_FK_PANEL_PLACEMENT_REQUEST_TEAM_ID    Script Date: 8/20/2015 6:11:43 PM ******/
CREATE INDEX XPANEL_PLACEMENT_REQ_TEAM_ID ON PCMM.PANEL_PLACEMENT_REQUEST
(
  TEAM_ID ASC
);





/****** Object:  Index IXNC_PATIENT_ASSIGN_TEAM_POSITION_TEAM_POSITION_ID_START_DATE_END_DATE    Script Date: 8/20/2015 6:11:43 PM ******/
CREATE INDEX XPATIEN_ASSIGN_TM_POS_FLDS ON PCMM.PATIENT_ASSIGN_TEAM_POSITION
(
  TEAM_POSITION_ID ASC,
  START_DATE ASC,
  END_DATE ASC,
  TEAM_PATIENT_ASSIGN_ID,
  "PatientPositionAssignmentSID"
);



/****** Object:  Index IX_FK_PCM_STD_ALERT_TEMPLATE_RECIPIENT_APP_USER_ID    Script Date: 8/20/2015 6:11:43 PM ******/
CREATE INDEX XPCM_STD_ALERT_TEMP_REC_FLDS ON PCMM.PCM_STD_ALERT_TEMPL_RECIPIENT
(
  APP_USER_ID,
  PCM_STD_ALERT_TEMP_id,
  ROLE_ID
);

/****** Object:  Index XIS_CDW_IEN    Script Date: 8/20/2015 6:11:43 PM ******/
CREATE INDEX XIS_CDW_IEN ON PCMM.PCM_STD_CDW_PCM_INST_TRANSFORM
(
  CDW_InstitutionIEN
);

/****** Object:  Index IX_FK_PCM_STD_CDW_STANDARDPOS_STAFF_ROLE_PCM_STD_STAFF_ROLE_ID    Script Date: 8/20/2015 6:11:43 PM ******/

CREATE INDEX XCDW_STANDARDPOS_STAFF_ROLE ON PCMM.PCM_STD_CDW_STDPOS_STAFF_ROLE
(
  PCM_STD_STAFF_ROLE_ID ASC
);

/****** Object:  Index IX_FK_PCM_STD_CDW_STANDARDPOS_STAFF_ROLE_PCM_STD_TEAM_ROLE_ID    Script Date: 8/20/2015 6:11:43 PM ******/
CREATE INDEX XCDW_STRDPOS_STAFF_ROLE_T_ID ON PCMM.PCM_STD_CDW_STDPOS_STAFF_ROLE
(
  PCM_STD_TEAM_ROLE_ID ASC
);





/****** Object:  Index IX_FK_PCM_STD_PANEL_SIZE_ADJUSTMENT_PCM_STD_TEAM_CARE_TYPE_ID    Script Date: 8/20/2015 6:11:43 PM ******/
CREATE INDEX XPCM_STD_PANEL_SIZE_ADJ_FLDS ON PCMM.PCM_STD_PANEL_SIZE_ADJUSTMENT
(
  PCM_STD_TEAM_CARE_TYPE_ID,
  VA_FACILITY_ID
);



/****** Object:  Index IX_FK_PCM_STD_PERSON_CLASS_CLASSIFICATION_CISS_ROLE_ID    Script Date: 8/20/2015 6:11:43 PM ******/

CREATE INDEX XPERSON_CLASS_CFN_CISS_ROLE_FL ON PCMM.PERSON_CLASS_CISS_ROLE
(
  CISS_ROLE_id,
  PERSON_CLASS_CLASSIFICATION_id
);

/****** Object:  Index IX_FK_PCM_STD_PERSONCLASS_STAFF_ROLE_PCM_STD_STAFF_ROLE_ID    Script Date: 8/20/2015 6:11:43 PM ******/
CREATE INDEX XPERSONCLASS_STAFF_ROLE_FLD ON PCMM.PCM_STD_PERSONCLASS_STAFF_ROLE
(
  PCM_STD_STAFF_ROLE_ID,
  PERSON_CLASS_ID
);

/****** Object:  Index IX_FK_PCM_STD_PRECEPTOR_TRANSFORM_PRECEPTEE_ROLE_ID    Script Date: 8/20/2015 6:11:43 PM ******/
CREATE INDEX XPCM_STD_PRECEPTOR_TRANSF_FLD ON PCMM.PCM_STD_PRECEPTOR_TRANSFORM
(
  PRECEPTEE_ROLE_ID,
  PRECEPTEE_TEAM_ROLE_ID
);





/****** Object:  Index IX_FK_PCM_STD_TEAM_CARE_TYPE_HISTORY_PCM_STD_TEAM_CARE_TYPE_ID    Script Date: 8/20/2015 6:11:43 PM ******/
CREATE INDEX XTEAM_CARE_TYPE_HISTORY_TYP_ID ON PCMM.PCM_STD_TEAM_CARE_TYPE_HISTORY
(
  PCM_STD_TEAM_CARE_TYPE_ID ASC
);

/****** Object:  Index IX_FK_PCM_STD_TEAM_CARE_TYPE_TEAM_ROLE_PCM_STD_FTEE_REQUIRED_TYPE_ID    Script Date: 8/20/2015 6:11:43 PM ******/
CREATE INDEX XTEAM_CARE_TYPE_TEAM_ROLE_FLD ON PCMM.TEAM_CARE_TYPE_TEAM_ROLE
(
  PCM_STD_FTEE_REQUIRED_TYPE_ID,
  PCM_STD_TEAM_CARE_TYPE_ID,
  PCM_STD_TEAM_ROLE_ID
);

/****** Object:  Index idx_PCM_STD_TEAM_FOCUS_PCM_STD_TEAM_FOCUS_ID_PCM_STD_TEAM_CARE_TYPE_ID    Script Date: 8/20/2015 6:11:43 PM ******/
CREATE INDEX XPCM_STD_TEAM_FOCUS_FLD ON PCMM.PCM_STD_TEAM_FOCUS
(
  PCM_STD_TEAM_FOCUS_ID ASC,
  PCM_STD_TEAM_CARE_TYPE_ID ASC
);



/****** Object:  Index IX_FK_PCM_STD_TEAM_FOCUS_HISTORY_PCM_STD_TEAM_FOCUS_ID    Script Date: 8/20/2015 6:11:43 PM ******/
CREATE INDEX XPCM_STD_TEAM_FOCUS_HIST_FOCUS ON PCMM.PCM_STD_TEAM_FOCUS_HISTORY
(
  PCM_STD_TEAM_FOCUS_ID ASC
);

/****** Object:  Index IX_FK_PCM_STD_TEAM_ROLE_STAFF_ROLE_PCM_STD_STAFF_ROLE_ID    Script Date: 8/20/2015 6:11:43 PM ******/
CREATE INDEX XPCM_STD_TEAM_ROLE_STAF_RL_FLD ON PCMM.PCM_STD_TEAM_ROLE_STAFF_ROLE
(
  PCM_STD_STAFF_ROLE_id,
  PCM_STD_TEAM_ROLE_id
);


/****** Object:  Index IX_FK_PCM_STD_TEAM_ROLE_VISTA_INSTANCE_PCM_STD_TEAM_ROLE_ID    Script Date: 8/20/2015 6:11:43 PM ******/
CREATE INDEX XTEAM_ROLE_VISTA_INST_FLD ON PCMM.TEAM_ROLE_VISTA_INSTANCE
(
  PCM_STD_TEAM_ROLE_id,
  PCMM_VISTA_INSTANCE_id
);

/****** Object:  Index IX_FK_PCMM_ALERT_CLOSED_BY_APP_USER_ID    Script Date: 8/20/2015 6:11:43 PM ******/

CREATE INDEX XPCMM_ALERT_FLDS ON PCMM.PCMM_ALERT
(
  CLOSED_BY_APP_USER_ID,
  MULTI_PCP_ID,
  PCM_STD_ALERT_TEMPLATE_ID,
  PCMM_JOB_EXECUTION_RESULT_ID,
  PCMM_PATIENT_ID,
  SENDER_APP_USER_ID,
  STAFF_ID,
  TEAM_ID
);

/****** Object:  Index IX_FK_PCMM_ALERT_COMMENT_APP_USER_ID    Script Date: 8/20/2015 6:11:43 PM ******/

CREATE INDEX XPCMM_ALERT_COMMENT_FLDS ON PCMM.PCMM_ALERT_COMMENT
(
  APP_USER_ID,
  PCMM_ALERT_ID
);


/****** Object:  Index IX_FK_PCMM_ALERT_RECIPIENT_APP_USER_ID    Script Date: 8/20/2015 6:11:43 PM ******/
CREATE INDEX XPCMM_ALERT_RECIPIENT_FLDS ON PCMM.PCMM_ALERT_RECIPIENT
(
  APP_USER_ID,
  PCMM_ALERT_ID,
  ROLE_ID,
  VA_FACILITY_ID,
  HIBERNATE_CLASS_TYPE
);

/****** Object:  Index IX_FK_PCMM_ALERT_RECIPIENT_INACTIVATION_PCM_STD_ALERT_TEMPLATE_RECIPIENT_ID    Script Date: 8/20/2015 6:11:43 PM ******/

CREATE INDEX XPCMM_ALERT_RECIPIENT_INACT_FL ON PCMM.ALERT_RECIPIENT_INACTIVATION
(
  ALERT_TEMPLATE_RECIPIENT_id,
  VA_FACILITY_id
);


/****** Object:  Index IX_FK_PCMM_BATCH_JOB_EXECUTION_JOB_INSTANCE_ID    Script Date: 8/20/2015 6:11:43 PM ******/
CREATE INDEX XPCMM_BATCH_JOB_EXE_JOBID ON PCMM.PCMM_BATCH_JOB_EXECUTION
(
  JOB_INSTANCE_ID ASC
);

/****** Object:  Index IX_FK_PCMM_BATCH_JOB_EXECUTION_PARAMS_JOB_EXECUTION_ID    Script Date: 8/20/2015 6:11:43 PM ******/
CREATE INDEX XBATCH_JOB_EXEC_PARAM_JOBID ON PCMM.PCMM_BATCH_JOB_EXECUTION_PARAM
(
  JOB_EXECUTION_ID ASC
);

/****** Object:  Index IX_FK_PCMM_BATCH_STEP_EXECUTION_JOB_EXECUTION_ID    Script Date: 8/20/2015 6:11:43 PM ******/
CREATE INDEX XBATCH_STEP_EXECUTION_EXEID ON PCMM.PCMM_BATCH_STEP_EXECUTION
(
  JOB_EXECUTION_ID ASC
);





/****** Object:  Index IX_FK_PCMM_JOB_EXECUTION_RESULT_EXECUTE_REQUEST_BY    Script Date: 8/20/2015 6:11:43 PM ******/
CREATE INDEX XPCMM_JOB_EXECUTION_RESULT_FLD ON PCMM.PCMM_JOB_EXECUTION_RESULT
(
  EXECUTE_REQUEST_BY,
  JOB_EXECUTION_ID,
  PCM_STD_JOB_EXECUTION_TYPE_ID,
  VA_INSTITUTION_ID
);


/****** Object:  Index IX_FK_PCMM_JOB_EXECUTION_RESULT_ITEM_PCMM_JOB_EXECUTION_RESULT_ID    Script Date: 8/20/2015 6:11:43 PM ******/

CREATE INDEX XPCMM_JOB_EXE_RESULT_ITEM_FLD ON PCMM.PCMM_JOB_EXECUTION_RESULT_ITEM
(
  PCMM_JOB_EXECUTION_RESULT_ID,
  PCMM_PATIENT_ID,
  STATUS_EXCEPTION_BINARY_OBJ_ID,
  TEAM_ID,
  TEAM_POSITION_ID
);

/****** Object:  Index idx_PCMM_PATIENT_LAST_NAME    Script Date: 8/20/2015 6:11:43 PM ******/
CREATE INDEX XPCMM_PATIENT_FLDS ON PCMM.PCMM_PATIENT
(
  LAST_NAME,
  SSN,
  ENROLLMENT_STATUS_ID,
  GENDER_ID,
  SSN_VERIFICATION_STATUS_ID,
  SENSITIVE_PATIENT_IND,
  VISTA_PATIENT_NAME,
  "PatientSID"
); 


/****** Object:  Index IXS_PCMM_PATIENT_H_Icn    Script Date: 8/20/2015 6:11:43 PM ******/
CREATE INDEX XPCMM_PATIENT_H_FLDS ON PCMM.PCMM_PATIENT_H
(
  ICN,
  LAST_NAME,
  FIRST_NAME,
  PCMM_PATIENT_ID
); 



/****** Object:  Index IX_FK_PCMM_VISTA_PATIENT_PCMM_PATIENT_ID    Script Date: 8/20/2015 6:11:43 PM ******/
CREATE INDEX XPCMM_VISTA_PATIENT_PATIENT_ID ON PCMM.PCMM_VISTA_PATIENT
(
  PCMM_PATIENT_ID,
  CPRS_HEADER_TEXT,
  PatientSID
);

/****** Object:  Index IXS_PCMM_VISTA_PATIENT_HInstitutionID    Script Date: 8/20/2015 6:11:43 PM ******/

CREATE INDEX XPCMM_VISTA_PATIENT_H_FLDS ON PCMM.PCMM_VISTA_PATIENT_H
(
  VA_INSTITUTION_ID,
  PCMM_PATIENT_ID,
  PCMM_VISTA_PATIENT_ID
);

/****** Object:  Index IX_FK_PRECEPTOR_ASSIGNMENT_PRECEPTEE_ID    Script Date: 8/20/2015 6:11:43 PM ******/
CREATE INDEX XPRECEPTOR_ASSIGNMENT_FLDS ON PCMM.PRECEPTOR_ASSIGNMENT
(
  PRECEPTOR_id,
  ProviderPreceptorRelationSID
);


/****** Object:  Index idx_STAFF_SSN_LAST_NAME    Script Date: 8/20/2015 6:11:43 PM ******/
CREATE INDEX XSTAFF_FLDS ON PCMM.STAFF
(
  SSN,
  LAST_NAME,
  VA_INSTITUTION_ID
);


/****** Object:  Index IX_TeamSID    Script Date: 8/20/2015 6:11:43 PM ******/
CREATE INDEX IX_TeamSID ON PCMM.TEAM
(
  "TeamSID"
);


/****** Object:  Index IX_ProviderFTEESID    Script Date: 8/20/2015 6:11:43 PM ******/
CREATE INDEX IX_ProviderFTEESID ON PCMM.TEAM_MEMBERSHIP
(
  "ProviderPositionAssignmentSID"
);





/****** Object:  Index IXS_TEAM_MEMBERSHIP_StartEndDate    Script Date: 8/20/2015 6:11:43 PM ******/
CREATE INDEX IXS_TEAM_MEMB_StartEndDate ON PCMM.TEAM_MEMBERSHIP
(
  START_DATE ASC,
  END_DATE ASC
);


/****** Object:  Index IXS_TEAM_MEMBERSHIP_TeamID    Script Date: 8/20/2015 6:11:43 PM ******/
CREATE INDEX IXS_TEAM_MEMBERSHIP_TeamID ON PCMM.TEAM_MEMBERSHIP
(
  TEAM_ID ASC,
  START_DATE ASC,
  END_DATE ASC
);




/****** Object:  Index IXS_TEAM_NOTIFICATION_DISTRIBUTION_RULES_TeamPositionID    Script Date: 8/20/2015 6:11:43 PM ******/
CREATE INDEX XTEAM_NOTIFI_DISTR_RULES_POSID ON PCMM.TEAM_NOTIFY_DISTRIBUTION_RULES
(
  TEAM_POSITION_ID ASC
);

/****** Object:  Index IX_PatientID_StartDate_EndDate    Script Date: 8/20/2015 6:11:43 PM ******/
CREATE INDEX IX_PatientID_StartDate_EndDate ON PCMM.TEAM_PATIENT_ASSIGN
(
  PCMM_PATIENT_ID ASC,
  START_DATE ASC,
  END_DATE ASC
);

/****** Object:  Index IX_PatientTeamAssignmentSID    Script Date: 8/20/2015 6:11:43 PM ******/
CREATE INDEX IX_PatientTeamAssignmentSID ON PCMM.TEAM_PATIENT_ASSIGN
(
  "PatientTeamAssignmentSID"
);

/****** Object:  Index IXS_TEAM_PATIENT_ASSIGN_AutoInactivDate    Script Date: 8/20/2015 6:11:43 PM ******/

CREATE INDEX XTEAM_PATIENT_ASSIGN_FLDS ON PCMM.TEAM_PATIENT_ASSIGN
(
  AUTO_INACTIVATION_DATE,
  END_DATE,
  MULTI_PCP_ID,
  RECORD_MODIFIED_DATE,
  TEAM_id,
  TEAM_PATIENT_ASSIGN_ID,
  START_DATE
);

/****** Object:  Index IX_TEAM_PATIENT_ASSIGN_H_TEAM_PATIENT_ASSIGN_ID    Script Date: 8/20/2015 6:11:43 PM ******/

CREATE INDEX XTEAM_PATIENT_ASSIGN_H_FLDS ON PCMM.TEAM_PATIENT_ASSIGN_H
(
  TEAM_PATIENT_ASSIGN_H_ID,
  AUTO_INACTIVATION_DATE,
  PCMM_PATIENT_ID,
  TEAM_ID,
  RECORD_MODIFIED_BY
);

/****** Object:  Index IX_TeamPositionSID    Script Date: 8/20/2015 6:11:43 PM ******/
CREATE INDEX XTEAM_POSITION_FLD ON PCMM.TEAM_POSITION
(
  "TeamPositionSID",
  TEAM_ID,
  PCM_STD_TEAM_ROLE_ID
);


/****** Object:  Index IXS_TEAM_POSITION_HISTORY_EffDate    Script Date: 8/20/2015 6:11:43 PM ******/

CREATE INDEX IXS_TEAM_POS_HIST_EffDate ON PCMM.TEAM_POSITION_HISTORY
(
  EFFECTIVE_DATE ASC
);

/****** Object:  Index IXS_TEAM_POSITION_HISTORY_TeamPosID    Script Date: 8/20/2015 6:11:43 PM ******/
CREATE INDEX IXS_TEAM_POS_HIS_TeamPosID ON PCMM.TEAM_POSITION_HISTORY
(
  TEAM_POSITION_ID ASC,
  EFFECTIVE_DATE ASC
);

/****** Object:  Index ixSTD_AEAgency    Script Date: 8/20/2015 6:11:43 PM ******/
CREATE INDEX ixSTD_AEAgency ON sdsadm.STD_AdministrativeEntity
(
  agency_id ASC
);

/****** Object:  Index ixSTD_AEInstitution    Script Date: 8/20/2015 6:11:43 PM ******/
CREATE INDEX ixSTD_AEInstitution ON sdsadm.STD_AdministrativeEntity
(
  institution_id ASC
); 

/****** Object:  Index ixSTD_ConfAddrCatHl7Value    Script Date: 8/20/2015 6:11:43 PM ******/
CREATE INDEX ixSTD_ConfAddrCatHl7Value ON sdsadm.STD_ConfidentialAddressCat
(
  hl7Value ASC
); 

/****** Object:  Index ixSTD_EthnicityCdcValue    Script Date: 8/20/2015 6:11:43 PM ******/
CREATE INDEX ixSTD_EthnicityCdcValue ON sdsadm.STD_Ethnicity
(
  cdcValue ASC
); 

/****** Object:  Index ixSTD_EthnicityHl7Value    Script Date: 8/20/2015 6:11:43 PM ******/
CREATE INDEX ixSTD_EthnicityHl7Value ON sdsadm.STD_Ethnicity
(
  hl7Value ASC
);




/****** Object:  Index ixSTD_EthnicityPtfValue    Script Date: 8/20/2015 6:11:43 PM ******/
CREATE INDEX ixSTD_EthnicityPtfValue ON sdsadm.STD_Ethnicity
(
  ptfValue ASC
);

/****** Object:  Index ixSTD_ExpenseTypeCode    Script Date: 8/20/2015 6:11:43 PM ******/
CREATE INDEX ixSTD_ExpenseTypeCode ON sdsadm.STD_ExpenseType
(
  code ASC
);



/****** Object:  Index ixSTD_InstStationNumber    Script Date: 8/20/2015 6:11:43 PM ******/
CREATE INDEX ixSTD_InstStationNumber ON sdsadm.STD_Institution
(
  stationNumber ASC
); 

/****** Object:  Index ixSTD_PersonClassNuccCode    Script Date: 8/20/2015 6:11:43 PM ******/
CREATE INDEX ixSTD_PersonClassNuccCode ON sdsadm.STD_PersonClass
(
  nuccCode ASC
); 

/****** Object:  Index ixSTD_PersonClassX12Code    Script Date: 8/20/2015 6:11:43 PM ******/
CREATE INDEX ixSTD_PersonClassX12Code ON sdsadm.STD_PersonClass
(
  x12Code ASC
);


grant references on sdsadm.STD_Institution to CISS;
grant references on sdsadm.STD_Institution to PCMM;
grant references on sdsadm.STD_PersonClassClassification to PCMM;
grant references on sdsadm.STD_PersonClassProviderType to PCMM;
grant references on sdsadm.STD_EnrollmentStatus to PCMM;
grant references on sdsadm.STD_Gender to PCMM;
grant references on sdsadm.STD_SSNVerificationStatus to PCMM;
grant references on CISS.APP_USER to PCMM;
grant references on CISS.ROLE to PCMM;


ALTER TABLE PCMM.PCMM_BATCH_JOB_EXECUTION MODIFY START_TIME DEFAULT (NULL);
              
ALTER TABLE PCMM.PCMM_BATCH_JOB_EXECUTION MODIFY END_TIME DEFAULT (NULL);

ALTER TABLE CISS.ADMIN_STATION_H  MODIFY  HISTORY_RECORD_CREATE_DATE  DEFAULT (SYSDATE) ;
              
ALTER TABLE CISS.APP_PARAMETER_H  MODIFY  HISTORY_RECORD_CREATE_DATE  DEFAULT (SYSDATE) ;
              
ALTER TABLE CISS.APP_USER MODIFY  LDAP_DISABLED_IND DEFAULT ('0') ;
              
ALTER TABLE CISS.APP_USER_APPLICATION_PROFILE MODIFY  INACTIVE_IND  DEFAULT ((0)) ;
              
ALTER TABLE CISS.APP_USER_APPLICATION_PROFILE_H MODIFY  HISTORY_RECORD_CREATE_DATE  DEFAULT (SYSDATE) ;
              
ALTER TABLE CISS.APP_USER_H MODIFY  HISTORY_RECORD_CREATE_DATE  DEFAULT (SYSDATE) ;
              
ALTER TABLE CISS.APP_USER_ROLE_H  MODIFY  HISTORY_RECORD_CREATE_DATE  DEFAULT (SYSDATE) ;
              
ALTER TABLE CISS.BATCH_JOB_PERMISSION_H MODIFY  HISTORY_RECORD_CREATE_DATE  DEFAULT (SYSDATE) ;
              
ALTER TABLE CISS.DUTY_STATION_H MODIFY  HISTORY_RECORD_CREATE_DATE  DEFAULT (SYSDATE) ;
              
ALTER TABLE CISS.JOB_CONFIG_H MODIFY  HISTORY_RECORD_CREATE_DATE  DEFAULT (SYSDATE) ;
              
ALTER TABLE CISS.JOB_RESULT_H MODIFY  HISTORY_RECORD_CREATE_DATE  DEFAULT (SYSDATE) ;
              
ALTER TABLE CISS.PERMISSION_H MODIFY  HISTORY_RECORD_CREATE_DATE  DEFAULT (SYSDATE) ;
              
ALTER TABLE CISS.ROLE_H MODIFY  HISTORY_RECORD_CREATE_DATE  DEFAULT (SYSDATE) ;
              
ALTER TABLE CISS.ROLE_PERMISSION_H  MODIFY  HISTORY_RECORD_CREATE_DATE  DEFAULT (SYSDATE) ;
              
ALTER TABLE CISS.TEMPLATE MODIFY  RECORD_MODIFIED_COUNT DEFAULT ((0)) ;
              
ALTER TABLE PCMM.AUTO_INACTIVATION_ENCOUNTERS MODIFY  USE_FOR_BATCH DEFAULT ((0)) ;
              
ALTER TABLE PCMM.FACILITY_ROOM  MODIFY  ROOM_ACTIVE_IND DEFAULT ('N') ;
              
ALTER TABLE PCMM.MODEL_TEAM_POSITION  MODIFY  REQUIRED_IND  DEFAULT ('N') ;
              
ALTER TABLE PCMM.MULTI_PCP_H  MODIFY  HISTORY_RECORD_CREATE_DATE  DEFAULT (SYSDATE) ;
              
ALTER TABLE PCMM.NON_VA_PRACTICE  MODIFY  RECORD_MODIFIED_COUNT DEFAULT ((0)) ;
              
ALTER TABLE PCMM.NON_VA_PRACTICE_H  MODIFY  HISTORY_RECORD_CREATE_DATE  DEFAULT (SYSDATE) ;
              
ALTER TABLE PCMM.NON_VA_PROVIDER  MODIFY  RECORD_MODIFIED_COUNT DEFAULT ((0)) ;
              
ALTER TABLE PCMM.NON_VA_PROVIDER_H  MODIFY  HISTORY_RECORD_CREATE_DATE  DEFAULT (SYSDATE) ;
              
ALTER TABLE PCMM.NON_VA_PROVIDER_NONVA_PRACTICE MODIFY  RECORD_MODIFIED_COUNT DEFAULT ((0)) ;
              
ALTER TABLE PCMM.NON_VA_PROVIDER_NVP_CATERY MODIFY  RECORD_MODIFIED_COUNT DEFAULT ((0)) ;
              
ALTER TABLE PCMM.NON_VA_PROVIDER_NVP_ROLE MODIFY  RECORD_MODIFIED_COUNT DEFAULT ((0)) ;
              
ALTER TABLE PCMM.NON_VA_PROVIDER_NON_VA_SPLTY MODIFY  RECORD_MODIFIED_COUNT DEFAULT ((0)) ;
              
ALTER TABLE PCMM.NVP_PATIENT_RELATIONSHIP MODIFY  RECORD_MODIFIED_COUNT DEFAULT ((0)) ;
              
ALTER TABLE PCMM.NVP_PATIENT_RELATIONSHIP_H MODIFY  HISTORY_RECORD_CREATE_DATE  DEFAULT (SYSDATE) ;
              
ALTER TABLE PCMM.PATIENT_ASSIGN_TEAM_POSITION_H MODIFY  HISTORY_RECORD_CREATE_DATE  DEFAULT (SYSDATE) ;
              
ALTER TABLE PCMM.PCM_STD_ALERT_TEMPLATE MODIFY  EMAIL_RECIPIENTS_IND  DEFAULT ('N') ;
              
ALTER TABLE PCMM.PCM_STD_MULTIPCP_STAT_REASON MODIFY  ISMANUALLYASSIGNABLE  DEFAULT ('Y') ;
              
ALTER TABLE PCMM.PCM_STD_STAFF_ROLE MODIFY  PHYSICIAN_PROVIDER_IND  DEFAULT ('N') ;
              
ALTER TABLE PCMM.TEAM_CARE_TYPE_TEAM_ROLE MODIFY  PCM_STD_FTEE_REQUIRED_TYPE_ID DEFAULT ((1)) ;
              
ALTER TABLE PCMM.TEAM_CARE_TYPE_TEAM_ROLE MODIFY  TEAMLET_IND DEFAULT ('Y') ;
              
ALTER TABLE PCMM.TEAM_CARE_TYPE_TEAM_ROLE MODIFY  TEAMLET_ENCOUNTER_QUALIFY_IND DEFAULT ('N') ;
              
ALTER TABLE PCMM.TEAM_CARE_TYPE_TEAM_ROLE MODIFY  ONE_ACTIVE_ALLOWED_IND  DEFAULT ('N') ;
              
ALTER TABLE PCMM.TEAM_CARE_TYPE_TEAM_ROLE MODIFY  DIRECT_CARE_PROVIDER_IND  DEFAULT ('N') ;
              
ALTER TABLE PCMM.TEAM_CARE_TYPE_TEAM_ROLE MODIFY  RESTRICT_1_PATIENT_STA3N_IND  DEFAULT (NULL)  ;
              
ALTER TABLE PCMM.PCM_STD_TEAM_ROLE_STAFF_ROLE MODIFY  INCLUDED_IN_PCFTE_IND DEFAULT ('N') ;
              
ALTER TABLE PCMM.PCM_STD_TEMPLATE MODIFY  RECORD_MODIFIED_COUNT DEFAULT ((0)) ;
              
ALTER TABLE PCMM.PCMM_ALERT MODIFY  ALERT_CLOSED_IND  DEFAULT ('N') ;
              
ALTER TABLE PCMM.PCMM_ALERT MODIFY  ALERT_ACTIVATION_DATE DEFAULT (SYSDATE) ;
              
ALTER TABLE PCMM.PCMM_ALERT_H MODIFY  HISTORY_RECORD_CREATE_DATE  DEFAULT (SYSDATE) ;
              
ALTER TABLE PCMM.PCMM_BATCH_JOB_EXECUTION_PARAM MODIFY  DATE_VAL  DEFAULT (NULL)  ;
              
ALTER TABLE PCMM.PCMM_JOB_EXECUTION_RESULT_ITEM MODIFY  JOB_SUCCESS_IND DEFAULT ('N') ;
              
ALTER TABLE PCMM.PCMM_PATIENT MODIFY  ROI_INDICATOR DEFAULT ('N') ;
              
ALTER TABLE PCMM.PCMM_PATIENT MODIFY  SENSITIVE_PATIENT_IND DEFAULT ('N') ;
              
ALTER TABLE PCMM.PCMM_PATIENT_H MODIFY  HISTORY_RECORD_CREATE_DATE  DEFAULT (SYSDATE) ;
              
ALTER TABLE PCMM.PCMM_VISTA_INSTANCE  MODIFY  PATIENT_INACTIVATE_ENABLED_IND  DEFAULT ('N') ;
              
ALTER TABLE PCMM.PCMM_VISTA_INSTANCE  MODIFY  VISTA_SYNC_PROCESS_ENABLED_IND  DEFAULT ('N') ;
              
ALTER TABLE PCMM.PCMM_VISTA_INSTANCE  MODIFY  VISTA_CLEANUP_ENABLED_IND DEFAULT ('N') ;
              
ALTER TABLE PCMM.PCMM_VISTA_INSTANCE  MODIFY  MVI_REGISTRATION_ENABLED_IND  DEFAULT ('N') ;
              
ALTER TABLE PCMM.PCMM_VISTA_INSTANCE  MODIFY  STAFF_UPDATE_PROCESS_ENABL_IND  DEFAULT ('N') ;
              
ALTER TABLE PCMM.PCMM_VISTA_INSTANCE  MODIFY  CPRS_SYNC_PROCESS_ENABLED_IND DEFAULT ('N') ;
              
ALTER TABLE PCMM.PCMM_VISTA_INSTANCE  MODIFY  MAILMAN_ENABLED_IND DEFAULT ('Y') ;
              
ALTER TABLE PCMM.PCMM_VISTA_PATIENT MODIFY  MVI_REGISTRATION_IND  DEFAULT ('N') ;
              
ALTER TABLE PCMM.PCMM_VISTA_PATIENT MODIFY  CPRS_HEADER_TEXT  DEFAULT ('NONE')  ;
              
ALTER TABLE PCMM.PCMM_VISTA_PATIENT_H MODIFY  HISTORY_REC_CREATE_DATE DEFAULT (SYSDATE) ;
              
ALTER TABLE PCMM.PRECEPTOR_ASSIGNMENT_H MODIFY  HISTORY_RECORD_CREATE_DATE  DEFAULT (SYSDATE) ;
              
ALTER TABLE PCMM.STAFF_H  MODIFY  HISTORY_RECORD_CREATE_DATE  DEFAULT (SYSDATE) ;
              
ALTER TABLE PCMM.TEAM MODIFY  ALLOW_OVERRIDE_IND  DEFAULT ('N') ;
              
ALTER TABLE PCMM.TEAM MODIFY  TEAM_CLOSED_IND DEFAULT ('N') ;
              
ALTER TABLE PCMM.TEAM MODIFY  VALIDATION_NEEDED_IND DEFAULT ('N') ;
              
ALTER TABLE PCMM.TEAM MODIFY  SYNC_AFTER_VALIDATION_NEED_IND  DEFAULT ('N') ;
              
ALTER TABLE PCMM.TEAM_H MODIFY  HISTORY_RECORD_CREATE_DATE  DEFAULT (SYSDATE) ;
              
ALTER TABLE PCMM.TEAM_MEMBERSHIP  MODIFY  TEMPORARY_PCP_IND DEFAULT ('N') ;
              
ALTER TABLE PCMM.TEAM_MEMB_DETAIL_HISTORY_H MODIFY  HISTORY_RECORD_CREATE_DATE  DEFAULT (SYSDATE) ;
              
ALTER TABLE PCMM.TEAM_MEMBERSHIP_H  MODIFY  HISTORY_RECORD_CREATE_DATE  DEFAULT (SYSDATE) ;
              
ALTER TABLE PCMM.TEAM_PATIENT_ASSIGN_H  MODIFY  HISTORY_RECORD_CREATE_DATE  DEFAULT (SYSDATE) ;
              
ALTER TABLE PCMM.TEAM_POSITION  MODIFY  TEAM_LEAD_IND DEFAULT ('N') ;
              
ALTER TABLE PCMM.TEAM_POSITION  MODIFY  PRIMARY_TEAM_CONTACT_IND  DEFAULT ('N') ;
              
ALTER TABLE PCMM.TEAM_POSITION  MODIFY  REQUIRED_IND  DEFAULT ('N') ;
              
ALTER TABLE PCMM.TEAM_POSITION  MODIFY  SECONDARY_TEAM_CONTACT_IND  DEFAULT ('N') ;
              
ALTER TABLE PCMM.TEAM_POSITION  MODIFY  ALLOW_OVERRIDE_IND  DEFAULT ('N') ;
              
ALTER TABLE PCMM.TEAM_POSITION_H  MODIFY  HISTORY_RECORD_CREATE_DATE  DEFAULT (SYSDATE) ;
              
ALTER TABLE PCMM.PCMM_VISTA_PATIENT MODIFY  CPRS_HEAD_VISTA_SYNC_NEED_IND DEFAULT ('Y') ;

/*
ALTER TABLE PCMM.PCMM_GROUP ADD CONSTRAINT  FK_StdInstitution_PcmmGroup FOREIGN KEY(VA_FACILITY_ID)                   
REFERENCES  sdsadm.STD_Institution  (id);    

ALTER TABLE PCMM.PCMM_PATIENT ADD CONSTRAINT  FK_StdGender_Patient  FOREIGN KEY(GENDER_ID)                    
REFERENCES  sdsadm.STD_Gender (id); 

ALTER TABLE PCMM.PCMM_PATIENT ADD CONSTRAINT  FK_StdSSNVerifyStat_Patient FOREIGN KEY(SSN_VERIFICATION_STATUS_ID)                   
REFERENCES  sdsadm.STD_SSNVerificationStatus  (id); 

ALTER TABLE PCMM.STAFF  ADD CONSTRAINT  FK_StdInstitution_Staff FOREIGN KEY(VA_INSTITUTION_ID)                    
REFERENCES  sdsadm.STD_Institution  (id);                             

   ALTER TABLE PCMM.TEAM ADD CONSTRAINT  FK_StdInstitution_Team  FOREIGN KEY(VA_INSTITUTION_ID)                    
REFERENCES  sdsadm.STD_Institution  (id);                             
                         
ALTER TABLE PCMM.TEAM_MEMBERSHIP  ADD CONSTRAINT  FK_CONSTRAINT47 FOREIGN KEY(PCM_STD_STAFF_ASSIGN_REASON_ID) 
REFERENCES  PCMM.PCM_STD_STAFF_ASSIGN_REASON  (PCM_STD_STAFF_ASSIGN_REASON_ID);   

ALTER TABLE PCMM.TEAM_PATIENT_ASSIGN  ADD CONSTRAINT  FK_MultiPcp_TeamPatient FOREIGN KEY(MULTI_PCP_ID)                   
REFERENCES  PCMM.MULTI_PCP  (MULTI_PCP_ID);                             

ALTER TABLE PCMM.TEAM_PATIENT_ASSIGN  ADD CONSTRAINT  FK_Patient_TeamPatient  FOREIGN KEY(PCMM_PATIENT_ID)                    
REFERENCES  PCMM.PCMM_PATIENT (PCMM_PATIENT_ID);                              

ALTER TABLE PCMM.TEAM_PATIENT_ASSIGN  ADD CONSTRAINT  FK_CONSTRAINT58 FOREIGN KEY(PCM_STD_MULTIPCP_STATUS_ID)                   
REFERENCES  PCMM.PCM_STD_MULTIPCP_STATUS  (PCM_STD_MULTIPCP_STATUS_ID);                             

ALTER TABLE PCMM.TEAM_PATIENT_ASSIGN  ADD CONSTRAINT  FK_CONSTRAINT60 FOREIGN KEY(TEAM_PATIENT_ASSIGN_STATUS_ID)                    
REFERENCES  PCMM.TEAM_PATIENT_ASSIGN_STATUS (TEAM_PATIENT_ASSIGN_STATUS_ID);   

ALTER TABLE PCMM.TEAM_POSITION  ADD CONSTRAINT  FK_ModelTeam_TeamPosition FOREIGN KEY(MODEL_TEAM_ID)                    
REFERENCES  PCMM.MODEL_TEAM (MODEL_TEAM_ID);                              

ALTER TABLE PCMM.TEAM ADD CONSTRAINT  FK_CONSTRAINT46 FOREIGN KEY(UPDATED_BY_VISTA_AUTH_TOKEN_ID)                   
REFERENCES  PCMM.PCMM_BINARY_OBJECTS  (PCMM_BINARY_OBJECTS_ID)  ;                           

                                 
ALTER TABLE PCMM.TEAM_PATIENT_ASSIGN  ADD CONSTRAINT  FK_CONSTRAINT59 FOREIGN KEY(PATIENT_UNASSIGN_REASON_ID)                   
REFERENCES  PCMM.PATIENT_UNASSIGN_REASON  (PATIENT_UNASSIGN_REASON_ID);                             
                                  

*/

ALTER TABLE CISS.ADMIN_STATION  ADD CONSTRAINT  FK_AdminStation_AppUserId FOREIGN KEY(APP_USER_ID)                    
REFERENCES  CISS.APP_USER (APP_USER_ID);                              
                                  
ALTER TABLE CISS.ADMIN_STATION  ADD CONSTRAINT  FK_AdminStation_Institusion_id  FOREIGN KEY(STATION_id)                   
REFERENCES  sdsadm.STD_Institution  (id);                             
                                  
ALTER TABLE CISS.AGENT_CONFIG ADD CONSTRAINT  FK_AgentConfig_AppUserID  FOREIGN KEY(APP_USER_ID)                    
REFERENCES  CISS.APP_USER (APP_USER_ID);                              
                                  
ALTER TABLE CISS.AGENT_RIA_CONFIG ADD CONSTRAINT  FK_AgentRiaConfig_AppUserID FOREIGN KEY(APP_USER_ID)                    
REFERENCES  CISS.APP_USER (APP_USER_ID);                              
                                  
ALTER TABLE CISS.APP_PARAMETER  ADD CONSTRAINT  FK_AppParameter_AppParamTypeID  FOREIGN KEY(APP_PARAMETER_TYPE_ID)                    
REFERENCES  CISS.CISS_STD_APPPARAMETERTYPE  (CISS_STD_APPPARAMETERTYPE_ID);                             
                                  
ALTER TABLE CISS.APP_PARAMETER  ADD CONSTRAINT  FK_AppParam_CissStdAppID  FOREIGN KEY(CISS_STD_APPLICATION_ID)                    
REFERENCES  CISS.CISS_STD_APPLICATION (CISS_STD_APPLICATION_ID);                              
                                  
ALTER TABLE CISS.APP_PARAMETER  ADD CONSTRAINT  FK_AppParam_StdAppParamUnitID FOREIGN KEY(STD_APPPARAMETERUNIT_ID)                    
REFERENCES  CISS.CISS_STD_APPPARAMETERUNIT  (CISS_STD_APPPARAMETERUNIT_ID);                             
                                  
ALTER TABLE CISS.APP_PARAMETER_VALUE  ADD CONSTRAINT  FK_CONSTRAINT75 FOREIGN KEY(APP_PARAMETER_ID)                   
REFERENCES  CISS.APP_PARAMETER  (APP_PARAMETER_ID);                             
                                  
ALTER TABLE CISS.APP_USER ADD CONSTRAINT  FK_AppUsr_LastVisitDutyStation  FOREIGN KEY(LAST_VISITED_DUTY_STATION)                    
REFERENCES  sdsadm.STD_Institution  (id);                             
                                  
ALTER TABLE CISS.APP_USER_APPLICATION_PROFILE ADD CONSTRAINT  FK_AppUserAppProf_AppUserID FOREIGN KEY(APP_USER_ID)                    
REFERENCES  CISS.APP_USER (APP_USER_ID);                              
                                  
ALTER TABLE CISS.APP_USER_APPLICATION_PROFILE ADD CONSTRAINT  FK_AppUserAppProf_CissStdAppId  FOREIGN KEY(CISS_STD_APPLICATION_ID)  REFERENCES  CISS.CISS_STD_APPLICATION (CISS_STD_APPLICATION_ID);              
                                  
ALTER TABLE CISS.APP_USER_ROLE  ADD CONSTRAINT  FK_AppUserRole_AppUserId  FOREIGN KEY(APP_USER_ID)                    
REFERENCES  CISS.APP_USER (APP_USER_ID);                              
                                  
ALTER TABLE CISS.APP_USER_ROLE  ADD CONSTRAINT  FK_AppUserRole_RoleId FOREIGN KEY(ROLE_ID)                    
REFERENCES  CISS.ROLE (ROLE_ID);                              
                                  
ALTER TABLE CISS.ARCHIVE_LOG_ENTRY_SNAPSHOT ADD CONSTRAINT  FK_LogEntrySnapshot_LogEntryID  FOREIGN KEY(ARCHIVE_LOG_ENTRY_ID) REFERENCES  CISS.ARCHIVE_LOG_ENTRY  (ARCHIVE_LOG_ENTRY_ID);               
                                  
ALTER TABLE CISS.BATCH_JOB_PERMISSION ADD CONSTRAINT  FK_BatchJobPerm_JobConfigId FOREIGN KEY(JOB_CONFIG_ID)                    
REFERENCES  CISS.JOB_CONFIG (JOB_CONFIG_ID);                              
                                  
ALTER TABLE CISS.BATCH_JOB_PERMISSION ADD CONSTRAINT  FK_BatchJobPermission_Perm  FOREIGN KEY(PERMISSION_ID)                    
REFERENCES  CISS.PERMISSION (PERMISSION_ID);                              
                                  
ALTER TABLE CISS.CISS_STD_INACTIVE_REASON ADD CONSTRAINT  FK_InactiveReason_CissStdAppID  FOREIGN KEY(CISS_STD_APPLICATION_ID)                    
REFERENCES  CISS.CISS_STD_APPLICATION (CISS_STD_APPLICATION_ID);                              
                                  
ALTER TABLE CISS.DUTY_STATION ADD CONSTRAINT  FK_DutyStation_AppUserID  FOREIGN KEY(APP_USER_ID)                    
REFERENCES  CISS.APP_USER (APP_USER_ID);                              
                                  
ALTER TABLE CISS.DUTY_STATION ADD CONSTRAINT  FK_DutyStation_StdInstID  FOREIGN KEY(INSTITUTION_ID)                   
REFERENCES  sdsadm.STD_Institution  (id)  ;                           
                                  
ALTER TABLE CISS.EXCEPTION_LOG  ADD CONSTRAINT  FK_CissExcLog_PaidExtractErrId  FOREIGN KEY(PAID_LOAD_ERRORS_ID)                    
REFERENCES  CISS.PAID_LOAD_ERRORS (PAID_LOAD_ERRORS_ID);                              
                                  
ALTER TABLE CISS.JOB_CONFIG ADD CONSTRAINT  FK_JobConfig_CissStdAppID FOREIGN KEY(CISS_STD_APPLICATION_ID)                    
REFERENCES  CISS.CISS_STD_APPLICATION (CISS_STD_APPLICATION_ID);                              
                                  
ALTER TABLE CISS.JOB_RESULT ADD CONSTRAINT  FK_JobResult_CissStdApplID  FOREIGN KEY(CISS_STD_APPLICATION_ID)                    
REFERENCES  CISS.CISS_STD_APPLICATION (CISS_STD_APPLICATION_ID);                              
                                  
ALTER TABLE CISS.PAID_LOAD_ERRORS ADD CONSTRAINT  FK_PaidExtrError_PaidExtrLogId  FOREIGN KEY(PAID_LOAD_LOG_ID)                   
REFERENCES  CISS.PAID_LOAD_LOG  (PAID_LOAD_LOG_ID);                             
                                  
ALTER TABLE CISS.PERMISSION ADD CONSTRAINT  FK_Permission_CissStdAppID  FOREIGN KEY(CISS_STD_APPLICATION_ID)                    
REFERENCES  CISS.CISS_STD_APPLICATION (CISS_STD_APPLICATION_ID);                              
                                  
ALTER TABLE CISS.ROLE ADD CONSTRAINT  FK_Role_CissStdApplicationID  FOREIGN KEY(CISS_STD_APPLICATION_ID)                    
REFERENCES  CISS.CISS_STD_APPLICATION (CISS_STD_APPLICATION_ID);                              
                                  
ALTER TABLE CISS.ROLE_GRANTS_WHITELIST  ADD CONSTRAINT  FK_GrantableRole_RoleID FOREIGN KEY(GRANTABLE_ROLE_ID)                    
REFERENCES  CISS.ROLE (ROLE_ID);                              
                                  
ALTER TABLE CISS.ROLE_GRANTS_WHITELIST  ADD CONSTRAINT  FK_Role_RoleID  FOREIGN KEY(ROLE_ID)                    
REFERENCES  CISS.ROLE (ROLE_ID);                              
                                  
ALTER TABLE CISS.ROLE_PERMISSION  ADD CONSTRAINT  FK_RolePermission_PermissionID  FOREIGN KEY(PERMISSION_ID)                    
REFERENCES  CISS.PERMISSION (PERMISSION_ID);                              
                                  
ALTER TABLE CISS.ROLE_PERMISSION  ADD CONSTRAINT  FK_RolePermission_RoleID  FOREIGN KEY(ROLE_ID)                    
REFERENCES  CISS.ROLE (ROLE_ID);                              
                                  
ALTER TABLE CISS.UNIQUE_IDENTIFIER  ADD CONSTRAINT  FK_UniqueIdentify_CissStdAppID  FOREIGN KEY(CISS_STD_APPLICATION_ID)                    
REFERENCES  CISS.CISS_STD_APPLICATION (CISS_STD_APPLICATION_ID);                              
                                  
ALTER TABLE PCMM.APP_USER_VISTA_INFO  ADD CONSTRAINT  FK_AppUser_AppUserVistaInfo FOREIGN KEY(APP_USER_id)                    
REFERENCES  CISS.APP_USER (APP_USER_ID);                              
                                  
ALTER TABLE PCMM.APP_USER_VISTA_INFO  ADD CONSTRAINT  FK_StdInst_AppUserVistaInfo FOREIGN KEY(VA_INSTITUTION_id)                    
REFERENCES  sdsadm.STD_Institution  (id);                             
                                  
ALTER TABLE PCMM.FACILITY_ROOM  ADD CONSTRAINT  FK_FacilityRoomType_FacRoom FOREIGN KEY(PCM_STD_FACILITY_ROOM_TYPE_ID)                    
REFERENCES  PCMM.PCM_STD_FACILITY_ROOM_TYPE (PCM_STD_FACILITY_ROOM_TYPE_ID);                              
                                  
ALTER TABLE PCMM.FACILITY_ROOM  ADD CONSTRAINT  FK_StdInstitution_FacilityRoom  FOREIGN KEY(VA_FACILITY_ID)                   
REFERENCES  sdsadm.STD_Institution(id);                               
                                  
ALTER TABLE PCMM.MODEL_TEAM ADD CONSTRAINT  FK_TeamCareType_ModelTeam FOREIGN KEY(PCM_STD_TEAM_CARE_TYPE_ID)                    
REFERENCES  PCMM.PCM_STD_TEAM_CARE_TYPE (PCM_STD_TEAM_CARE_TYPE_ID);                              
                                  
ALTER TABLE PCMM.MODEL_TEAM ADD CONSTRAINT  FK_PcmStdTeamFocus_ModelTeam  FOREIGN KEY(PCM_STD_TEAM_FOCUS_ID)                    
REFERENCES  PCMM.PCM_STD_TEAM_FOCUS (PCM_STD_TEAM_FOCUS_ID);                              
                                  
ALTER TABLE PCMM.MODEL_TEAM ADD CONSTRAINT  FK_StdInstitution_ModelTeam FOREIGN KEY(VA_INSTITUTION_ID)                    
REFERENCES  sdsadm.STD_Institution(id);                               
                                  
ALTER TABLE PCMM.MODEL_TEAM_POSITION  ADD CONSTRAINT  FK_ModelTeam_ModelTeamPosition  FOREIGN KEY(MODEL_TEAM_ID)                    
REFERENCES  PCMM.MODEL_TEAM (MODEL_TEAM_ID);                              
                                  
ALTER TABLE PCMM.MODEL_TEAM_POSITION  ADD CONSTRAINT  TeamRole_ModelTeamPosition  FOREIGN KEY(PCM_STD_TEAM_ROLE_ID)                   
REFERENCES  PCMM.PCM_STD_TEAM_ROLE  (PCM_STD_TEAM_ROLE_ID);                             
                                  
ALTER TABLE PCMM.MULTI_PCP  ADD CONSTRAINT  FK_DestinationStation_MultiPCP  FOREIGN KEY(DESTINATION_STATION_id)                   
REFERENCES  sdsadm.STD_Institution  (id);                             
                                  
ALTER TABLE PCMM.MULTI_PCP  ADD CONSTRAINT  FK_MultiPCPCancelRsn_MultiPCP FOREIGN KEY(PCM_STD_MULTIPCP_CANCEL_RSN_ID)                   
REFERENCES  PCMM.PCM_STD_MULTIPCP_STAT_REASON (PCM_STD_MULTIPCP_STAT_RSN_ID);                               
                                  
ALTER TABLE PCMM.MULTI_PCP  ADD CONSTRAINT  FK_MultipcpStatus_MultiPCP  FOREIGN KEY(PCM_STD_MULTIPCP_STATUS_ID)                   
REFERENCES  PCMM.PCM_STD_MULTIPCP_STATUS  (PCM_STD_MULTIPCP_STATUS_ID);                             
                                  
ALTER TABLE PCMM.MULTI_PCP  ADD CONSTRAINT  FK_MultiPCPstatusRsn_MultiPCP FOREIGN KEY(PCM_STD_MULTIPCP_STAT_RESON_ID)                   
REFERENCES  PCMM.PCM_STD_MULTIPCP_STAT_REASON (PCM_STD_MULTIPCP_STAT_RSN_ID);                             
                                  
ALTER TABLE PCMM.MULTI_PCP  ADD CONSTRAINT  FK_PcmmPatient_MultiPCP FOREIGN KEY(PCMM_PATIENT_ID)                    
REFERENCES  PCMM.PCMM_PATIENT (PCMM_PATIENT_ID);                              
                                  
ALTER TABLE PCMM.MULTI_PCP  ADD CONSTRAINT  FK_SourceStation_MultiPCP FOREIGN KEY(SOURCE_STATION_id)                    
REFERENCES  sdsadm.STD_Institution  (id);                             
                                  
ALTER TABLE PCMM.MULTI_PCP  ADD CONSTRAINT  FK_Team_MultiPCP  FOREIGN KEY(TEAM_ID)                    
REFERENCES  PCMM.TEAM (TEAM_ID);                              
                                  
ALTER TABLE PCMM.MULTI_PCP_APPROVALS  ADD CONSTRAINT  FK_ApprStation_MultiPCPAppr FOREIGN KEY(APPROVING_STATION_ID)                   
REFERENCES  sdsadm.STD_Institution  (id);                             
                                  
ALTER TABLE PCMM.MULTI_PCP_APPROVALS  ADD CONSTRAINT  FK_MultipcpId_MultiPCPAppr  FOREIGN KEY(MULTI_PCP_ID)                   
REFERENCES  PCMM.MULTI_PCP  (MULTI_PCP_ID);                             
                                  
ALTER TABLE PCMM.MULTI_PCP_APPROVALS  ADD CONSTRAINT  FK_PatientAsnmt_MultiPCPAppr  FOREIGN KEY(TEAM_PATIENT_ASSIGN_ID)                   
REFERENCES  PCMM.TEAM_PATIENT_ASSIGN  (TEAM_PATIENT_ASSIGN_ID);                             
                                  
ALTER TABLE PCMM.MULTI_PCP_APPROVALS  ADD CONSTRAINT  FK_StaffID_MultiPCPApprovals  FOREIGN KEY(CLINICAL_APPROVER_STAFF_ID)                   
REFERENCES  PCMM.STAFF  (STAFF_ID);                             
                                  
ALTER TABLE PCMM.MULTI_PCP_APPROVALS  ADD CONSTRAINT  FK_TVCId_MultiPCPApprovals  FOREIGN KEY(TVC_APPROVER_ID)                    
REFERENCES  CISS.APP_USER (APP_USER_ID);                              
                                  
ALTER TABLE PCMM.NON_VA_PROVIDER_NONVA_PRACTICE ADD CONSTRAINT  FK_NonVaPractice_NonVaPractice  FOREIGN KEY(NON_VA_PRACTICE_ID)                   
REFERENCES  PCMM.NON_VA_PRACTICE  (NON_VA_PRACTICE_ID);                             
                                  
ALTER TABLE PCMM.NON_VA_PROVIDER_NONVA_PRACTICE ADD CONSTRAINT  FK_NonVaProvider_NonVaPractice  FOREIGN KEY(NON_VA_PROVIDER_ID)                   
REFERENCES  PCMM.NON_VA_PROVIDER  (NON_VA_PROVIDER_ID);                             
                                  
ALTER TABLE PCMM.NON_VA_PROVIDER_NVP_ROLE ADD CONSTRAINT  FK_NVP_NVPR_ROLE_F1 FOREIGN KEY(NON_VA_PROVIDER_ID)                   
REFERENCES  PCMM.NON_VA_PROVIDER  (NON_VA_PROVIDER_ID);                             
                                  
ALTER TABLE PCMM.NON_VA_PROVIDER_NVP_ROLE ADD CONSTRAINT  FK_NVP_NVPR_ROLE_F2 FOREIGN KEY(PCM_STD_NVP_ROLE_id)                    
REFERENCES  PCMM.PCM_STD_NON_VA_PROVIDER_ROLE (PCM_STD_NVP_ROLE_ID);                              
                                  
ALTER TABLE PCMM.NON_VA_PROVIDER_NON_VA_SPLTY ADD CONSTRAINT  FK_NVP_NVS_F1 FOREIGN KEY(NON_VA_PROVIDER_ID)                   
REFERENCES  PCMM.NON_VA_PROVIDER  (NON_VA_PROVIDER_ID);                             
                                  
ALTER TABLE PCMM.NON_VA_PROVIDER_NON_VA_SPLTY ADD CONSTRAINT  FK_NVP_NVS_F2 FOREIGN KEY(PCM_STD_NVP_SPECIALTY_id)                   
REFERENCES  PCMM.PCM_STD_NON_VA_PROV_SPECIALTY  (PCM_STD_NVP_SPECIALTY_ID);                             
                                  
                                  
ALTER TABLE PCMM.NVP_PATIENT_RELATIONSHIP ADD CONSTRAINT  FK_NVP_PR_F1  FOREIGN KEY(NON_VA_PRACTICE_ID)                   
REFERENCES  PCMM.NON_VA_PRACTICE  (NON_VA_PRACTICE_ID);                             
                                  
ALTER TABLE PCMM.NVP_PATIENT_RELATIONSHIP ADD CONSTRAINT  FK_NVP_PR_F2  FOREIGN KEY(NON_VA_PROVIDER_ID)                   
REFERENCES  PCMM.NON_VA_PROVIDER  (NON_VA_PROVIDER_ID);                             
                                  
ALTER TABLE PCMM.NVP_PATIENT_RELATIONSHIP ADD CONSTRAINT  FK_NVP_PR_F3  FOREIGN KEY(PCM_STD_NVP_CATERY_ID)                    
REFERENCES  PCMM.PCM_STD_NONVA_PROVIDER_CATERY  (PCM_STD_NVP_CATERY_ID) ;                           
                                  
ALTER TABLE PCMM.NVP_PATIENT_RELATIONSHIP ADD CONSTRAINT  FK_NVP_PR_F4  FOREIGN KEY(PCMM_PATIENT_ID)                    
REFERENCES  PCMM.PCMM_PATIENT (PCMM_PATIENT_ID);                              
                                  
ALTER TABLE PCMM.NVP_PATIENT_RELATIONSHIP ADD CONSTRAINT  FK_NVP_PR_F5  FOREIGN KEY(PCM_STD_NVP_ROLE_id)                    
REFERENCES  PCMM.PCM_STD_NON_VA_PROVIDER_ROLE (PCM_STD_NVP_ROLE_ID);                              
                                  
ALTER TABLE PCMM.NVP_PATIENT_RELATIONSHIP ADD CONSTRAINT  FK_NVP_PR_F6  FOREIGN KEY(PCM_STD_NVP_SPECIALTY_ID)                   
REFERENCES  PCMM.PCM_STD_NON_VA_PROV_SPECIALTY  (PCM_STD_NVP_SPECIALTY_ID);                             
                                  
ALTER TABLE PCMM.NVP_PATIENT_RELATIONSHIP ADD CONSTRAINT  FK_NVP_PR_F7  FOREIGN KEY(TEAM_ID)                    
REFERENCES  PCMM.TEAM (TEAM_ID);                              
                                  
ALTER TABLE PCMM.PANEL_PLACEMENT_REQUEST  ADD CONSTRAINT  FK_PANEL_PLACEMENT_REQ_F1 FOREIGN KEY(PCMM_GROUP_ID)                    
REFERENCES  PCMM.PCMM_GROUP (PCMM_GROUP_ID);                              
                                  
ALTER TABLE PCMM.PANEL_PLACEMENT_REQUEST  ADD CONSTRAINT  FK_PANEL_PLACEMENT_REQ_F2 FOREIGN KEY(PCMM_PATIENT_ID)                    
REFERENCES  PCMM.PCMM_PATIENT (PCMM_PATIENT_ID);                              
                                  
ALTER TABLE PCMM.PANEL_PLACEMENT_REQUEST  ADD CONSTRAINT  FK_PANEL_PLACEMENT_REQ_F3 FOREIGN KEY(PANEL_PLACEMENT_REQUEST_ID)                   
REFERENCES  PCMM.PCM_STD_PANEL_PLACEMENT_REQ  (PANEL_PLACEMENT_REQ_ID);                             
                                  
ALTER TABLE PCMM.PANEL_PLACEMENT_REQUEST  ADD CONSTRAINT  FK_PANEL_PLACEMENT_REQ_F4 FOREIGN KEY(PANEL_PLACEMENT_REQUEST_ID)                   
REFERENCES  PCMM.PCM_STD_PANEL_PLACEMENT_STATUS (PANEL_PLACEMENT_STATUS_ID);                              
                                  
ALTER TABLE PCMM.PANEL_PLACEMENT_REQUEST  ADD CONSTRAINT  FK_PANEL_PLACEMENT_REQ_F5 FOREIGN KEY(PATIENT_PANEL_REASON_id)                    
REFERENCES  PCMM.PATIENT_PANEL_PLACEMENT_REASON (PANEL_PLACEMENT_REASON_ID);                              
                                  
ALTER TABLE PCMM.PANEL_PLACEMENT_REQUEST  ADD CONSTRAINT  FK_PANEL_PLACEMENT_REQ_F6 FOREIGN KEY(VA_FACILITY_ID)                   
REFERENCES  sdsadm.STD_Institution  (id);                             
                                  
ALTER TABLE PCMM.PANEL_PLACEMENT_REQUEST  ADD CONSTRAINT  FK_PANEL_PLACEMENT_REQ_F7 FOREIGN KEY(TEAM_ID)                    
REFERENCES  PCMM.TEAM (TEAM_ID) ;                           
                                  
ALTER TABLE PCMM.PANEL_SIZE_ADJ_HISTORY ADD CONSTRAINT  FK_PANEL_SIZE_ADJ_HIST_FLD1 FOREIGN KEY(PCM_STD_PANEL_SIZE_ADJ_id)                    
REFERENCES  PCMM.PCM_STD_PANEL_SIZE_ADJUSTMENT  (PANEL_SIZE_ADJUSTMENT_ID);                             
                                  
                                  
                                  
ALTER TABLE PCMM.PCM_STD_ALERT_TEMPLATE ADD CONSTRAINT  FK_PCM_STD_ALERT_TEMPL_FL1  FOREIGN KEY(PCM_STD_TEMPLATE_ID)                    
REFERENCES  PCMM.PCM_STD_TEMPLATE (PCM_STD_TEMPLATE_ID);                              
                                  
ALTER TABLE PCMM.PCM_STD_ALERT_TEMPL_RECIPIENT  ADD CONSTRAINT  FK_ALERT_TEMPL_RECIPIENT_F1 FOREIGN KEY(APP_USER_ID)                    
REFERENCES  CISS.APP_USER (APP_USER_ID);                              
                                  
ALTER TABLE PCMM.PCM_STD_ALERT_TEMPL_RECIPIENT  ADD CONSTRAINT  FK_ALERT_TEMPL_RECIPIENT_F2 FOREIGN KEY(PCM_STD_ALERT_TEMP_id)                    
REFERENCES  PCMM.PCM_STD_ALERT_TEMPLATE (PCM_STD_ALERT_TEMPLATE_ID);                              
                                  
ALTER TABLE PCMM.PCM_STD_ALERT_TEMPL_RECIPIENT  ADD CONSTRAINT  FK_ALERT_TEMPL_RECIPIENT_F3 FOREIGN KEY(ROLE_ID)                    
REFERENCES  CISS.ROLE (ROLE_ID);                              
                                  
ALTER TABLE PCMM.PCM_STD_CDW_STDPOS_STAFF_ROLE  ADD CONSTRAINT  FK_PSCS_STAFF_ROLE_F1 FOREIGN KEY(PCM_STD_STAFF_ROLE_ID)                    
REFERENCES  PCMM.PCM_STD_STAFF_ROLE (PCM_STD_STAFF_ROLE_ID);                              
                                  
ALTER TABLE PCMM.PCM_STD_CDW_STDPOS_STAFF_ROLE  ADD CONSTRAINT  FK_PSCS_STAFF_ROLE_F2 FOREIGN KEY(PCM_STD_TEAM_ROLE_ID)                   
REFERENCES  PCMM.PCM_STD_TEAM_ROLE  (PCM_STD_TEAM_ROLE_ID);                             
                                  
ALTER TABLE PCMM.PCM_STD_MULTIPCP_STAT_REASON ADD CONSTRAINT  FK_PSMS_REASON_FLD1 FOREIGN KEY(PCM_STD_MULTIPCP_STATUS_ID)                   
REFERENCES  PCMM.PCM_STD_MULTIPCP_STATUS  (PCM_STD_MULTIPCP_STATUS_ID);                             
                                  
ALTER TABLE PCMM.PCM_STD_NON_VA_PROV_ROLE_HIST  ADD CONSTRAINT  FK_CONSTRAINT1  FOREIGN KEY(PCM_STD_NVP_ROLE_id)                    
REFERENCES  PCMM.PCM_STD_TEAM_FOCUS (PCM_STD_TEAM_FOCUS_ID);                              
                                  
ALTER TABLE PCMM.PCM_STD_NOTIFICATION_TYPE  ADD CONSTRAINT  FK_CONSTRAINT2  FOREIGN KEY(PCM_STD_NOTIFY_CATERY_TYPE_id)                    
REFERENCES  PCMM.PCM_STD_NOTIFY_CATERY_TYPE (NOTIFY_CATERY_TYPE_ID);                              
                                  
ALTER TABLE PCMM.PCM_STD_PANEL_SIZE_ADJUSTMENT  ADD CONSTRAINT  FK_CONSTRAINT3  FOREIGN KEY(PCM_STD_TEAM_CARE_TYPE_ID)                    
REFERENCES  PCMM.PCM_STD_TEAM_CARE_TYPE (PCM_STD_TEAM_CARE_TYPE_ID);                              
                                  
ALTER TABLE PCMM.PCM_STD_PANEL_SIZE_ADJUSTMENT  ADD CONSTRAINT  FK_CONSTRAINT4  FOREIGN KEY(VA_FACILITY_id)                   
REFERENCES  sdsadm.STD_Institution(id);                                               
            
ALTER TABLE PCMM.PERSON_CLASS_STAFF_ROLE  ADD CONSTRAINT  FK_CONSTRAINT6  FOREIGN KEY(PERSON_CLASS_CLASSIFICATION_id)                   
REFERENCES  sdsadm.STD_PersonClassClassification  (id);                             
                                  
ALTER TABLE PCMM.PERSON_CLASS_STAFF_ROLE  ADD CONSTRAINT  FK_CONSTRAINT7  FOREIGN KEY(PCM_STD_STAFF_ROLE_ID)                    
REFERENCES  PCMM.PCM_STD_STAFF_ROLE (PCM_STD_STAFF_ROLE_ID);                              
                                  
ALTER TABLE PCMM.PCM_STD_PERSONCLASS_STAFF_ROLE ADD CONSTRAINT  FK_CONSTRAINT9  FOREIGN KEY(PCM_STD_STAFF_ROLE_ID)                    
REFERENCES  PCMM.PCM_STD_STAFF_ROLE (PCM_STD_STAFF_ROLE_ID);                              
                                  
ALTER TABLE PCMM.PCM_STD_PERSONCLASS_STAFF_ROLE ADD CONSTRAINT  FK_CONSTRAINT10 FOREIGN KEY(PERSON_CLASS_ID)                    
REFERENCES  sdsadm.STD_PersonClassProviderType  (id);                             
                                  
ALTER TABLE PCMM.PCM_STD_PRECEPTOR_TRANSFORM  ADD CONSTRAINT  FK_CONSTRAINT11 FOREIGN KEY(PRECEPTEE_ROLE_ID)                    
REFERENCES  PCMM.PCM_STD_STAFF_ROLE (PCM_STD_STAFF_ROLE_ID) ;                           
                                  
ALTER TABLE PCMM.PCM_STD_PRECEPTOR_TRANSFORM  ADD CONSTRAINT  FK_CONSTRAINT12 FOREIGN KEY(PRECEPTEE_TEAM_ROLE_ID)                   
REFERENCES  PCMM.PCM_STD_TEAM_ROLE  (PCM_STD_TEAM_ROLE_ID);                             
                                  
ALTER TABLE PCMM.PCM_STD_PRECEPTOR_TRANSFORM  ADD CONSTRAINT  FK_CONSTRAINT13 FOREIGN KEY(PRECEPTOR_ROLE_ID)                    
REFERENCES  PCMM.PCM_STD_STAFF_ROLE (PCM_STD_STAFF_ROLE_ID);                              
                                  
ALTER TABLE PCMM.PCM_STD_PRECEPTOR_TRANSFORM  ADD CONSTRAINT  FK_CONSTRAINT14 FOREIGN KEY(PRECEPTOR_TEAM_ROLE_ID)                   
REFERENCES  PCMM.PCM_STD_TEAM_ROLE  (PCM_STD_TEAM_ROLE_ID);                             
                                  
ALTER TABLE PCMM.PCM_STD_PRIMARY_CARE_INTENSITY ADD CONSTRAINT  FK_CONSTRAINT15 FOREIGN KEY(VA_FACILITY_ID)                   
REFERENCES  sdsadm.STD_Institution  (id);                             
                                  
ALTER TABLE PCMM.STOP_CODE_VALID_FOR_ENC  ADD CONSTRAINT  FK_CONSTRAINT16 FOREIGN KEY(PCM_STD_TEAM_CARE_TYPE_id)                    
REFERENCES  PCMM.PCM_STD_TEAM_CARE_TYPE (PCM_STD_TEAM_CARE_TYPE_ID) ;                           
                                  
ALTER TABLE PCMM.PCM_STD_TEAM_CARE_TYPE_HISTORY ADD CONSTRAINT  FK_CONSTRAINT17 FOREIGN KEY(PCM_STD_TEAM_CARE_TYPE_ID)                    
REFERENCES  PCMM.PCM_STD_TEAM_CARE_TYPE (PCM_STD_TEAM_CARE_TYPE_ID);                              
                                  
ALTER TABLE PCMM.TEAM_CARE_TYPE_TEAM_ROLE ADD CONSTRAINT  FK_CONSTRAINT18 FOREIGN KEY(PCM_STD_TEAM_ROLE_ID)                   
REFERENCES  PCMM.PCM_STD_TEAM_ROLE  (PCM_STD_TEAM_ROLE_ID);                             
                                  
ALTER TABLE PCMM.TEAM_CARE_TYPE_TEAM_ROLE ADD CONSTRAINT  FK_CONSTRAINT19 FOREIGN KEY(PCM_STD_TEAM_CARE_TYPE_ID)                    
REFERENCES  PCMM.PCM_STD_TEAM_CARE_TYPE (PCM_STD_TEAM_CARE_TYPE_ID);                              
                                  
ALTER TABLE PCMM.TEAM_CARE_TYPE_TEAM_ROLE ADD CONSTRAINT  FK_CONSTRAINT20 FOREIGN KEY(PCM_STD_FTEE_REQUIRED_TYPE_ID)                    
REFERENCES  PCMM.PCM_STD_FTEE_REQUIRED_TYPE (PCM_STD_FTEE_REQUIRED_TYPE_ID);                              
                                  
                                  
ALTER TABLE PCMM.PCM_STD_TEAM_FOCUS_HISTORY ADD CONSTRAINT  FK_CONSTRAINT22 FOREIGN KEY(PCM_STD_TEAM_FOCUS_ID)                    
REFERENCES  PCMM.PCM_STD_TEAM_FOCUS (PCM_STD_TEAM_FOCUS_ID);                              
                                  
 
                                  
ALTER TABLE PCMM.TEAM_ROLE_VISTA_INSTANCE ADD CONSTRAINT  FK_CONSTRAINT26 FOREIGN KEY(PCM_STD_TEAM_ROLE_ID)                   
REFERENCES  PCMM.PCM_STD_TEAM_ROLE  (PCM_STD_TEAM_ROLE_ID);                             
                                  
ALTER TABLE PCMM.TEAM_ROLE_VISTA_INSTANCE ADD CONSTRAINT  FK_CONSTRAINT27 FOREIGN KEY(PCMM_VISTA_INSTANCE_ID)                   
REFERENCES  PCMM.PCMM_VISTA_INSTANCE  (PCMM_VISTA_INSTANCE_ID);                             
                                  
ALTER TABLE PCMM.PCMM_ALERT ADD CONSTRAINT  FK_ClosedByAppUser_PcmmAlert  FOREIGN KEY(CLOSED_BY_APP_USER_ID)                    
REFERENCES  CISS.APP_USER (APP_USER_ID);                              
                                  
ALTER TABLE PCMM.PCMM_ALERT ADD CONSTRAINT  FK_MultiPcp_PcmmAlert FOREIGN KEY(MULTI_PCP_ID)                   
REFERENCES  PCMM.MULTI_PCP  (MULTI_PCP_ID);                             
                                  
ALTER TABLE PCMM.PCMM_ALERT ADD CONSTRAINT  FK_CONSTRAINT28 FOREIGN KEY(PCMM_JOB_EXECUTION_RESULT_ID)                   
REFERENCES  PCMM.PCMM_JOB_EXECUTION_RESULT  (PCMM_JOB_EXECUTION_RESULT_ID);                             
                                  
ALTER TABLE PCMM.PCMM_ALERT ADD CONSTRAINT  FK_PcmmPatient_PcmmAlert  FOREIGN KEY(PCMM_PATIENT_ID)                    
REFERENCES  PCMM.PCMM_PATIENT (PCMM_PATIENT_ID);                              
                                  
ALTER TABLE PCMM.PCMM_ALERT ADD CONSTRAINT  FK_PcmStdAlertTempl_PcmAlert  FOREIGN KEY(PCM_STD_ALERT_TEMPLATE_ID)                    
REFERENCES  PCMM.PCM_STD_ALERT_TEMPLATE (PCM_STD_ALERT_TEMPLATE_ID);                              
                                  
ALTER TABLE PCMM.PCMM_ALERT ADD CONSTRAINT  FK_SenderAppUser_PcmmAlert  FOREIGN KEY(SENDER_APP_USER_ID)                   
REFERENCES  CISS.APP_USER (APP_USER_ID);                              
                                  
ALTER TABLE PCMM.PCMM_ALERT ADD CONSTRAINT  FK_Staff_PcmmAlert  FOREIGN KEY(STAFF_ID)                   
REFERENCES  PCMM.STAFF  (STAFF_ID);                             
                                  
ALTER TABLE PCMM.PCMM_ALERT ADD CONSTRAINT  FK_Team_PcmmAlert FOREIGN KEY(TEAM_ID)                    
REFERENCES  PCMM.TEAM (TEAM_ID) ;                           
                                  
ALTER TABLE PCMM.PCMM_ALERT_COMMENT ADD CONSTRAINT  FK_AppUser_PcmmAlertComment FOREIGN KEY(APP_USER_id)                    
REFERENCES  CISS.APP_USER (APP_USER_ID);                              
                                  
ALTER TABLE PCMM.PCMM_ALERT_COMMENT ADD CONSTRAINT  FK_PcmmAlert_PcmmAlertComment FOREIGN KEY(PCMM_ALERT_ID)                    
REFERENCES  PCMM.PCMM_ALERT (PCMM_ALERT_ID) ;                           
                                  
ALTER TABLE PCMM.PCMM_ALERT_RECIPIENT ADD CONSTRAINT  FK_AppUser_PcmmAlertRecipient FOREIGN KEY(APP_USER_ID)                    
REFERENCES  CISS.APP_USER (APP_USER_ID);                              
                                  
ALTER TABLE PCMM.PCMM_ALERT_RECIPIENT ADD CONSTRAINT  FK_PcmAlert_PcmAlertRecipient FOREIGN KEY(PCMM_ALERT_id)                    
REFERENCES  PCMM.PCMM_ALERT (PCMM_ALERT_ID);                                                            
                                  
ALTER TABLE PCMM.PCMM_ALERT_RECIPIENT ADD CONSTRAINT  FK_Role_PcmmAlertRecipient  FOREIGN KEY(ROLE_ID)                    
REFERENCES  CISS.ROLE (ROLE_ID) ;                           
                                  
ALTER TABLE PCMM.PCMM_ALERT_RECIPIENT ADD CONSTRAINT  FK_CONSTRAINT29 FOREIGN KEY(VA_FACILITY_ID)                   
REFERENCES  sdsadm.STD_Institution  (id);                             
                                  
ALTER TABLE PCMM.ALERT_RECIPIENT_INACTIVATION ADD CONSTRAINT  FK_CONSTRAINT30 FOREIGN KEY(ALERT_TEMPLATE_RECIPIENT_id)                    
REFERENCES  PCMM.PCM_STD_ALERT_TEMPL_RECIPIENT  (PCM_STD_ALERT_RECIPIENT_ID);                             
                                  
ALTER TABLE PCMM.ALERT_RECIPIENT_INACTIVATION ADD CONSTRAINT  FK_CONSTRAINT31 FOREIGN KEY(VA_FACILITY_ID)                   
REFERENCES  sdsadm.STD_Institution  (id);                             
                                  
ALTER TABLE PCMM.PCMM_BATCH_JOB_EXECUTION ADD CONSTRAINT  JOB_INST_EXEC_FK  FOREIGN KEY(JOB_INSTANCE_ID)                    
REFERENCES  PCMM.PCMM_BATCH_JOB_INSTANCE  (JOB_INSTANCE_ID);                              
                                  
ALTER TABLE PCMM.BATCH_JOB_EXECUTION_CONTEXT  ADD CONSTRAINT  JOB_EXEC_CTX_FK FOREIGN KEY(JOB_EXECUTION_ID)                   
REFERENCES  PCMM.PCMM_BATCH_JOB_EXECUTION (JOB_EXECUTION_ID);                             
                                  
ALTER TABLE PCMM.PCMM_BATCH_JOB_EXECUTION_PARAM ADD CONSTRAINT  JOB_EXEC_PARAMS_FK  FOREIGN KEY(JOB_EXECUTION_ID)                   
REFERENCES  PCMM.PCMM_BATCH_JOB_EXECUTION (JOB_EXECUTION_ID);                             
                                  
ALTER TABLE PCMM.PCMM_BATCH_STEP_EXECUTION  ADD CONSTRAINT  JOB_EXEC_STEP_FK  FOREIGN KEY(JOB_EXECUTION_ID)                   
REFERENCES  PCMM.PCMM_BATCH_JOB_EXECUTION (JOB_EXECUTION_ID);                             
                                  
ALTER TABLE PCMM.PCMM_BATCH_STEP_EXE_CONTEXT  ADD CONSTRAINT  STEP_EXEC_CTX_FK  FOREIGN KEY(STEP_EXECUTION_ID)                    
REFERENCES  PCMM.PCMM_BATCH_STEP_EXECUTION  (STEP_EXECUTION_ID);                              
                                  
                     
                                  
ALTER TABLE PCMM.PCMM_JOB_EXECUTION_METADATA  ADD CONSTRAINT  FK_CONSTRAINT32 FOREIGN KEY(PCM_STD_JOB_EXECUTION_TYPE_ID)                    
REFERENCES  PCMM.PCM_STD_JOB_EXECUTION_TYPE (PCM_STD_JOB_EXECUTION_TYPE_ID);                              
                                  
ALTER TABLE PCMM.PCMM_JOB_EXECUTION_RESULT  ADD CONSTRAINT  FK_CONSTRAINT33 FOREIGN KEY(EXECUTE_REQUEST_BY)                   
REFERENCES  CISS.APP_USER (APP_USER_ID);                              
                                  
ALTER TABLE PCMM.PCMM_JOB_EXECUTION_RESULT  ADD CONSTRAINT  FK_PcmmJobExecutionResult FOREIGN KEY(JOB_EXECUTION_ID)               
REFERENCES  PCMM.PCMM_BATCH_JOB_EXECUTION (JOB_EXECUTION_ID);                             
                                  
ALTER TABLE PCMM.PCMM_JOB_EXECUTION_RESULT  ADD CONSTRAINT  FK_CONSTRAINT34 FOREIGN KEY(PCM_STD_JOB_EXECUTION_TYPE_ID)                    
REFERENCES  PCMM.PCM_STD_JOB_EXECUTION_TYPE (PCM_STD_JOB_EXECUTION_TYPE_ID);                              
                                  
ALTER TABLE PCMM.PCMM_JOB_EXECUTION_RESULT  ADD CONSTRAINT  FK_CONSTRAINT35 FOREIGN KEY(VA_INSTITUTION_ID)                    
REFERENCES  sdsadm.STD_Institution  (id);                             
                                  
ALTER TABLE PCMM.PCMM_JOB_EXECUTION_RESULT_ITEM ADD CONSTRAINT  FK_CONSTRAINT36 FOREIGN KEY(PCMM_JOB_EXECUTION_RESULT_ID)                   
REFERENCES  PCMM.PCMM_JOB_EXECUTION_RESULT  (PCMM_JOB_EXECUTION_RESULT_ID);                             
                                  
ALTER TABLE PCMM.PCMM_JOB_EXECUTION_RESULT_ITEM ADD CONSTRAINT  FK_CONSTRAINT37 FOREIGN KEY(PCMM_PATIENT_ID)                    
REFERENCES  PCMM.PCMM_PATIENT (PCMM_PATIENT_ID) ;                           
                                  
ALTER TABLE PCMM.PCMM_JOB_EXECUTION_RESULT_ITEM ADD CONSTRAINT  FK_CONSTRAINT38 FOREIGN KEY(STATUS_EXCEPTION_BINARY_OBJ_ID)                   
REFERENCES  PCMM.PCMM_BINARY_OBJECTS  (PCMM_BINARY_OBJECTS_ID)                              
ON  DELETE  CASCADE;

ALTER TABLE PCMM.PCMM_JOB_EXECUTION_RESULT_ITEM ADD CONSTRAINT  FK_CONSTRAINT39 FOREIGN KEY(TEAM_ID)                    
REFERENCES  PCMM.TEAM (TEAM_ID);                              
                                  
ALTER TABLE PCMM.PCMM_JOB_EXECUTION_RESULT_ITEM ADD CONSTRAINT  FK_CONSTRAINT40 FOREIGN KEY(TEAM_POSITION_ID)                   
REFERENCES  PCMM.TEAM_POSITION  (TEAM_POSITION_ID);                             
                                  
ALTER TABLE PCMM.PCMM_PATIENT ADD CONSTRAINT  FK_StdEnrollmentStat_Patient  FOREIGN KEY(ENROLLMENT_STATUS_ID)                   
REFERENCES  sdsadm.STD_EnrollmentStatus (id);                             
                                  
                       
                                  
                                  
ALTER TABLE PCMM.SENSITIVE_PATIENTS_ACCESS_LOG  ADD CONSTRAINT  FK_PcmmPatient_SensPatLog FOREIGN KEY(PCMM_PATIENT_ID)                    
REFERENCES  PCMM.PCMM_PATIENT (PCMM_PATIENT_ID);                              
                                  
ALTER TABLE PCMM.PCMM_VISTA_INSTANCE  ADD CONSTRAINT  FK_CONSTRAINT41 FOREIGN KEY(PCMM_VISTA_INSTANCE_ID)                   
REFERENCES  PCMM.PCMM_VISTA_INSTANCE  (PCMM_VISTA_INSTANCE_ID);                             
                                  
ALTER TABLE PCMM.PCMM_VISTA_PATIENT ADD CONSTRAINT  FK_PcmPatient_PcmVistaPatient FOREIGN KEY(PCMM_PATIENT_ID)                    
REFERENCES  PCMM.PCMM_PATIENT (PCMM_PATIENT_ID);                              
                                  
ALTER TABLE PCMM.PRECEPTOR_ASSIGNMENT ADD CONSTRAINT  FK_TeamMembership_Preceptee FOREIGN KEY(PRECEPTEE_ID)                   
REFERENCES  PCMM.TEAM_MEMBERSHIP  (TEAM_MEMBERSHIP_ID);                             
                                  
ALTER TABLE PCMM.PRECEPTOR_ASSIGNMENT ADD CONSTRAINT  FK_TeamMembership_Preceptor FOREIGN KEY(PRECEPTOR_ID)                   
REFERENCES  PCMM.TEAM_MEMBERSHIP  (TEAM_MEMBERSHIP_ID);                             
                                  
                                  
ALTER TABLE PCMM.SURR_STAFF_ASSIGN_TEAM_POS ADD CONSTRAINT  FK_CONSTRAINT42 FOREIGN KEY(STAFF_ID)                   
REFERENCES  PCMM.STAFF  (STAFF_ID);                             
                                                                    
ALTER TABLE PCMM.SURR_STAFF_ASSIGN_TEAM_POS ADD CONSTRAINT  FK_CONSTRAINT44 FOREIGN KEY(TEAM_POSITION_ID)                   
REFERENCES  PCMM.TEAM_POSITION  (TEAM_POSITION_ID);                             
                                  
ALTER TABLE PCMM.TEAM ADD CONSTRAINT  FK_CONSTRAINT45 FOREIGN KEY(LAST_ERROR_BINARY_OBJECT_ID)                    
REFERENCES  PCMM.PCMM_BINARY_OBJECTS  (PCMM_BINARY_OBJECTS_ID);                             
                                  
                                     
                                                                      
ALTER TABLE PCMM.TEAM_MEMBERSHIP_DETAIL_HISTORY ADD CONSTRAINT  FK_CONSTRAINT51 FOREIGN KEY(TEAM_MEMBERSHIP_ID)                   
REFERENCES  PCMM.TEAM_MEMBERSHIP  (TEAM_MEMBERSHIP_ID);                             
                                  
ALTER TABLE PCMM.TEAM_NOTIFY_DISTRIBUTION_RULES ADD CONSTRAINT  FK_CONSTRAINT52 FOREIGN KEY(TEAM_ID)                    
REFERENCES  PCMM.TEAM (TEAM_ID);                              
                                  
ALTER TABLE PCMM.TEAM_NOTIFY_DISTRIBUTION_RULES ADD CONSTRAINT  FK_CONSTRAINT53 FOREIGN KEY(PCM_STD_NOTIFICATION_TYPE_id)                   
REFERENCES  PCMM.PCM_STD_NOTIFICATION_TYPE  (PCM_STD_NOTIFICATION_TYPE_ID);                             
                                                                    
ALTER TABLE PCMM.TEAM_NOTIFY_DISTRIBUTION_RULES ADD CONSTRAINT  FK_CONSTRAINT55 FOREIGN KEY(TEAM_POSITION_ID)                   
REFERENCES  PCMM.TEAM_POSITION  (TEAM_POSITION_ID);                             
                                                                    
                                  
                                  
ALTER TABLE PCMM.TEAM_PATIENT_ASSIGN  ADD CONSTRAINT  FK_CONSTRAINT57 FOREIGN KEY(INACTIVATION_EXTEND_REASON_ID)                    
REFERENCES  PCMM.PCM_STD_AUTO_INACT_EXT_REASON  (PCM_STD_AUTO_INACT_EXT_REASON);                              
                                  
                                     
                                    
ALTER TABLE PCMM.TEAM_POSITION_HISTORY  ADD CONSTRAINT  FK_CONSTRAINT61 FOREIGN KEY(PCM_STD_STATUS_ID)                    
REFERENCES  PCMM.PCM_STD_STATUS (PCM_STD_STATUS_ID) ;                           
                                  
ALTER TABLE PCMM.TEAM_POSITION_HISTORY  ADD CONSTRAINT  FK_CONSTRAINT62 FOREIGN KEY(TEAM_POSITION_STATUS_REASON_ID)                   
REFERENCES  PCMM.TEAM_POSITION_STATUS_REASON_ID (TEAM_POSITION_STATUS_REASON_ID);                             
                                  
ALTER TABLE PCMM.TEAM_POSITION_HISTORY  ADD CONSTRAINT  FK_CONSTRAINT63 FOREIGN KEY(TEAM_POSITION_ID)                   
REFERENCES  PCMM.TEAM_POSITION  (TEAM_POSITION_ID);                             
                                  
ALTER TABLE PCMM.TEAM_ROOM  ADD CONSTRAINT  FK_FacilityRoom_TeamRoom  FOREIGN KEY(FACILITY_ROOM_ID)                   
REFERENCES  PCMM.FACILITY_ROOM  (FACILITY_ROOM_ID);                             
                                  
ALTER TABLE PCMM.TEAM_ROOM  ADD CONSTRAINT  FK_Team_TeamRoom  FOREIGN KEY(TEAM_ID)                    
REFERENCES  PCMM.TEAM (TEAM_ID);                              
                                  
ALTER TABLE PCMM.TEAM_STATUS_HISTORY  ADD CONSTRAINT  FK_CONSTRAINT64 FOREIGN KEY(PCM_STD_STATUS_ID)                    
REFERENCES  PCMM.PCM_STD_STATUS (PCM_STD_STATUS_ID);                              
                                  
ALTER TABLE PCMM.TEAM_STATUS_HISTORY  ADD CONSTRAINT  FK_CONSTRAINT65 FOREIGN KEY(PCM_STD_TEAM_STATUS_REASON_ID)                    
REFERENCES  PCMM.PCM_STD_TEAM_STATUS_REASON (PCM_STD_TEAM_STATUS_REASON_ID);                              
                                  
ALTER TABLE PCMM.TEAM_STATUS_HISTORY  ADD CONSTRAINT  FK_Team_TeamStatusHistory FOREIGN KEY(TEAM_ID)                    
REFERENCES  PCMM.TEAM (TEAM_ID);                              
                                  
ALTER TABLE sdsadm.STD_AddressChangeSourceHistory ADD CONSTRAINT  fkSTD_AddressChngSrcHstryOwnr FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_AddressChangeSource  (id)                              
ON  DELETE  CASCADE;                              
                                  
ALTER TABLE sdsadm.STD_AddressTypeHistory ADD CONSTRAINT  fkSTD_AddressTypeHistoryOwner FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_AddressType  (id)                              
ON  DELETE  CASCADE;                              
                                  
ALTER TABLE sdsadm.STD_AdministrativeEntity ADD CONSTRAINT  fkSTD_AEAdministrativeParent  FOREIGN KEY(administrativeParent_id)                    
REFERENCES  sdsadm.STD_AdministrativeEntity (id);                             
                                  
ALTER TABLE sdsadm.STD_AdministrativeEntity ADD CONSTRAINT  fkSTD_AEAgency  FOREIGN KEY(agency_id)                    
REFERENCES  sdsadm.STD_Agency (id);                             
                                  
ALTER TABLE sdsadm.STD_AdministrativeEntity ADD CONSTRAINT  fkSTD_AEInstitution FOREIGN KEY(institution_id)                   
REFERENCES  sdsadm.STD_Institution  (id);                             
                                  
ALTER TABLE sdsadm.STD_AdrsDlvryFlrCdHistory  ADD CONSTRAINT  fkSTD_AdrsDlvryFlrCdHstryOwnr FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_AddressDeliveryFailureCode (id)                              
ON  DELETE  CASCADE;                              
                                  
ALTER TABLE sdsadm.STD_AdrsInvalRsnHistory  ADD CONSTRAINT  fkSTD_AdrsInvalRsnHistoryOwner  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_AddressInvalidReason (id)                              
ON  DELETE  CASCADE;                              
                                  
ALTER TABLE sdsadm.STD_AffectedExtremityHistory ADD CONSTRAINT  fkSTD_AffectedExtrmtyHstryOwnr  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_AffectedExtremity  (id)                              
ON  DELETE  CASCADE;                              
                                  
ALTER TABLE sdsadm.STD_AgencyHistory  ADD CONSTRAINT  fkSTD_AgencyHistoryOwner  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_Agency (id)                              
ON  DELETE  CASCADE;                              
                                  
ALTER TABLE sdsadm.STD_AgentOrangeLocnHistory ADD CONSTRAINT  fkSTD_AgentOrangeLocnHstryOwnr  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_AgentOrangeLocation  (id)                              
ON  DELETE  CASCADE;                              
                                  
ALTER TABLE sdsadm.STD_AlliedCountryHistory ADD CONSTRAINT  fkSTD_AlliedCountryHistoryOwnr  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_AlliedCountry  (id)                              
ON  DELETE  CASCADE;                              
                                  
ALTER TABLE sdsadm.STD_AppParameterTypeHistory  ADD CONSTRAINT  fkSTD_AppParameterTypHstryOwnr  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_AppParameterType (id)                              
ON  DELETE  CASCADE;                              
                                  
ALTER TABLE sdsadm.STD_AppParameterUnitHistory  ADD CONSTRAINT  fkSTD_AppParameterUntHstryOwnr  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_AppParameterUnit (id)                              
ON  DELETE  CASCADE;                              
                                  
                                  
ALTER TABLE sdsadm.STD_AppParamGrpTypeHistory ADD CONSTRAINT  fkSTD_AppParamGrpTypeHstryOwnr  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_AppParamGrpType  (id)                              
ON  DELETE  CASCADE;                              
                                  
ALTER TABLE sdsadm.STD_AssetTypeHistory ADD CONSTRAINT  fkSTD_AssetTypeHistoryOwner FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_AssetType  (id)                              
ON  DELETE  CASCADE;                              
                                  
ALTER TABLE sdsadm.STD_AssigningAuthority ADD CONSTRAINT  fkSTD_AssigningAuthorityCntry FOREIGN KEY(country_id)                   
REFERENCES  sdsadm.STD_Country  (id);                             
                                  
ALTER TABLE sdsadm.STD_AssigningAuthorityHistory  ADD CONSTRAINT  fkSTD_AssigningAthrtyHstryOwnr  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_AssigningAuthority (id)                              
ON  DELETE  CASCADE;                              
                                  
ALTER TABLE sdsadm.STD_BenefitsCoordTypeHistory ADD CONSTRAINT  fkSTD_BenefitsCrdTypHstryOwnr FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_BenefitsCoordType  (id)                              
ON  DELETE  CASCADE;                              
                                  
ALTER TABLE sdsadm.STD_BillingTransTypeHistory  ADD CONSTRAINT  fkSTD_BillingTransTypHstryOwnr  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_BillingTransType (id)                              
ON  DELETE  CASCADE;                              
                                  
ALTER TABLE sdsadm.STD_CancelDeclineHistory ADD CONSTRAINT  fkSTD_CancelDeclineHistoryOwnr  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_CancelDeclineReason  (id)                              
ON  DELETE  CASCADE;                              
                                  
ALTER TABLE sdsadm.STD_CancelDeclineStTypHistory  ADD CONSTRAINT  fkSTD_CancelDclnStTypHstryOwnr  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_CancelDeclineStTyp (id)                              
ON  DELETE  CASCADE;                              
                                  
ALTER TABLE sdsadm.STD_CataDisabilityExtCdHistory ADD CONSTRAINT  fkSTD_CataDsbltyExtCdHstryOwnr  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_CataDisabilityExtCd  (id)                              
ON  DELETE  CASCADE;                              
                                  
ALTER TABLE sdsadm.STD_ClinDeterTypeHistory ADD CONSTRAINT  fkSTD_ClinDeterTypeHistoryOwnr  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_ClinDeterType  (id)                              
ON  DELETE  CASCADE;                              
                                  
ALTER TABLE sdsadm.STD_CodingSystemHistory  ADD CONSTRAINT  fkSTD_CodingSystemHistoryOwner  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_CodingSystem (id)                              
ON  DELETE  CASCADE;                              
                                  
                            
                            
                                  
ALTER TABLE sdsadm.STD_CombatPayTypeHistory ADD CONSTRAINT  fkSTD_CombatPayTypeHistoryOwnr  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_CombatPayType  (id);                             
                                  
ALTER TABLE sdsadm.STD_CombatSvcLocationHistory ADD CONSTRAINT  fkSTD_CombatSvcLctnHstryOwnr  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_CombatSvcLocation  (id)                              
ON  DELETE  CASCADE;                              
                                  
ALTER TABLE sdsadm.STD_CombatSvcSourceHistory ADD CONSTRAINT  fkSTD_CombatSvcSourceHstryOwnr  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_CombatSvcSource  (id)                              
ON  DELETE  CASCADE;                            
                                  
ALTER TABLE sdsadm.STD_CommErrorTypeHistory ADD CONSTRAINT  fkSTD_CommErrorTypeHistoryOwnr  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_CommErrorType  (id)                              
ON  DELETE  CASCADE;                              
                                  
ALTER TABLE sdsadm.STD_CommLetterGenTypeHistory ADD CONSTRAINT  fkSTD_CommLetterGnTypHstryOwnr  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_CommLetterGenType  (id)                              
ON  DELETE  CASCADE;                              
                                  
ALTER TABLE sdsadm.STD_CommLetterTypeHistory  ADD CONSTRAINT  fkSTD_CommLetterTypeHstryOwnr FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_CommLetterType (id)                              
ON  DELETE  CASCADE;                              
                                  
ALTER TABLE sdsadm.STD_CommMailingStTypeHistory ADD CONSTRAINT  fkSTD_CommMlngStTypHstryOwnr  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_CommMailingStType  (id)                              
ON  DELETE  CASCADE;                              
                                  
ALTER TABLE sdsadm.STD_CommMlTriggerTypeHistory ADD CONSTRAINT  fkSTD_CommMlTrggrTypHstryOwnr FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_CommMlTriggerType  (id)                              
ON  DELETE  CASCADE;                              
                                  
ALTER TABLE sdsadm.STD_ComRejectReasonTypeHistory ADD CONSTRAINT  fkSTD_ComRejectRsnTypHstryOwnr  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_ComRejectReasonType  (id)                              
ON  DELETE  CASCADE;                              
                                  
ALTER TABLE sdsadm.STD_ConditionCodeHistory ADD CONSTRAINT  fkSTD_ConditionCodeHistoryOwnr  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_ConditionCode  (id)                              
ON  DELETE  CASCADE;                              
                                  
ALTER TABLE sdsadm.STD_ConfAddrCatHistory ADD CONSTRAINT  fkSTD_ConfAddrCatHistoryOwner FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_ConfidentialAddressCat (id)                              
ON  DELETE  CASCADE;                              
                                  
ALTER TABLE sdsadm.STD_CountryHistory ADD CONSTRAINT  fkSTD_CountryHistoryOwner FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_Country  (id)                              
ON  DELETE  CASCADE;                              
                                  
ALTER TABLE sdsadm.STD_County ADD CONSTRAINT  fkSTD_CountyState FOREIGN KEY(state_id)                   
REFERENCES  sdsadm.STD_State  (id)                              
ON  DELETE  CASCADE;                              
                                  
ALTER TABLE sdsadm.STD_CountyHistory  ADD CONSTRAINT  fkSTD_CountyHistoryOwner  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_County (id)                              
ON  DELETE  CASCADE;                              
                                  
ALTER TABLE sdsadm.STD_DataCollectJobTypeHistory  ADD CONSTRAINT  fkSTD_DataCllctJbTypHstryOwnr FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_DataCollectJobType (id)                              
ON  DELETE  CASCADE;                              
                                                                
                                                                    
ALTER TABLE sdsadm.STD_DecorationTypeHistory  ADD CONSTRAINT  fkSTD_DecorationTypeHstryOwnr FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_DecorationType (id);                             
                                  
ALTER TABLE sdsadm.STD_DecoratnDocTypHistory  ADD CONSTRAINT  fkSTD_DecoratnDocTypHstryOwnr FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_DecorationDocumentType (id)                              
ON  DELETE  CASCADE;                              
                                  
ALTER TABLE sdsadm.STD_DegreeHistory  ADD CONSTRAINT  fkSTD_DegreeHistoryOwner  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_Degree (id)                              
ON  DELETE  CASCADE;                              
                                  
ALTER TABLE sdsadm.STD_DetailedIncFinDoc  ADD CONSTRAINT  fkSTD_DtldIncFnDcDtldIncmTyp  FOREIGN KEY(detailedIncomeType_id)                    
REFERENCES  sdsadm.STD_DetailedIncomeType (id);                             
                                  
ALTER TABLE sdsadm.STD_DetailedIncFinDoc  ADD CONSTRAINT  fkSTD_DtldIncFnDcFnnclDcmTyp  FOREIGN KEY(financialDocumType_id)                    
REFERENCES  sdsadm.STD_FinancialDocumType (id);                             
                                  
ALTER TABLE sdsadm.STD_DetailedIncFinDocHistory ADD CONSTRAINT  fkSTD_DetailedIncFnDcHstryOwnr  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_DetailedIncFinDoc  (id)                              
ON  DELETE  CASCADE;                              
                                  
ALTER TABLE sdsadm.STD_DetailedIncomeTypeHistory  ADD CONSTRAINT  fkSTD_DetailedIncmTypHstryOwnr  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_DetailedIncomeType (id)                              
ON  DELETE  CASCADE;                              
                                  
ALTER TABLE sdsadm.STD_DiagnosisCodeHistory ADD CONSTRAINT  fkSTD_DiagnosisCodeHistoryOwnr  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_DiagnosisCode  (id)                              
ON  DELETE  CASCADE;                              
                                  
ALTER TABLE sdsadm.STD_DiagnosisCodSchHistory ADD CONSTRAINT  fkSTD_DiagnosisCodSchHstryOwnr  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_DiagnosisCodSch  (id)                              
ON  DELETE  CASCADE;                              
                                                                  
ALTER TABLE sdsadm.STD_DiagnosisTypeHistory ADD CONSTRAINT  fkSTD_DiagnosisTypeHistoryOwnr  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_DiagnosisType  (id)                              
ON  DELETE  CASCADE;                              
                                  
ALTER TABLE sdsadm.STD_DisabilityConditionHistory ADD CONSTRAINT  fkSTD_DisabilityCndtnHstryOwnr  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_DisabilityCondition  (id)                              
ON  DELETE  CASCADE;                              
                                  
ALTER TABLE sdsadm.STD_DistributionCodeHistory  ADD CONSTRAINT  fkSTD_DistributionCdHstryOwnr FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_DistributionCode (id)                              
ON  DELETE  CASCADE;                              
                                  
ALTER TABLE sdsadm.STD_DistributionTypeHistory  ADD CONSTRAINT  fkSTD_DistributionTypHstryOwnr  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_DistributionType (id)                              
ON  DELETE  CASCADE;                              
                                  
ALTER TABLE sdsadm.STD_DocumentSourceTypeHistory  ADD CONSTRAINT  fkSTD_DocumentSrcTypHstryOwnr FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_DocumentSourceType (id)                              
ON  DELETE  CASCADE;                              
                                  
ALTER TABLE sdsadm.STD_EgtProcessStatusHistory  ADD CONSTRAINT  fkSTD_EgtProcessSttsHstryOwnr FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_EgtProcessStatus (id)                              
ON  DELETE  CASCADE;                              
                                  
ALTER TABLE sdsadm.STD_EgtTypeHistory ADD CONSTRAINT  fkSTD_EgtTypeHistoryOwner FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_EgtType  (id)                              
ON  DELETE  CASCADE;                              
                                                                
                                                                
                                  
ALTER TABLE sdsadm.STD_EligibilityCode  ADD CONSTRAINT  fkSTD_EligibilityCodeType FOREIGN KEY(type_id)                    
REFERENCES  sdsadm.STD_EligibilityCodeType  (id);                             
                                  
ALTER TABLE sdsadm.STD_EligibilityCodeHistory ADD CONSTRAINT  fkSTD_EligibilityCodeHstryOwnr  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_EligibilityCode  (id)                              
ON  DELETE  CASCADE;                              
                                  
ALTER TABLE sdsadm.STD_EligibilityCodeTypeHistory ADD CONSTRAINT  fkSTD_ElgbltyCdTypHstryOwnr FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_EligibilityCodeType  (id)                              
ON  DELETE  CASCADE;                              
                                  
ALTER TABLE sdsadm.STD_EligibilityFactorHistory ADD CONSTRAINT  fkSTD_EligibilityFctrHstryOwnr  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_EligibilityFactor  (id)                              
ON  DELETE  CASCADE;                              
                                  
ALTER TABLE sdsadm.STD_EligibilityStatusHistory ADD CONSTRAINT  fkSTD_EligibilitySttsHstryOwnr  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_EligibilityStatus  (id)                              
ON  DELETE  CASCADE;                              
                                  
ALTER TABLE sdsadm.STD_EligibilityVrScTypHistory  ADD CONSTRAINT  fkSTD_ElgbltyVrScTypHstryOwnr FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_EligibilityVrScTyp (id)                              
ON  DELETE  CASCADE;                              
                                  
ALTER TABLE sdsadm.STD_EligPrmryDataSrcHistory  ADD CONSTRAINT  fkSTD_EligPrmryDtSrcHstryOwnr FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_EligibilityPrimaryDataSrc  (id)                              
ON  DELETE  CASCADE;                              
                                  
ALTER TABLE sdsadm.STD_Email_Domain ADD CONSTRAINT  fkSTD_Email_DomainInstitution FOREIGN KEY(institution_id)                   
REFERENCES  sdsadm.STD_Institution  (id);                             
                                  
                                  
ALTER TABLE sdsadm.STD_Email_DomainHistory  ADD CONSTRAINT  fkSTD_Email_DomainHistoryOwner  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_Email_Domain (id)                              
ON  DELETE  CASCADE;                            
                                  
                                  
ALTER TABLE sdsadm.STD_EmailAddressTypeHistory  ADD CONSTRAINT  fkSTD_EmailAddressTypHstryOwnr  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_EmailAddressType (id)                              
ON  DELETE  CASCADE;                              
                                  
ALTER TABLE sdsadm.STD_EmailChangeSourceHistory ADD CONSTRAINT  fkSTD_EmailChangeSrcHstryOwnr FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_EmailChangeSource  (id)                              
ON  DELETE  CASCADE ;                           
                                  
                                        
                                  
                                  
ALTER TABLE sdsadm.STD_EnrollmentCatTypeHistory ADD CONSTRAINT  fkSTD_EnrollmentCtTypHstryOwnr  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_EnrollmentCatType  (id);                             
                                  
                                  
ALTER TABLE sdsadm.STD_EnrollmentOvrdeRsnHistory  ADD CONSTRAINT  fkSTD_EnrllmntOvrdRsnHstryOwnr  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_EnrollmentOverrideReason (id)                              
ON  DELETE  CASCADE;                              
                                  
ALTER TABLE sdsadm.STD_EnrollmentPriorGrpHistory  ADD CONSTRAINT  fkSTD_EnrllmntPrrGrpHstryOwnr FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_EnrollmentPriorGrp (id)                              
ON  DELETE  CASCADE ;                           
                                  
                                  
ALTER TABLE sdsadm.STD_EnrollmentPriorSGrpHistory ADD CONSTRAINT  fkSTD_EnrllmntPrrSGrpHstryOwnr  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_EnrollmentPriorSGrp  (id)                              
ON  DELETE  CASCADE;                              
                                  
                                  
ALTER TABLE sdsadm.STD_EnrollmentSourceHistory  ADD CONSTRAINT  fkSTD_EnrollmentSrcHstryOwnr  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_EnrollmentSource (id)                              
ON  DELETE  CASCADE;                              
                                  
                                  
ALTER TABLE sdsadm.STD_EnrollmentStatus ADD CONSTRAINT  fkSTD_EnrollmentSttsEnrllmntCt  FOREIGN KEY(enrollmentCat_id)                   
REFERENCES  sdsadm.STD_EnrollmentCatType  (id);                             
                                  
                                  
ALTER TABLE sdsadm.STD_EnrollmentStatusHistory  ADD CONSTRAINT  fkSTD_EnrollmentSttsHstryOwnr FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_EnrollmentStatus (id)                              
ON  DELETE  CASCADE;                              
                                  
                                  
ALTER TABLE sdsadm.STD_EntitlementCodeHistory ADD CONSTRAINT  fkSTD_EntitlementCodeHstryOwnr  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_EntitlementCode  (id)                              
ON  DELETE  CASCADE;                              
                                  
                                  
ALTER TABLE sdsadm.STD_EthCollMthdHistory ADD CONSTRAINT  fkSTD_EthCollMthdHistoryOwner FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_EthnicityCollectionMethod  (id)                              
ON  DELETE  CASCADE;                              
                                  
                                  
ALTER TABLE sdsadm.STD_EthnicityHistory ADD CONSTRAINT  fkSTD_EthnicityHistoryOwner FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_Ethnicity  (id)                              
ON  DELETE  CASCADE;                              
                                  
                                  
ALTER TABLE sdsadm.STD_EvaluationMethodHistory  ADD CONSTRAINT  fkSTD_EvaluationMthdHstryOwnr FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_EvaluationMethod (id)                              
ON  DELETE  CASCADE;                              
                                  
                                  
ALTER TABLE sdsadm.STD_ExclusionRsnTypeHistory  ADD CONSTRAINT  fkSTD_ExclusionRsnTypHstryOwnr  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_ExclusionRsnType (id)                              
ON  DELETE  CASCADE;                              
                                  
                                  
ALTER TABLE sdsadm.STD_ExpenseTypeHistory ADD CONSTRAINT  fkSTD_ExpenseTypeHistoryOwner FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_ExpenseType  (id)                              
ON  DELETE  CASCADE ;                           
                                  
                                  
ALTER TABLE sdsadm.STD_ExtremityCodeHistory ADD CONSTRAINT  fkSTD_ExtremityCodeHistoryOwnr  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_ExtremityCode  (id)                              
ON  DELETE  CASCADE ;                           
                                  
                                  
ALTER TABLE sdsadm.STD_FacilityTypeHistory  ADD CONSTRAINT  fkSTD_FacilityTypeHistoryOwner  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_FacilityType (id)                              
ON  DELETE  CASCADE;                              
                                  
                                  
ALTER TABLE sdsadm.STD_FeeBasisPrgrmHistory ADD CONSTRAINT  fkSTD_FeeBasisPrgrmHistoryOwnr  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_FeeBasisProgram  (id)                              
ON  DELETE  CASCADE;                              
                                  
                                  
ALTER TABLE sdsadm.STD_FeeBasisTrtmntHistory  ADD CONSTRAINT  fkSTD_FeeBasisTrtmntHstryOwnr FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_FeeBasisTreatmentCodeType  (id)                              
ON  DELETE  CASCADE ;                           
                                  
                                  
ALTER TABLE sdsadm.STD_FilipinoVetProofHistory  ADD CONSTRAINT  fkSTD_FilipinoVetPrfHstryOwnr FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_FilipinoVeteranProof (id)                              
ON  DELETE  CASCADE;                              
                                  
                            
                                  
ALTER TABLE sdsadm.STD_FTITransStatusHistory  ADD CONSTRAINT  fkSTD_FTITransStatusHstryOwnr FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_FTITransStatus (id);                             
                                  
                              
                                  
ALTER TABLE sdsadm.STD_GenderHistory  ADD CONSTRAINT  fkSTD_GenderHistoryOwner  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_Gender (id)                              
ON  DELETE  CASCADE ;                           
                                  
ALTER TABLE sdsadm.STD_HealthBenefitTypeHistory ADD CONSTRAINT  fkSTD_HealthBnftTypHstryOwnr  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_HealthBenefitType  (id)                              
ON  DELETE  CASCADE ;                           
                                  
ALTER TABLE sdsadm.STD_HL724EthnicityMap  ADD CONSTRAINT  fkSTD_HL724EthnicityMapEthncty  FOREIGN KEY(ethnicity_id)                   
REFERENCES  sdsadm.STD_Ethnicity  (id);                             
                                  
                                  
ALTER TABLE sdsadm.STD_HL724MaritalStaMapHistory  ADD CONSTRAINT  fkSTD_HL724MrtlStMpHstryOwnr  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_HL724MaritalStaMap (id)                              
ON  DELETE  CASCADE ;                           
                                  
ALTER TABLE sdsadm.STD_HL724RaceMap ADD CONSTRAINT  fkSTD_HL724RaceMapRace  FOREIGN KEY(race_id)                    
REFERENCES  sdsadm.STD_Race (id);                             
                                  
ALTER TABLE sdsadm.STD_HL724RaceMapHistory  ADD CONSTRAINT  fkSTD_HL724RaceMapHistoryOwner  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_HL724RaceMap (id)                              
ON  DELETE  CASCADE ;                           
                                  
ALTER TABLE sdsadm.STD_HL7AckCodeHistory  ADD CONSTRAINT  fkSTD_HL7AckCodeHistoryOwner  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_HL7AcknowledgementCode (id)                              
ON  DELETE  CASCADE;                              
                                  
                                  
ALTER TABLE sdsadm.STD_HL7AckTypeHistory  ADD CONSTRAINT  fkSTD_HL7AckTypeHistoryOwner  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_HL7AcknowledgementType (id)                              
ON  DELETE  CASCADE;                              
                                  
                                  
ALTER TABLE sdsadm.STD_HL7ActionCodeHistory ADD CONSTRAINT  fkSTD_HL7ActionCodeHistoryOwnr  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_HL7ActionCode  (id)                              
ON  DELETE  CASCADE;                              
                                  
                                  
ALTER TABLE sdsadm.STD_HL7DataTypeHistory ADD CONSTRAINT  fkSTD_HL7DataTypeHistoryOwner FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_HL7DataType  (id)                              
ON  DELETE  CASCADE;                              
                                  
                                  
ALTER TABLE sdsadm.STD_HL7EventTypeHistory  ADD CONSTRAINT  fkSTD_HL7EventTypeHistoryOwner  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_HL7EventType (id)                              
ON  DELETE  CASCADE;                              
                                  
                                  
ALTER TABLE sdsadm.STD_HL7FileLevelEventHistory ADD CONSTRAINT  fkSTD_HL7FileLvlEvntHstryOwnr FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_HL7FileLevelEvent  (id)                              
ON  DELETE  CASCADE;                              
                                  
                                  
ALTER TABLE sdsadm.STD_HL7MasterFileIDCodeHistory ADD CONSTRAINT  fkSTD_HL7MasterFlIDCdHstryOwnr  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_HL7MasterFileIDCode  (id)                              
ON  DELETE  CASCADE;                              
                                  
                                  
ALTER TABLE sdsadm.STD_HL7MessageStrucHistory ADD CONSTRAINT  fkSTD_HL7MessageStrucHstryOwnr  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_HL7MessageStruc  (id)                              
ON  DELETE  CASCADE;                              
                                  
                                  
ALTER TABLE sdsadm.STD_HL7MessageTypeHistory  ADD CONSTRAINT  fkSTD_HL7MessageTypeHstryOwnr FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_HL7MessageType (id)                              
ON  DELETE  CASCADE ;                           
                                  
                                  
ALTER TABLE sdsadm.STD_HL7ObservResultCodeHistory ADD CONSTRAINT  fkSTD_HL7ObservRsltCdHstryOwnr  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_HL7ObservResultCode  (id)                              
ON  DELETE  CASCADE;                              
                                  
                                  
ALTER TABLE sdsadm.STD_HL7PrimKeyValTypeHistory ADD CONSTRAINT  fkSTD_HL7PrimKeyVlTypHstryOwnr  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_HL7PrimaryKeyValueType (id)                              
ON  DELETE  CASCADE;                              
                                  
                                  
ALTER TABLE sdsadm.STD_HL7ProcIDHistory ADD CONSTRAINT  fkSTD_HL7ProcIDHistoryOwner FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_HL7ProcessingID  (id)                              
ON  DELETE  CASCADE ;                           
                                  
                                  
ALTER TABLE sdsadm.STD_HL7ProcModeHistory ADD CONSTRAINT  fkSTD_HL7ProcModeHistoryOwner FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_HL7ProcessingMode  (id)                              
ON  DELETE  CASCADE ;                           
                                  
                                  
ALTER TABLE sdsadm.STD_HL7QryRespFmtCodeHistory ADD CONSTRAINT  fkSTD_HL7QryRespFmtCdHstryOwnr  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_HL7QryRespFmtCode  (id)                              
ON  DELETE  CASCADE;                              
                                  
                                  
ALTER TABLE sdsadm.STD_HL7QryRespStatusHistory  ADD CONSTRAINT  fkSTD_HL7QryRespSttsHstryOwnr FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_HL7QueryResponseStatus (id)                              
ON  DELETE  CASCADE;                              
                                  
                                  
ALTER TABLE sdsadm.STD_HL7QuanLimReqHistory ADD CONSTRAINT  fkSTD_HL7QuanLimReqHistoryOwnr  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_HL7QuantityLimitedRequest  (id)                              
ON  DELETE  CASCADE ;                           
                                  
                                  
ALTER TABLE sdsadm.STD_HL7QueryPriorityHistory  ADD CONSTRAINT  fkSTD_HL7QueryPrrtyHstryOwnr  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_HL7QueryPriority (id)                              
ON  DELETE  CASCADE ;                           
                                  
                                  
ALTER TABLE sdsadm.STD_HL7QueryResultsHistory ADD CONSTRAINT  fkSTD_HL7QueryResultsHstryOwnr  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_HL7QueryResults  (id)                              
ON  DELETE  CASCADE;                              
                                  
                                  
ALTER TABLE sdsadm.STD_HL7RecLevErrRetHistory ADD CONSTRAINT  fkSTD_HL7RecLevErrRetHstryOwnr  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_HL7RecLevErrRet  (id)                              
ON  DELETE  CASCADE ;                           
                                  
                                  
ALTER TABLE sdsadm.STD_HL7RecLevEvCodeHistory ADD CONSTRAINT  fkSTD_HL7RecLevEvCodeHstryOwnr  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_HL7RecLevEvCode  (id)                              
ON  DELETE  CASCADE;                              
                                  
                                  
ALTER TABLE sdsadm.STD_HL7RespLevCodeHistory  ADD CONSTRAINT  fkSTD_HL7RespLevCodeHstryOwnr FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_HL7RespLevCode (id)                              
ON  DELETE  CASCADE ;                           
                                  
                                  
ALTER TABLE sdsadm.STD_HL7RespModalityHistory ADD CONSTRAINT  fkSTD_HL7RespModalityHstryOwnr  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_HL7RespModality  (id)                              
ON  DELETE  CASCADE ;                           
                                  
                                  
ALTER TABLE sdsadm.STD_HL7SrcOfCommentHistory ADD CONSTRAINT  fkSTD_HL7SrcOfCommentHstryOwnr  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_HL7SrcOfComment  (id)                              
ON  DELETE  CASCADE ;                           
                                  
                                  
ALTER TABLE sdsadm.STD_HL7ValueTypeHistory  ADD CONSTRAINT  fkSTD_HL7ValueTypeHistoryOwner  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_HL7ValueType (id)                              
ON  DELETE  CASCADE;                              
                                  
                                  
ALTER TABLE sdsadm.STD_HL7VersionIDHistory  ADD CONSTRAINT  fkSTD_HL7VersionIDHistoryOwner  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_HL7VersionID (id)                              
ON  DELETE  CASCADE ;                           
                                  
                                  
ALTER TABLE sdsadm.STD_HL7WhatSubjectFltrHistory  ADD CONSTRAINT  fkSTD_HL7WhtSbjctFltrHstryOwnr  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_HL7WhatSubjectFltr (id)                              
ON  DELETE  CASCADE;                              
                                  
                                  
ALTER TABLE sdsadm.STD_IdentifierTypeHistory  ADD CONSTRAINT  fkSTD_IdentifierTypeHstryOwnr FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_IdentifierType (id)                              
ON  DELETE  CASCADE ;                           
                                  
                                  
ALTER TABLE sdsadm.STD_IdEventTypeHistory ADD CONSTRAINT  fkSTD_IdEventTypeHistoryOwner FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_IdEventType  (id)                              
ON  DELETE  CASCADE ;                           
                                  
                                  
ALTER TABLE sdsadm.STD_IdExcepTypeGroupHistory  ADD CONSTRAINT  fkSTD_IdExcepTypeGrpHstryOwnr FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_IdExcepTypeGroup (id)                              
ON  DELETE  CASCADE ;                           
                                  
                                  
ALTER TABLE sdsadm.STD_IdTaskProbCateryHistory  ADD CONSTRAINT  fkSTD_IdTaskProbCtgryHstryOwnr  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_IdTaskProbCatery (id)                              
ON  DELETE  CASCADE ;                           
                                  
                                  
ALTER TABLE sdsadm.STD_IdTaskStatusTypeHistory  ADD CONSTRAINT  fkSTD_IdTaskStatusTypHstryOwnr  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_IdTaskStatusType (id)                              
ON  DELETE  CASCADE ;                           
                                  
                                  
ALTER TABLE sdsadm.STD_IncomeTestSourceHistory  ADD CONSTRAINT  fkSTD_IncomeTestSrcHstryOwnr  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_IncomeTestSource (id)                              
ON  DELETE  CASCADE;                              
                                  
                                  
ALTER TABLE sdsadm.STD_IncomeTestTypeHistory  ADD CONSTRAINT  fkSTD_IncomeTestTypeHstryOwnr FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_IncomeTestType (id)                              
ON  DELETE  CASCADE ;                           
                                  
                                  
ALTER TABLE sdsadm.STD_IncomeThresholdHistory ADD CONSTRAINT  fkSTD_IncomeThresholdHstryOwnr  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_IncomeThreshold  (id)                              
ON  DELETE  CASCADE ;                           
                                  
                                  
ALTER TABLE sdsadm.STD_IncomeTypeHistory  ADD CONSTRAINT  fkSTD_IncomeTypeHistoryOwner  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_IncomeType (id)                              
ON  DELETE  CASCADE;                              
                                  
                                  
ALTER TABLE sdsadm.STD_IncomeVerifStatusHistory ADD CONSTRAINT  fkSTD_IncomeVerifSttsHstryOwnr  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_IncomeVerifStatus  (id)                              
ON  DELETE  CASCADE;                              
                                  
                                  
ALTER TABLE sdsadm.STD_InsPlanTypeHistory ADD CONSTRAINT  fkSTD_InsPlanTypeHistoryOwner FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_InsurancePlanType  (id)                              
ON  DELETE  CASCADE;                              
                                  
                                  
ALTER TABLE sdsadm.STD_InsRprtSrcHistory  ADD CONSTRAINT  fkSTD_InsRprtSrcHistoryOwner  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_InsuranceReportSource  (id)                              
ON  DELETE  CASCADE;                              
                                  
                                  
ALTER TABLE sdsadm.STD_Institution  ADD CONSTRAINT  fkSTD_InstAgency  FOREIGN KEY(agency_id)                    
REFERENCES  sdsadm.STD_Agency (id);                             
                                  
                                  
ALTER TABLE sdsadm.STD_Institution  ADD CONSTRAINT  fkSTD_InstFacilityType  FOREIGN KEY(facilityType_id)                    
REFERENCES  sdsadm.STD_FacilityType (id);                             
                                  
                                  
ALTER TABLE sdsadm.STD_Institution  ADD CONSTRAINT  fkSTD_InstMailingCountry  FOREIGN KEY(mailingCountry_id)                    
REFERENCES  sdsadm.STD_Country  (id);                             
                                  
                                  
ALTER TABLE sdsadm.STD_Institution  ADD CONSTRAINT  fkSTD_InstMailingCounty FOREIGN KEY(mailingCounty_id)                   
REFERENCES  sdsadm.STD_County (id);                             
                                  
                                  
ALTER TABLE sdsadm.STD_Institution  ADD CONSTRAINT  fkSTD_InstMailingState  FOREIGN KEY(mailingState_id)                    
REFERENCES  sdsadm.STD_State  (id);                             
                                  
                                  
ALTER TABLE sdsadm.STD_Institution  ADD CONSTRAINT  fkSTD_InstParent  FOREIGN KEY(parent_id)                    
REFERENCES  sdsadm.STD_Institution  (id);                             
                                  
                                  
ALTER TABLE sdsadm.STD_Institution  ADD CONSTRAINT  fkSTD_InstRealignedFrom FOREIGN KEY(realignedFrom_id)                   
REFERENCES  sdsadm.STD_Institution  (id);                             
                                  
                                  
ALTER TABLE sdsadm.STD_Institution  ADD CONSTRAINT  fkSTD_InstRealignedTo FOREIGN KEY(realignedTo_id)                   
REFERENCES  sdsadm.STD_Institution  (id);                             
                                  
                                  
ALTER TABLE sdsadm.STD_Institution  ADD CONSTRAINT  fkSTD_InstStreetCountry FOREIGN KEY(streetCountry_id)                   
REFERENCES  sdsadm.STD_Country  (id);                             
                                  
ALTER TABLE sdsadm.STD_Institution  ADD CONSTRAINT  fkSTD_InstStreetCounty  FOREIGN KEY(streetCounty_id)                    
REFERENCES  sdsadm.STD_County (id);                             
                                  
                                  
ALTER TABLE sdsadm.STD_Institution  ADD CONSTRAINT  fkSTD_InstStreetState FOREIGN KEY(streetState_id)                   
REFERENCES  sdsadm.STD_State  (id);                             
                                  
                                  
ALTER TABLE sdsadm.STD_Institution  ADD CONSTRAINT  fkSTD_InstVisn  FOREIGN KEY(visn_id)                    
REFERENCES  sdsadm.STD_Institution  (id);                             
                                  
                                  
ALTER TABLE sdsadm.STD_InstitutionCode  ADD CONSTRAINT  fkSTD_InstCdCodingSystem  FOREIGN KEY(codingSystem_id)                    
REFERENCES  sdsadm.STD_CodingSystem (id);                             
                                  
                                  
ALTER TABLE sdsadm.STD_InstitutionCode  ADD CONSTRAINT  fkSTD_InstCdInstitution FOREIGN KEY(institution_id)                   
REFERENCES  sdsadm.STD_Institution  (id)                              
ON  DELETE  CASCADE ;                           
                                  
                                  
ALTER TABLE sdsadm.STD_InsuranceHolderTypeHistory ADD CONSTRAINT  fkSTD_InsrncHldrTypHstryOwnr  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_InsuranceHolderType  (id)                              
ON  DELETE  CASCADE;                              
                                  
ALTER TABLE sdsadm.STD_InsuranceMappingHistory  ADD CONSTRAINT  fkSTD_InsuranceMppngHstryOwnr FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_InsuranceMapping (id)                              
ON  DELETE  CASCADE ;                           
                                  
                                  
                              
                                                        
                                  
ALTER TABLE sdsadm.STD_IVMMigrateTypeHistory  ADD CONSTRAINT  fkSTD_IVMMigrateTypeHstryOwnr FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_IVMMigrateType (id)                              
ON  DELETE  CASCADE;                              
                                  
ALTER TABLE sdsadm.STD_IVMUnitHistory ADD CONSTRAINT  fkSTD_IVMUnitHistoryOwner FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_IVMUnit  (id)                              
ON  DELETE  CASCADE;                              
                                  
                                  
ALTER TABLE sdsadm.STD_LocationTypeHistory  ADD CONSTRAINT  fkSTD_LocationTypeHistoryOwner  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_LocationType (id)                              
ON  DELETE  CASCADE;                              
                                  
                                  
ALTER TABLE sdsadm.STD_MaritalStatusHistory ADD CONSTRAINT  fkSTD_MaritalStatusHistoryOwnr  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_MaritalStatus  (id)                              
ON  DELETE  CASCADE;                              
                                  
                                  
ALTER TABLE sdsadm.STD_MASMTTHistory  ADD CONSTRAINT  fkSTD_MASMTTHistoryOwner  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_MASMovementTransactionType (id)                              
ON  DELETE  CASCADE;                              
                                  
                                  
ALTER TABLE sdsadm.STD_MeansTestSigStatusHistory  ADD CONSTRAINT  fkSTD_MeansTestSgSttsHstryOwnr  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_MeansTestSigStatus (id)                              
ON  DELETE  CASCADE ;                           
                                  
                                  
ALTER TABLE sdsadm.STD_MeansTestStatusHistory ADD CONSTRAINT  fkSTD_MeansTestStatusHstryOwnr  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_MeansTestStatus  (id)                              
ON  DELETE  CASCADE;                              
                                  
                                  
ALTER TABLE sdsadm.STD_MessageStatusHistory ADD CONSTRAINT  fkSTD_MessageStatusHistoryOwnr  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_MessageStatus  (id)                              
ON  DELETE  CASCADE;                              
                                  
                                  
ALTER TABLE sdsadm.STD_MessageTypeHistory ADD CONSTRAINT  fkSTD_MessageTypeHistoryOwner FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_MessageType  (id)                              
ON  DELETE  CASCADE ;                           
                                  
                                  
ALTER TABLE sdsadm.STD_MilHistoryTypeHistory  ADD CONSTRAINT  fkSTD_MilHistoryTypeHstryOwnr FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_MilHistoryType (id)                              
ON  DELETE  CASCADE;                              
                                  
                                  
ALTER TABLE sdsadm.STD_MilitarySvcCompHistory ADD CONSTRAINT  fkSTD_MilitarySvcCompHstryOwnr  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_MilitarySvcComp  (id)                              
ON  DELETE  CASCADE;                              
                                  
                                  
ALTER TABLE sdsadm.STD_MonetaryBenefitTypeHistory ADD CONSTRAINT  fkSTD_MonetaryBnftTypHstryOwnr  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_MonetaryBenefitType  (id)                              
ON  DELETE  CASCADE ;                           
                                  
                                  
ALTER TABLE sdsadm.STD_MSTStatusHistory ADD CONSTRAINT  fkSTD_MSTStatusHistoryOwner FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_MSTStatus  (id)                              
ON  DELETE  CASCADE;                              
                                  
                                  
ALTER TABLE sdsadm.STD_MTNotReqRsnTypeHistory ADD CONSTRAINT  fkSTD_MTNotReqRsnTypeHstryOwnr  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_MTNotReqRsnType  (id)                              
ON  DELETE  CASCADE ;                           
                                  
                                  
ALTER TABLE sdsadm.STD_NameTypeHistory  ADD CONSTRAINT  fkSTD_NameTypeHistoryOwner  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_NameType (id)                              
ON  DELETE  CASCADE;                              
                                  
                                  
ALTER TABLE sdsadm.STD_NCOADeliveryTypeHistory  ADD CONSTRAINT  fkSTD_NCOADeliveryTypHstryOwnr  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_NCOADeliveryType (id)                              
ON  DELETE  CASCADE;                              
                                  
                                  
ALTER TABLE sdsadm.STD_NCOAStatusTypeHistory  ADD CONSTRAINT  fkSTD_NCOAStatusTypeHstryOwnr FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_NCOAStatusType (id)                              
ON  DELETE  CASCADE ;                           
                                  
                                  
ALTER TABLE sdsadm.STD_NCOAZipMatchTypeHistory  ADD CONSTRAINT  fkSTD_NCOAZipMatchTypHstryOwnr  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_NCOAZipMatchType (id)                              
ON  DELETE  CASCADE;                              
                                  
                                  
ALTER TABLE sdsadm.STD_NCOAZipNoMatchTypeHistory  ADD CONSTRAINT  fkSTD_NCOAZipNMtchTypHstryOwnr  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_NCOAZipNoMatchType (id)                              
ON  DELETE  CASCADE ;                           
                                  
ALTER TABLE sdsadm.STD_NoSiteUploadReasonHistory  ADD CONSTRAINT  fkSTD_NoSiteUploadRsnHstryOwnr  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_NoSiteUploadReason (id)                              
ON  DELETE  CASCADE ;                           
                                                      
                          
                                  
                                  
ALTER TABLE sdsadm.STD_NPPESOrgAltRsnHistory  ADD CONSTRAINT  fkSTD_NPPESOrgAltRsnHstryOwnr FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_NPPESOrgAltRsn (id);                             
                                  
                                  
ALTER TABLE sdsadm.STD_NTRQualifierHistory  ADD CONSTRAINT  fkSTD_NTRQualifierHistoryOwner  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_NTRQualifier (id)                              
ON  DELETE  CASCADE;                              
                                  
ALTER TABLE sdsadm.STD_NTRVerificatnMthdHistory ADD CONSTRAINT  fkSTD_NTRVrfctnMthdHstryOwnr  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_NTRVerificationMethod  (id)                              
ON  DELETE  CASCADE ;                           
                                  
                                  
ALTER TABLE sdsadm.STD_OefOifSourceHistory  ADD CONSTRAINT  fkSTD_OefOifSourceHistoryOwner  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_OefOifSource (id)                              
ON  DELETE  CASCADE;                              
                                  
                                  
ALTER TABLE sdsadm.STD_ORGPROVTAXONOMYHistory ADD CONSTRAINT  fkSTD_ORGPROVTAXONOMYHstryOwnr  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_ORGPROVTAXONOMY  (id)                              
ON  DELETE  CASCADE ;                           
                                  
                                  
ALTER TABLE sdsadm.STD_OtherFederalAgencyHistory  ADD CONSTRAINT  fkSTD_OtherFdrlAgncyHstryOwnr FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_OtherFederalAgency (id)                              
ON  DELETE  CASCADE;                              
                                  
                                  
ALTER TABLE sdsadm.STD_PatientTypeHistory ADD CONSTRAINT  fkSTD_PatientTypeHistoryOwner FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_PatientType  (id)                              
ON  DELETE  CASCADE ;                           
                                  
                                  
ALTER TABLE sdsadm.STD_PeriodOfServiceHistory ADD CONSTRAINT  fkSTD_PeriodOfServiceHstryOwnr  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_PeriodOfService  (id)                              
ON  DELETE  CASCADE ;                           
                                  
                                  
ALTER TABLE sdsadm.STD_PermanentCodeHistory ADD CONSTRAINT  fkSTD_PermanentCodeHistoryOwnr  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_PermanentCode  (id)                              
ON  DELETE  CASCADE ;                           
                                  
                                  
ALTER TABLE sdsadm.STD_PermissionTypeHistory  ADD CONSTRAINT  fkSTD_PermissionTypeHstryOwnr FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_PermissionType (id)                              
ON  DELETE  CASCADE ;                           
                                  
                                  
ALTER TABLE sdsadm.STD_PersonCateryHistory  ADD CONSTRAINT  fkSTD_PersonCateryHstryOwnr FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_PersonCatery (id)                              
ON  DELETE  CASCADE;                            
                                  
                                  
ALTER TABLE sdsadm.STD_PersonClass  ADD CONSTRAINT  fkSTD_PersonClassClssfctn FOREIGN KEY(classification_id)                    
REFERENCES  sdsadm.STD_PersonClassClassification  (id);                             
                                  
                                  
ALTER TABLE sdsadm.STD_PersonClass  ADD CONSTRAINT  fkSTD_PersonClassProviderType FOREIGN KEY(providerType_id)                    
REFERENCES  sdsadm.STD_PersonClassProviderType  (id);                             
                                  
                                  
ALTER TABLE sdsadm.STD_PersonClassCHistory  ADD CONSTRAINT  fkSTD_PersonClassCHistoryOwner  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_PersonClassClassification  (id)                              
ON  DELETE  CASCADE;                              
                                  
                                  
ALTER TABLE sdsadm.STD_PersonClassHistory ADD CONSTRAINT  fkSTD_PersonClassHistoryOwner FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_PersonClass  (id)                              
ON  DELETE  CASCADE;                              
                                  
                                  
ALTER TABLE sdsadm.STD_PersonClassPTHistory ADD CONSTRAINT  fkSTD_PersonClassPTHistoryOwnr  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_PersonClassProviderType  (id)                              
ON  DELETE  CASCADE ;                           
                                  
                                  
ALTER TABLE sdsadm.STD_PersonContactTypeHistory ADD CONSTRAINT  fkSTD_PersonCntctTypHstryOwnr FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_PersonContactType  (id)                              
ON  DELETE  CASCADE ;                           
                                  
                                  
ALTER TABLE sdsadm.STD_PersonMergeStatusHistory ADD CONSTRAINT  fkSTD_PersonMergeSttsHstryOwnr  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_PersonMergeStatus  (id)                              
ON  DELETE  CASCADE;                              
                                  
                                  
ALTER TABLE sdsadm.STD_PersonRelationHistory  ADD CONSTRAINT  fkSTD_PersonRelationHstryOwnr FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_PersonRelation (id)                              
ON  DELETE  CASCADE ;                           
                                  
                                  
ALTER TABLE sdsadm.STD_PHDataSrcTypeHistory ADD CONSTRAINT  fkSTD_PHDataSrcTypeHistoryOwnr  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_PHDataSrcType  (id)                              
ON  DELETE  CASCADE ;                           
                                  
                                  
ALTER TABLE sdsadm.STD_PhoneChangeSourceHistory ADD CONSTRAINT  fkSTD_PhoneChangeSrcHstryOwnr FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_PhoneChangeSource  (id)                              
ON  DELETE  CASCADE;                              
                                  
ALTER TABLE sdsadm.STD_PhoneContactTypeHistory  ADD CONSTRAINT  fkSTD_PhoneContactTypHstryOwnr  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_PhoneContactType (id)                              
ON  DELETE  CASCADE ;                           
                                  
                          
                                  
                                  
ALTER TABLE sdsadm.STD_PolicyHolderTypeHistory  ADD CONSTRAINT  fkSTD_PolicyHolderTypHstryOwnr  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_PolicyHolderType (id);                             
                                  
                                  
ALTER TABLE sdsadm.STD_PowCasLocnHistory  ADD CONSTRAINT  fkSTD_PowCasLocnHistoryOwner  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_PowCasualtyLocation  (id)                              
ON  DELETE  CASCADE;                              
                                  
ALTER TABLE sdsadm.STD_POWConfineLocnTypeHistory  ADD CONSTRAINT  fkSTD_POWCnfnLcnTypHstryOwnr  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_POWConfineLocnType (id)                              
ON  DELETE  CASCADE;                              
                                  
                                  
ALTER TABLE sdsadm.STD_POWDataSourceTypeHistory ADD CONSTRAINT  fkSTD_POWDataSrcTypHstryOwnr  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_POWDataSourceType  (id)                              
ON  DELETE  CASCADE;                              
                                  
                                  
ALTER TABLE sdsadm.STD_POWDocumentTypeHistory ADD CONSTRAINT  fkSTD_POWDocumentTypeHstryOwnr  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_POWDocumentType  (id)                              
ON  DELETE  CASCADE;                              
                                  
                                  
ALTER TABLE sdsadm.STD_POWPeriodHistory ADD CONSTRAINT  fkSTD_POWPeriodHistoryOwner FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_POWPeriod  (id)                              
ON  DELETE  CASCADE ;                           
                                  
                                  
ALTER TABLE sdsadm.STD_ProcedureCodeHistory ADD CONSTRAINT  fkSTD_ProcedureCodeHistoryOwnr  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_ProcedureCode  (id)                              
ON  DELETE  CASCADE;                              
                                  
                                  
ALTER TABLE sdsadm.STD_ProgramOfStudyHistory  ADD CONSTRAINT  fkSTD_ProgramOfStudyHstryOwnr FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_ProgramOfStudy (id)                              
ON  DELETE  CASCADE;                              
                                  
                                  
ALTER TABLE sdsadm.STD_PseudoSSNReasonHistory ADD CONSTRAINT  fkSTD_PseudoSSNReasonHstryOwnr  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_PseudoSSNReason  (id)                              
ON  DELETE  CASCADE;                              
                                  
ALTER TABLE sdsadm.STD_PTFDischargeCodeHistory  ADD CONSTRAINT  fkSTD_PTFDischargeCdHstryOwnr FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_PTFDischargeCode (id)                              
ON  DELETE  CASCADE ;                           
                                  
                                  
ALTER TABLE sdsadm.STD_PublicationTopicHistory  ADD CONSTRAINT  fkSTD_PublicationTpcHstryOwnr FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_PublicationTopic (id)                              
ON  DELETE  CASCADE;                              
                                  
                                  
ALTER TABLE sdsadm.STD_RaceHistory  ADD CONSTRAINT  fkSTD_RaceHistoryOwner  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_Race (id)                              
ON  DELETE  CASCADE ;                           
                                  
                                  
ALTER TABLE sdsadm.STD_RadiatnExpsrMthdHistory  ADD CONSTRAINT  fkSTD_RdtnExpsrMthdHstryOwnr  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_RadiationExposureMethod  (id)                              
ON  DELETE  CASCADE;                              
                                  
                                  
ALTER TABLE sdsadm.STD_RegistryTypeHistory  ADD CONSTRAINT  fkSTD_RegistryTypeHistoryOwner  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_RegistryType (id)                              
ON  DELETE  CASCADE;                              
                                  
                                  
ALTER TABLE sdsadm.STD_RejectedRemarksHistory ADD CONSTRAINT  fkSTD_RejectedRemarksHstryOwnr  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_RejectedRemarks  (id)                              
ON  DELETE  CASCADE;                              
                                  
                                  
ALTER TABLE sdsadm.STD_RelationshipHistory  ADD CONSTRAINT  fkSTD_RelationshipHistoryOwner  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_Relationship (id)                              
ON  DELETE  CASCADE ;                           
                                  
ALTER TABLE sdsadm.STD_RelatnlConjunctnHistory  ADD CONSTRAINT  fkSTD_RelatnlCnjnctnHstryOwnr FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_RelationalConjunction  (id)                              
ON  DELETE  CASCADE;                              
                                  
                                  
ALTER TABLE sdsadm.STD_RelatnlOperatorHistory ADD CONSTRAINT  fkSTD_RelatnlOperatorHstryOwnr  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_RelationalOperator (id)                              
ON  DELETE  CASCADE;                              
                                  
                                  
ALTER TABLE sdsadm.STD_ReligionHistory  ADD CONSTRAINT  fkSTD_ReligionHistoryOwner  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_Religion (id)                              
ON  DELETE  CASCADE ;                           
                                  
                                  
ALTER TABLE sdsadm.STD_RelToVetInsuranceHistory ADD CONSTRAINT  fkSTD_RelToVetInsrncHstryOwnr FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_RelToVetInsurance  (id)                              
ON  DELETE  CASCADE;                              
                                  
                                  
ALTER TABLE sdsadm.STD_ReportEligFactorHistory  ADD CONSTRAINT  fkSTD_ReportEligFctrHstryOwnr FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_ReportEligFactor (id)                              
ON  DELETE  CASCADE;                              
                                  
                                  
ALTER TABLE sdsadm.STD_ReportEnrollPrStatHistory  ADD CONSTRAINT  fkSTD_RprtEnrllPrSttHstryOwnr FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_ReportEnrollPrStat (id)                              
ON  DELETE  CASCADE;                              
                                  
                                  
ALTER TABLE sdsadm.STD_ReportTypeHistory  ADD CONSTRAINT  fkSTD_ReportTypeHistoryOwner  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_ReportType (id)                              
ON  DELETE  CASCADE;                              
                                  
                                  
ALTER TABLE sdsadm.STD_RPTDayOfMonthTypeHistory ADD CONSTRAINT  fkSTD_RPTDayOfMnthTypHstryOwnr  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_RPTDayOfMonthType  (id)                              
ON  DELETE  CASCADE;                              
                                  
                                  
ALTER TABLE sdsadm.STD_RPTDayOfQuarterTypHistory  ADD CONSTRAINT  fkSTD_RPTDayOfQrtrTypHstryOwnr  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_RPTDayOfQuarterTyp (id)                              
ON  DELETE  CASCADE;                              
                                  
                                  
ALTER TABLE sdsadm.STD_RPTDayOfWeekTypeHistory  ADD CONSTRAINT  fkSTD_RPTDayOfWeekTypHstryOwnr  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_RPTDayOfWeekType (id)                              
ON  DELETE  CASCADE ;                           
                                  
                                  
ALTER TABLE sdsadm.STD_RPTDetailByTypeHistory ADD CONSTRAINT  fkSTD_RPTDetailByTypeHstryOwnr  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_RPTDetailByType  (id)                              
ON  DELETE  CASCADE ;                           
                                  
ALTER TABLE sdsadm.STD_RPTDetailForTypeHistory  ADD CONSTRAINT  fkSTD_RPTDetailForTypHstryOwnr  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_RPTDetailForType (id)                              
ON  DELETE  CASCADE ;                           
                                  
                                                          
                                  
                                  
ALTER TABLE sdsadm.STD_RPTExceptionTypeHistory  ADD CONSTRAINT  fkSTD_RPTExceptionTypHstryOwnr  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_RPTExceptionType (id);                             
                                  
                                  
ALTER TABLE sdsadm.STD_RPTLetterFileTypeHistory ADD CONSTRAINT  fkSTD_RPTLetterFlTypHstryOwnr FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_RPTLetterFileType  (id)                              
ON  DELETE  CASCADE ;                           
                                  
ALTER TABLE sdsadm.STD_RPTMonthListHistory  ADD CONSTRAINT  fkSTD_RPTMonthListHistoryOwner  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_RPTMonthList (id)                              
ON  DELETE  CASCADE ;                           
                                  
                                  
ALTER TABLE sdsadm.STD_RPTOutFormatTypeHistory  ADD CONSTRAINT  fkSTD_RPTOutFormatTypHstryOwnr  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_RPTOutFormatType (id)                              
ON  DELETE  CASCADE;                              
                                  
                                  
ALTER TABLE sdsadm.STD_RPTOutputFileTypeHistory ADD CONSTRAINT  fkSTD_RPTOutputFlTypHstryOwnr FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_RPTOutputFileType  (id)                              
ON  DELETE  CASCADE;                              
                                  
                                  
ALTER TABLE sdsadm.STD_RPTPeriodTypeHistory ADD CONSTRAINT  fkSTD_RPTPeriodTypeHistoryOwnr  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_RPTPeriodType  (id)                              
ON  DELETE  CASCADE;                              
                                  
                                  
ALTER TABLE sdsadm.STD_RPTQuarterListHistory  ADD CONSTRAINT  fkSTD_RPTQuarterListHstryOwnr FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_RPTQuarterList (id)                              
ON  DELETE  CASCADE;                              
                                  
                                  
ALTER TABLE sdsadm.STD_RPTRunFrequencyTypHistory  ADD CONSTRAINT  fkSTD_RPTRunFrqncyTypHstryOwnr  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_RPTRunFrequencyTyp (id)                              
ON  DELETE  CASCADE;                              
                                  
                                  
ALTER TABLE sdsadm.STD_RPTScheduleTypeHistory ADD CONSTRAINT  fkSTD_RPTScheduleTypeHstryOwnr  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_RPTScheduleType  (id)                              
ON  DELETE  CASCADE ;                           
                                  
ALTER TABLE sdsadm.STD_RPTSiteDisplayTypeHistory  ADD CONSTRAINT  fkSTD_RPTSiteDsplyTypHstryOwnr  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_RPTSiteDisplayType (id)                              
ON  DELETE  CASCADE;                              
                                  
                                  
                          
                                  
                                  
ALTER TABLE sdsadm.STD_RPTStatusComponentHistory  ADD CONSTRAINT  fkSTD_RPTStatusCmpnntHstryOwnr  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_RPTStatusComponent (id);                             
                                  
                                  
ALTER TABLE sdsadm.STD_RPTWeekOfMonthTypeHistory  ADD CONSTRAINT  fkSTD_RPTWkOfMnthTypHstryOwnr FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_RPTWeekOfMonthType (id)                              
ON  DELETE  CASCADE ;                           
                                  
ALTER TABLE sdsadm.STD_RPTWorkItemStTypeHistory ADD CONSTRAINT  fkSTD_RPTWorkItmStTypHstryOwnr  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_RPTWorkItemStType  (id)                              
ON  DELETE  CASCADE ;                           
                                  
                                  
ALTER TABLE sdsadm.STD_SensitivityChngSrcHistory  ADD CONSTRAINT  fkSTD_SnstvtyChngSrcHstryOwnr FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_SensitivityChangeSource  (id)                              
ON  DELETE  CASCADE;                              
                                  
                                  
ALTER TABLE sdsadm.STD_ServiceBranchHistory ADD CONSTRAINT  fkSTD_ServiceBranchHistoryOwnr  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_ServiceBranch  (id)                              
ON  DELETE  CASCADE ;                           
                                  
                                  
ALTER TABLE sdsadm.STD_ServiceHistory ADD CONSTRAINT  fkSTD_ServiceHistoryOwner FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_Service  (id)                              
ON  DELETE  CASCADE;                              
                                  
                                  
ALTER TABLE sdsadm.STD_SHADDocumentTypeHistory  ADD CONSTRAINT  fkSTD_SHADDocumentTypHstryOwnr  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_SHADDocumentType (id)                              
ON  DELETE  CASCADE;                              
                                  
                                  
ALTER TABLE sdsadm.STD_SignatureIndTypeHistory  ADD CONSTRAINT  fkSTD_SignatureIndTypHstryOwnr  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_SignatureIndType (id)                              
ON  DELETE  CASCADE;                              
                                  
                                  
ALTER TABLE sdsadm.STD_SiteUploadStatusHistory  ADD CONSTRAINT  fkSTD_SiteUploadSttsHstryOwnr FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_SiteUploadStatus (id)                              
ON  DELETE  CASCADE;                              
                                  
                                  
ALTER TABLE sdsadm.STD_SpecialFactorMapHistory  ADD CONSTRAINT  fkSTD_SpecialFactorMpHstryOwnr  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_SpecialFactorMap (id)                              
ON  DELETE  CASCADE;                              
                                  
ALTER TABLE sdsadm.STD_SpecialtyServiceHistory  ADD CONSTRAINT  fkSTD_SpecialtySrvcHstryOwnr  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_SpecialtyService (id)                              
ON  DELETE  CASCADE ;                           
                                  
                                  
                                  
ALTER TABLE sdsadm.STD_SSAVerifCodeHistory  ADD CONSTRAINT  fkSTD_SSAVerifCodeHistoryOwner  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_SSAVerifCode (id);                             
                                  
                                  
ALTER TABLE sdsadm.STD_SSNChangeSourceHistory ADD CONSTRAINT  fkSTD_SSNChangeSourceHstryOwnr  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_SSNChangeSource  (id)                              
ON  DELETE  CASCADE ;                           
                                  
ALTER TABLE sdsadm.STD_SSNTypeHistory ADD CONSTRAINT  fkSTD_SSNTypeHistoryOwner FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_SSNType  (id)                              
ON  DELETE  CASCADE ;                           
                                  
                                  
ALTER TABLE sdsadm.STD_SSNVerifStatusHistory  ADD CONSTRAINT  fkSTD_SSNVerifStatusHstryOwnr FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_SSNVerificationStatus  (id)                              
ON  DELETE  CASCADE ;                           
                                  
                                  
ALTER TABLE sdsadm.STD_StatCntyXref ADD CONSTRAINT  fkSTD_StatCntyXrefCounty  FOREIGN KEY(county_id)                    
REFERENCES  sdsadm.STD_County (id)                              
ON  DELETE  CASCADE ;                           
                                  
                                  
ALTER TABLE sdsadm.STD_StatCntyXref ADD CONSTRAINT  fkSTD_StatCntyXrefSttstclAr FOREIGN KEY(statisticalArea_id)                   
REFERENCES  sdsadm.STD_StatisticalArea  (id)                              
ON  DELETE  CASCADE;                              
                                  
                                  
ALTER TABLE sdsadm.STD_State  ADD CONSTRAINT  fkSTD_StateCountry  FOREIGN KEY(country_id)                   
REFERENCES  sdsadm.STD_Country  (id)                              
ON  DELETE  CASCADE ;                           
                                  
                                  
ALTER TABLE sdsadm.STD_StateHistory ADD CONSTRAINT  fkSTD_StateHistoryOwner FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_State  (id)                              
ON  DELETE  CASCADE;                              
                                  
ALTER TABLE sdsadm.STD_StatisticalArea  ADD CONSTRAINT  fkSTD_StatisticalAreaParent FOREIGN KEY(parent_id)                    
REFERENCES  sdsadm.STD_StatisticalArea  (id);                             
                                  
ALTER TABLE sdsadm.STD_StatisticalArea  ADD CONSTRAINT  fkSTD_SttstclArSttstclArTyp FOREIGN KEY(statisticalAreaType_id)                   
REFERENCES  sdsadm.STD_StatisticalAreaType  (id);                             
                                  
                                  
                                  
ALTER TABLE sdsadm.STD_StatisticalAreaTypeHistory ADD CONSTRAINT  fkSTD_SttstclArTypHstryOwnr FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_StatisticalAreaType  (id);                             
                                  
                                  
ALTER TABLE sdsadm.STD_SvcDschrgCdHistory ADD CONSTRAINT  fkSTD_SvcDschrgCdHistoryOwner FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_ServiceDischargeCode (id)                              
ON  DELETE  CASCADE;                              
                                  
ALTER TABLE sdsadm.STD_TransactionTypeHistory ADD CONSTRAINT  fkSTD_TransactionTypeHstryOwnr  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_TransactionType  (id)                              
ON  DELETE  CASCADE;                              
                                  
                                  
ALTER TABLE sdsadm.STD_UserAbsenceTypeHistory ADD CONSTRAINT  fkSTD_UserAbsenceTypeHstryOwnr  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_UserAbsenceType  (id)                              
ON  DELETE  CASCADE;                              
                                  
                                  
ALTER TABLE sdsadm.STD_UserGroupTypeHistory ADD CONSTRAINT  fkSTD_UserGroupTypeHistoryOwnr  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_UserGroupType  (id)                              
ON  DELETE  CASCADE;                              
                                  
                                  
ALTER TABLE sdsadm.STD_VBAQueryStatusTypeHistory  ADD CONSTRAINT  fkSTD_VBAQuerySttsTypHstryOwnr  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_VBAQueryStatusType (id)                              
ON  DELETE  CASCADE ;                           
                                  
                                  
ALTER TABLE sdsadm.STD_WkfDataJobActionHistory  ADD CONSTRAINT  fkSTD_WkfDataJobActnHstryOwnr FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_WkfDataJobAction (id)                              
ON  DELETE  CASCADE;                              
                                  
                                  
ALTER TABLE sdsadm.STD_WkfDataJobStatusHistory  ADD CONSTRAINT  fkSTD_WkfDataJobSttsHstryOwnr FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_WkfDataJobStatus (id)                              
ON  DELETE  CASCADE;                              
                                  
                                  
ALTER TABLE sdsadm.STD_WKFIssueTypeHistory  ADD CONSTRAINT  fkSTD_WKFIssueTypeHistoryOwner  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_WKFIssueType (id)                              
ON  DELETE  CASCADE;                              
                                  
ALTER TABLE sdsadm.STD_WkfloCaseActivityHistory ADD CONSTRAINT  fkSTD_WkfloCaseActvtyHstryOwnr  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_WorkflowCaseActivity (id)                              
ON  DELETE  CASCADE;                              
                                  
                                  
ALTER TABLE sdsadm.STD_WkfloCaseRequestHistory  ADD CONSTRAINT  fkSTD_WkfloCaseRqstHstryOwnr  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_WorkflowCaseRequest  (id)                              
ON  DELETE  CASCADE;                              
                                  
                                  
ALTER TABLE sdsadm.STD_WkfloCaseStatusHistory ADD CONSTRAINT  fkSTD_WkfloCaseStatusHstryOwnr  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_WorkflowCaseStatus (id)                              
ON  DELETE  CASCADE;                              
                                  
                                  
ALTER TABLE sdsadm.STD_WkfloCaseTypeHistory ADD CONSTRAINT  fkSTD_WkfloCaseTypeHistoryOwnr  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_WorkflowCaseType (id)                              
ON  DELETE  CASCADE;                              
                                  
                                  
ALTER TABLE sdsadm.STD_WkfloUpdateTypeHistory ADD CONSTRAINT  fkSTD_WkfloUpdateTypeHstryOwnr  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_WorkflowUpdateType (id)                              
ON  DELETE  CASCADE;                              
                                  
                                  
ALTER TABLE sdsadm.STD_YesNoCodeHistory ADD CONSTRAINT  fkSTD_YesNoCodeHistoryOwner FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_YesNoCode  (id)                              
ON  DELETE  CASCADE ;                           
                                  
                                  
ALTER TABLE sdsadm.STD_ZipAssignment  ADD CONSTRAINT  fkSTD_ZipAssignmentZipcode  FOREIGN KEY(zipcode_id)                   
REFERENCES  sdsadm.STD_ZipCode  (id)                              
ON  DELETE  CASCADE;                              
                                  
                                  
ALTER TABLE sdsadm.STD_ZipAssignment  ADD CONSTRAINT  fkSTD_ZipAssignmentZipplace FOREIGN KEY(zipplace_id)                    
REFERENCES  sdsadm.STD_ZipPlace (id)                              
ON  DELETE  CASCADE;                              
                                  
                                  
ALTER TABLE sdsadm.STD_ZipClassificationHistory ADD CONSTRAINT  fkSTD_ZipClssfctnHstryOwnr  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_ZipClassification  (id)                              
ON  DELETE  CASCADE ;                           
                                  
                                  
ALTER TABLE sdsadm.STD_ZipCode  ADD CONSTRAINT  fkSTD_ZipCodePreferredZipPlace  FOREIGN KEY(preferredZipPlace_id)                   
REFERENCES  sdsadm.STD_ZipPlace (id);                             
                                  
                                  
ALTER TABLE sdsadm.STD_ZipCode  ADD CONSTRAINT  fkSTD_ZipCodeState  FOREIGN KEY(state_id)                   
REFERENCES  sdsadm.STD_State  (id);                             
                                  
                                  
ALTER TABLE sdsadm.STD_ZipCode  ADD CONSTRAINT  fkSTD_ZipCodeZipClassification  FOREIGN KEY(zipClassification_id)                   
REFERENCES  sdsadm.STD_ZipClassification  (id);                             
                                  
                                  
ALTER TABLE sdsadm.STD_ZipCodeHistory ADD CONSTRAINT  fkSTD_ZipCodeHistoryOwner FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_ZipCode  (id)                              
ON  DELETE  CASCADE;                              
                                  
                                  
ALTER TABLE sdsadm.STD_ZipPlace ADD CONSTRAINT  fkSTD_ZipPlaceZipPlaceFacility  FOREIGN KEY(zipPlaceFacility_id)                    
REFERENCES  sdsadm.STD_ZipPlaceFacility (id);                             
                                  
                                  
ALTER TABLE sdsadm.STD_ZipPlaceFacilityHistory  ADD CONSTRAINT  fkSTD_ZipPlaceFcltyHstryOwnr  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_ZipPlaceFacility (id)                              
ON  DELETE  CASCADE ;                           
                                  
                                  
ALTER TABLE sdsadm.STD_ZipPlaceHistory  ADD CONSTRAINT  fkSTD_ZipPlaceHistoryOwner  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_ZipPlace (id)                              
ON  DELETE  CASCADE;                              
                                  
                                  
ALTER TABLE sdsadm.STD_ZipToMSAHistory  ADD CONSTRAINT  fkSTD_ZipToMSAHistoryOwner  FOREIGN KEY(owner_id)                   
REFERENCES  sdsadm.STD_ZipToMSA (id)                              
ON  DELETE  CASCADE;                              
                                  
                                  
ALTER TABLE PCMM.PATIENT_ASSIGN_TEAM_POSITION ADD CONSTRAINT  CK_PatAsnTmPosm_StartEndDate  CHECK ((START_DATE  IS  NULL  OR  END_DATE  IS  NULL  OR  START_DATE<=END_DATE));
                                  
                                  
ALTER TABLE PCMM.PCM_STD_NON_VA_PROV_ROLE_HIST  ADD CONSTRAINT  FK_CONSTRAINT67 CHECK ((ISACTIVE='Y'  OR  INACTIVATE_REASON IS  NOT NULL));         
                                  
                                  
ALTER TABLE PCMM.STOP_CODE_VALID_FOR_ENC ADD  CONSTRAINT  CK_PcmStdStopCodeValidForEnc  
CHECK ((STOP_CODE IS  NOT NULL  OR  SECONDARY_STOP_CODE IS  NOT NULL));
                                  
                                  
ALTER TABLE PCMM.PCM_STD_TEAM_CARE_TYPE_HISTORY ADD CONSTRAINT  FK_CONSTRAINT68 CHECK ((ISACTIVE='Y'  OR  INACTIVATE_REASON IS  NOT NULL))  ;       
                                  
                                  
ALTER TABLE PCMM.PCM_STD_TEAM_FOCUS_HISTORY ADD CONSTRAINT  FK_CONSTRAINT69 CHECK ((ISACTIVE='Y'  OR  INACTIVATE_REASON IS  NOT NULL));         
                                  
ALTER TABLE PCMM.PRECEPTOR_ASSIGNMENT ADD CONSTRAINT  FK_CONSTRAINT70 CHECK ((START_DATE  IS  NULL  OR  END_DATE  IS  NULL  OR  START_DATE<=END_DATE))  ; 
                                  
                                  
ALTER TABLE PCMM.SURR_STAFF_ASSIGN_TEAM_POS ADD CONSTRAINT  
FK_CONSTRAINT71 CHECK ((START_DATE  IS  NULL  OR  END_DATE  IS  NULL  OR  START_DATE<=END_DATE));   
                                  
ALTER TABLE PCMM.TEAM_GROUP ADD CONSTRAINT  CK_TeamGroup_StartEndDate CHECK ((START_DATE  IS  NULL  OR  END_DATE  IS  NULL  OR  START_DATE<=END_DATE));   
                                  
                                  
ALTER TABLE PCMM.TEAM_PATIENT_ASSIGN ADD  CONSTRAINT  FK_CONSTRAINT72 CHECK ((START_DATE  IS  NULL  OR  END_DATE  IS  NULL  OR  START_DATE<=END_DATE));
                                  
                                  
ALTER TABLE PCMM.TEAM_ROOM  ADD CONSTRAINT  CK_TeamRoom_StartEndDate  CHECK ((START_DATE  IS  NULL  OR  END_DATE  IS  NULL  OR  START_DATE<=END_DATE))    

