require "selenium-webdriver"
require 'rspec/expectations'
require 'httparty'

World(RSpec::Matchers)

When(/^I go to the cdsinvocation base url plus "(.*?)"$/) do |url|
  #@driver.get("#{ENV['CDSINVOCATION_IP']}/#{url}")
  if url != ""
    puts "url => :#{url}:"
    @response = HTTParty.get(
        "http://#{ENV['CDSINVOCATION_IP']}:#{ENV['CDSINVOCATION_PORT']}#{url}",
        :verify => false
    )
  else
    puts "I don't have aws access, so lets ouput the URL"
    puts "http://#{ENV['CDSINVOCATION_IP']}"
    @response = "Apache Server"
  end
end

Then(/^what I get back contains (?:"(.*?)")?$/) do |text|
  expect(@response).to include(text)
end

Then(/^CDSInvocation server is running with (?:"(.*?)")?$/) do |text|
  expect(@response).to include(text)
end

When(/^sending a post request with json data "(.*?)"$/) do |payload|
  @response = HTTParty.post(
    "http://#{ENV['CDSINVOCATION_IP']}:#{ENV['CDSINVOCATION_PORT']}/cds-results-service/cds/invokeRules",
    {
      :body => payload,
      :headers => { 'Content-Type' => 'application/json', 'Accept' => 'application/json' }
    }
    )
  # puts @response
end

Then(/^successful message returned with code "(.*?)"$/) do  |text|
 # puts "#{ENV['CDSINVOCATION_IP']}/cds-results-service/rest/invokeRulesForPatient"
  expect(@response.code).to eq(200)
end

When(/^trying to connect to MongoDB$/) do
  # url = "http://IPADDRESS :27017"
  @response = HTTParty.get(
    "http://#{ENV['CDSDB_IP']}:#{ENV['CDSDB_PORT']}",
    :verify => false
    )
end

Then(/^successful message returned from MongoDB server with "(.*?)"$/) do |text|
  expect(@response).to include(text)
end

When(/^sending a get request for a advice$/) do
  auth = { :accessCode => "pu1234", :verifyCode => "pu1234!!", :site => "9E7A" }
  url = "http://#{ENV['RDK_IP']}:#{ENV['RDK_PORT']}/resource/cds/advice/list?use=providerInteractiveAdvice&pid=5000000317V387446"
  @response = HTTParty.get(
    url,
    :query => auth,
    :verify => false
    )
  puts @response
end

When(/^trying to connect to open CDS$/) do
  @response = HTTParty.get(
    "http://#{ENV['OPENCDS_IP']}:#{ENV['OPENCDS_PORT']}/opencds-decision-support-service",
    :verify => false
    )
end

Then(/^Open CDS server is running with (?:"(.*?)")?$/) do |text|
  expect(@response).to include(text)
end

When(/^sending a get request to FHIR server$/) do
  auth = { :accessCode => "pu1234", :verifyCode => "pu1234!!", :site => "9E7A" }
  url = "http://#{ENV['RDK_IP']}:#{ENV['RDK_PORT']}/resource/fhir/patient/9E7A;253/observation"
  @response = HTTParty.get(
    url,
    :query => auth,
    :verify => false
    )
  # puts @response
end
