package org.opencds.config.migrate;

import java.nio.file.Paths

import org.opencds.config.migrate.utilities.FileUtility;

import spock.lang.Specification

class ConfigMigratorSpec extends Specification {

    ConfigMigrator cm
    
    def setup() {
        cm = new ConfigMigrator()
    }
    
    def "test migration"() {
//        given:
        def targetPath = Paths.get("/Users/phillip/projects/opencds/opencds/opencds-knowledge-repository-data/src/main/resources/resources_v1.3")
        def configResources = [
            (ConfigResourceType.CODE_SYSTEMS): new ConfigResource(location: "resourceAttributes", name: "openCDSCodeSystems.xml"),
            (ConfigResourceType.EXECUTION_ENGINES): new ConfigResource(location: "resourceAttributes", name: "openCdsExecutionEngines.xml"),
            (ConfigResourceType.KNOWLEDGE_MODULES): new ConfigResource(location: "resourceAttributes", name: "knowledgeModules.xml"),
            (ConfigResourceType.SEMANTIC_SIGNIFIERS): new ConfigResource(location: "resourceAttributes", name: "semanticSignifiers.xml"),
            (ConfigResourceType.SUPPORTED_CONCEPTS): new ConfigResource(location: "resourceAttributes", name: "supportedConceptsConfigFile.xml"),
            (ConfigResourceType.AUTOGEN_CONCEPT_MAPPINGS_SPEC): new ConfigResource(location: "conceptMappingSpecifications/autoGeneratedMappings"),
            (ConfigResourceType.MANUAL_CONCEPT_MAPPINGS_SPEC): new ConfigResource(location: "conceptMappingSpecifications/manualMappings"),
            (ConfigResourceType.EXECUTION_ENGINE_MODULES): new ConfigResource(location: "knowledgeModules")
            ]
        OpencdsBaseConfig config = new OpencdsBaseConfig("SIMPLE_FILE", "/Users/phillip/projects/opencds/opencds/opencds-knowledge-repository-data/src/main/resources/resources_v1.1", configResources);
        config.setFileUtility(new FileUtility());
        
//        when:
        cm.migrate(targetPath, config)
        
//        then:
        true
    }

}
