/*******************************************************************************
 *
 *   Copyright 2016 Cognitive Medical Systems
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 *
 *     
 *******************************************************************************/
package com.cognitive.cds.services.engineinstance.model;

import org.springframework.beans.factory.annotation.Required;

import com.cognitive.cds.invocation.util.JsonUtils;
import com.fasterxml.jackson.core.JsonProcessingException;

/**
 * The EngineInstanceStateRequest class is used to communicate the state of an engine instance from an external agent
 * making a call to the web service.
 *
 * @author jfox
 *
 */
public class EngineInstanceStateRequest {

	private String name;
	private String type;
	private String host;
	private String port;
	private boolean status;

	/**
	 * The name of the engine for which this instance is in reference to.
	 *
	 * @return the name
	 */
	public String getName() {
		return name;
	}

	/**
	 * The name of the engine for which this instance is in reference to.
	 *
	 * @param name the name to set
	 */
	@Required
	public void setName(String name) {
		this.name = name;
	}

	/**
	 * @return the type
	 */
	public String getType() {
		return type;
	}

	/**
	 * @param type the type to set
	 */
	@Required
	public void setType(String type) {
		this.type = type;
	}

	/**
	 * @return the host
	 */
	public String getHost() {
		return host;
	}

	/**
	 * @param host the host to set
	 */
	@Required
	public void setHost(String host) {
		this.host = host;
	}

	/**
	 * @return the port
	 */
	public String getPort() {
		return port;
	}

	/**
	 * @param port the port to set
	 */
	@Required
	public void setPort(String port) {
		this.port = port;
	}

	/**
	 * @return the status
	 */
	public boolean isStatus() {
		return status;
	}

	/**
	 * @param status the status to set
	 */
	@Required
	public void setStatus(boolean status) {
		this.status = status;
	}

	/**
	 * Get the JSON representation of this Engine Instance State
	 *
	 * @return JSON representation of engine instance state
	 * @throws JsonProcessingException
	 */
	public String toJsonString() throws JsonProcessingException {
		return JsonUtils.toJsonString(this);
	}

}
