/*******************************************************************************
 *
 *   Copyright 2015 Cognitive Medical Systems
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 *
 *     
 *******************************************************************************/
package com.cognitive.cds.services.cdsinteractive;

import javax.ws.rs.Path;

import org.apache.cxf.jaxrs.ext.MessageContext;

import com.cognitive.cds.invocation.CDSInvocationIFace;
import com.cognitive.cds.invocation.model.ResultBundle;




/**
 * @author Jerry Goodnough
 * @version 1.0
 * @created 4/28/2015
 */
@Path("/cds")
public interface InvokeIface {

	/**
	 * Core generic interactive reasoning service - Acts as a thin wrapper to a CDSInvocationIFace
	 * @see CDSInvocationIFace
	 * 
	 * @param target The invocation target (required)
	 * @param ctx The call context (required)
	 * @param parameters call parameters (optional)
	 * @param dataModel the data model (optional)
	 * @return
	 */
//    @POST
//    @Consumes("application/json")
//    @Produces("application/json")
//    @Path("/invokeRules")
    public ResultBundle invokeRules(InvokeServiceReq request, @javax.ws.rs.core.Context MessageContext context );


}