/*******************************************************************************
 *
 *   Copyright 2015 Cognitive Medical Systems
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 *
 *     
 *******************************************************************************/
package com.cognitive.cds.invocation.mongo;

import java.util.logging.Level;
import java.util.logging.Logger;

import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

import com.cognitive.cds.invocation.execution.model.Job;

public class JobDaoTest {

    private static MongoDbDao mongoDbDao;
    private JobDao jobDao;
    private static Logger logger = Logger.getLogger(JobDaoTest.class.getName());

    @BeforeClass
    public static void beforeClass() {
        try {
            ApplicationContext context = new ClassPathXmlApplicationContext(
                    "classpath:mongodb-dao-context.xml");
            mongoDbDao = (MongoDbDao) context.getBean("mongoDbDao");
        } catch (Exception e) {
            logger.log(Level.SEVERE,
                    "Error loading connection properties.  Cannot connect to MongoDB");
        }
    }

    @Ignore("a service integration test")
    @Test
    public void testLoadJob() {

        jobDao = new JobDao();
        jobDao.setMongoDbDao(mongoDbDao);
        Job job = jobDao.loadJobInfo("HTNList");

        Assert.assertTrue(job != null);
    }

    @Ignore("a service integration test")
    @Test
    public void testSaveJob() {

        jobDao = new JobDao();
        jobDao.setMongoDbDao(mongoDbDao);
        Job job = jobDao.loadJobInfo("HTNList");

        jobDao.saveJobInfo("HTNList", job);

    }
}
