/**
 * *****************************************************************************
 *
 * Copyright 2015 Cognitive Medical Systems
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 *
 *
 ******************************************************************************
 */
package com.cognitive.cds.invocation.mongo;

import com.cognitive.cds.invocation.model.IntentMapping;
import com.cognitive.cds.invocation.model.InvocationMapping;
import com.cognitive.cds.invocation.model.Rule;
import java.util.logging.Level;
import java.util.logging.Logger;

import org.bson.types.ObjectId;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

import com.fasterxml.jackson.core.JsonProcessingException;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

import org.junit.Ignore;

/**
 *
 * @author Tadesse Sefer
 * 
 */
public class IntentMappingDaoTest {

	private static MongoDbDao mongoDbDao;
	private static IntentMappingDao intentMappingDao;
	private static Logger logger = Logger.getLogger(IntentMappingDaoTest.class.getName());

	@BeforeClass
	public static void beforeClass() {
		try {
			ApplicationContext context = new ClassPathXmlApplicationContext("classpath:mongodb-dao-context.xml");
			mongoDbDao = (MongoDbDao) context.getBean("mongoDbDao");
			intentMappingDao = new IntentMappingDao();
			intentMappingDao.setMongoDbDao(mongoDbDao);
		} catch (Exception e) {
			logger.log(Level.SEVERE, "Error loading connection properties.  Cannot connect to MongoDB");
		}
	}

	@Ignore("a service integration test")
	@Test
	public void testCreateIntentMapping() {
		String id = new String();
		IntentMapping im = createIntentMappingObject();
		try {
			id = intentMappingDao.createIntent(im);
		} catch (JsonProcessingException jpe) {
			jpe.printStackTrace();
		}
		logger.info(id);

		Assert.assertNotNull(id);

		String savedIntent = intentMappingDao.getIntent(im.getName()).getName();
		Assert.assertNotNull(savedIntent);

		// Clean up after the test
		try {
			intentMappingDao.deleteIntent(savedIntent);
		} catch (JsonProcessingException e) {
			e.printStackTrace();
		}
	}

	@Ignore("a service integration test")
	@Test
	public void testUpdateIntentMapping() {
		String id = new String();
		IntentMapping im = null;
		try {
			im = createIntentMappingObject();
			id = intentMappingDao.createIntent(im);
			IntentMapping imNew = intentMappingDao.getIntent(im.getName());
			im.set_id(imNew.get_id());
			im.setName("Hypertension");
			intentMappingDao.updateIntentMapping(im);
			IntentMapping updatedIM = intentMappingDao.getIntent(im.getName());
			Assert.assertTrue(updatedIM.getName().equals("Hypertension"));
			// Clean up after test
			intentMappingDao.deleteIntent(im.getName());
		} catch (JsonProcessingException e) {
			logger.log(Level.SEVERE, e.getMessage());
		}
	}
	
	@Ignore("a service integration test")
	@Test
	public void testGetAll() {
		String id = new String();
		IntentMapping im = null;
		System.out.println(intentMappingDao.getAll());
	}


	private IntentMapping createIntentMappingObject() {
		IntentMapping intentMapping = new IntentMapping();
		InvocationMapping invocationMapping = new InvocationMapping();
		List<Rule> rules = new ArrayList<>();
		Rule rule = new Rule();
		Properties props = new Properties();
		props.put("scopingEntityId", "com.cognitive");
		props.put("businessId", "genderAge");
		props.put("version", "1.0.0");
		rule.setProperties(props);
		rules.add(rule);
		invocationMapping.setRules(rules);
		invocationMapping.setEngineName("OpenCDS");

		List<String> dataQueries = new ArrayList<>();
		dataQueries.add("patient/##SUBJECT.ID##");
		invocationMapping.setDataQueries(dataQueries);

		List<InvocationMapping> invocations = new ArrayList<>();
		invocations.add(invocationMapping);
		intentMapping.setName("providerInteractiveAdvice");
		intentMapping.setInvocations(invocations);

		return intentMapping;
	}
}
