/**
 * *****************************************************************************
 *
 * Copyright 2015 Cognitive Medical Systems
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 *
 *
 ******************************************************************************
 */
package com.cognitive.cds.invocation.workproduct.model;

import com.cognitive.cds.invocation.model.Base;
import com.cognitive.cds.invocation.model.InvocationTarget;

/**
 * Information about an invocation.
 * 
 * @author jgoodnough
 *
 */
public class InvocationInfo extends Base {
	/**
	 * The target of the invocation
	 */
	InvocationTarget targetInfo;
	/**
	 * The call Id 
	 */
	String callId;
	/**
	 * The generating engine
	 */
	String generatedBy;

	/**
	 * Return the engine that generated the artifact (Take for Results Structure)
	 * @return
	 */
	public String getGeneratedBy() {
		return generatedBy;
	}

	public void setGeneratedBy(String generatedBy) {
		this.generatedBy = generatedBy;
	}

	/**
	 * The Call id that result in the work product being created
	 * @return
	 */
	public String getCallId() {
		return callId;
	}

	public void setCallId(String callId) {
		this.callId = callId;
	}

	public InvocationTarget getTargetInfo() {
		return targetInfo;
	}

	public void setTargetInfo(InvocationTarget targetInfo) {
		this.targetInfo = targetInfo;
	}
	
}
