package com.cognitive.cds.invocation.exceptions;

/********************************************************************************
*
*   Copyright 2015 Cognitive Medical Systems
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
* 
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*
*
*     
********************************************************************************/
import java.util.Iterator;
import java.util.LinkedList;

/**
 * This exception is used to valid a error validating data
 * 
 * @author jgoodnough
 *
 */
public class DataValidationException extends Exception {

    /**
     * 
     */
    private static final long serialVersionUID = 1L;
    private LinkedList<String> faults = new LinkedList<>();

    public DataValidationException(String msg) {
        super(msg);

    }

    public DataValidationException(String msg, Exception e) {
        super(msg, e);
    }

    public void addFault(String fault) {
        faults.add(fault);

    }

    public LinkedList<String> getFaults() {
        return faults;
    }

    public void setFaults(LinkedList<String> faults) {
        this.faults = faults;
    }

    @Override
    public String getMessage() {
        StringBuffer buf = new StringBuffer(super.getMessage());
        if (!faults.isEmpty()) {
            buf.append("Details: ");
            int cnt = 1;
            Iterator<String> itr = faults.iterator();
            while (itr.hasNext()) {
                buf.append("\n  ");
                buf.append(cnt);
                buf.append(itr.next());
                cnt++;
            }

        }
        return buf.toString();
    }

}
