/*******************************************************************************
 *
 *   Copyright 2016 Cognitive Medical Systems
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 *
 *     
 *******************************************************************************/
package com.cognitive.cds.invocation;

import java.util.List;

import com.cognitive.cds.invocation.model.ResultBundle;
import com.cognitive.cds.invocation.model.Rule;

/**
 * Core interface implemented by various type of reasoning engines.
 *
 * Data may be raw (native, unknown) or type indicated.
 *
 * @author Jerry Goodnough
 * @version 1.0
 * @created 11-Dec-2014 9:10:40 AM
 */
public interface CDSEnginePlugInIFace {

	//FUTURE Consider moving model transform into the engine.
	/**
	 *
	 * @param rules
	 * @param data Serialied Data
	 * @param callId
	 * @param eism - engineInstanceStateManager to be used for this invocation.
	 */
	public ResultBundle invoke(List<Rule> rules, String data, String callId, EngineInstanceStateManagementIFace eism);

	/**
	 *
	 * @param rules
	 * @param data
	 * @param callId
	 * @param eism - engineInstanceStateManager to be used for this invocation.
	 */
	public ResultBundle invokeRaw(List<Rule> rules, Object data, String callId, EngineInstanceStateManagementIFace eism);

	public void introduceData();

}
