/*******************************************************************************
 *
 *   Copyright 2016 Cognitive Medical Systems
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 *
 *     
 *******************************************************************************/
package com.cognitive.cds.engine.agent.event;

import org.springframework.context.ApplicationEvent;

/**
 *
 * @author jeremy
 */
public class EngineAgentEvent extends ApplicationEvent {

	private static final long serialVersionUID = 1L;

	private String successMessage;
	private String errorMessage;

	//Constructor's first parameter must be the source
	public EngineAgentEvent(Object source, String successMessage, String errorMessage) {
		super(source);
		this.successMessage = successMessage;
		this.errorMessage = errorMessage;
	}

	public String getSuccessMessage() {
		return successMessage;
	}

	public String getErrorMessage() {
		return errorMessage;
	}
}
