/*******************************************************************************
 *  Copyright 2015 Cognitive Medical Systems
 *  
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *  
 *       http://www.apache.org/licenses/LICENSE-2.0
 *  
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 *******************************************************************************/
package com.cognitivemedicine.metricsservice.model;

import java.io.Serializable;
import java.util.List;

/**
 * Used for grouping related definitions
 * 
 * @author sschechter
 * 
 */
public class MetricGroup implements Serializable {

    private String _id;
    private String name;
    private String description;
    private List<String> metricList;

    public String get_id() {
        return _id;
    }

    public void set_id(String id) {
        this._id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<String> getMetricList() {
        return metricList;
    }

    public void setMetricList(List<String> metricList) {
        this.metricList = metricList;
    }
}
