VPRJUCR ;SLC/KCM -- Unit tests for range parameter parsing
 ;;1.0;JSON DATA STORE;;Sep 01, 2012
 ;
STARTUP  ; Run once before all tests
 Q
SHUTDOWN ; Run once after all tests
 Q
SETUP    ; Run before each test
 Q
TEARDOWN ; Run after each test
 Q
ASSERT(EXPECT,ACTUAL) ; convenience
 D EQ^VPRJT(EXPECT,ACTUAL)
 Q
 ;
ADJNUM   ;; @TEST incrementing and decrementing numbers
 ; use CHKTF, CHKEQ, FAIL, CHKLEAKS to test calls
 N X
 S X=$$ADJNUM^VPRJCR(100)       D ASSERT(101,X)
 S X=$$ADJNUM^VPRJCR(1.009)     D ASSERT(1.01,X)
 S X=$$ADJNUM^VPRJCR(1.001,"-") D ASSERT(1,X)
 S X=$$ADJNUM^VPRJCR(100,"-")   D ASSERT(99,X)
 Q
ADJSTR   ;; @TEST bumping strings up and down in collation
 N X
 S X=$$ADJSTR^VPRJCR("SMILE","-") D ASSERT("SMILD"_$C(255),X)
 S X=$$ADJSTR^VPRJCR("SMI")       D ASSERT("SMI"_$C(255),X)
 Q
TESTRNG(RANGE,START,STOP,CLTN) ; procedure to test RNG2VAL^VPRJCR
 N RANGES
 D XRANGES^VPRJCR(RANGE,.RANGES)               ; extract the range into RANGES(1)
 D RNG2VAL^VPRJCR(.RANGES,1,.START,.STOP,CLTN) ; now get the start/stop info
 Q
RNG2VAL  ;; @TEST converting ranges to START, STOP
 N START,STOP,MAXC
 S MAXC=$C(255)
 ;
 ; default is include endpoints and assume each is "starts with"
 D TESTRNG("201209191045..201210200620",.START,.STOP,"T")
 D ASSERT("201209191045",START),ASSERT("201210200620 ",STOP)
 ; (start:stop) gets the values between start and stop (exclude endpoints)
 D TESTRNG("]201209191045..201210200620[",.START,.STOP,"T")
 D ASSERT("201209191045 ",START),ASSERT("201210200620",STOP)
 ; [start:stop] changes start/stop so that $O will include endpoints
 D TESTRNG("[201209191045..201210200620]",.START,.STOP,"T")
 D ASSERT("201209191045",START),ASSERT("201210200620 ",STOP)
 D TESTRNG("20121101",.START,.STOP,"T")
 D ASSERT("20121101",START),ASSERT("20121101 ",STOP)
 D TESTRNG("201211011045",.START,.STOP,"T")
 D ASSERT("201211011045",START),ASSERT("201211011045 ",STOP)
 ;
 D TESTRNG("ACETAMINOPHEN..ASPIRIN",.START,.STOP,"S")
 D ASSERT("ACETAMINOPHEN",START),ASSERT("ASPIRIN ",STOP)
 D TESTRNG("]ACETAMINOPHEN..ASPIRIN[",.START,.STOP,"S")
 D ASSERT("ACETAMINOPHEN ",START),ASSERT("ASPIRIN",STOP)
 D TESTRNG("[ACETAMINOPHEN..ASPIRIN]",.START,.STOP,"S")
 D ASSERT("ACETAMINOPHEN",START),ASSERT("ASPIRIN ",STOP)
 ;
 D TESTRNG("ASPIRIN*",.START,.STOP,"S")
 D ASSERT("ASPIRIN",START),ASSERT("ASPIRIN"_MAXC,STOP)
 D TESTRNG("ASP*",.START,.STOP,"S")
 D ASSERT("ASP",START),ASSERT("ASP"_MAXC,STOP)
 ;
 D TESTRNG("10..20",.START,.STOP,"N")
 D ASSERT(9,START),ASSERT(20,STOP)
 D TESTRNG("[10..20]",.START,.STOP,"N")
 D ASSERT(9,START),ASSERT(20,STOP)
 D TESTRNG("]1.001..3.1416[",.START,.STOP,"N")
 D ASSERT(1.001,START),ASSERT(3.1415,STOP)
 D TESTRNG("[1.001..3.1416]",.START,.STOP,"N")
 D ASSERT(1,START),ASSERT(3.1416,STOP)
 Q
RNG2VAL2 ;; @TEST convert range to start, stop (2nd edition)
 ;; -- string collation, space appended to each entry in index
 ;;SMILE       "SMILE"   Q:X]"SMILE "   []  equals SMILE
 ;;[SMILE]     "SMILE"   Q:X]"SMILE "   []  equals SMILE
 ;;SMI..SOR    "SMI"     Q:X]"SOR "     []  startswith SMI thru startswith SOR
 ;;[SMI..SOR]  "SMI"     Q:X]"SOR "     []  SMI thru SOR (not startswith)
 ;;]SMI..SOR[  "SMI "    Q:X]"SOR"      ()  SMI thru SOR excluding SMI and SOR
 ;;SMI*        "SMI"     Q:X]"SMI"      [*  startswith SMI
 ;;]SMI*       "SMI "    Q:X]"SMI"      (*  startswith SMI, excluding SMI itself
 ;;
 ;; -- time collation, space appended to each entry in index
 ;;20121101..20121117    "20121101"       Q:X]"20121117 "      []
 ;;20121101              "20121101"       Q:X]"20121101 "      []
 ;;[20121101..20121117]  "20121101"       Q:X]"20121117 "      []
 ;;]20121101..20121117[  "20121101 "      Q:X]"20121117"       ()
 ;;201211011045          "201211011045"   Q:X]"201211011045 "  []
 ;;201211*               "201211"         Q:X]"201211"         [*
 ;;]201211*              "201211 "        Q:X]"201211"         (*
 ;;
 ;; -- inverse time collation, number inverted and space appended
 ;;20121101..20121117    "79878882:"      Q:X]"79878898="      []
 ;;20121101              "79878898:"      Q:X]"79878898="      []
 ;;[20121101..20121117]  "79878882:"      Q:X]"79878898="      []
 ;;]20121101..20121117[  "79878882="      Q:X]"79878898:"      ()
 ;;201211011045          "798788988954:"  Q:X]"798788988954="  []
 ;;201211*               "798788 "        Q:X]"798788="        [*
 ;;]201211*              "798788 "        Q:X]"798788:"        (*
 ;;
 ;; -- numeric collation, each entry in index is "plused"
 ;;123456.654321..65432.789    123456.654320   Q:X>65432.789   []
 ;;[123456.654321..65432.789]  123456.654320   Q:X>65432.789   []
 ;;]123456.654321..65432.789[  123456.654321   Q:X>65432.788   ()
 ;
 N START,STOP,MAXC
 S MAXC=$C(255)
 D TESTRNG("SMILE",.START,.STOP,"S")      D ASSERT("SMILE",START) D ASSERT("SMILE ",STOP)
 D TESTRNG("[SMILE]",.START,.STOP,"S")    D ASSERT("SMILE",START) D ASSERT("SMILE ",STOP)
 D TESTRNG("SMI..SOR",.START,.STOP,"S")   D ASSERT("SMI",START)   D ASSERT("SOR ",STOP)
 D TESTRNG("[SMI..SOR]",.START,.STOP,"S") D ASSERT("SMI",START)   D ASSERT("SOR ",STOP)
 D TESTRNG("]SMI..SOR[",.START,.STOP,"S") D ASSERT("SMI ",START)  D ASSERT("SOR",STOP)
 D TESTRNG("SMI*",.START,.STOP,"S")       D ASSERT("SMI",START)   D ASSERT("SMI"_MAXC,STOP)
 D TESTRNG("]SMI*",.START,STOP,"S")       D ASSERT("SMI ",START)  D ASSERT("SMI"_MAXC,STOP)
 ;
 D TESTRNG("20121101..20121117",.START,.STOP,"T")   D ASSERT("20121101",START)     D ASSERT("20121117 ",STOP)
 D TESTRNG("20121101",.START,.STOP,"T")             D ASSERT("20121101",START)     D ASSERT("20121101 ",STOP)
 D TESTRNG("[20121101..20121117]",.START,.STOP,"T") D ASSERT("20121101",START)     D ASSERT("20121117 ",STOP)
 D TESTRNG("]20121101..20121117[",.START,.STOP,"T") D ASSERT("20121101 ",START)    D ASSERT("20121117",STOP)
 D TESTRNG("201211011045",.START,.STOP,"T")         D ASSERT("201211011045",START) D ASSERT("201211011045 ",STOP)
 D TESTRNG("201211*",.START,.STOP,"T")              D ASSERT("201211",START)       D ASSERT("201211"_MAXC,STOP)
 D TESTRNG("]201211*",.START,.STOP,"T")             D ASSERT("201211 ",START)      D ASSERT("201211"_MAXC,STOP)
 ;
 D TESTRNG("20121101..20121117",.START,.STOP,"V")   D ASSERT("79878882:",START)     D ASSERT("79878898=",STOP)
 D TESTRNG("20121101",.START,.STOP,"V")             D ASSERT("79878898:",START)     D ASSERT("79878898=",STOP)
 D TESTRNG("[20121101..20121117]",.START,.STOP,"V") D ASSERT("79878882:",START)     D ASSERT("79878898=",STOP)
 D TESTRNG("]20121101..20121117[",.START,.STOP,"V") D ASSERT("79878882=",START)     D ASSERT("79878898:",STOP)
 D TESTRNG("201211011045",.START,.STOP,"V")         D ASSERT("798788988954:",START) D ASSERT("798788988954=",STOP)
 D TESTRNG("201211*",.START,.STOP,"V")              D ASSERT("798788 ",START)       D ASSERT("798788=",STOP)
 D TESTRNG("]201211*",.START,.STOP,"V")             D ASSERT("798788 ",START)       D ASSERT("798788:",STOP)
 ;
 D TESTRNG("12345.654321..65432.789",.START,.STOP,"N")   D ASSERT(12345.65432,START)  D ASSERT(65432.789,STOP)
 D TESTRNG("[12345.654321..65432.789]",.START,.STOP,"N") D ASSERT(12345.65432,START)  D ASSERT(65432.789,STOP)
 D TESTRNG("]12345.654321..65432.789[",.START,.STOP,"N") D ASSERT(12345.654321,START) D ASSERT(65432.788,STOP)
 ;
 D TESTRNG("2014..1999",.START,.STOP,"T") D ASSERT("1999",START) D ASSERT("2014 ",STOP)
 Q
QUOTES ;; @TEST ranges with quotes in them
 ;;"DOE,JOHN".."WELBY,MARCUS"
 ;;'JOHN''S CAR'*
 ;;"JOHN'S CAR"*
 ;;"666"*
 ;;20121101..20121117>3.4..7.9>"AARDVARK,ARTHUR".."RATBURN,RICHARD">'ARTHUR''S DOG'
 N RANGE,INDEX,START,STOP,DIR
 S INDEX("levels")=1,INDEX("collate",1)="s"
 S RANGE=$P($T(QUOTES+1),";;",2,99)
 D PARSERNG^VPRJCR
 D ASSERT("doe,john",START(1)),ASSERT("welby,marcus ",STOP(1))
 S RANGE=$P($T(QUOTES+2),";;",2,99)
 D PARSERNG^VPRJCR
 D ASSERT("john's car",START(1)),ASSERT("john's car"_$C(255),STOP(1))
 S RANGE=$P($T(QUOTES+3),";;",2,99)
 D PARSERNG^VPRJCR
 D ASSERT("john's car",START(1)),ASSERT("john's car"_$C(255),STOP(1))
 S RANGE=$P($T(QUOTES+4),";;",2,99)
 D PARSERNG^VPRJCR
 D ASSERT("665"_$C(255),START(1)),ASSERT("666"_$C(255),STOP(1))
 S INDEX("levels")=4
 S INDEX("collate",1)="T",INDEX("collate",2)="N",INDEX("collate",3)="s",INDEX("collate",4)="s"
 S RANGE=$P($T(QUOTES+5),";;",2,99)
 D PARSERNG^VPRJCR
 D ASSERT("20121101",START(1)),ASSERT("20121117 ",STOP(1))
 D ASSERT(3.3,START(2)),ASSERT(7.9,STOP(2))
 D ASSERT("aardvark,arthur",START(3)),ASSERT("ratburn,richard ",STOP(3))
 D ASSERT("arthur's dog",START(4)),ASSERT("arthur's dog ",STOP(4))
 Q
NULLRNG ;; @TEST when no range entered
 N RANGE,INDEX,START,STOP,DIR
 S INDEX("levels")=1,INDEX("collate",1)="s",RANGE=""
 D PARSERNG^VPRJCR
 D ASSERT("",START(1)),ASSERT($C(255,255,255),STOP(1))
 Q
