package us.vistacore.mocks.util;

/*
 * Copyright (c) 2012, United States Government, as represented by the Secretary of Health and Human Services.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *     * Redistributions of source code must retain the above
 *       copyright notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the documentation
 *       and/or other materials provided with the distribution.
 *     * Neither the name of the United States Government nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE UNITED STATES GOVERNMENT BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

import java.util.Collection;
import java.util.List;
import java.util.Map;

/**
 * Utility to check for null nature of various types of values.
 *
 * @author rayj, Les Westberg
 */
public final class NullChecker {

    private NullChecker() { }

    public static boolean isNullish(String value) {
        return ((value == null) || (value.contentEquals("")));
    }

    public static boolean isNotNullish(String value) {
        return (!isNullish(value));
    }

    public static boolean isNullish(List<?> value) {
        return ((value == null) || (value.size() == 0));
    }

    public static boolean isNotNullish(List<?> value) {
        return (!isNullish(value));
    }

    public static boolean isNullish(Collection<?> value) {
        return ((value == null) || (value.isEmpty()));
    }

    public static boolean isNotNullish(Collection<?> value) {
        return (!isNullish(value));
    }

    public static boolean isNullish(Map<?, ?> value) {
        return ((value == null) || (value.isEmpty()));
    }

    public static boolean isNotNullish(Map<?, ?> value) {
        return (!isNullish(value));
    }

}
